/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudformation.transform;

import java.util.ArrayList;

import javax.xml.stream.events.XMLEvent;
import javax.annotation.Generated;

import software.amazon.awssdk.services.cloudformation.model.*;
import software.amazon.awssdk.awscore.protocol.xml.StaxUnmarshallerContext;
import software.amazon.awssdk.awscore.protocol.xml.SimpleTypeStaxUnmarshallers.*;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;

/**
 * RollbackConfiguration StAX Unmarshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class RollbackConfigurationUnmarshaller implements Unmarshaller<RollbackConfiguration, StaxUnmarshallerContext> {

    public RollbackConfiguration unmarshall(StaxUnmarshallerContext context) throws Exception {
        RollbackConfiguration.Builder rollbackConfiguration = RollbackConfiguration.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;

        if (context.isStartOfDocument())
            targetDepth += 1;

        java.util.List<RollbackTrigger> rollbackTriggers = null;

        while (true) {
            XMLEvent xmlEvent = context.nextEvent();
            if (xmlEvent.isEndDocument()) {
                rollbackConfiguration.rollbackTriggers(rollbackTriggers);
                break;
            }

            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {

                if (context.testExpression("RollbackTriggers", targetDepth)) {
                    rollbackTriggers = new ArrayList<RollbackTrigger>();
                    continue;
                }

                if (context.testExpression("RollbackTriggers/member", targetDepth)) {
                    rollbackTriggers.add(RollbackTriggerUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("MonitoringTimeInMinutes", targetDepth)) {
                    rollbackConfiguration.monitoringTimeInMinutes(IntegerUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
            } else if (xmlEvent.isEndElement()) {
                if (context.getCurrentDepth() < originalDepth) {
                    rollbackConfiguration.rollbackTriggers(rollbackTriggers);
                    break;
                }
            }
        }
        return rollbackConfiguration.build();
    }

    private static final RollbackConfigurationUnmarshaller INSTANCE = new RollbackConfigurationUnmarshaller();

    public static RollbackConfigurationUnmarshaller getInstance() {
        return INSTANCE;
    }
}
