/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudformation.transform;

import java.util.List;

import javax.annotation.Generated;

import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.services.cloudformation.model.*;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.core.util.IdempotentUtils;

/**
 * UpdateStackInstancesRequest Marshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class UpdateStackInstancesRequestMarshaller implements
        Marshaller<Request<UpdateStackInstancesRequest>, UpdateStackInstancesRequest> {

    public Request<UpdateStackInstancesRequest> marshall(UpdateStackInstancesRequest updateStackInstancesRequest) {

        if (updateStackInstancesRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }

        Request<UpdateStackInstancesRequest> request = new DefaultRequest<UpdateStackInstancesRequest>(
                updateStackInstancesRequest, "CloudFormationClient");
        request.addParameter("Action", "UpdateStackInstances");
        request.addParameter("Version", "2010-05-15");
        request.setHttpMethod(HttpMethodName.POST);

        if (updateStackInstancesRequest.stackSetName() != null) {
            request.addParameter("StackSetName", StringConversion.fromString(updateStackInstancesRequest.stackSetName()));
        }

        if (updateStackInstancesRequest.accounts().isEmpty()
                && !(updateStackInstancesRequest.accounts() instanceof software.amazon.awssdk.core.util.SdkAutoConstructList)) {
            request.addParameter("Accounts", "");
        } else if (!updateStackInstancesRequest.accounts().isEmpty()
                && !(updateStackInstancesRequest.accounts() instanceof software.amazon.awssdk.core.util.SdkAutoConstructList)) {
            java.util.List<String> accountsList = updateStackInstancesRequest.accounts();
            int accountsListIndex = 1;

            for (String accountsListValue : accountsList) {
                if (accountsListValue != null) {
                    request.addParameter("Accounts.member." + accountsListIndex, StringConversion.fromString(accountsListValue));
                }
                accountsListIndex++;
            }
        }

        if (updateStackInstancesRequest.regions().isEmpty()
                && !(updateStackInstancesRequest.regions() instanceof software.amazon.awssdk.core.util.SdkAutoConstructList)) {
            request.addParameter("Regions", "");
        } else if (!updateStackInstancesRequest.regions().isEmpty()
                && !(updateStackInstancesRequest.regions() instanceof software.amazon.awssdk.core.util.SdkAutoConstructList)) {
            java.util.List<String> regionsList = updateStackInstancesRequest.regions();
            int regionsListIndex = 1;

            for (String regionsListValue : regionsList) {
                if (regionsListValue != null) {
                    request.addParameter("Regions.member." + regionsListIndex, StringConversion.fromString(regionsListValue));
                }
                regionsListIndex++;
            }
        }

        if (updateStackInstancesRequest.parameterOverrides().isEmpty()
                && !(updateStackInstancesRequest.parameterOverrides() instanceof software.amazon.awssdk.core.util.SdkAutoConstructList)) {
            request.addParameter("ParameterOverrides", "");
        } else if (!updateStackInstancesRequest.parameterOverrides().isEmpty()
                && !(updateStackInstancesRequest.parameterOverrides() instanceof software.amazon.awssdk.core.util.SdkAutoConstructList)) {
            java.util.List<Parameter> parameterOverridesList = updateStackInstancesRequest.parameterOverrides();
            int parameterOverridesListIndex = 1;

            for (Parameter parameterOverridesListValue : parameterOverridesList) {

                if (parameterOverridesListValue.parameterKey() != null) {
                    request.addParameter("ParameterOverrides.member." + parameterOverridesListIndex + ".ParameterKey",
                            StringConversion.fromString(parameterOverridesListValue.parameterKey()));
                }

                if (parameterOverridesListValue.parameterValue() != null) {
                    request.addParameter("ParameterOverrides.member." + parameterOverridesListIndex + ".ParameterValue",
                            StringConversion.fromString(parameterOverridesListValue.parameterValue()));
                }

                if (parameterOverridesListValue.usePreviousValue() != null) {
                    request.addParameter("ParameterOverrides.member." + parameterOverridesListIndex + ".UsePreviousValue",
                            StringConversion.fromBoolean(parameterOverridesListValue.usePreviousValue()));
                }

                if (parameterOverridesListValue.resolvedValue() != null) {
                    request.addParameter("ParameterOverrides.member." + parameterOverridesListIndex + ".ResolvedValue",
                            StringConversion.fromString(parameterOverridesListValue.resolvedValue()));
                }
                parameterOverridesListIndex++;
            }
        }

        StackSetOperationPreferences operationPreferences = updateStackInstancesRequest.operationPreferences();
        if (operationPreferences != null) {

            if (operationPreferences.regionOrder().isEmpty()
                    && !(operationPreferences.regionOrder() instanceof software.amazon.awssdk.core.util.SdkAutoConstructList)) {
                request.addParameter("OperationPreferences.RegionOrder", "");
            } else if (!operationPreferences.regionOrder().isEmpty()
                    && !(operationPreferences.regionOrder() instanceof software.amazon.awssdk.core.util.SdkAutoConstructList)) {
                java.util.List<String> regionOrderList = operationPreferences.regionOrder();
                int regionOrderListIndex = 1;

                for (String regionOrderListValue : regionOrderList) {
                    if (regionOrderListValue != null) {
                        request.addParameter("OperationPreferences.RegionOrder.member." + regionOrderListIndex,
                                StringConversion.fromString(regionOrderListValue));
                    }
                    regionOrderListIndex++;
                }
            }

            if (operationPreferences.failureToleranceCount() != null) {
                request.addParameter("OperationPreferences.FailureToleranceCount",
                        StringConversion.fromInteger(operationPreferences.failureToleranceCount()));
            }

            if (operationPreferences.failureTolerancePercentage() != null) {
                request.addParameter("OperationPreferences.FailureTolerancePercentage",
                        StringConversion.fromInteger(operationPreferences.failureTolerancePercentage()));
            }

            if (operationPreferences.maxConcurrentCount() != null) {
                request.addParameter("OperationPreferences.MaxConcurrentCount",
                        StringConversion.fromInteger(operationPreferences.maxConcurrentCount()));
            }

            if (operationPreferences.maxConcurrentPercentage() != null) {
                request.addParameter("OperationPreferences.MaxConcurrentPercentage",
                        StringConversion.fromInteger(operationPreferences.maxConcurrentPercentage()));
            }
        }

        request.addParameter("OperationId", IdempotentUtils.resolveString(updateStackInstancesRequest.operationId()));

        return request;
    }

}
