/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudformation.transform;

import java.util.List;

import javax.annotation.Generated;

import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.services.cloudformation.model.*;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.core.util.IdempotentUtils;

/**
 * UpdateStackSetRequest Marshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class UpdateStackSetRequestMarshaller implements Marshaller<Request<UpdateStackSetRequest>, UpdateStackSetRequest> {

    public Request<UpdateStackSetRequest> marshall(UpdateStackSetRequest updateStackSetRequest) {

        if (updateStackSetRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }

        Request<UpdateStackSetRequest> request = new DefaultRequest<UpdateStackSetRequest>(updateStackSetRequest,
                "CloudFormationClient");
        request.addParameter("Action", "UpdateStackSet");
        request.addParameter("Version", "2010-05-15");
        request.setHttpMethod(HttpMethodName.POST);

        if (updateStackSetRequest.stackSetName() != null) {
            request.addParameter("StackSetName", StringConversion.fromString(updateStackSetRequest.stackSetName()));
        }

        if (updateStackSetRequest.description() != null) {
            request.addParameter("Description", StringConversion.fromString(updateStackSetRequest.description()));
        }

        if (updateStackSetRequest.templateBody() != null) {
            request.addParameter("TemplateBody", StringConversion.fromString(updateStackSetRequest.templateBody()));
        }

        if (updateStackSetRequest.templateURL() != null) {
            request.addParameter("TemplateURL", StringConversion.fromString(updateStackSetRequest.templateURL()));
        }

        if (updateStackSetRequest.usePreviousTemplate() != null) {
            request.addParameter("UsePreviousTemplate", StringConversion.fromBoolean(updateStackSetRequest.usePreviousTemplate()));
        }

        if (updateStackSetRequest.parameters().isEmpty()
                && !(updateStackSetRequest.parameters() instanceof software.amazon.awssdk.core.util.SdkAutoConstructList)) {
            request.addParameter("Parameters", "");
        } else if (!updateStackSetRequest.parameters().isEmpty()
                && !(updateStackSetRequest.parameters() instanceof software.amazon.awssdk.core.util.SdkAutoConstructList)) {
            java.util.List<Parameter> parametersList = updateStackSetRequest.parameters();
            int parametersListIndex = 1;

            for (Parameter parametersListValue : parametersList) {

                if (parametersListValue.parameterKey() != null) {
                    request.addParameter("Parameters.member." + parametersListIndex + ".ParameterKey",
                            StringConversion.fromString(parametersListValue.parameterKey()));
                }

                if (parametersListValue.parameterValue() != null) {
                    request.addParameter("Parameters.member." + parametersListIndex + ".ParameterValue",
                            StringConversion.fromString(parametersListValue.parameterValue()));
                }

                if (parametersListValue.usePreviousValue() != null) {
                    request.addParameter("Parameters.member." + parametersListIndex + ".UsePreviousValue",
                            StringConversion.fromBoolean(parametersListValue.usePreviousValue()));
                }

                if (parametersListValue.resolvedValue() != null) {
                    request.addParameter("Parameters.member." + parametersListIndex + ".ResolvedValue",
                            StringConversion.fromString(parametersListValue.resolvedValue()));
                }
                parametersListIndex++;
            }
        }

        if (updateStackSetRequest.capabilitiesAsStrings().isEmpty()
                && !(updateStackSetRequest.capabilitiesAsStrings() instanceof software.amazon.awssdk.core.util.SdkAutoConstructList)) {
            request.addParameter("Capabilities", "");
        } else if (!updateStackSetRequest.capabilitiesAsStrings().isEmpty()
                && !(updateStackSetRequest.capabilitiesAsStrings() instanceof software.amazon.awssdk.core.util.SdkAutoConstructList)) {
            java.util.List<String> capabilitiesList = updateStackSetRequest.capabilitiesAsStrings();
            int capabilitiesListIndex = 1;

            for (String capabilitiesListValue : capabilitiesList) {
                if (capabilitiesListValue != null) {
                    request.addParameter("Capabilities.member." + capabilitiesListIndex,
                            StringConversion.fromString(capabilitiesListValue));
                }
                capabilitiesListIndex++;
            }
        }

        if (updateStackSetRequest.tags().isEmpty()
                && !(updateStackSetRequest.tags() instanceof software.amazon.awssdk.core.util.SdkAutoConstructList)) {
            request.addParameter("Tags", "");
        } else if (!updateStackSetRequest.tags().isEmpty()
                && !(updateStackSetRequest.tags() instanceof software.amazon.awssdk.core.util.SdkAutoConstructList)) {
            java.util.List<Tag> tagsList = updateStackSetRequest.tags();
            int tagsListIndex = 1;

            for (Tag tagsListValue : tagsList) {

                if (tagsListValue.key() != null) {
                    request.addParameter("Tags.member." + tagsListIndex + ".Key",
                            StringConversion.fromString(tagsListValue.key()));
                }

                if (tagsListValue.value() != null) {
                    request.addParameter("Tags.member." + tagsListIndex + ".Value",
                            StringConversion.fromString(tagsListValue.value()));
                }
                tagsListIndex++;
            }
        }

        StackSetOperationPreferences operationPreferences = updateStackSetRequest.operationPreferences();
        if (operationPreferences != null) {

            if (operationPreferences.regionOrder().isEmpty()
                    && !(operationPreferences.regionOrder() instanceof software.amazon.awssdk.core.util.SdkAutoConstructList)) {
                request.addParameter("OperationPreferences.RegionOrder", "");
            } else if (!operationPreferences.regionOrder().isEmpty()
                    && !(operationPreferences.regionOrder() instanceof software.amazon.awssdk.core.util.SdkAutoConstructList)) {
                java.util.List<String> regionOrderList = operationPreferences.regionOrder();
                int regionOrderListIndex = 1;

                for (String regionOrderListValue : regionOrderList) {
                    if (regionOrderListValue != null) {
                        request.addParameter("OperationPreferences.RegionOrder.member." + regionOrderListIndex,
                                StringConversion.fromString(regionOrderListValue));
                    }
                    regionOrderListIndex++;
                }
            }

            if (operationPreferences.failureToleranceCount() != null) {
                request.addParameter("OperationPreferences.FailureToleranceCount",
                        StringConversion.fromInteger(operationPreferences.failureToleranceCount()));
            }

            if (operationPreferences.failureTolerancePercentage() != null) {
                request.addParameter("OperationPreferences.FailureTolerancePercentage",
                        StringConversion.fromInteger(operationPreferences.failureTolerancePercentage()));
            }

            if (operationPreferences.maxConcurrentCount() != null) {
                request.addParameter("OperationPreferences.MaxConcurrentCount",
                        StringConversion.fromInteger(operationPreferences.maxConcurrentCount()));
            }

            if (operationPreferences.maxConcurrentPercentage() != null) {
                request.addParameter("OperationPreferences.MaxConcurrentPercentage",
                        StringConversion.fromInteger(operationPreferences.maxConcurrentPercentage()));
            }
        }

        if (updateStackSetRequest.administrationRoleARN() != null) {
            request.addParameter("AdministrationRoleARN",
                    StringConversion.fromString(updateStackSetRequest.administrationRoleARN()));
        }

        if (updateStackSetRequest.executionRoleName() != null) {
            request.addParameter("ExecutionRoleName", StringConversion.fromString(updateStackSetRequest.executionRoleName()));
        }

        request.addParameter("OperationId", IdempotentUtils.resolveString(updateStackSetRequest.operationId()));

        if (updateStackSetRequest.accounts().isEmpty()
                && !(updateStackSetRequest.accounts() instanceof software.amazon.awssdk.core.util.SdkAutoConstructList)) {
            request.addParameter("Accounts", "");
        } else if (!updateStackSetRequest.accounts().isEmpty()
                && !(updateStackSetRequest.accounts() instanceof software.amazon.awssdk.core.util.SdkAutoConstructList)) {
            java.util.List<String> accountsList = updateStackSetRequest.accounts();
            int accountsListIndex = 1;

            for (String accountsListValue : accountsList) {
                if (accountsListValue != null) {
                    request.addParameter("Accounts.member." + accountsListIndex, StringConversion.fromString(accountsListValue));
                }
                accountsListIndex++;
            }
        }

        if (updateStackSetRequest.regions().isEmpty()
                && !(updateStackSetRequest.regions() instanceof software.amazon.awssdk.core.util.SdkAutoConstructList)) {
            request.addParameter("Regions", "");
        } else if (!updateStackSetRequest.regions().isEmpty()
                && !(updateStackSetRequest.regions() instanceof software.amazon.awssdk.core.util.SdkAutoConstructList)) {
            java.util.List<String> regionsList = updateStackSetRequest.regions();
            int regionsListIndex = 1;

            for (String regionsListValue : regionsList) {
                if (regionsListValue != null) {
                    request.addParameter("Regions.member." + regionsListIndex, StringConversion.fromString(regionsListValue));
                }
                regionsListIndex++;
            }
        }

        return request;
    }

}
