/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudformation.transform;

import javax.annotation.Generated;

import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.services.cloudformation.model.*;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringConversion;

/**
 * UpdateTerminationProtectionRequest Marshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class UpdateTerminationProtectionRequestMarshaller implements
        Marshaller<Request<UpdateTerminationProtectionRequest>, UpdateTerminationProtectionRequest> {

    public Request<UpdateTerminationProtectionRequest> marshall(
            UpdateTerminationProtectionRequest updateTerminationProtectionRequest) {

        if (updateTerminationProtectionRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }

        Request<UpdateTerminationProtectionRequest> request = new DefaultRequest<UpdateTerminationProtectionRequest>(
                updateTerminationProtectionRequest, "CloudFormationClient");
        request.addParameter("Action", "UpdateTerminationProtection");
        request.addParameter("Version", "2010-05-15");
        request.setHttpMethod(HttpMethodName.POST);

        if (updateTerminationProtectionRequest.enableTerminationProtection() != null) {
            request.addParameter("EnableTerminationProtection",
                    StringConversion.fromBoolean(updateTerminationProtectionRequest.enableTerminationProtection()));
        }

        if (updateTerminationProtectionRequest.stackName() != null) {
            request.addParameter("StackName", StringConversion.fromString(updateTerminationProtectionRequest.stackName()));
        }

        return request;
    }

}
