/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudformation.transform;

import javax.annotation.Generated;

import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.services.cloudformation.model.*;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringConversion;

/**
 * ValidateTemplateRequest Marshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class ValidateTemplateRequestMarshaller implements Marshaller<Request<ValidateTemplateRequest>, ValidateTemplateRequest> {

    public Request<ValidateTemplateRequest> marshall(ValidateTemplateRequest validateTemplateRequest) {

        if (validateTemplateRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }

        Request<ValidateTemplateRequest> request = new DefaultRequest<ValidateTemplateRequest>(validateTemplateRequest,
                "CloudFormationClient");
        request.addParameter("Action", "ValidateTemplate");
        request.addParameter("Version", "2010-05-15");
        request.setHttpMethod(HttpMethodName.POST);

        if (validateTemplateRequest.templateBody() != null) {
            request.addParameter("TemplateBody", StringConversion.fromString(validateTemplateRequest.templateBody()));
        }

        if (validateTemplateRequest.templateURL() != null) {
            request.addParameter("TemplateURL", StringConversion.fromString(validateTemplateRequest.templateURL()));
        }

        return request;
    }

}
