/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudformation.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The output for a <a>EstimateTemplateCost</a> action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class EstimateTemplateCostResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<EstimateTemplateCostResponse.Builder, EstimateTemplateCostResponse> {
    private final String url;

    private EstimateTemplateCostResponse(BuilderImpl builder) {
        this.url = builder.url;
    }

    /**
     * <p>
     * An AWS Simple Monthly Calculator URL with a query string that describes the resources required to run the
     * template.
     * </p>
     * 
     * @return An AWS Simple Monthly Calculator URL with a query string that describes the resources required to run the
     *         template.
     */
    public String url() {
        return url;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((url() == null) ? 0 : url().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EstimateTemplateCostResponse)) {
            return false;
        }
        EstimateTemplateCostResponse other = (EstimateTemplateCostResponse) obj;
        if (other.url() == null ^ this.url() == null) {
            return false;
        }
        if (other.url() != null && !other.url().equals(this.url())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (url() != null) {
            sb.append("Url: ").append(url()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, EstimateTemplateCostResponse> {
        /**
         * <p>
         * An AWS Simple Monthly Calculator URL with a query string that describes the resources required to run the
         * template.
         * </p>
         * 
         * @param url
         *        An AWS Simple Monthly Calculator URL with a query string that describes the resources required to run
         *        the template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder url(String url);
    }

    private static final class BuilderImpl implements Builder {
        private String url;

        private BuilderImpl() {
        }

        private BuilderImpl(EstimateTemplateCostResponse model) {
            setUrl(model.url);
        }

        public final String getUrl() {
            return url;
        }

        @Override
        public final Builder url(String url) {
            this.url = url;
            return this;
        }

        public final void setUrl(String url) {
            this.url = url;
        }

        @Override
        public EstimateTemplateCostResponse build() {
            return new EstimateTemplateCostResponse(this);
        }
    }
}
