/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudformation.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class ListExportsResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<ListExportsResponse.Builder, ListExportsResponse> {
    private final List<Export> exports;

    private final String nextToken;

    private ListExportsResponse(BuilderImpl builder) {
        this.exports = builder.exports;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The output for the <a>ListExports</a> action.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The output for the <a>ListExports</a> action.
     */
    public List<Export> exports() {
        return exports;
    }

    /**
     * <p>
     * If the output exceeds 100 exported output values, a string that identifies the next page of exports. If there is
     * no additional page, this value is null.
     * </p>
     * 
     * @return If the output exceeds 100 exported output values, a string that identifies the next page of exports. If
     *         there is no additional page, this value is null.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((exports() == null) ? 0 : exports().hashCode());
        hashCode = 31 * hashCode + ((nextToken() == null) ? 0 : nextToken().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListExportsResponse)) {
            return false;
        }
        ListExportsResponse other = (ListExportsResponse) obj;
        if (other.exports() == null ^ this.exports() == null) {
            return false;
        }
        if (other.exports() != null && !other.exports().equals(this.exports())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        if (other.nextToken() != null && !other.nextToken().equals(this.nextToken())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (exports() != null) {
            sb.append("Exports: ").append(exports()).append(",");
        }
        if (nextToken() != null) {
            sb.append("NextToken: ").append(nextToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, ListExportsResponse> {
        /**
         * <p>
         * The output for the <a>ListExports</a> action.
         * </p>
         * 
         * @param exports
         *        The output for the <a>ListExports</a> action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exports(Collection<Export> exports);

        /**
         * <p>
         * The output for the <a>ListExports</a> action.
         * </p>
         * 
         * @param exports
         *        The output for the <a>ListExports</a> action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exports(Export... exports);

        /**
         * <p>
         * If the output exceeds 100 exported output values, a string that identifies the next page of exports. If there
         * is no additional page, this value is null.
         * </p>
         * 
         * @param nextToken
         *        If the output exceeds 100 exported output values, a string that identifies the next page of exports.
         *        If there is no additional page, this value is null.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    private static final class BuilderImpl implements Builder {
        private List<Export> exports;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListExportsResponse model) {
            setExports(model.exports);
            setNextToken(model.nextToken);
        }

        public final Collection<Export> getExports() {
            return exports;
        }

        @Override
        public final Builder exports(Collection<Export> exports) {
            this.exports = ExportsCopier.copy(exports);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder exports(Export... exports) {
            exports(Arrays.asList(exports));
            return this;
        }

        public final void setExports(Collection<Export> exports) {
            this.exports = ExportsCopier.copy(exports);
        }

        @SafeVarargs
        public final void setExports(Export... exports) {
            exports(Arrays.asList(exports));
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListExportsResponse build() {
            return new ListExportsResponse(this);
        }
    }
}
