/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudformation.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The input for the <a>SignalResource</a> action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class SignalResourceRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<SignalResourceRequest.Builder, SignalResourceRequest> {
    private final String stackName;

    private final String logicalResourceId;

    private final String uniqueId;

    private final String status;

    private SignalResourceRequest(BuilderImpl builder) {
        this.stackName = builder.stackName;
        this.logicalResourceId = builder.logicalResourceId;
        this.uniqueId = builder.uniqueId;
        this.status = builder.status;
    }

    /**
     * <p>
     * The stack name or unique stack ID that includes the resource that you want to signal.
     * </p>
     * 
     * @return The stack name or unique stack ID that includes the resource that you want to signal.
     */
    public String stackName() {
        return stackName;
    }

    /**
     * <p>
     * The logical ID of the resource that you want to signal. The logical ID is the name of the resource that given in
     * the template.
     * </p>
     * 
     * @return The logical ID of the resource that you want to signal. The logical ID is the name of the resource that
     *         given in the template.
     */
    public String logicalResourceId() {
        return logicalResourceId;
    }

    /**
     * <p>
     * A unique ID of the signal. When you signal Amazon EC2 instances or Auto Scaling groups, specify the instance ID
     * that you are signaling as the unique ID. If you send multiple signals to a single resource (such as signaling a
     * wait condition), each signal requires a different unique ID.
     * </p>
     * 
     * @return A unique ID of the signal. When you signal Amazon EC2 instances or Auto Scaling groups, specify the
     *         instance ID that you are signaling as the unique ID. If you send multiple signals to a single resource
     *         (such as signaling a wait condition), each signal requires a different unique ID.
     */
    public String uniqueId() {
        return uniqueId;
    }

    /**
     * <p>
     * The status of the signal, which is either success or failure. A failure signal causes AWS CloudFormation to
     * immediately fail the stack creation or update.
     * </p>
     * 
     * @return The status of the signal, which is either success or failure. A failure signal causes AWS CloudFormation
     *         to immediately fail the stack creation or update.
     * @see ResourceSignalStatus
     */
    public String status() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((stackName() == null) ? 0 : stackName().hashCode());
        hashCode = 31 * hashCode + ((logicalResourceId() == null) ? 0 : logicalResourceId().hashCode());
        hashCode = 31 * hashCode + ((uniqueId() == null) ? 0 : uniqueId().hashCode());
        hashCode = 31 * hashCode + ((status() == null) ? 0 : status().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SignalResourceRequest)) {
            return false;
        }
        SignalResourceRequest other = (SignalResourceRequest) obj;
        if (other.stackName() == null ^ this.stackName() == null) {
            return false;
        }
        if (other.stackName() != null && !other.stackName().equals(this.stackName())) {
            return false;
        }
        if (other.logicalResourceId() == null ^ this.logicalResourceId() == null) {
            return false;
        }
        if (other.logicalResourceId() != null && !other.logicalResourceId().equals(this.logicalResourceId())) {
            return false;
        }
        if (other.uniqueId() == null ^ this.uniqueId() == null) {
            return false;
        }
        if (other.uniqueId() != null && !other.uniqueId().equals(this.uniqueId())) {
            return false;
        }
        if (other.status() == null ^ this.status() == null) {
            return false;
        }
        if (other.status() != null && !other.status().equals(this.status())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (stackName() != null) {
            sb.append("StackName: ").append(stackName()).append(",");
        }
        if (logicalResourceId() != null) {
            sb.append("LogicalResourceId: ").append(logicalResourceId()).append(",");
        }
        if (uniqueId() != null) {
            sb.append("UniqueId: ").append(uniqueId()).append(",");
        }
        if (status() != null) {
            sb.append("Status: ").append(status()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, SignalResourceRequest> {
        /**
         * <p>
         * The stack name or unique stack ID that includes the resource that you want to signal.
         * </p>
         * 
         * @param stackName
         *        The stack name or unique stack ID that includes the resource that you want to signal.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stackName(String stackName);

        /**
         * <p>
         * The logical ID of the resource that you want to signal. The logical ID is the name of the resource that given
         * in the template.
         * </p>
         * 
         * @param logicalResourceId
         *        The logical ID of the resource that you want to signal. The logical ID is the name of the resource
         *        that given in the template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logicalResourceId(String logicalResourceId);

        /**
         * <p>
         * A unique ID of the signal. When you signal Amazon EC2 instances or Auto Scaling groups, specify the instance
         * ID that you are signaling as the unique ID. If you send multiple signals to a single resource (such as
         * signaling a wait condition), each signal requires a different unique ID.
         * </p>
         * 
         * @param uniqueId
         *        A unique ID of the signal. When you signal Amazon EC2 instances or Auto Scaling groups, specify the
         *        instance ID that you are signaling as the unique ID. If you send multiple signals to a single resource
         *        (such as signaling a wait condition), each signal requires a different unique ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder uniqueId(String uniqueId);

        /**
         * <p>
         * The status of the signal, which is either success or failure. A failure signal causes AWS CloudFormation to
         * immediately fail the stack creation or update.
         * </p>
         * 
         * @param status
         *        The status of the signal, which is either success or failure. A failure signal causes AWS
         *        CloudFormation to immediately fail the stack creation or update.
         * @see ResourceSignalStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceSignalStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the signal, which is either success or failure. A failure signal causes AWS CloudFormation to
         * immediately fail the stack creation or update.
         * </p>
         * 
         * @param status
         *        The status of the signal, which is either success or failure. A failure signal causes AWS
         *        CloudFormation to immediately fail the stack creation or update.
         * @see ResourceSignalStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceSignalStatus
         */
        Builder status(ResourceSignalStatus status);
    }

    private static final class BuilderImpl implements Builder {
        private String stackName;

        private String logicalResourceId;

        private String uniqueId;

        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(SignalResourceRequest model) {
            setStackName(model.stackName);
            setLogicalResourceId(model.logicalResourceId);
            setUniqueId(model.uniqueId);
            setStatus(model.status);
        }

        public final String getStackName() {
            return stackName;
        }

        @Override
        public final Builder stackName(String stackName) {
            this.stackName = stackName;
            return this;
        }

        public final void setStackName(String stackName) {
            this.stackName = stackName;
        }

        public final String getLogicalResourceId() {
            return logicalResourceId;
        }

        @Override
        public final Builder logicalResourceId(String logicalResourceId) {
            this.logicalResourceId = logicalResourceId;
            return this;
        }

        public final void setLogicalResourceId(String logicalResourceId) {
            this.logicalResourceId = logicalResourceId;
        }

        public final String getUniqueId() {
            return uniqueId;
        }

        @Override
        public final Builder uniqueId(String uniqueId) {
            this.uniqueId = uniqueId;
            return this;
        }

        public final void setUniqueId(String uniqueId) {
            this.uniqueId = uniqueId;
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ResourceSignalStatus status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final void setStatus(ResourceSignalStatus status) {
            this.status(status.toString());
        }

        @Override
        public SignalResourceRequest build() {
            return new SignalResourceRequest(this);
        }
    }
}
