/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudformation.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The Stack data type.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class Stack implements ToCopyableBuilder<Stack.Builder, Stack> {
    private final String stackId;

    private final String stackName;

    private final String changeSetId;

    private final String description;

    private final List<Parameter> parameters;

    private final Instant creationTime;

    private final Instant lastUpdatedTime;

    private final String stackStatus;

    private final String stackStatusReason;

    private final Boolean disableRollback;

    private final List<String> notificationARNs;

    private final Integer timeoutInMinutes;

    private final List<String> capabilities;

    private final List<Output> outputs;

    private final String roleARN;

    private final List<Tag> tags;

    private Stack(BuilderImpl builder) {
        this.stackId = builder.stackId;
        this.stackName = builder.stackName;
        this.changeSetId = builder.changeSetId;
        this.description = builder.description;
        this.parameters = builder.parameters;
        this.creationTime = builder.creationTime;
        this.lastUpdatedTime = builder.lastUpdatedTime;
        this.stackStatus = builder.stackStatus;
        this.stackStatusReason = builder.stackStatusReason;
        this.disableRollback = builder.disableRollback;
        this.notificationARNs = builder.notificationARNs;
        this.timeoutInMinutes = builder.timeoutInMinutes;
        this.capabilities = builder.capabilities;
        this.outputs = builder.outputs;
        this.roleARN = builder.roleARN;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * Unique identifier of the stack.
     * </p>
     * 
     * @return Unique identifier of the stack.
     */
    public String stackId() {
        return stackId;
    }

    /**
     * <p>
     * The name associated with the stack.
     * </p>
     * 
     * @return The name associated with the stack.
     */
    public String stackName() {
        return stackName;
    }

    /**
     * <p>
     * The unique ID of the change set.
     * </p>
     * 
     * @return The unique ID of the change set.
     */
    public String changeSetId() {
        return changeSetId;
    }

    /**
     * <p>
     * A user-defined description associated with the stack.
     * </p>
     * 
     * @return A user-defined description associated with the stack.
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * A list of <code>Parameter</code> structures.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A list of <code>Parameter</code> structures.
     */
    public List<Parameter> parameters() {
        return parameters;
    }

    /**
     * <p>
     * The time at which the stack was created.
     * </p>
     * 
     * @return The time at which the stack was created.
     */
    public Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * The time the stack was last updated. This field will only be returned if the stack has been updated at least
     * once.
     * </p>
     * 
     * @return The time the stack was last updated. This field will only be returned if the stack has been updated at
     *         least once.
     */
    public Instant lastUpdatedTime() {
        return lastUpdatedTime;
    }

    /**
     * <p>
     * Current status of the stack.
     * </p>
     * 
     * @return Current status of the stack.
     * @see StackStatus
     */
    public String stackStatus() {
        return stackStatus;
    }

    /**
     * <p>
     * Success/failure message associated with the stack status.
     * </p>
     * 
     * @return Success/failure message associated with the stack status.
     */
    public String stackStatusReason() {
        return stackStatusReason;
    }

    /**
     * <p>
     * Boolean to enable or disable rollback on stack creation failures:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>true</code>: disable rollback
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>false</code>: enable rollback
     * </p>
     * </li>
     * </ul>
     * 
     * @return Boolean to enable or disable rollback on stack creation failures:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>true</code>: disable rollback
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>false</code>: enable rollback
     *         </p>
     *         </li>
     */
    public Boolean disableRollback() {
        return disableRollback;
    }

    /**
     * <p>
     * SNS topic ARNs to which stack related events are published.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return SNS topic ARNs to which stack related events are published.
     */
    public List<String> notificationARNs() {
        return notificationARNs;
    }

    /**
     * <p>
     * The amount of time within which stack creation should complete.
     * </p>
     * 
     * @return The amount of time within which stack creation should complete.
     */
    public Integer timeoutInMinutes() {
        return timeoutInMinutes;
    }

    /**
     * <p>
     * The capabilities allowed in the stack.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The capabilities allowed in the stack.
     * @see Capability
     */
    public List<String> capabilities() {
        return capabilities;
    }

    /**
     * <p>
     * A list of output structures.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A list of output structures.
     */
    public List<Output> outputs() {
        return outputs;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of an AWS Identity and Access Management (IAM) role that is associated with the
     * stack. During a stack operation, AWS CloudFormation uses this role's credentials to make calls on your behalf.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of an AWS Identity and Access Management (IAM) role that is associated
     *         with the stack. During a stack operation, AWS CloudFormation uses this role's credentials to make calls
     *         on your behalf.
     */
    public String roleARN() {
        return roleARN;
    }

    /**
     * <p>
     * A list of <code>Tag</code>s that specify information about the stack.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A list of <code>Tag</code>s that specify information about the stack.
     */
    public List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((stackId() == null) ? 0 : stackId().hashCode());
        hashCode = 31 * hashCode + ((stackName() == null) ? 0 : stackName().hashCode());
        hashCode = 31 * hashCode + ((changeSetId() == null) ? 0 : changeSetId().hashCode());
        hashCode = 31 * hashCode + ((description() == null) ? 0 : description().hashCode());
        hashCode = 31 * hashCode + ((parameters() == null) ? 0 : parameters().hashCode());
        hashCode = 31 * hashCode + ((creationTime() == null) ? 0 : creationTime().hashCode());
        hashCode = 31 * hashCode + ((lastUpdatedTime() == null) ? 0 : lastUpdatedTime().hashCode());
        hashCode = 31 * hashCode + ((stackStatus() == null) ? 0 : stackStatus().hashCode());
        hashCode = 31 * hashCode + ((stackStatusReason() == null) ? 0 : stackStatusReason().hashCode());
        hashCode = 31 * hashCode + ((disableRollback() == null) ? 0 : disableRollback().hashCode());
        hashCode = 31 * hashCode + ((notificationARNs() == null) ? 0 : notificationARNs().hashCode());
        hashCode = 31 * hashCode + ((timeoutInMinutes() == null) ? 0 : timeoutInMinutes().hashCode());
        hashCode = 31 * hashCode + ((capabilities() == null) ? 0 : capabilities().hashCode());
        hashCode = 31 * hashCode + ((outputs() == null) ? 0 : outputs().hashCode());
        hashCode = 31 * hashCode + ((roleARN() == null) ? 0 : roleARN().hashCode());
        hashCode = 31 * hashCode + ((tags() == null) ? 0 : tags().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Stack)) {
            return false;
        }
        Stack other = (Stack) obj;
        if (other.stackId() == null ^ this.stackId() == null) {
            return false;
        }
        if (other.stackId() != null && !other.stackId().equals(this.stackId())) {
            return false;
        }
        if (other.stackName() == null ^ this.stackName() == null) {
            return false;
        }
        if (other.stackName() != null && !other.stackName().equals(this.stackName())) {
            return false;
        }
        if (other.changeSetId() == null ^ this.changeSetId() == null) {
            return false;
        }
        if (other.changeSetId() != null && !other.changeSetId().equals(this.changeSetId())) {
            return false;
        }
        if (other.description() == null ^ this.description() == null) {
            return false;
        }
        if (other.description() != null && !other.description().equals(this.description())) {
            return false;
        }
        if (other.parameters() == null ^ this.parameters() == null) {
            return false;
        }
        if (other.parameters() != null && !other.parameters().equals(this.parameters())) {
            return false;
        }
        if (other.creationTime() == null ^ this.creationTime() == null) {
            return false;
        }
        if (other.creationTime() != null && !other.creationTime().equals(this.creationTime())) {
            return false;
        }
        if (other.lastUpdatedTime() == null ^ this.lastUpdatedTime() == null) {
            return false;
        }
        if (other.lastUpdatedTime() != null && !other.lastUpdatedTime().equals(this.lastUpdatedTime())) {
            return false;
        }
        if (other.stackStatus() == null ^ this.stackStatus() == null) {
            return false;
        }
        if (other.stackStatus() != null && !other.stackStatus().equals(this.stackStatus())) {
            return false;
        }
        if (other.stackStatusReason() == null ^ this.stackStatusReason() == null) {
            return false;
        }
        if (other.stackStatusReason() != null && !other.stackStatusReason().equals(this.stackStatusReason())) {
            return false;
        }
        if (other.disableRollback() == null ^ this.disableRollback() == null) {
            return false;
        }
        if (other.disableRollback() != null && !other.disableRollback().equals(this.disableRollback())) {
            return false;
        }
        if (other.notificationARNs() == null ^ this.notificationARNs() == null) {
            return false;
        }
        if (other.notificationARNs() != null && !other.notificationARNs().equals(this.notificationARNs())) {
            return false;
        }
        if (other.timeoutInMinutes() == null ^ this.timeoutInMinutes() == null) {
            return false;
        }
        if (other.timeoutInMinutes() != null && !other.timeoutInMinutes().equals(this.timeoutInMinutes())) {
            return false;
        }
        if (other.capabilities() == null ^ this.capabilities() == null) {
            return false;
        }
        if (other.capabilities() != null && !other.capabilities().equals(this.capabilities())) {
            return false;
        }
        if (other.outputs() == null ^ this.outputs() == null) {
            return false;
        }
        if (other.outputs() != null && !other.outputs().equals(this.outputs())) {
            return false;
        }
        if (other.roleARN() == null ^ this.roleARN() == null) {
            return false;
        }
        if (other.roleARN() != null && !other.roleARN().equals(this.roleARN())) {
            return false;
        }
        if (other.tags() == null ^ this.tags() == null) {
            return false;
        }
        if (other.tags() != null && !other.tags().equals(this.tags())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (stackId() != null) {
            sb.append("StackId: ").append(stackId()).append(",");
        }
        if (stackName() != null) {
            sb.append("StackName: ").append(stackName()).append(",");
        }
        if (changeSetId() != null) {
            sb.append("ChangeSetId: ").append(changeSetId()).append(",");
        }
        if (description() != null) {
            sb.append("Description: ").append(description()).append(",");
        }
        if (parameters() != null) {
            sb.append("Parameters: ").append(parameters()).append(",");
        }
        if (creationTime() != null) {
            sb.append("CreationTime: ").append(creationTime()).append(",");
        }
        if (lastUpdatedTime() != null) {
            sb.append("LastUpdatedTime: ").append(lastUpdatedTime()).append(",");
        }
        if (stackStatus() != null) {
            sb.append("StackStatus: ").append(stackStatus()).append(",");
        }
        if (stackStatusReason() != null) {
            sb.append("StackStatusReason: ").append(stackStatusReason()).append(",");
        }
        if (disableRollback() != null) {
            sb.append("DisableRollback: ").append(disableRollback()).append(",");
        }
        if (notificationARNs() != null) {
            sb.append("NotificationARNs: ").append(notificationARNs()).append(",");
        }
        if (timeoutInMinutes() != null) {
            sb.append("TimeoutInMinutes: ").append(timeoutInMinutes()).append(",");
        }
        if (capabilities() != null) {
            sb.append("Capabilities: ").append(capabilities()).append(",");
        }
        if (outputs() != null) {
            sb.append("Outputs: ").append(outputs()).append(",");
        }
        if (roleARN() != null) {
            sb.append("RoleARN: ").append(roleARN()).append(",");
        }
        if (tags() != null) {
            sb.append("Tags: ").append(tags()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, Stack> {
        /**
         * <p>
         * Unique identifier of the stack.
         * </p>
         * 
         * @param stackId
         *        Unique identifier of the stack.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stackId(String stackId);

        /**
         * <p>
         * The name associated with the stack.
         * </p>
         * 
         * @param stackName
         *        The name associated with the stack.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stackName(String stackName);

        /**
         * <p>
         * The unique ID of the change set.
         * </p>
         * 
         * @param changeSetId
         *        The unique ID of the change set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder changeSetId(String changeSetId);

        /**
         * <p>
         * A user-defined description associated with the stack.
         * </p>
         * 
         * @param description
         *        A user-defined description associated with the stack.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * A list of <code>Parameter</code> structures.
         * </p>
         * 
         * @param parameters
         *        A list of <code>Parameter</code> structures.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameters(Collection<Parameter> parameters);

        /**
         * <p>
         * A list of <code>Parameter</code> structures.
         * </p>
         * 
         * @param parameters
         *        A list of <code>Parameter</code> structures.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameters(Parameter... parameters);

        /**
         * <p>
         * The time at which the stack was created.
         * </p>
         * 
         * @param creationTime
         *        The time at which the stack was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * The time the stack was last updated. This field will only be returned if the stack has been updated at least
         * once.
         * </p>
         * 
         * @param lastUpdatedTime
         *        The time the stack was last updated. This field will only be returned if the stack has been updated at
         *        least once.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedTime(Instant lastUpdatedTime);

        /**
         * <p>
         * Current status of the stack.
         * </p>
         * 
         * @param stackStatus
         *        Current status of the stack.
         * @see StackStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StackStatus
         */
        Builder stackStatus(String stackStatus);

        /**
         * <p>
         * Current status of the stack.
         * </p>
         * 
         * @param stackStatus
         *        Current status of the stack.
         * @see StackStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StackStatus
         */
        Builder stackStatus(StackStatus stackStatus);

        /**
         * <p>
         * Success/failure message associated with the stack status.
         * </p>
         * 
         * @param stackStatusReason
         *        Success/failure message associated with the stack status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stackStatusReason(String stackStatusReason);

        /**
         * <p>
         * Boolean to enable or disable rollback on stack creation failures:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>true</code>: disable rollback
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>false</code>: enable rollback
         * </p>
         * </li>
         * </ul>
         * 
         * @param disableRollback
         *        Boolean to enable or disable rollback on stack creation failures:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>true</code>: disable rollback
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>false</code>: enable rollback
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder disableRollback(Boolean disableRollback);

        /**
         * <p>
         * SNS topic ARNs to which stack related events are published.
         * </p>
         * 
         * @param notificationARNs
         *        SNS topic ARNs to which stack related events are published.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notificationARNs(Collection<String> notificationARNs);

        /**
         * <p>
         * SNS topic ARNs to which stack related events are published.
         * </p>
         * 
         * @param notificationARNs
         *        SNS topic ARNs to which stack related events are published.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notificationARNs(String... notificationARNs);

        /**
         * <p>
         * The amount of time within which stack creation should complete.
         * </p>
         * 
         * @param timeoutInMinutes
         *        The amount of time within which stack creation should complete.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timeoutInMinutes(Integer timeoutInMinutes);

        /**
         * <p>
         * The capabilities allowed in the stack.
         * </p>
         * 
         * @param capabilities
         *        The capabilities allowed in the stack.
         * @see Capability
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Capability
         */
        Builder capabilities(Collection<String> capabilities);

        /**
         * <p>
         * The capabilities allowed in the stack.
         * </p>
         * 
         * @param capabilities
         *        The capabilities allowed in the stack.
         * @see Capability
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Capability
         */
        Builder capabilities(String... capabilities);

        /**
         * <p>
         * The capabilities allowed in the stack.
         * </p>
         * 
         * @param capabilities
         *        The capabilities allowed in the stack.
         * @see Capability
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Capability
         */
        Builder capabilities(Capability... capabilities);

        /**
         * <p>
         * A list of output structures.
         * </p>
         * 
         * @param outputs
         *        A list of output structures.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputs(Collection<Output> outputs);

        /**
         * <p>
         * A list of output structures.
         * </p>
         * 
         * @param outputs
         *        A list of output structures.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputs(Output... outputs);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of an AWS Identity and Access Management (IAM) role that is associated with
         * the stack. During a stack operation, AWS CloudFormation uses this role's credentials to make calls on your
         * behalf.
         * </p>
         * 
         * @param roleARN
         *        The Amazon Resource Name (ARN) of an AWS Identity and Access Management (IAM) role that is associated
         *        with the stack. During a stack operation, AWS CloudFormation uses this role's credentials to make
         *        calls on your behalf.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleARN(String roleARN);

        /**
         * <p>
         * A list of <code>Tag</code>s that specify information about the stack.
         * </p>
         * 
         * @param tags
         *        A list of <code>Tag</code>s that specify information about the stack.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * A list of <code>Tag</code>s that specify information about the stack.
         * </p>
         * 
         * @param tags
         *        A list of <code>Tag</code>s that specify information about the stack.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);
    }

    private static final class BuilderImpl implements Builder {
        private String stackId;

        private String stackName;

        private String changeSetId;

        private String description;

        private List<Parameter> parameters;

        private Instant creationTime;

        private Instant lastUpdatedTime;

        private String stackStatus;

        private String stackStatusReason;

        private Boolean disableRollback;

        private List<String> notificationARNs;

        private Integer timeoutInMinutes;

        private List<String> capabilities;

        private List<Output> outputs;

        private String roleARN;

        private List<Tag> tags;

        private BuilderImpl() {
        }

        private BuilderImpl(Stack model) {
            setStackId(model.stackId);
            setStackName(model.stackName);
            setChangeSetId(model.changeSetId);
            setDescription(model.description);
            setParameters(model.parameters);
            setCreationTime(model.creationTime);
            setLastUpdatedTime(model.lastUpdatedTime);
            setStackStatus(model.stackStatus);
            setStackStatusReason(model.stackStatusReason);
            setDisableRollback(model.disableRollback);
            setNotificationARNs(model.notificationARNs);
            setTimeoutInMinutes(model.timeoutInMinutes);
            setCapabilities(model.capabilities);
            setOutputs(model.outputs);
            setRoleARN(model.roleARN);
            setTags(model.tags);
        }

        public final String getStackId() {
            return stackId;
        }

        @Override
        public final Builder stackId(String stackId) {
            this.stackId = stackId;
            return this;
        }

        public final void setStackId(String stackId) {
            this.stackId = stackId;
        }

        public final String getStackName() {
            return stackName;
        }

        @Override
        public final Builder stackName(String stackName) {
            this.stackName = stackName;
            return this;
        }

        public final void setStackName(String stackName) {
            this.stackName = stackName;
        }

        public final String getChangeSetId() {
            return changeSetId;
        }

        @Override
        public final Builder changeSetId(String changeSetId) {
            this.changeSetId = changeSetId;
            return this;
        }

        public final void setChangeSetId(String changeSetId) {
            this.changeSetId = changeSetId;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Collection<Parameter> getParameters() {
            return parameters;
        }

        @Override
        public final Builder parameters(Collection<Parameter> parameters) {
            this.parameters = ParametersCopier.copy(parameters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameters(Parameter... parameters) {
            parameters(Arrays.asList(parameters));
            return this;
        }

        public final void setParameters(Collection<Parameter> parameters) {
            this.parameters = ParametersCopier.copy(parameters);
        }

        @SafeVarargs
        public final void setParameters(Parameter... parameters) {
            parameters(Arrays.asList(parameters));
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        public final Instant getLastUpdatedTime() {
            return lastUpdatedTime;
        }

        @Override
        public final Builder lastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
            return this;
        }

        public final void setLastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
        }

        public final String getStackStatus() {
            return stackStatus;
        }

        @Override
        public final Builder stackStatus(String stackStatus) {
            this.stackStatus = stackStatus;
            return this;
        }

        @Override
        public final Builder stackStatus(StackStatus stackStatus) {
            this.stackStatus(stackStatus.toString());
            return this;
        }

        public final void setStackStatus(String stackStatus) {
            this.stackStatus = stackStatus;
        }

        public final void setStackStatus(StackStatus stackStatus) {
            this.stackStatus(stackStatus.toString());
        }

        public final String getStackStatusReason() {
            return stackStatusReason;
        }

        @Override
        public final Builder stackStatusReason(String stackStatusReason) {
            this.stackStatusReason = stackStatusReason;
            return this;
        }

        public final void setStackStatusReason(String stackStatusReason) {
            this.stackStatusReason = stackStatusReason;
        }

        public final Boolean getDisableRollback() {
            return disableRollback;
        }

        @Override
        public final Builder disableRollback(Boolean disableRollback) {
            this.disableRollback = disableRollback;
            return this;
        }

        public final void setDisableRollback(Boolean disableRollback) {
            this.disableRollback = disableRollback;
        }

        public final Collection<String> getNotificationARNs() {
            return notificationARNs;
        }

        @Override
        public final Builder notificationARNs(Collection<String> notificationARNs) {
            this.notificationARNs = NotificationARNsCopier.copy(notificationARNs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder notificationARNs(String... notificationARNs) {
            notificationARNs(Arrays.asList(notificationARNs));
            return this;
        }

        public final void setNotificationARNs(Collection<String> notificationARNs) {
            this.notificationARNs = NotificationARNsCopier.copy(notificationARNs);
        }

        @SafeVarargs
        public final void setNotificationARNs(String... notificationARNs) {
            notificationARNs(Arrays.asList(notificationARNs));
        }

        public final Integer getTimeoutInMinutes() {
            return timeoutInMinutes;
        }

        @Override
        public final Builder timeoutInMinutes(Integer timeoutInMinutes) {
            this.timeoutInMinutes = timeoutInMinutes;
            return this;
        }

        public final void setTimeoutInMinutes(Integer timeoutInMinutes) {
            this.timeoutInMinutes = timeoutInMinutes;
        }

        public final Collection<String> getCapabilities() {
            return capabilities;
        }

        @Override
        public final Builder capabilities(Collection<String> capabilities) {
            this.capabilities = CapabilitiesCopier.copy(capabilities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder capabilities(String... capabilities) {
            capabilities(Arrays.asList(capabilities));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder capabilities(Capability... capabilities) {
            capabilities(Arrays.asList(capabilities).stream().map(Object::toString).collect(Collectors.toList()));
            return this;
        }

        public final void setCapabilities(Collection<String> capabilities) {
            this.capabilities = CapabilitiesCopier.copy(capabilities);
        }

        @SafeVarargs
        public final void setCapabilities(String... capabilities) {
            capabilities(Arrays.asList(capabilities));
        }

        @SafeVarargs
        public final void setCapabilities(Capability... capabilities) {
            capabilities(Arrays.asList(capabilities).stream().map(Object::toString).collect(Collectors.toList()));
        }

        public final Collection<Output> getOutputs() {
            return outputs;
        }

        @Override
        public final Builder outputs(Collection<Output> outputs) {
            this.outputs = OutputsCopier.copy(outputs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outputs(Output... outputs) {
            outputs(Arrays.asList(outputs));
            return this;
        }

        public final void setOutputs(Collection<Output> outputs) {
            this.outputs = OutputsCopier.copy(outputs);
        }

        @SafeVarargs
        public final void setOutputs(Output... outputs) {
            outputs(Arrays.asList(outputs));
        }

        public final String getRoleARN() {
            return roleARN;
        }

        @Override
        public final Builder roleARN(String roleARN) {
            this.roleARN = roleARN;
            return this;
        }

        public final void setRoleARN(String roleARN) {
            this.roleARN = roleARN;
        }

        public final Collection<Tag> getTags() {
            return tags;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        public final void setTags(Collection<Tag> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        @SafeVarargs
        public final void setTags(Tag... tags) {
            tags(Arrays.asList(tags));
        }

        @Override
        public Stack build() {
            return new Stack(this);
        }
    }
}
