/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudformation.transform;

import java.util.ArrayList;

import javax.xml.stream.events.XMLEvent;
import javax.annotation.Generated;

import software.amazon.awssdk.services.cloudformation.model.*;
import software.amazon.awssdk.runtime.transform.Unmarshaller;

import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers.*;

/**
 * ListStackResourcesResponse StAX Unmarshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class ListStackResourcesResponseUnmarshaller implements Unmarshaller<ListStackResourcesResponse, StaxUnmarshallerContext> {

    public ListStackResourcesResponse unmarshall(StaxUnmarshallerContext context) throws Exception {
        ListStackResourcesResponse.Builder listStackResourcesResponse = ListStackResourcesResponse.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;

        if (context.isStartOfDocument())
            targetDepth += 2;

        java.util.List<StackResourceSummary> stackResourceSummaries = null;

        while (true) {
            XMLEvent xmlEvent = context.nextEvent();
            if (xmlEvent.isEndDocument()) {
                listStackResourcesResponse.stackResourceSummaries(stackResourceSummaries);
                break;
            }

            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {

                if (context.testExpression("StackResourceSummaries", targetDepth)) {
                    stackResourceSummaries = new ArrayList<StackResourceSummary>();
                    continue;
                }

                if (context.testExpression("StackResourceSummaries/member", targetDepth)) {
                    stackResourceSummaries.add(StackResourceSummaryUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("NextToken", targetDepth)) {
                    listStackResourcesResponse.nextToken(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
            } else if (xmlEvent.isEndElement()) {
                if (context.getCurrentDepth() < originalDepth) {
                    listStackResourcesResponse.stackResourceSummaries(stackResourceSummaries);
                    break;
                }
            }
        }
        return listStackResourcesResponse.build();
    }

    private static ListStackResourcesResponseUnmarshaller INSTANCE;

    public static ListStackResourcesResponseUnmarshaller getInstance() {
        if (INSTANCE == null)
            INSTANCE = new ListStackResourcesResponseUnmarshaller();
        return INSTANCE;
    }
}
