/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudformation.transform;

import java.util.ArrayList;

import javax.xml.stream.events.XMLEvent;
import javax.annotation.Generated;

import software.amazon.awssdk.services.cloudformation.model.*;
import software.amazon.awssdk.runtime.transform.Unmarshaller;

import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers.*;

/**
 * ValidateTemplateResponse StAX Unmarshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class ValidateTemplateResponseUnmarshaller implements Unmarshaller<ValidateTemplateResponse, StaxUnmarshallerContext> {

    public ValidateTemplateResponse unmarshall(StaxUnmarshallerContext context) throws Exception {
        ValidateTemplateResponse.Builder validateTemplateResponse = ValidateTemplateResponse.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;

        if (context.isStartOfDocument())
            targetDepth += 2;

        java.util.List<TemplateParameter> parameters = null;
        java.util.List<String> capabilities = null;
        java.util.List<String> declaredTransforms = null;

        while (true) {
            XMLEvent xmlEvent = context.nextEvent();
            if (xmlEvent.isEndDocument()) {
                validateTemplateResponse.parameters(parameters);
                validateTemplateResponse.capabilities(capabilities);
                validateTemplateResponse.declaredTransforms(declaredTransforms);
                break;
            }

            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {

                if (context.testExpression("Parameters", targetDepth)) {
                    parameters = new ArrayList<TemplateParameter>();
                    continue;
                }

                if (context.testExpression("Parameters/member", targetDepth)) {
                    parameters.add(TemplateParameterUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("Description", targetDepth)) {
                    validateTemplateResponse.description(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("Capabilities", targetDepth)) {
                    capabilities = new ArrayList<String>();
                    continue;
                }

                if (context.testExpression("Capabilities/member", targetDepth)) {
                    capabilities.add(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("CapabilitiesReason", targetDepth)) {
                    validateTemplateResponse.capabilitiesReason(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("DeclaredTransforms", targetDepth)) {
                    declaredTransforms = new ArrayList<String>();
                    continue;
                }

                if (context.testExpression("DeclaredTransforms/member", targetDepth)) {
                    declaredTransforms.add(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

            } else if (xmlEvent.isEndElement()) {
                if (context.getCurrentDepth() < originalDepth) {
                    validateTemplateResponse.parameters(parameters);
                    validateTemplateResponse.capabilities(capabilities);
                    validateTemplateResponse.declaredTransforms(declaredTransforms);
                    break;
                }
            }
        }
        return validateTemplateResponse.build();
    }

    private static ValidateTemplateResponseUnmarshaller INSTANCE;

    public static ValidateTemplateResponseUnmarshaller getInstance() {
        if (INSTANCE == null)
            INSTANCE = new ValidateTemplateResponseUnmarshaller();
        return INSTANCE;
    }
}
