/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.transform;

import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.cloudformation.model.StackResourceSummary;

public class StackResourceSummaryUnmarshaller
implements Unmarshaller<StackResourceSummary, StaxUnmarshallerContext> {
    private static StackResourceSummaryUnmarshaller INSTANCE;

    public StackResourceSummary unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        StackResourceSummary.Builder stackResourceSummary = StackResourceSummary.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("LogicalResourceId", targetDepth)) {
                    stackResourceSummary.logicalResourceId(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("PhysicalResourceId", targetDepth)) {
                    stackResourceSummary.physicalResourceId(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("ResourceType", targetDepth)) {
                    stackResourceSummary.resourceType(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("LastUpdatedTimestamp", targetDepth)) {
                    stackResourceSummary.lastUpdatedTimestamp(SimpleTypeStaxUnmarshallers.InstantUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("ResourceStatus", targetDepth)) {
                    stackResourceSummary.resourceStatus(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("ResourceStatusReason", targetDepth)) continue;
                stackResourceSummary.resourceStatusReason(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (StackResourceSummary)stackResourceSummary.build();
    }

    public static StackResourceSummaryUnmarshaller getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new StackResourceSummaryUnmarshaller();
        }
        return INSTANCE;
    }
}

