/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudformation.model;

import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The <code>Change</code> structure describes the changes AWS CloudFormation will perform if you execute the change
 * set.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class Change implements ToCopyableBuilder<Change.Builder, Change> {
    private final String type;

    private final ResourceChange resourceChange;

    private Change(BuilderImpl builder) {
        this.type = builder.type;
        this.resourceChange = builder.resourceChange;
    }

    /**
     * <p>
     * The type of entity that AWS CloudFormation changes. Currently, the only entity type is <code>Resource</code>.
     * </p>
     * 
     * @return The type of entity that AWS CloudFormation changes. Currently, the only entity type is
     *         <code>Resource</code>.
     * @see ChangeType
     */
    public String type() {
        return type;
    }

    /**
     * <p>
     * A <code>ResourceChange</code> structure that describes the resource and action that AWS CloudFormation will
     * perform.
     * </p>
     * 
     * @return A <code>ResourceChange</code> structure that describes the resource and action that AWS CloudFormation
     *         will perform.
     */
    public ResourceChange resourceChange() {
        return resourceChange;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((type() == null) ? 0 : type().hashCode());
        hashCode = 31 * hashCode + ((resourceChange() == null) ? 0 : resourceChange().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Change)) {
            return false;
        }
        Change other = (Change) obj;
        if (other.type() == null ^ this.type() == null) {
            return false;
        }
        if (other.type() != null && !other.type().equals(this.type())) {
            return false;
        }
        if (other.resourceChange() == null ^ this.resourceChange() == null) {
            return false;
        }
        if (other.resourceChange() != null && !other.resourceChange().equals(this.resourceChange())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (type() != null) {
            sb.append("Type: ").append(type()).append(",");
        }
        if (resourceChange() != null) {
            sb.append("ResourceChange: ").append(resourceChange()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, Change> {
        /**
         * <p>
         * The type of entity that AWS CloudFormation changes. Currently, the only entity type is <code>Resource</code>.
         * </p>
         * 
         * @param type
         *        The type of entity that AWS CloudFormation changes. Currently, the only entity type is
         *        <code>Resource</code>.
         * @see ChangeType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ChangeType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of entity that AWS CloudFormation changes. Currently, the only entity type is <code>Resource</code>.
         * </p>
         * 
         * @param type
         *        The type of entity that AWS CloudFormation changes. Currently, the only entity type is
         *        <code>Resource</code>.
         * @see ChangeType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ChangeType
         */
        Builder type(ChangeType type);

        /**
         * <p>
         * A <code>ResourceChange</code> structure that describes the resource and action that AWS CloudFormation will
         * perform.
         * </p>
         * 
         * @param resourceChange
         *        A <code>ResourceChange</code> structure that describes the resource and action that AWS CloudFormation
         *        will perform.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceChange(ResourceChange resourceChange);
    }

    private static final class BuilderImpl implements Builder {
        private String type;

        private ResourceChange resourceChange;

        private BuilderImpl() {
        }

        private BuilderImpl(Change model) {
            setType(model.type);
            setResourceChange(model.resourceChange);
        }

        public final String getType() {
            return type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(ChangeType type) {
            this.type(type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final ResourceChange getResourceChange() {
            return resourceChange;
        }

        @Override
        public final Builder resourceChange(ResourceChange resourceChange) {
            this.resourceChange = resourceChange;
            return this;
        }

        public final void setResourceChange(ResourceChange resourceChange) {
            this.resourceChange = resourceChange;
        }

        @Override
        public Change build() {
            return new Change(this);
        }
    }
}
