/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudformation.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The input for the <a>ContinueUpdateRollback</a> action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ContinueUpdateRollbackRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<ContinueUpdateRollbackRequest.Builder, ContinueUpdateRollbackRequest> {
    private final String stackName;

    private final String roleARN;

    private final List<String> resourcesToSkip;

    private final String clientRequestToken;

    private ContinueUpdateRollbackRequest(BuilderImpl builder) {
        this.stackName = builder.stackName;
        this.roleARN = builder.roleARN;
        this.resourcesToSkip = builder.resourcesToSkip;
        this.clientRequestToken = builder.clientRequestToken;
    }

    /**
     * <p>
     * The name or the unique ID of the stack that you want to continue rolling back.
     * </p>
     * <note>
     * <p>
     * Don't specify the name of a nested stack (a stack that was created by using the
     * <code>AWS::CloudFormation::Stack</code> resource). Instead, use this operation on the parent stack (the stack
     * that contains the <code>AWS::CloudFormation::Stack</code> resource).
     * </p>
     * </note>
     * 
     * @return The name or the unique ID of the stack that you want to continue rolling back.</p> <note>
     *         <p>
     *         Don't specify the name of a nested stack (a stack that was created by using the
     *         <code>AWS::CloudFormation::Stack</code> resource). Instead, use this operation on the parent stack (the
     *         stack that contains the <code>AWS::CloudFormation::Stack</code> resource).
     *         </p>
     */
    public String stackName() {
        return stackName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of an AWS Identity and Access Management (IAM) role that AWS CloudFormation
     * assumes to roll back the stack. AWS CloudFormation uses the role's credentials to make calls on your behalf. AWS
     * CloudFormation always uses this role for all future operations on the stack. As long as users have permission to
     * operate on the stack, AWS CloudFormation uses this role even if the users don't have permission to pass it.
     * Ensure that the role grants least privilege.
     * </p>
     * <p>
     * If you don't specify a value, AWS CloudFormation uses the role that was previously associated with the stack. If
     * no role is available, AWS CloudFormation uses a temporary session that is generated from your user credentials.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of an AWS Identity and Access Management (IAM) role that AWS
     *         CloudFormation assumes to roll back the stack. AWS CloudFormation uses the role's credentials to make
     *         calls on your behalf. AWS CloudFormation always uses this role for all future operations on the stack. As
     *         long as users have permission to operate on the stack, AWS CloudFormation uses this role even if the
     *         users don't have permission to pass it. Ensure that the role grants least privilege.</p>
     *         <p>
     *         If you don't specify a value, AWS CloudFormation uses the role that was previously associated with the
     *         stack. If no role is available, AWS CloudFormation uses a temporary session that is generated from your
     *         user credentials.
     */
    public String roleARN() {
        return roleARN;
    }

    /**
     * <p>
     * A list of the logical IDs of the resources that AWS CloudFormation skips during the continue update rollback
     * operation. You can specify only resources that are in the <code>UPDATE_FAILED</code> state because a rollback
     * failed. You can't specify resources that are in the <code>UPDATE_FAILED</code> state for other reasons, for
     * example, because an update was canceled. To check why a resource update failed, use the
     * <a>DescribeStackResources</a> action, and view the resource status reason.
     * </p>
     * <important>
     * <p>
     * Specify this property to skip rolling back resources that AWS CloudFormation can't successfully roll back. We
     * recommend that you <a href=
     * "http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/troubleshooting.html#troubleshooting-errors-update-rollback-failed"
     * > troubleshoot</a> resources before skipping them. AWS CloudFormation sets the status of the specified resources
     * to <code>UPDATE_COMPLETE</code> and continues to roll back the stack. After the rollback is complete, the state
     * of the skipped resources will be inconsistent with the state of the resources in the stack template. Before
     * performing another stack update, you must update the stack or resources to be consistent with each other. If you
     * don't, subsequent stack updates might fail, and the stack will become unrecoverable.
     * </p>
     * </important>
     * <p>
     * Specify the minimum number of resources required to successfully roll back your stack. For example, a failed
     * resource update might cause dependent resources to fail. In this case, it might not be necessary to skip the
     * dependent resources.
     * </p>
     * <p>
     * To specify resources in a nested stack, use the following format: <code>NestedStackName.ResourceLogicalID</code>.
     * If the <code>ResourceLogicalID</code> is a stack resource (<code>Type: AWS::CloudFormation::Stack</code>), it
     * must be in one of the following states: <code>DELETE_IN_PROGRESS</code>, <code>DELETE_COMPLETE</code>, or
     * <code>DELETE_FAILED</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A list of the logical IDs of the resources that AWS CloudFormation skips during the continue update
     *         rollback operation. You can specify only resources that are in the <code>UPDATE_FAILED</code> state
     *         because a rollback failed. You can't specify resources that are in the <code>UPDATE_FAILED</code> state
     *         for other reasons, for example, because an update was canceled. To check why a resource update failed,
     *         use the <a>DescribeStackResources</a> action, and view the resource status reason. </p> <important>
     *         <p>
     *         Specify this property to skip rolling back resources that AWS CloudFormation can't successfully roll
     *         back. We recommend that you <a href=
     *         "http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/troubleshooting.html#troubleshooting-errors-update-rollback-failed"
     *         > troubleshoot</a> resources before skipping them. AWS CloudFormation sets the status of the specified
     *         resources to <code>UPDATE_COMPLETE</code> and continues to roll back the stack. After the rollback is
     *         complete, the state of the skipped resources will be inconsistent with the state of the resources in the
     *         stack template. Before performing another stack update, you must update the stack or resources to be
     *         consistent with each other. If you don't, subsequent stack updates might fail, and the stack will become
     *         unrecoverable.
     *         </p>
     *         </important>
     *         <p>
     *         Specify the minimum number of resources required to successfully roll back your stack. For example, a
     *         failed resource update might cause dependent resources to fail. In this case, it might not be necessary
     *         to skip the dependent resources.
     *         </p>
     *         <p>
     *         To specify resources in a nested stack, use the following format:
     *         <code>NestedStackName.ResourceLogicalID</code>. If the <code>ResourceLogicalID</code> is a stack resource
     *         (<code>Type: AWS::CloudFormation::Stack</code>), it must be in one of the following states:
     *         <code>DELETE_IN_PROGRESS</code>, <code>DELETE_COMPLETE</code>, or <code>DELETE_FAILED</code>.
     */
    public List<String> resourcesToSkip() {
        return resourcesToSkip;
    }

    /**
     * <p>
     * A unique identifier for this <code>ContinueUpdateRollback</code> request. Specify this token if you plan to retry
     * requests so that AWS CloudFormation knows that you're not attempting to continue the rollback to a stack with the
     * same name. You might retry <code>ContinueUpdateRollback</code> requests to ensure that AWS CloudFormation
     * successfully received them.
     * </p>
     * 
     * @return A unique identifier for this <code>ContinueUpdateRollback</code> request. Specify this token if you plan
     *         to retry requests so that AWS CloudFormation knows that you're not attempting to continue the rollback to
     *         a stack with the same name. You might retry <code>ContinueUpdateRollback</code> requests to ensure that
     *         AWS CloudFormation successfully received them.
     */
    public String clientRequestToken() {
        return clientRequestToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((stackName() == null) ? 0 : stackName().hashCode());
        hashCode = 31 * hashCode + ((roleARN() == null) ? 0 : roleARN().hashCode());
        hashCode = 31 * hashCode + ((resourcesToSkip() == null) ? 0 : resourcesToSkip().hashCode());
        hashCode = 31 * hashCode + ((clientRequestToken() == null) ? 0 : clientRequestToken().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ContinueUpdateRollbackRequest)) {
            return false;
        }
        ContinueUpdateRollbackRequest other = (ContinueUpdateRollbackRequest) obj;
        if (other.stackName() == null ^ this.stackName() == null) {
            return false;
        }
        if (other.stackName() != null && !other.stackName().equals(this.stackName())) {
            return false;
        }
        if (other.roleARN() == null ^ this.roleARN() == null) {
            return false;
        }
        if (other.roleARN() != null && !other.roleARN().equals(this.roleARN())) {
            return false;
        }
        if (other.resourcesToSkip() == null ^ this.resourcesToSkip() == null) {
            return false;
        }
        if (other.resourcesToSkip() != null && !other.resourcesToSkip().equals(this.resourcesToSkip())) {
            return false;
        }
        if (other.clientRequestToken() == null ^ this.clientRequestToken() == null) {
            return false;
        }
        if (other.clientRequestToken() != null && !other.clientRequestToken().equals(this.clientRequestToken())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (stackName() != null) {
            sb.append("StackName: ").append(stackName()).append(",");
        }
        if (roleARN() != null) {
            sb.append("RoleARN: ").append(roleARN()).append(",");
        }
        if (resourcesToSkip() != null) {
            sb.append("ResourcesToSkip: ").append(resourcesToSkip()).append(",");
        }
        if (clientRequestToken() != null) {
            sb.append("ClientRequestToken: ").append(clientRequestToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, ContinueUpdateRollbackRequest> {
        /**
         * <p>
         * The name or the unique ID of the stack that you want to continue rolling back.
         * </p>
         * <note>
         * <p>
         * Don't specify the name of a nested stack (a stack that was created by using the
         * <code>AWS::CloudFormation::Stack</code> resource). Instead, use this operation on the parent stack (the stack
         * that contains the <code>AWS::CloudFormation::Stack</code> resource).
         * </p>
         * </note>
         * 
         * @param stackName
         *        The name or the unique ID of the stack that you want to continue rolling back.</p> <note>
         *        <p>
         *        Don't specify the name of a nested stack (a stack that was created by using the
         *        <code>AWS::CloudFormation::Stack</code> resource). Instead, use this operation on the parent stack
         *        (the stack that contains the <code>AWS::CloudFormation::Stack</code> resource).
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stackName(String stackName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of an AWS Identity and Access Management (IAM) role that AWS CloudFormation
         * assumes to roll back the stack. AWS CloudFormation uses the role's credentials to make calls on your behalf.
         * AWS CloudFormation always uses this role for all future operations on the stack. As long as users have
         * permission to operate on the stack, AWS CloudFormation uses this role even if the users don't have permission
         * to pass it. Ensure that the role grants least privilege.
         * </p>
         * <p>
         * If you don't specify a value, AWS CloudFormation uses the role that was previously associated with the stack.
         * If no role is available, AWS CloudFormation uses a temporary session that is generated from your user
         * credentials.
         * </p>
         * 
         * @param roleARN
         *        The Amazon Resource Name (ARN) of an AWS Identity and Access Management (IAM) role that AWS
         *        CloudFormation assumes to roll back the stack. AWS CloudFormation uses the role's credentials to make
         *        calls on your behalf. AWS CloudFormation always uses this role for all future operations on the stack.
         *        As long as users have permission to operate on the stack, AWS CloudFormation uses this role even if
         *        the users don't have permission to pass it. Ensure that the role grants least privilege.</p>
         *        <p>
         *        If you don't specify a value, AWS CloudFormation uses the role that was previously associated with the
         *        stack. If no role is available, AWS CloudFormation uses a temporary session that is generated from
         *        your user credentials.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleARN(String roleARN);

        /**
         * <p>
         * A list of the logical IDs of the resources that AWS CloudFormation skips during the continue update rollback
         * operation. You can specify only resources that are in the <code>UPDATE_FAILED</code> state because a rollback
         * failed. You can't specify resources that are in the <code>UPDATE_FAILED</code> state for other reasons, for
         * example, because an update was canceled. To check why a resource update failed, use the
         * <a>DescribeStackResources</a> action, and view the resource status reason.
         * </p>
         * <important>
         * <p>
         * Specify this property to skip rolling back resources that AWS CloudFormation can't successfully roll back. We
         * recommend that you <a href=
         * "http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/troubleshooting.html#troubleshooting-errors-update-rollback-failed"
         * > troubleshoot</a> resources before skipping them. AWS CloudFormation sets the status of the specified
         * resources to <code>UPDATE_COMPLETE</code> and continues to roll back the stack. After the rollback is
         * complete, the state of the skipped resources will be inconsistent with the state of the resources in the
         * stack template. Before performing another stack update, you must update the stack or resources to be
         * consistent with each other. If you don't, subsequent stack updates might fail, and the stack will become
         * unrecoverable.
         * </p>
         * </important>
         * <p>
         * Specify the minimum number of resources required to successfully roll back your stack. For example, a failed
         * resource update might cause dependent resources to fail. In this case, it might not be necessary to skip the
         * dependent resources.
         * </p>
         * <p>
         * To specify resources in a nested stack, use the following format:
         * <code>NestedStackName.ResourceLogicalID</code>. If the <code>ResourceLogicalID</code> is a stack resource (
         * <code>Type: AWS::CloudFormation::Stack</code>), it must be in one of the following states:
         * <code>DELETE_IN_PROGRESS</code>, <code>DELETE_COMPLETE</code>, or <code>DELETE_FAILED</code>.
         * </p>
         * 
         * @param resourcesToSkip
         *        A list of the logical IDs of the resources that AWS CloudFormation skips during the continue update
         *        rollback operation. You can specify only resources that are in the <code>UPDATE_FAILED</code> state
         *        because a rollback failed. You can't specify resources that are in the <code>UPDATE_FAILED</code>
         *        state for other reasons, for example, because an update was canceled. To check why a resource update
         *        failed, use the <a>DescribeStackResources</a> action, and view the resource status reason. </p>
         *        <important>
         *        <p>
         *        Specify this property to skip rolling back resources that AWS CloudFormation can't successfully roll
         *        back. We recommend that you <a href=
         *        "http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/troubleshooting.html#troubleshooting-errors-update-rollback-failed"
         *        > troubleshoot</a> resources before skipping them. AWS CloudFormation sets the status of the specified
         *        resources to <code>UPDATE_COMPLETE</code> and continues to roll back the stack. After the rollback is
         *        complete, the state of the skipped resources will be inconsistent with the state of the resources in
         *        the stack template. Before performing another stack update, you must update the stack or resources to
         *        be consistent with each other. If you don't, subsequent stack updates might fail, and the stack will
         *        become unrecoverable.
         *        </p>
         *        </important>
         *        <p>
         *        Specify the minimum number of resources required to successfully roll back your stack. For example, a
         *        failed resource update might cause dependent resources to fail. In this case, it might not be
         *        necessary to skip the dependent resources.
         *        </p>
         *        <p>
         *        To specify resources in a nested stack, use the following format:
         *        <code>NestedStackName.ResourceLogicalID</code>. If the <code>ResourceLogicalID</code> is a stack
         *        resource (<code>Type: AWS::CloudFormation::Stack</code>), it must be in one of the following states:
         *        <code>DELETE_IN_PROGRESS</code>, <code>DELETE_COMPLETE</code>, or <code>DELETE_FAILED</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourcesToSkip(Collection<String> resourcesToSkip);

        /**
         * <p>
         * A list of the logical IDs of the resources that AWS CloudFormation skips during the continue update rollback
         * operation. You can specify only resources that are in the <code>UPDATE_FAILED</code> state because a rollback
         * failed. You can't specify resources that are in the <code>UPDATE_FAILED</code> state for other reasons, for
         * example, because an update was canceled. To check why a resource update failed, use the
         * <a>DescribeStackResources</a> action, and view the resource status reason.
         * </p>
         * <important>
         * <p>
         * Specify this property to skip rolling back resources that AWS CloudFormation can't successfully roll back. We
         * recommend that you <a href=
         * "http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/troubleshooting.html#troubleshooting-errors-update-rollback-failed"
         * > troubleshoot</a> resources before skipping them. AWS CloudFormation sets the status of the specified
         * resources to <code>UPDATE_COMPLETE</code> and continues to roll back the stack. After the rollback is
         * complete, the state of the skipped resources will be inconsistent with the state of the resources in the
         * stack template. Before performing another stack update, you must update the stack or resources to be
         * consistent with each other. If you don't, subsequent stack updates might fail, and the stack will become
         * unrecoverable.
         * </p>
         * </important>
         * <p>
         * Specify the minimum number of resources required to successfully roll back your stack. For example, a failed
         * resource update might cause dependent resources to fail. In this case, it might not be necessary to skip the
         * dependent resources.
         * </p>
         * <p>
         * To specify resources in a nested stack, use the following format:
         * <code>NestedStackName.ResourceLogicalID</code>. If the <code>ResourceLogicalID</code> is a stack resource (
         * <code>Type: AWS::CloudFormation::Stack</code>), it must be in one of the following states:
         * <code>DELETE_IN_PROGRESS</code>, <code>DELETE_COMPLETE</code>, or <code>DELETE_FAILED</code>.
         * </p>
         * 
         * @param resourcesToSkip
         *        A list of the logical IDs of the resources that AWS CloudFormation skips during the continue update
         *        rollback operation. You can specify only resources that are in the <code>UPDATE_FAILED</code> state
         *        because a rollback failed. You can't specify resources that are in the <code>UPDATE_FAILED</code>
         *        state for other reasons, for example, because an update was canceled. To check why a resource update
         *        failed, use the <a>DescribeStackResources</a> action, and view the resource status reason. </p>
         *        <important>
         *        <p>
         *        Specify this property to skip rolling back resources that AWS CloudFormation can't successfully roll
         *        back. We recommend that you <a href=
         *        "http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/troubleshooting.html#troubleshooting-errors-update-rollback-failed"
         *        > troubleshoot</a> resources before skipping them. AWS CloudFormation sets the status of the specified
         *        resources to <code>UPDATE_COMPLETE</code> and continues to roll back the stack. After the rollback is
         *        complete, the state of the skipped resources will be inconsistent with the state of the resources in
         *        the stack template. Before performing another stack update, you must update the stack or resources to
         *        be consistent with each other. If you don't, subsequent stack updates might fail, and the stack will
         *        become unrecoverable.
         *        </p>
         *        </important>
         *        <p>
         *        Specify the minimum number of resources required to successfully roll back your stack. For example, a
         *        failed resource update might cause dependent resources to fail. In this case, it might not be
         *        necessary to skip the dependent resources.
         *        </p>
         *        <p>
         *        To specify resources in a nested stack, use the following format:
         *        <code>NestedStackName.ResourceLogicalID</code>. If the <code>ResourceLogicalID</code> is a stack
         *        resource (<code>Type: AWS::CloudFormation::Stack</code>), it must be in one of the following states:
         *        <code>DELETE_IN_PROGRESS</code>, <code>DELETE_COMPLETE</code>, or <code>DELETE_FAILED</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourcesToSkip(String... resourcesToSkip);

        /**
         * <p>
         * A unique identifier for this <code>ContinueUpdateRollback</code> request. Specify this token if you plan to
         * retry requests so that AWS CloudFormation knows that you're not attempting to continue the rollback to a
         * stack with the same name. You might retry <code>ContinueUpdateRollback</code> requests to ensure that AWS
         * CloudFormation successfully received them.
         * </p>
         * 
         * @param clientRequestToken
         *        A unique identifier for this <code>ContinueUpdateRollback</code> request. Specify this token if you
         *        plan to retry requests so that AWS CloudFormation knows that you're not attempting to continue the
         *        rollback to a stack with the same name. You might retry <code>ContinueUpdateRollback</code> requests
         *        to ensure that AWS CloudFormation successfully received them.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientRequestToken(String clientRequestToken);
    }

    private static final class BuilderImpl implements Builder {
        private String stackName;

        private String roleARN;

        private List<String> resourcesToSkip;

        private String clientRequestToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ContinueUpdateRollbackRequest model) {
            setStackName(model.stackName);
            setRoleARN(model.roleARN);
            setResourcesToSkip(model.resourcesToSkip);
            setClientRequestToken(model.clientRequestToken);
        }

        public final String getStackName() {
            return stackName;
        }

        @Override
        public final Builder stackName(String stackName) {
            this.stackName = stackName;
            return this;
        }

        public final void setStackName(String stackName) {
            this.stackName = stackName;
        }

        public final String getRoleARN() {
            return roleARN;
        }

        @Override
        public final Builder roleARN(String roleARN) {
            this.roleARN = roleARN;
            return this;
        }

        public final void setRoleARN(String roleARN) {
            this.roleARN = roleARN;
        }

        public final Collection<String> getResourcesToSkip() {
            return resourcesToSkip;
        }

        @Override
        public final Builder resourcesToSkip(Collection<String> resourcesToSkip) {
            this.resourcesToSkip = ResourcesToSkipCopier.copy(resourcesToSkip);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourcesToSkip(String... resourcesToSkip) {
            resourcesToSkip(Arrays.asList(resourcesToSkip));
            return this;
        }

        public final void setResourcesToSkip(Collection<String> resourcesToSkip) {
            this.resourcesToSkip = ResourcesToSkipCopier.copy(resourcesToSkip);
        }

        public final String getClientRequestToken() {
            return clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        @Override
        public ContinueUpdateRollbackRequest build() {
            return new ContinueUpdateRollbackRequest(this);
        }
    }
}
