/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudformation.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The output for the <a>CreateChangeSet</a> action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class CreateChangeSetResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<CreateChangeSetResponse.Builder, CreateChangeSetResponse> {
    private final String id;

    private final String stackId;

    private CreateChangeSetResponse(BuilderImpl builder) {
        this.id = builder.id;
        this.stackId = builder.stackId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the change set.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the change set.
     */
    public String id() {
        return id;
    }

    /**
     * <p>
     * The unique ID of the stack.
     * </p>
     * 
     * @return The unique ID of the stack.
     */
    public String stackId() {
        return stackId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((id() == null) ? 0 : id().hashCode());
        hashCode = 31 * hashCode + ((stackId() == null) ? 0 : stackId().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateChangeSetResponse)) {
            return false;
        }
        CreateChangeSetResponse other = (CreateChangeSetResponse) obj;
        if (other.id() == null ^ this.id() == null) {
            return false;
        }
        if (other.id() != null && !other.id().equals(this.id())) {
            return false;
        }
        if (other.stackId() == null ^ this.stackId() == null) {
            return false;
        }
        if (other.stackId() != null && !other.stackId().equals(this.stackId())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (id() != null) {
            sb.append("Id: ").append(id()).append(",");
        }
        if (stackId() != null) {
            sb.append("StackId: ").append(stackId()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, CreateChangeSetResponse> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the change set.
         * </p>
         * 
         * @param id
         *        The Amazon Resource Name (ARN) of the change set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The unique ID of the stack.
         * </p>
         * 
         * @param stackId
         *        The unique ID of the stack.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stackId(String stackId);
    }

    private static final class BuilderImpl implements Builder {
        private String id;

        private String stackId;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateChangeSetResponse model) {
            setId(model.id);
            setStackId(model.stackId);
        }

        public final String getId() {
            return id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getStackId() {
            return stackId;
        }

        @Override
        public final Builder stackId(String stackId) {
            this.stackId = stackId;
            return this;
        }

        public final void setStackId(String stackId) {
            this.stackId = stackId;
        }

        @Override
        public CreateChangeSetResponse build() {
            return new CreateChangeSetResponse(this);
        }
    }
}
