/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudformation.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The input for <a>CreateStack</a> action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class CreateStackRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<CreateStackRequest.Builder, CreateStackRequest> {
    private final String stackName;

    private final String templateBody;

    private final String templateURL;

    private final List<Parameter> parameters;

    private final Boolean disableRollback;

    private final Integer timeoutInMinutes;

    private final List<String> notificationARNs;

    private final List<String> capabilities;

    private final List<String> resourceTypes;

    private final String roleARN;

    private final String onFailure;

    private final String stackPolicyBody;

    private final String stackPolicyURL;

    private final List<Tag> tags;

    private final String clientRequestToken;

    private CreateStackRequest(BuilderImpl builder) {
        this.stackName = builder.stackName;
        this.templateBody = builder.templateBody;
        this.templateURL = builder.templateURL;
        this.parameters = builder.parameters;
        this.disableRollback = builder.disableRollback;
        this.timeoutInMinutes = builder.timeoutInMinutes;
        this.notificationARNs = builder.notificationARNs;
        this.capabilities = builder.capabilities;
        this.resourceTypes = builder.resourceTypes;
        this.roleARN = builder.roleARN;
        this.onFailure = builder.onFailure;
        this.stackPolicyBody = builder.stackPolicyBody;
        this.stackPolicyURL = builder.stackPolicyURL;
        this.tags = builder.tags;
        this.clientRequestToken = builder.clientRequestToken;
    }

    /**
     * <p>
     * The name that is associated with the stack. The name must be unique in the region in which you are creating the
     * stack.
     * </p>
     * <note>
     * <p>
     * A stack name can contain only alphanumeric characters (case sensitive) and hyphens. It must start with an
     * alphabetic character and cannot be longer than 128 characters.
     * </p>
     * </note>
     * 
     * @return The name that is associated with the stack. The name must be unique in the region in which you are
     *         creating the stack.</p> <note>
     *         <p>
     *         A stack name can contain only alphanumeric characters (case sensitive) and hyphens. It must start with an
     *         alphabetic character and cannot be longer than 128 characters.
     *         </p>
     */
    public String stackName() {
        return stackName;
    }

    /**
     * <p>
     * Structure containing the template body with a minimum length of 1 byte and a maximum length of 51,200 bytes. For
     * more information, go to <a
     * href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html">Template Anatomy</a>
     * in the AWS CloudFormation User Guide.
     * </p>
     * <p>
     * Conditional: You must specify either the <code>TemplateBody</code> or the <code>TemplateURL</code> parameter, but
     * not both.
     * </p>
     * 
     * @return Structure containing the template body with a minimum length of 1 byte and a maximum length of 51,200
     *         bytes. For more information, go to <a
     *         href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html">Template
     *         Anatomy</a> in the AWS CloudFormation User Guide.</p>
     *         <p>
     *         Conditional: You must specify either the <code>TemplateBody</code> or the <code>TemplateURL</code>
     *         parameter, but not both.
     */
    public String templateBody() {
        return templateBody;
    }

    /**
     * <p>
     * Location of file containing the template body. The URL must point to a template (max size: 460,800 bytes) that is
     * located in an Amazon S3 bucket. For more information, go to the <a
     * href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html">Template Anatomy</a>
     * in the AWS CloudFormation User Guide.
     * </p>
     * <p>
     * Conditional: You must specify either the <code>TemplateBody</code> or the <code>TemplateURL</code> parameter, but
     * not both.
     * </p>
     * 
     * @return Location of file containing the template body. The URL must point to a template (max size: 460,800 bytes)
     *         that is located in an Amazon S3 bucket. For more information, go to the <a
     *         href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html">Template
     *         Anatomy</a> in the AWS CloudFormation User Guide.</p>
     *         <p>
     *         Conditional: You must specify either the <code>TemplateBody</code> or the <code>TemplateURL</code>
     *         parameter, but not both.
     */
    public String templateURL() {
        return templateURL;
    }

    /**
     * <p>
     * A list of <code>Parameter</code> structures that specify input parameters for the stack. For more information,
     * see the <a
     * href="http://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_Parameter.html">Parameter</a> data
     * type.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A list of <code>Parameter</code> structures that specify input parameters for the stack. For more
     *         information, see the <a
     *         href="http://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_Parameter.html">Parameter</a>
     *         data type.
     */
    public List<Parameter> parameters() {
        return parameters;
    }

    /**
     * <p>
     * Set to <code>true</code> to disable rollback of the stack if stack creation failed. You can specify either
     * <code>DisableRollback</code> or <code>OnFailure</code>, but not both.
     * </p>
     * <p>
     * Default: <code>false</code>
     * </p>
     * 
     * @return Set to <code>true</code> to disable rollback of the stack if stack creation failed. You can specify
     *         either <code>DisableRollback</code> or <code>OnFailure</code>, but not both.</p>
     *         <p>
     *         Default: <code>false</code>
     */
    public Boolean disableRollback() {
        return disableRollback;
    }

    /**
     * <p>
     * The amount of time that can pass before the stack status becomes CREATE_FAILED; if <code>DisableRollback</code>
     * is not set or is set to <code>false</code>, the stack will be rolled back.
     * </p>
     * 
     * @return The amount of time that can pass before the stack status becomes CREATE_FAILED; if
     *         <code>DisableRollback</code> is not set or is set to <code>false</code>, the stack will be rolled back.
     */
    public Integer timeoutInMinutes() {
        return timeoutInMinutes;
    }

    /**
     * <p>
     * The Simple Notification Service (SNS) topic ARNs to publish stack related events. You can find your SNS topic
     * ARNs using the SNS console or your Command Line Interface (CLI).
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The Simple Notification Service (SNS) topic ARNs to publish stack related events. You can find your SNS
     *         topic ARNs using the SNS console or your Command Line Interface (CLI).
     */
    public List<String> notificationARNs() {
        return notificationARNs;
    }

    /**
     * <p>
     * A list of values that you must specify before AWS CloudFormation can create certain stacks. Some stack templates
     * might include resources that can affect permissions in your AWS account, for example, by creating new AWS
     * Identity and Access Management (IAM) users. For those stacks, you must explicitly acknowledge their capabilities
     * by specifying this parameter.
     * </p>
     * <p>
     * The only valid values are <code>CAPABILITY_IAM</code> and <code>CAPABILITY_NAMED_IAM</code>. The following
     * resources require you to specify this parameter: <a
     * href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-accesskey.html">
     * AWS::IAM::AccessKey</a>, <a
     * href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-group.html">
     * AWS::IAM::Group</a>, <a
     * href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-instanceprofile.html">
     * AWS::IAM::InstanceProfile</a>, <a
     * href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-policy.html">
     * AWS::IAM::Policy</a>, <a
     * href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-role.html">
     * AWS::IAM::Role</a>, <a
     * href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-user.html">
     * AWS::IAM::User</a>, and <a
     * href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-addusertogroup.html">
     * AWS::IAM::UserToGroupAddition</a>. If your stack template contains these resources, we recommend that you review
     * all permissions associated with them and edit their permissions if necessary.
     * </p>
     * <p>
     * If you have IAM resources, you can specify either capability. If you have IAM resources with custom names, you
     * must specify <code>CAPABILITY_NAMED_IAM</code>. If you don't specify this parameter, this action returns an
     * <code>InsufficientCapabilities</code> error.
     * </p>
     * <p>
     * For more information, see <a
     * href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html#capabilities"
     * >Acknowledging IAM Resources in AWS CloudFormation Templates</a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A list of values that you must specify before AWS CloudFormation can create certain stacks. Some stack
     *         templates might include resources that can affect permissions in your AWS account, for example, by
     *         creating new AWS Identity and Access Management (IAM) users. For those stacks, you must explicitly
     *         acknowledge their capabilities by specifying this parameter.</p>
     *         <p>
     *         The only valid values are <code>CAPABILITY_IAM</code> and <code>CAPABILITY_NAMED_IAM</code>. The
     *         following resources require you to specify this parameter: <a
     *         href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-accesskey.html">
     *         AWS::IAM::AccessKey</a>, <a
     *         href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-group.html">
     *         AWS::IAM::Group</a>, <a href=
     *         "http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-instanceprofile.html">
     *         AWS::IAM::InstanceProfile</a>, <a
     *         href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-policy.html">
     *         AWS::IAM::Policy</a>, <a
     *         href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-role.html">
     *         AWS::IAM::Role</a>, <a
     *         href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-user.html">
     *         AWS::IAM::User</a>, and <a href=
     *         "http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-addusertogroup.html">
     *         AWS::IAM::UserToGroupAddition</a>. If your stack template contains these resources, we recommend that you
     *         review all permissions associated with them and edit their permissions if necessary.
     *         </p>
     *         <p>
     *         If you have IAM resources, you can specify either capability. If you have IAM resources with custom
     *         names, you must specify <code>CAPABILITY_NAMED_IAM</code>. If you don't specify this parameter, this
     *         action returns an <code>InsufficientCapabilities</code> error.
     *         </p>
     *         <p>
     *         For more information, see <a href=
     *         "http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html#capabilities"
     *         >Acknowledging IAM Resources in AWS CloudFormation Templates</a>.
     * @see Capability
     */
    public List<String> capabilities() {
        return capabilities;
    }

    /**
     * <p>
     * The template resource types that you have permissions to work with for this create stack action, such as
     * <code>AWS::EC2::Instance</code>, <code>AWS::EC2::*</code>, or <code>Custom::MyCustomInstance</code>. Use the
     * following syntax to describe template resource types: <code>AWS::*</code> (for all AWS resource),
     * <code>Custom::*</code> (for all custom resources), <code>Custom::<i>logical_ID</i> </code> (for a specific custom
     * resource), <code>AWS::<i>service_name</i>::*</code> (for all resources of a particular AWS service), and
     * <code>AWS::<i>service_name</i>::<i>resource_logical_ID</i> </code> (for a specific AWS resource).
     * </p>
     * <p>
     * If the list of resource types doesn't include a resource that you're creating, the stack creation fails. By
     * default, AWS CloudFormation grants permissions to all resource types. AWS Identity and Access Management (IAM)
     * uses this parameter for AWS CloudFormation-specific condition keys in IAM policies. For more information, see <a
     * href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html">Controlling Access
     * with AWS Identity and Access Management</a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The template resource types that you have permissions to work with for this create stack action, such as
     *         <code>AWS::EC2::Instance</code>, <code>AWS::EC2::*</code>, or <code>Custom::MyCustomInstance</code>. Use
     *         the following syntax to describe template resource types: <code>AWS::*</code> (for all AWS resource),
     *         <code>Custom::*</code> (for all custom resources), <code>Custom::<i>logical_ID</i> </code> (for a
     *         specific custom resource), <code>AWS::<i>service_name</i>::*</code> (for all resources of a particular
     *         AWS service), and <code>AWS::<i>service_name</i>::<i>resource_logical_ID</i> </code> (for a specific AWS
     *         resource).</p>
     *         <p>
     *         If the list of resource types doesn't include a resource that you're creating, the stack creation fails.
     *         By default, AWS CloudFormation grants permissions to all resource types. AWS Identity and Access
     *         Management (IAM) uses this parameter for AWS CloudFormation-specific condition keys in IAM policies. For
     *         more information, see <a
     *         href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html">Controlling
     *         Access with AWS Identity and Access Management</a>.
     */
    public List<String> resourceTypes() {
        return resourceTypes;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of an AWS Identity and Access Management (IAM) role that AWS CloudFormation
     * assumes to create the stack. AWS CloudFormation uses the role's credentials to make calls on your behalf. AWS
     * CloudFormation always uses this role for all future operations on the stack. As long as users have permission to
     * operate on the stack, AWS CloudFormation uses this role even if the users don't have permission to pass it.
     * Ensure that the role grants least privilege.
     * </p>
     * <p>
     * If you don't specify a value, AWS CloudFormation uses the role that was previously associated with the stack. If
     * no role is available, AWS CloudFormation uses a temporary session that is generated from your user credentials.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of an AWS Identity and Access Management (IAM) role that AWS
     *         CloudFormation assumes to create the stack. AWS CloudFormation uses the role's credentials to make calls
     *         on your behalf. AWS CloudFormation always uses this role for all future operations on the stack. As long
     *         as users have permission to operate on the stack, AWS CloudFormation uses this role even if the users
     *         don't have permission to pass it. Ensure that the role grants least privilege.</p>
     *         <p>
     *         If you don't specify a value, AWS CloudFormation uses the role that was previously associated with the
     *         stack. If no role is available, AWS CloudFormation uses a temporary session that is generated from your
     *         user credentials.
     */
    public String roleARN() {
        return roleARN;
    }

    /**
     * <p>
     * Determines what action will be taken if stack creation fails. This must be one of: DO_NOTHING, ROLLBACK, or
     * DELETE. You can specify either <code>OnFailure</code> or <code>DisableRollback</code>, but not both.
     * </p>
     * <p>
     * Default: <code>ROLLBACK</code>
     * </p>
     * 
     * @return Determines what action will be taken if stack creation fails. This must be one of: DO_NOTHING, ROLLBACK,
     *         or DELETE. You can specify either <code>OnFailure</code> or <code>DisableRollback</code>, but not
     *         both.</p>
     *         <p>
     *         Default: <code>ROLLBACK</code>
     * @see OnFailure
     */
    public String onFailure() {
        return onFailure;
    }

    /**
     * <p>
     * Structure containing the stack policy body. For more information, go to <a
     * href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/protect-stack-resources.html"> Prevent
     * Updates to Stack Resources</a> in the <i>AWS CloudFormation User Guide</i>. You can specify either the
     * <code>StackPolicyBody</code> or the <code>StackPolicyURL</code> parameter, but not both.
     * </p>
     * 
     * @return Structure containing the stack policy body. For more information, go to <a
     *         href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/protect-stack-resources.html">
     *         Prevent Updates to Stack Resources</a> in the <i>AWS CloudFormation User Guide</i>. You can specify
     *         either the <code>StackPolicyBody</code> or the <code>StackPolicyURL</code> parameter, but not both.
     */
    public String stackPolicyBody() {
        return stackPolicyBody;
    }

    /**
     * <p>
     * Location of a file containing the stack policy. The URL must point to a policy (maximum size: 16 KB) located in
     * an S3 bucket in the same region as the stack. You can specify either the <code>StackPolicyBody</code> or the
     * <code>StackPolicyURL</code> parameter, but not both.
     * </p>
     * 
     * @return Location of a file containing the stack policy. The URL must point to a policy (maximum size: 16 KB)
     *         located in an S3 bucket in the same region as the stack. You can specify either the
     *         <code>StackPolicyBody</code> or the <code>StackPolicyURL</code> parameter, but not both.
     */
    public String stackPolicyURL() {
        return stackPolicyURL;
    }

    /**
     * <p>
     * Key-value pairs to associate with this stack. AWS CloudFormation also propagates these tags to the resources
     * created in the stack. A maximum number of 10 tags can be specified.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Key-value pairs to associate with this stack. AWS CloudFormation also propagates these tags to the
     *         resources created in the stack. A maximum number of 10 tags can be specified.
     */
    public List<Tag> tags() {
        return tags;
    }

    /**
     * <p>
     * A unique identifier for this <code>CreateStack</code> request. Specify this token if you plan to retry requests
     * so that AWS CloudFormation knows that you're not attempting to create a stack with the same name. You might retry
     * <code>CreateStack</code> requests to ensure that AWS CloudFormation successfully received them.
     * </p>
     * 
     * @return A unique identifier for this <code>CreateStack</code> request. Specify this token if you plan to retry
     *         requests so that AWS CloudFormation knows that you're not attempting to create a stack with the same
     *         name. You might retry <code>CreateStack</code> requests to ensure that AWS CloudFormation successfully
     *         received them.
     */
    public String clientRequestToken() {
        return clientRequestToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((stackName() == null) ? 0 : stackName().hashCode());
        hashCode = 31 * hashCode + ((templateBody() == null) ? 0 : templateBody().hashCode());
        hashCode = 31 * hashCode + ((templateURL() == null) ? 0 : templateURL().hashCode());
        hashCode = 31 * hashCode + ((parameters() == null) ? 0 : parameters().hashCode());
        hashCode = 31 * hashCode + ((disableRollback() == null) ? 0 : disableRollback().hashCode());
        hashCode = 31 * hashCode + ((timeoutInMinutes() == null) ? 0 : timeoutInMinutes().hashCode());
        hashCode = 31 * hashCode + ((notificationARNs() == null) ? 0 : notificationARNs().hashCode());
        hashCode = 31 * hashCode + ((capabilities() == null) ? 0 : capabilities().hashCode());
        hashCode = 31 * hashCode + ((resourceTypes() == null) ? 0 : resourceTypes().hashCode());
        hashCode = 31 * hashCode + ((roleARN() == null) ? 0 : roleARN().hashCode());
        hashCode = 31 * hashCode + ((onFailure() == null) ? 0 : onFailure().hashCode());
        hashCode = 31 * hashCode + ((stackPolicyBody() == null) ? 0 : stackPolicyBody().hashCode());
        hashCode = 31 * hashCode + ((stackPolicyURL() == null) ? 0 : stackPolicyURL().hashCode());
        hashCode = 31 * hashCode + ((tags() == null) ? 0 : tags().hashCode());
        hashCode = 31 * hashCode + ((clientRequestToken() == null) ? 0 : clientRequestToken().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateStackRequest)) {
            return false;
        }
        CreateStackRequest other = (CreateStackRequest) obj;
        if (other.stackName() == null ^ this.stackName() == null) {
            return false;
        }
        if (other.stackName() != null && !other.stackName().equals(this.stackName())) {
            return false;
        }
        if (other.templateBody() == null ^ this.templateBody() == null) {
            return false;
        }
        if (other.templateBody() != null && !other.templateBody().equals(this.templateBody())) {
            return false;
        }
        if (other.templateURL() == null ^ this.templateURL() == null) {
            return false;
        }
        if (other.templateURL() != null && !other.templateURL().equals(this.templateURL())) {
            return false;
        }
        if (other.parameters() == null ^ this.parameters() == null) {
            return false;
        }
        if (other.parameters() != null && !other.parameters().equals(this.parameters())) {
            return false;
        }
        if (other.disableRollback() == null ^ this.disableRollback() == null) {
            return false;
        }
        if (other.disableRollback() != null && !other.disableRollback().equals(this.disableRollback())) {
            return false;
        }
        if (other.timeoutInMinutes() == null ^ this.timeoutInMinutes() == null) {
            return false;
        }
        if (other.timeoutInMinutes() != null && !other.timeoutInMinutes().equals(this.timeoutInMinutes())) {
            return false;
        }
        if (other.notificationARNs() == null ^ this.notificationARNs() == null) {
            return false;
        }
        if (other.notificationARNs() != null && !other.notificationARNs().equals(this.notificationARNs())) {
            return false;
        }
        if (other.capabilities() == null ^ this.capabilities() == null) {
            return false;
        }
        if (other.capabilities() != null && !other.capabilities().equals(this.capabilities())) {
            return false;
        }
        if (other.resourceTypes() == null ^ this.resourceTypes() == null) {
            return false;
        }
        if (other.resourceTypes() != null && !other.resourceTypes().equals(this.resourceTypes())) {
            return false;
        }
        if (other.roleARN() == null ^ this.roleARN() == null) {
            return false;
        }
        if (other.roleARN() != null && !other.roleARN().equals(this.roleARN())) {
            return false;
        }
        if (other.onFailure() == null ^ this.onFailure() == null) {
            return false;
        }
        if (other.onFailure() != null && !other.onFailure().equals(this.onFailure())) {
            return false;
        }
        if (other.stackPolicyBody() == null ^ this.stackPolicyBody() == null) {
            return false;
        }
        if (other.stackPolicyBody() != null && !other.stackPolicyBody().equals(this.stackPolicyBody())) {
            return false;
        }
        if (other.stackPolicyURL() == null ^ this.stackPolicyURL() == null) {
            return false;
        }
        if (other.stackPolicyURL() != null && !other.stackPolicyURL().equals(this.stackPolicyURL())) {
            return false;
        }
        if (other.tags() == null ^ this.tags() == null) {
            return false;
        }
        if (other.tags() != null && !other.tags().equals(this.tags())) {
            return false;
        }
        if (other.clientRequestToken() == null ^ this.clientRequestToken() == null) {
            return false;
        }
        if (other.clientRequestToken() != null && !other.clientRequestToken().equals(this.clientRequestToken())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (stackName() != null) {
            sb.append("StackName: ").append(stackName()).append(",");
        }
        if (templateBody() != null) {
            sb.append("TemplateBody: ").append(templateBody()).append(",");
        }
        if (templateURL() != null) {
            sb.append("TemplateURL: ").append(templateURL()).append(",");
        }
        if (parameters() != null) {
            sb.append("Parameters: ").append(parameters()).append(",");
        }
        if (disableRollback() != null) {
            sb.append("DisableRollback: ").append(disableRollback()).append(",");
        }
        if (timeoutInMinutes() != null) {
            sb.append("TimeoutInMinutes: ").append(timeoutInMinutes()).append(",");
        }
        if (notificationARNs() != null) {
            sb.append("NotificationARNs: ").append(notificationARNs()).append(",");
        }
        if (capabilities() != null) {
            sb.append("Capabilities: ").append(capabilities()).append(",");
        }
        if (resourceTypes() != null) {
            sb.append("ResourceTypes: ").append(resourceTypes()).append(",");
        }
        if (roleARN() != null) {
            sb.append("RoleARN: ").append(roleARN()).append(",");
        }
        if (onFailure() != null) {
            sb.append("OnFailure: ").append(onFailure()).append(",");
        }
        if (stackPolicyBody() != null) {
            sb.append("StackPolicyBody: ").append(stackPolicyBody()).append(",");
        }
        if (stackPolicyURL() != null) {
            sb.append("StackPolicyURL: ").append(stackPolicyURL()).append(",");
        }
        if (tags() != null) {
            sb.append("Tags: ").append(tags()).append(",");
        }
        if (clientRequestToken() != null) {
            sb.append("ClientRequestToken: ").append(clientRequestToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, CreateStackRequest> {
        /**
         * <p>
         * The name that is associated with the stack. The name must be unique in the region in which you are creating
         * the stack.
         * </p>
         * <note>
         * <p>
         * A stack name can contain only alphanumeric characters (case sensitive) and hyphens. It must start with an
         * alphabetic character and cannot be longer than 128 characters.
         * </p>
         * </note>
         * 
         * @param stackName
         *        The name that is associated with the stack. The name must be unique in the region in which you are
         *        creating the stack.</p> <note>
         *        <p>
         *        A stack name can contain only alphanumeric characters (case sensitive) and hyphens. It must start with
         *        an alphabetic character and cannot be longer than 128 characters.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stackName(String stackName);

        /**
         * <p>
         * Structure containing the template body with a minimum length of 1 byte and a maximum length of 51,200 bytes.
         * For more information, go to <a
         * href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html">Template
         * Anatomy</a> in the AWS CloudFormation User Guide.
         * </p>
         * <p>
         * Conditional: You must specify either the <code>TemplateBody</code> or the <code>TemplateURL</code> parameter,
         * but not both.
         * </p>
         * 
         * @param templateBody
         *        Structure containing the template body with a minimum length of 1 byte and a maximum length of 51,200
         *        bytes. For more information, go to <a
         *        href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html">Template
         *        Anatomy</a> in the AWS CloudFormation User Guide.</p>
         *        <p>
         *        Conditional: You must specify either the <code>TemplateBody</code> or the <code>TemplateURL</code>
         *        parameter, but not both.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder templateBody(String templateBody);

        /**
         * <p>
         * Location of file containing the template body. The URL must point to a template (max size: 460,800 bytes)
         * that is located in an Amazon S3 bucket. For more information, go to the <a
         * href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html">Template
         * Anatomy</a> in the AWS CloudFormation User Guide.
         * </p>
         * <p>
         * Conditional: You must specify either the <code>TemplateBody</code> or the <code>TemplateURL</code> parameter,
         * but not both.
         * </p>
         * 
         * @param templateURL
         *        Location of file containing the template body. The URL must point to a template (max size: 460,800
         *        bytes) that is located in an Amazon S3 bucket. For more information, go to the <a
         *        href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html">Template
         *        Anatomy</a> in the AWS CloudFormation User Guide.</p>
         *        <p>
         *        Conditional: You must specify either the <code>TemplateBody</code> or the <code>TemplateURL</code>
         *        parameter, but not both.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder templateURL(String templateURL);

        /**
         * <p>
         * A list of <code>Parameter</code> structures that specify input parameters for the stack. For more
         * information, see the <a
         * href="http://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_Parameter.html">Parameter</a> data
         * type.
         * </p>
         * 
         * @param parameters
         *        A list of <code>Parameter</code> structures that specify input parameters for the stack. For more
         *        information, see the <a
         *        href="http://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_Parameter.html"
         *        >Parameter</a> data type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameters(Collection<Parameter> parameters);

        /**
         * <p>
         * A list of <code>Parameter</code> structures that specify input parameters for the stack. For more
         * information, see the <a
         * href="http://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_Parameter.html">Parameter</a> data
         * type.
         * </p>
         * 
         * @param parameters
         *        A list of <code>Parameter</code> structures that specify input parameters for the stack. For more
         *        information, see the <a
         *        href="http://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_Parameter.html"
         *        >Parameter</a> data type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameters(Parameter... parameters);

        /**
         * <p>
         * Set to <code>true</code> to disable rollback of the stack if stack creation failed. You can specify either
         * <code>DisableRollback</code> or <code>OnFailure</code>, but not both.
         * </p>
         * <p>
         * Default: <code>false</code>
         * </p>
         * 
         * @param disableRollback
         *        Set to <code>true</code> to disable rollback of the stack if stack creation failed. You can specify
         *        either <code>DisableRollback</code> or <code>OnFailure</code>, but not both.</p>
         *        <p>
         *        Default: <code>false</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder disableRollback(Boolean disableRollback);

        /**
         * <p>
         * The amount of time that can pass before the stack status becomes CREATE_FAILED; if
         * <code>DisableRollback</code> is not set or is set to <code>false</code>, the stack will be rolled back.
         * </p>
         * 
         * @param timeoutInMinutes
         *        The amount of time that can pass before the stack status becomes CREATE_FAILED; if
         *        <code>DisableRollback</code> is not set or is set to <code>false</code>, the stack will be rolled
         *        back.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timeoutInMinutes(Integer timeoutInMinutes);

        /**
         * <p>
         * The Simple Notification Service (SNS) topic ARNs to publish stack related events. You can find your SNS topic
         * ARNs using the SNS console or your Command Line Interface (CLI).
         * </p>
         * 
         * @param notificationARNs
         *        The Simple Notification Service (SNS) topic ARNs to publish stack related events. You can find your
         *        SNS topic ARNs using the SNS console or your Command Line Interface (CLI).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notificationARNs(Collection<String> notificationARNs);

        /**
         * <p>
         * The Simple Notification Service (SNS) topic ARNs to publish stack related events. You can find your SNS topic
         * ARNs using the SNS console or your Command Line Interface (CLI).
         * </p>
         * 
         * @param notificationARNs
         *        The Simple Notification Service (SNS) topic ARNs to publish stack related events. You can find your
         *        SNS topic ARNs using the SNS console or your Command Line Interface (CLI).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notificationARNs(String... notificationARNs);

        /**
         * <p>
         * A list of values that you must specify before AWS CloudFormation can create certain stacks. Some stack
         * templates might include resources that can affect permissions in your AWS account, for example, by creating
         * new AWS Identity and Access Management (IAM) users. For those stacks, you must explicitly acknowledge their
         * capabilities by specifying this parameter.
         * </p>
         * <p>
         * The only valid values are <code>CAPABILITY_IAM</code> and <code>CAPABILITY_NAMED_IAM</code>. The following
         * resources require you to specify this parameter: <a
         * href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-accesskey.html">
         * AWS::IAM::AccessKey</a>, <a
         * href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-group.html">
         * AWS::IAM::Group</a>, <a
         * href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-instanceprofile.html">
         * AWS::IAM::InstanceProfile</a>, <a
         * href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-policy.html">
         * AWS::IAM::Policy</a>, <a
         * href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-role.html">
         * AWS::IAM::Role</a>, <a
         * href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-user.html">
         * AWS::IAM::User</a>, and <a
         * href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-addusertogroup.html">
         * AWS::IAM::UserToGroupAddition</a>. If your stack template contains these resources, we recommend that you
         * review all permissions associated with them and edit their permissions if necessary.
         * </p>
         * <p>
         * If you have IAM resources, you can specify either capability. If you have IAM resources with custom names,
         * you must specify <code>CAPABILITY_NAMED_IAM</code>. If you don't specify this parameter, this action returns
         * an <code>InsufficientCapabilities</code> error.
         * </p>
         * <p>
         * For more information, see <a
         * href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html#capabilities"
         * >Acknowledging IAM Resources in AWS CloudFormation Templates</a>.
         * </p>
         * 
         * @param capabilities
         *        A list of values that you must specify before AWS CloudFormation can create certain stacks. Some stack
         *        templates might include resources that can affect permissions in your AWS account, for example, by
         *        creating new AWS Identity and Access Management (IAM) users. For those stacks, you must explicitly
         *        acknowledge their capabilities by specifying this parameter.</p>
         *        <p>
         *        The only valid values are <code>CAPABILITY_IAM</code> and <code>CAPABILITY_NAMED_IAM</code>. The
         *        following resources require you to specify this parameter: <a href=
         *        "http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-accesskey.html">
         *        AWS::IAM::AccessKey</a>, <a
         *        href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-group.html">
         *        AWS::IAM::Group</a>, <a href=
         *        "http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-instanceprofile.html">
         *        AWS::IAM::InstanceProfile</a>, <a
         *        href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-policy.html">
         *        AWS::IAM::Policy</a>, <a
         *        href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-role.html">
         *        AWS::IAM::Role</a>, <a
         *        href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-user.html">
         *        AWS::IAM::User</a>, and <a href=
         *        "http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-addusertogroup.html"
         *        > AWS::IAM::UserToGroupAddition</a>. If your stack template contains these resources, we recommend
         *        that you review all permissions associated with them and edit their permissions if necessary.
         *        </p>
         *        <p>
         *        If you have IAM resources, you can specify either capability. If you have IAM resources with custom
         *        names, you must specify <code>CAPABILITY_NAMED_IAM</code>. If you don't specify this parameter, this
         *        action returns an <code>InsufficientCapabilities</code> error.
         *        </p>
         *        <p>
         *        For more information, see <a href=
         *        "http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html#capabilities"
         *        >Acknowledging IAM Resources in AWS CloudFormation Templates</a>.
         * @see Capability
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Capability
         */
        Builder capabilities(Collection<String> capabilities);

        /**
         * <p>
         * A list of values that you must specify before AWS CloudFormation can create certain stacks. Some stack
         * templates might include resources that can affect permissions in your AWS account, for example, by creating
         * new AWS Identity and Access Management (IAM) users. For those stacks, you must explicitly acknowledge their
         * capabilities by specifying this parameter.
         * </p>
         * <p>
         * The only valid values are <code>CAPABILITY_IAM</code> and <code>CAPABILITY_NAMED_IAM</code>. The following
         * resources require you to specify this parameter: <a
         * href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-accesskey.html">
         * AWS::IAM::AccessKey</a>, <a
         * href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-group.html">
         * AWS::IAM::Group</a>, <a
         * href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-instanceprofile.html">
         * AWS::IAM::InstanceProfile</a>, <a
         * href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-policy.html">
         * AWS::IAM::Policy</a>, <a
         * href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-role.html">
         * AWS::IAM::Role</a>, <a
         * href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-user.html">
         * AWS::IAM::User</a>, and <a
         * href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-addusertogroup.html">
         * AWS::IAM::UserToGroupAddition</a>. If your stack template contains these resources, we recommend that you
         * review all permissions associated with them and edit their permissions if necessary.
         * </p>
         * <p>
         * If you have IAM resources, you can specify either capability. If you have IAM resources with custom names,
         * you must specify <code>CAPABILITY_NAMED_IAM</code>. If you don't specify this parameter, this action returns
         * an <code>InsufficientCapabilities</code> error.
         * </p>
         * <p>
         * For more information, see <a
         * href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html#capabilities"
         * >Acknowledging IAM Resources in AWS CloudFormation Templates</a>.
         * </p>
         * 
         * @param capabilities
         *        A list of values that you must specify before AWS CloudFormation can create certain stacks. Some stack
         *        templates might include resources that can affect permissions in your AWS account, for example, by
         *        creating new AWS Identity and Access Management (IAM) users. For those stacks, you must explicitly
         *        acknowledge their capabilities by specifying this parameter.</p>
         *        <p>
         *        The only valid values are <code>CAPABILITY_IAM</code> and <code>CAPABILITY_NAMED_IAM</code>. The
         *        following resources require you to specify this parameter: <a href=
         *        "http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-accesskey.html">
         *        AWS::IAM::AccessKey</a>, <a
         *        href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-group.html">
         *        AWS::IAM::Group</a>, <a href=
         *        "http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-instanceprofile.html">
         *        AWS::IAM::InstanceProfile</a>, <a
         *        href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-policy.html">
         *        AWS::IAM::Policy</a>, <a
         *        href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-role.html">
         *        AWS::IAM::Role</a>, <a
         *        href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-user.html">
         *        AWS::IAM::User</a>, and <a href=
         *        "http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-addusertogroup.html"
         *        > AWS::IAM::UserToGroupAddition</a>. If your stack template contains these resources, we recommend
         *        that you review all permissions associated with them and edit their permissions if necessary.
         *        </p>
         *        <p>
         *        If you have IAM resources, you can specify either capability. If you have IAM resources with custom
         *        names, you must specify <code>CAPABILITY_NAMED_IAM</code>. If you don't specify this parameter, this
         *        action returns an <code>InsufficientCapabilities</code> error.
         *        </p>
         *        <p>
         *        For more information, see <a href=
         *        "http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html#capabilities"
         *        >Acknowledging IAM Resources in AWS CloudFormation Templates</a>.
         * @see Capability
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Capability
         */
        Builder capabilities(String... capabilities);

        /**
         * <p>
         * A list of values that you must specify before AWS CloudFormation can create certain stacks. Some stack
         * templates might include resources that can affect permissions in your AWS account, for example, by creating
         * new AWS Identity and Access Management (IAM) users. For those stacks, you must explicitly acknowledge their
         * capabilities by specifying this parameter.
         * </p>
         * <p>
         * The only valid values are <code>CAPABILITY_IAM</code> and <code>CAPABILITY_NAMED_IAM</code>. The following
         * resources require you to specify this parameter: <a
         * href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-accesskey.html">
         * AWS::IAM::AccessKey</a>, <a
         * href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-group.html">
         * AWS::IAM::Group</a>, <a
         * href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-instanceprofile.html">
         * AWS::IAM::InstanceProfile</a>, <a
         * href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-policy.html">
         * AWS::IAM::Policy</a>, <a
         * href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-role.html">
         * AWS::IAM::Role</a>, <a
         * href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-user.html">
         * AWS::IAM::User</a>, and <a
         * href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-addusertogroup.html">
         * AWS::IAM::UserToGroupAddition</a>. If your stack template contains these resources, we recommend that you
         * review all permissions associated with them and edit their permissions if necessary.
         * </p>
         * <p>
         * If you have IAM resources, you can specify either capability. If you have IAM resources with custom names,
         * you must specify <code>CAPABILITY_NAMED_IAM</code>. If you don't specify this parameter, this action returns
         * an <code>InsufficientCapabilities</code> error.
         * </p>
         * <p>
         * For more information, see <a
         * href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html#capabilities"
         * >Acknowledging IAM Resources in AWS CloudFormation Templates</a>.
         * </p>
         * 
         * @param capabilities
         *        A list of values that you must specify before AWS CloudFormation can create certain stacks. Some stack
         *        templates might include resources that can affect permissions in your AWS account, for example, by
         *        creating new AWS Identity and Access Management (IAM) users. For those stacks, you must explicitly
         *        acknowledge their capabilities by specifying this parameter.</p>
         *        <p>
         *        The only valid values are <code>CAPABILITY_IAM</code> and <code>CAPABILITY_NAMED_IAM</code>. The
         *        following resources require you to specify this parameter: <a href=
         *        "http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-accesskey.html">
         *        AWS::IAM::AccessKey</a>, <a
         *        href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-group.html">
         *        AWS::IAM::Group</a>, <a href=
         *        "http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-instanceprofile.html">
         *        AWS::IAM::InstanceProfile</a>, <a
         *        href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-policy.html">
         *        AWS::IAM::Policy</a>, <a
         *        href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-role.html">
         *        AWS::IAM::Role</a>, <a
         *        href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-user.html">
         *        AWS::IAM::User</a>, and <a href=
         *        "http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-addusertogroup.html"
         *        > AWS::IAM::UserToGroupAddition</a>. If your stack template contains these resources, we recommend
         *        that you review all permissions associated with them and edit their permissions if necessary.
         *        </p>
         *        <p>
         *        If you have IAM resources, you can specify either capability. If you have IAM resources with custom
         *        names, you must specify <code>CAPABILITY_NAMED_IAM</code>. If you don't specify this parameter, this
         *        action returns an <code>InsufficientCapabilities</code> error.
         *        </p>
         *        <p>
         *        For more information, see <a href=
         *        "http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html#capabilities"
         *        >Acknowledging IAM Resources in AWS CloudFormation Templates</a>.
         * @see Capability
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Capability
         */
        Builder capabilities(Capability... capabilities);

        /**
         * <p>
         * The template resource types that you have permissions to work with for this create stack action, such as
         * <code>AWS::EC2::Instance</code>, <code>AWS::EC2::*</code>, or <code>Custom::MyCustomInstance</code>. Use the
         * following syntax to describe template resource types: <code>AWS::*</code> (for all AWS resource),
         * <code>Custom::*</code> (for all custom resources), <code>Custom::<i>logical_ID</i> </code> (for a specific
         * custom resource), <code>AWS::<i>service_name</i>::*</code> (for all resources of a particular AWS service),
         * and <code>AWS::<i>service_name</i>::<i>resource_logical_ID</i> </code> (for a specific AWS resource).
         * </p>
         * <p>
         * If the list of resource types doesn't include a resource that you're creating, the stack creation fails. By
         * default, AWS CloudFormation grants permissions to all resource types. AWS Identity and Access Management
         * (IAM) uses this parameter for AWS CloudFormation-specific condition keys in IAM policies. For more
         * information, see <a
         * href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html">Controlling
         * Access with AWS Identity and Access Management</a>.
         * </p>
         * 
         * @param resourceTypes
         *        The template resource types that you have permissions to work with for this create stack action, such
         *        as <code>AWS::EC2::Instance</code>, <code>AWS::EC2::*</code>, or <code>Custom::MyCustomInstance</code>
         *        . Use the following syntax to describe template resource types: <code>AWS::*</code> (for all AWS
         *        resource), <code>Custom::*</code> (for all custom resources), <code>Custom::<i>logical_ID</i> </code>
         *        (for a specific custom resource), <code>AWS::<i>service_name</i>::*</code> (for all resources of a
         *        particular AWS service), and <code>AWS::<i>service_name</i>::<i>resource_logical_ID</i> </code> (for a
         *        specific AWS resource).</p>
         *        <p>
         *        If the list of resource types doesn't include a resource that you're creating, the stack creation
         *        fails. By default, AWS CloudFormation grants permissions to all resource types. AWS Identity and
         *        Access Management (IAM) uses this parameter for AWS CloudFormation-specific condition keys in IAM
         *        policies. For more information, see <a
         *        href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html"
         *        >Controlling Access with AWS Identity and Access Management</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceTypes(Collection<String> resourceTypes);

        /**
         * <p>
         * The template resource types that you have permissions to work with for this create stack action, such as
         * <code>AWS::EC2::Instance</code>, <code>AWS::EC2::*</code>, or <code>Custom::MyCustomInstance</code>. Use the
         * following syntax to describe template resource types: <code>AWS::*</code> (for all AWS resource),
         * <code>Custom::*</code> (for all custom resources), <code>Custom::<i>logical_ID</i> </code> (for a specific
         * custom resource), <code>AWS::<i>service_name</i>::*</code> (for all resources of a particular AWS service),
         * and <code>AWS::<i>service_name</i>::<i>resource_logical_ID</i> </code> (for a specific AWS resource).
         * </p>
         * <p>
         * If the list of resource types doesn't include a resource that you're creating, the stack creation fails. By
         * default, AWS CloudFormation grants permissions to all resource types. AWS Identity and Access Management
         * (IAM) uses this parameter for AWS CloudFormation-specific condition keys in IAM policies. For more
         * information, see <a
         * href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html">Controlling
         * Access with AWS Identity and Access Management</a>.
         * </p>
         * 
         * @param resourceTypes
         *        The template resource types that you have permissions to work with for this create stack action, such
         *        as <code>AWS::EC2::Instance</code>, <code>AWS::EC2::*</code>, or <code>Custom::MyCustomInstance</code>
         *        . Use the following syntax to describe template resource types: <code>AWS::*</code> (for all AWS
         *        resource), <code>Custom::*</code> (for all custom resources), <code>Custom::<i>logical_ID</i> </code>
         *        (for a specific custom resource), <code>AWS::<i>service_name</i>::*</code> (for all resources of a
         *        particular AWS service), and <code>AWS::<i>service_name</i>::<i>resource_logical_ID</i> </code> (for a
         *        specific AWS resource).</p>
         *        <p>
         *        If the list of resource types doesn't include a resource that you're creating, the stack creation
         *        fails. By default, AWS CloudFormation grants permissions to all resource types. AWS Identity and
         *        Access Management (IAM) uses this parameter for AWS CloudFormation-specific condition keys in IAM
         *        policies. For more information, see <a
         *        href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html"
         *        >Controlling Access with AWS Identity and Access Management</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceTypes(String... resourceTypes);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of an AWS Identity and Access Management (IAM) role that AWS CloudFormation
         * assumes to create the stack. AWS CloudFormation uses the role's credentials to make calls on your behalf. AWS
         * CloudFormation always uses this role for all future operations on the stack. As long as users have permission
         * to operate on the stack, AWS CloudFormation uses this role even if the users don't have permission to pass
         * it. Ensure that the role grants least privilege.
         * </p>
         * <p>
         * If you don't specify a value, AWS CloudFormation uses the role that was previously associated with the stack.
         * If no role is available, AWS CloudFormation uses a temporary session that is generated from your user
         * credentials.
         * </p>
         * 
         * @param roleARN
         *        The Amazon Resource Name (ARN) of an AWS Identity and Access Management (IAM) role that AWS
         *        CloudFormation assumes to create the stack. AWS CloudFormation uses the role's credentials to make
         *        calls on your behalf. AWS CloudFormation always uses this role for all future operations on the stack.
         *        As long as users have permission to operate on the stack, AWS CloudFormation uses this role even if
         *        the users don't have permission to pass it. Ensure that the role grants least privilege.</p>
         *        <p>
         *        If you don't specify a value, AWS CloudFormation uses the role that was previously associated with the
         *        stack. If no role is available, AWS CloudFormation uses a temporary session that is generated from
         *        your user credentials.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleARN(String roleARN);

        /**
         * <p>
         * Determines what action will be taken if stack creation fails. This must be one of: DO_NOTHING, ROLLBACK, or
         * DELETE. You can specify either <code>OnFailure</code> or <code>DisableRollback</code>, but not both.
         * </p>
         * <p>
         * Default: <code>ROLLBACK</code>
         * </p>
         * 
         * @param onFailure
         *        Determines what action will be taken if stack creation fails. This must be one of: DO_NOTHING,
         *        ROLLBACK, or DELETE. You can specify either <code>OnFailure</code> or <code>DisableRollback</code>,
         *        but not both.</p>
         *        <p>
         *        Default: <code>ROLLBACK</code>
         * @see OnFailure
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OnFailure
         */
        Builder onFailure(String onFailure);

        /**
         * <p>
         * Determines what action will be taken if stack creation fails. This must be one of: DO_NOTHING, ROLLBACK, or
         * DELETE. You can specify either <code>OnFailure</code> or <code>DisableRollback</code>, but not both.
         * </p>
         * <p>
         * Default: <code>ROLLBACK</code>
         * </p>
         * 
         * @param onFailure
         *        Determines what action will be taken if stack creation fails. This must be one of: DO_NOTHING,
         *        ROLLBACK, or DELETE. You can specify either <code>OnFailure</code> or <code>DisableRollback</code>,
         *        but not both.</p>
         *        <p>
         *        Default: <code>ROLLBACK</code>
         * @see OnFailure
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OnFailure
         */
        Builder onFailure(OnFailure onFailure);

        /**
         * <p>
         * Structure containing the stack policy body. For more information, go to <a
         * href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/protect-stack-resources.html"> Prevent
         * Updates to Stack Resources</a> in the <i>AWS CloudFormation User Guide</i>. You can specify either the
         * <code>StackPolicyBody</code> or the <code>StackPolicyURL</code> parameter, but not both.
         * </p>
         * 
         * @param stackPolicyBody
         *        Structure containing the stack policy body. For more information, go to <a
         *        href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/protect-stack-resources.html">
         *        Prevent Updates to Stack Resources</a> in the <i>AWS CloudFormation User Guide</i>. You can specify
         *        either the <code>StackPolicyBody</code> or the <code>StackPolicyURL</code> parameter, but not both.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stackPolicyBody(String stackPolicyBody);

        /**
         * <p>
         * Location of a file containing the stack policy. The URL must point to a policy (maximum size: 16 KB) located
         * in an S3 bucket in the same region as the stack. You can specify either the <code>StackPolicyBody</code> or
         * the <code>StackPolicyURL</code> parameter, but not both.
         * </p>
         * 
         * @param stackPolicyURL
         *        Location of a file containing the stack policy. The URL must point to a policy (maximum size: 16 KB)
         *        located in an S3 bucket in the same region as the stack. You can specify either the
         *        <code>StackPolicyBody</code> or the <code>StackPolicyURL</code> parameter, but not both.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stackPolicyURL(String stackPolicyURL);

        /**
         * <p>
         * Key-value pairs to associate with this stack. AWS CloudFormation also propagates these tags to the resources
         * created in the stack. A maximum number of 10 tags can be specified.
         * </p>
         * 
         * @param tags
         *        Key-value pairs to associate with this stack. AWS CloudFormation also propagates these tags to the
         *        resources created in the stack. A maximum number of 10 tags can be specified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * Key-value pairs to associate with this stack. AWS CloudFormation also propagates these tags to the resources
         * created in the stack. A maximum number of 10 tags can be specified.
         * </p>
         * 
         * @param tags
         *        Key-value pairs to associate with this stack. AWS CloudFormation also propagates these tags to the
         *        resources created in the stack. A maximum number of 10 tags can be specified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * A unique identifier for this <code>CreateStack</code> request. Specify this token if you plan to retry
         * requests so that AWS CloudFormation knows that you're not attempting to create a stack with the same name.
         * You might retry <code>CreateStack</code> requests to ensure that AWS CloudFormation successfully received
         * them.
         * </p>
         * 
         * @param clientRequestToken
         *        A unique identifier for this <code>CreateStack</code> request. Specify this token if you plan to retry
         *        requests so that AWS CloudFormation knows that you're not attempting to create a stack with the same
         *        name. You might retry <code>CreateStack</code> requests to ensure that AWS CloudFormation successfully
         *        received them.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientRequestToken(String clientRequestToken);
    }

    private static final class BuilderImpl implements Builder {
        private String stackName;

        private String templateBody;

        private String templateURL;

        private List<Parameter> parameters;

        private Boolean disableRollback;

        private Integer timeoutInMinutes;

        private List<String> notificationARNs;

        private List<String> capabilities;

        private List<String> resourceTypes;

        private String roleARN;

        private String onFailure;

        private String stackPolicyBody;

        private String stackPolicyURL;

        private List<Tag> tags;

        private String clientRequestToken;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateStackRequest model) {
            setStackName(model.stackName);
            setTemplateBody(model.templateBody);
            setTemplateURL(model.templateURL);
            setParameters(model.parameters);
            setDisableRollback(model.disableRollback);
            setTimeoutInMinutes(model.timeoutInMinutes);
            setNotificationARNs(model.notificationARNs);
            setCapabilities(model.capabilities);
            setResourceTypes(model.resourceTypes);
            setRoleARN(model.roleARN);
            setOnFailure(model.onFailure);
            setStackPolicyBody(model.stackPolicyBody);
            setStackPolicyURL(model.stackPolicyURL);
            setTags(model.tags);
            setClientRequestToken(model.clientRequestToken);
        }

        public final String getStackName() {
            return stackName;
        }

        @Override
        public final Builder stackName(String stackName) {
            this.stackName = stackName;
            return this;
        }

        public final void setStackName(String stackName) {
            this.stackName = stackName;
        }

        public final String getTemplateBody() {
            return templateBody;
        }

        @Override
        public final Builder templateBody(String templateBody) {
            this.templateBody = templateBody;
            return this;
        }

        public final void setTemplateBody(String templateBody) {
            this.templateBody = templateBody;
        }

        public final String getTemplateURL() {
            return templateURL;
        }

        @Override
        public final Builder templateURL(String templateURL) {
            this.templateURL = templateURL;
            return this;
        }

        public final void setTemplateURL(String templateURL) {
            this.templateURL = templateURL;
        }

        public final Collection<Parameter> getParameters() {
            return parameters;
        }

        @Override
        public final Builder parameters(Collection<Parameter> parameters) {
            this.parameters = ParametersCopier.copy(parameters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameters(Parameter... parameters) {
            parameters(Arrays.asList(parameters));
            return this;
        }

        public final void setParameters(Collection<Parameter> parameters) {
            this.parameters = ParametersCopier.copy(parameters);
        }

        public final Boolean getDisableRollback() {
            return disableRollback;
        }

        @Override
        public final Builder disableRollback(Boolean disableRollback) {
            this.disableRollback = disableRollback;
            return this;
        }

        public final void setDisableRollback(Boolean disableRollback) {
            this.disableRollback = disableRollback;
        }

        public final Integer getTimeoutInMinutes() {
            return timeoutInMinutes;
        }

        @Override
        public final Builder timeoutInMinutes(Integer timeoutInMinutes) {
            this.timeoutInMinutes = timeoutInMinutes;
            return this;
        }

        public final void setTimeoutInMinutes(Integer timeoutInMinutes) {
            this.timeoutInMinutes = timeoutInMinutes;
        }

        public final Collection<String> getNotificationARNs() {
            return notificationARNs;
        }

        @Override
        public final Builder notificationARNs(Collection<String> notificationARNs) {
            this.notificationARNs = NotificationARNsCopier.copy(notificationARNs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder notificationARNs(String... notificationARNs) {
            notificationARNs(Arrays.asList(notificationARNs));
            return this;
        }

        public final void setNotificationARNs(Collection<String> notificationARNs) {
            this.notificationARNs = NotificationARNsCopier.copy(notificationARNs);
        }

        public final Collection<String> getCapabilities() {
            return capabilities;
        }

        @Override
        public final Builder capabilities(Collection<String> capabilities) {
            this.capabilities = CapabilitiesCopier.copy(capabilities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder capabilities(String... capabilities) {
            capabilities(Arrays.asList(capabilities));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder capabilities(Capability... capabilities) {
            capabilities(Arrays.asList(capabilities).stream().map(Object::toString).collect(Collectors.toList()));
            return this;
        }

        public final void setCapabilities(Collection<String> capabilities) {
            this.capabilities = CapabilitiesCopier.copy(capabilities);
        }

        public final Collection<String> getResourceTypes() {
            return resourceTypes;
        }

        @Override
        public final Builder resourceTypes(Collection<String> resourceTypes) {
            this.resourceTypes = ResourceTypesCopier.copy(resourceTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceTypes(String... resourceTypes) {
            resourceTypes(Arrays.asList(resourceTypes));
            return this;
        }

        public final void setResourceTypes(Collection<String> resourceTypes) {
            this.resourceTypes = ResourceTypesCopier.copy(resourceTypes);
        }

        public final String getRoleARN() {
            return roleARN;
        }

        @Override
        public final Builder roleARN(String roleARN) {
            this.roleARN = roleARN;
            return this;
        }

        public final void setRoleARN(String roleARN) {
            this.roleARN = roleARN;
        }

        public final String getOnFailure() {
            return onFailure;
        }

        @Override
        public final Builder onFailure(String onFailure) {
            this.onFailure = onFailure;
            return this;
        }

        @Override
        public final Builder onFailure(OnFailure onFailure) {
            this.onFailure(onFailure.toString());
            return this;
        }

        public final void setOnFailure(String onFailure) {
            this.onFailure = onFailure;
        }

        public final String getStackPolicyBody() {
            return stackPolicyBody;
        }

        @Override
        public final Builder stackPolicyBody(String stackPolicyBody) {
            this.stackPolicyBody = stackPolicyBody;
            return this;
        }

        public final void setStackPolicyBody(String stackPolicyBody) {
            this.stackPolicyBody = stackPolicyBody;
        }

        public final String getStackPolicyURL() {
            return stackPolicyURL;
        }

        @Override
        public final Builder stackPolicyURL(String stackPolicyURL) {
            this.stackPolicyURL = stackPolicyURL;
            return this;
        }

        public final void setStackPolicyURL(String stackPolicyURL) {
            this.stackPolicyURL = stackPolicyURL;
        }

        public final Collection<Tag> getTags() {
            return tags;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        public final void setTags(Collection<Tag> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        public final String getClientRequestToken() {
            return clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        @Override
        public CreateStackRequest build() {
            return new CreateStackRequest(this);
        }
    }
}
