/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudformation.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The input for <a>DeleteStack</a> action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DeleteStackRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<DeleteStackRequest.Builder, DeleteStackRequest> {
    private final String stackName;

    private final List<String> retainResources;

    private final String roleARN;

    private final String clientRequestToken;

    private DeleteStackRequest(BuilderImpl builder) {
        this.stackName = builder.stackName;
        this.retainResources = builder.retainResources;
        this.roleARN = builder.roleARN;
        this.clientRequestToken = builder.clientRequestToken;
    }

    /**
     * <p>
     * The name or the unique stack ID that is associated with the stack.
     * </p>
     * 
     * @return The name or the unique stack ID that is associated with the stack.
     */
    public String stackName() {
        return stackName;
    }

    /**
     * <p>
     * For stacks in the <code>DELETE_FAILED</code> state, a list of resource logical IDs that are associated with the
     * resources you want to retain. During deletion, AWS CloudFormation deletes the stack but does not delete the
     * retained resources.
     * </p>
     * <p>
     * Retaining resources is useful when you cannot delete a resource, such as a non-empty S3 bucket, but you want to
     * delete the stack.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return For stacks in the <code>DELETE_FAILED</code> state, a list of resource logical IDs that are associated
     *         with the resources you want to retain. During deletion, AWS CloudFormation deletes the stack but does not
     *         delete the retained resources.</p>
     *         <p>
     *         Retaining resources is useful when you cannot delete a resource, such as a non-empty S3 bucket, but you
     *         want to delete the stack.
     */
    public List<String> retainResources() {
        return retainResources;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of an AWS Identity and Access Management (IAM) role that AWS CloudFormation
     * assumes to delete the stack. AWS CloudFormation uses the role's credentials to make calls on your behalf.
     * </p>
     * <p>
     * If you don't specify a value, AWS CloudFormation uses the role that was previously associated with the stack. If
     * no role is available, AWS CloudFormation uses a temporary session that is generated from your user credentials.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of an AWS Identity and Access Management (IAM) role that AWS
     *         CloudFormation assumes to delete the stack. AWS CloudFormation uses the role's credentials to make calls
     *         on your behalf.</p>
     *         <p>
     *         If you don't specify a value, AWS CloudFormation uses the role that was previously associated with the
     *         stack. If no role is available, AWS CloudFormation uses a temporary session that is generated from your
     *         user credentials.
     */
    public String roleARN() {
        return roleARN;
    }

    /**
     * <p>
     * A unique identifier for this <code>DeleteStack</code> request. Specify this token if you plan to retry requests
     * so that AWS CloudFormation knows that you're not attempting to delete a stack with the same name. You might retry
     * <code>DeleteStack</code> requests to ensure that AWS CloudFormation successfully received them.
     * </p>
     * 
     * @return A unique identifier for this <code>DeleteStack</code> request. Specify this token if you plan to retry
     *         requests so that AWS CloudFormation knows that you're not attempting to delete a stack with the same
     *         name. You might retry <code>DeleteStack</code> requests to ensure that AWS CloudFormation successfully
     *         received them.
     */
    public String clientRequestToken() {
        return clientRequestToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((stackName() == null) ? 0 : stackName().hashCode());
        hashCode = 31 * hashCode + ((retainResources() == null) ? 0 : retainResources().hashCode());
        hashCode = 31 * hashCode + ((roleARN() == null) ? 0 : roleARN().hashCode());
        hashCode = 31 * hashCode + ((clientRequestToken() == null) ? 0 : clientRequestToken().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteStackRequest)) {
            return false;
        }
        DeleteStackRequest other = (DeleteStackRequest) obj;
        if (other.stackName() == null ^ this.stackName() == null) {
            return false;
        }
        if (other.stackName() != null && !other.stackName().equals(this.stackName())) {
            return false;
        }
        if (other.retainResources() == null ^ this.retainResources() == null) {
            return false;
        }
        if (other.retainResources() != null && !other.retainResources().equals(this.retainResources())) {
            return false;
        }
        if (other.roleARN() == null ^ this.roleARN() == null) {
            return false;
        }
        if (other.roleARN() != null && !other.roleARN().equals(this.roleARN())) {
            return false;
        }
        if (other.clientRequestToken() == null ^ this.clientRequestToken() == null) {
            return false;
        }
        if (other.clientRequestToken() != null && !other.clientRequestToken().equals(this.clientRequestToken())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (stackName() != null) {
            sb.append("StackName: ").append(stackName()).append(",");
        }
        if (retainResources() != null) {
            sb.append("RetainResources: ").append(retainResources()).append(",");
        }
        if (roleARN() != null) {
            sb.append("RoleARN: ").append(roleARN()).append(",");
        }
        if (clientRequestToken() != null) {
            sb.append("ClientRequestToken: ").append(clientRequestToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, DeleteStackRequest> {
        /**
         * <p>
         * The name or the unique stack ID that is associated with the stack.
         * </p>
         * 
         * @param stackName
         *        The name or the unique stack ID that is associated with the stack.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stackName(String stackName);

        /**
         * <p>
         * For stacks in the <code>DELETE_FAILED</code> state, a list of resource logical IDs that are associated with
         * the resources you want to retain. During deletion, AWS CloudFormation deletes the stack but does not delete
         * the retained resources.
         * </p>
         * <p>
         * Retaining resources is useful when you cannot delete a resource, such as a non-empty S3 bucket, but you want
         * to delete the stack.
         * </p>
         * 
         * @param retainResources
         *        For stacks in the <code>DELETE_FAILED</code> state, a list of resource logical IDs that are associated
         *        with the resources you want to retain. During deletion, AWS CloudFormation deletes the stack but does
         *        not delete the retained resources.</p>
         *        <p>
         *        Retaining resources is useful when you cannot delete a resource, such as a non-empty S3 bucket, but
         *        you want to delete the stack.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder retainResources(Collection<String> retainResources);

        /**
         * <p>
         * For stacks in the <code>DELETE_FAILED</code> state, a list of resource logical IDs that are associated with
         * the resources you want to retain. During deletion, AWS CloudFormation deletes the stack but does not delete
         * the retained resources.
         * </p>
         * <p>
         * Retaining resources is useful when you cannot delete a resource, such as a non-empty S3 bucket, but you want
         * to delete the stack.
         * </p>
         * 
         * @param retainResources
         *        For stacks in the <code>DELETE_FAILED</code> state, a list of resource logical IDs that are associated
         *        with the resources you want to retain. During deletion, AWS CloudFormation deletes the stack but does
         *        not delete the retained resources.</p>
         *        <p>
         *        Retaining resources is useful when you cannot delete a resource, such as a non-empty S3 bucket, but
         *        you want to delete the stack.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder retainResources(String... retainResources);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of an AWS Identity and Access Management (IAM) role that AWS CloudFormation
         * assumes to delete the stack. AWS CloudFormation uses the role's credentials to make calls on your behalf.
         * </p>
         * <p>
         * If you don't specify a value, AWS CloudFormation uses the role that was previously associated with the stack.
         * If no role is available, AWS CloudFormation uses a temporary session that is generated from your user
         * credentials.
         * </p>
         * 
         * @param roleARN
         *        The Amazon Resource Name (ARN) of an AWS Identity and Access Management (IAM) role that AWS
         *        CloudFormation assumes to delete the stack. AWS CloudFormation uses the role's credentials to make
         *        calls on your behalf.</p>
         *        <p>
         *        If you don't specify a value, AWS CloudFormation uses the role that was previously associated with the
         *        stack. If no role is available, AWS CloudFormation uses a temporary session that is generated from
         *        your user credentials.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleARN(String roleARN);

        /**
         * <p>
         * A unique identifier for this <code>DeleteStack</code> request. Specify this token if you plan to retry
         * requests so that AWS CloudFormation knows that you're not attempting to delete a stack with the same name.
         * You might retry <code>DeleteStack</code> requests to ensure that AWS CloudFormation successfully received
         * them.
         * </p>
         * 
         * @param clientRequestToken
         *        A unique identifier for this <code>DeleteStack</code> request. Specify this token if you plan to retry
         *        requests so that AWS CloudFormation knows that you're not attempting to delete a stack with the same
         *        name. You might retry <code>DeleteStack</code> requests to ensure that AWS CloudFormation successfully
         *        received them.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientRequestToken(String clientRequestToken);
    }

    private static final class BuilderImpl implements Builder {
        private String stackName;

        private List<String> retainResources;

        private String roleARN;

        private String clientRequestToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteStackRequest model) {
            setStackName(model.stackName);
            setRetainResources(model.retainResources);
            setRoleARN(model.roleARN);
            setClientRequestToken(model.clientRequestToken);
        }

        public final String getStackName() {
            return stackName;
        }

        @Override
        public final Builder stackName(String stackName) {
            this.stackName = stackName;
            return this;
        }

        public final void setStackName(String stackName) {
            this.stackName = stackName;
        }

        public final Collection<String> getRetainResources() {
            return retainResources;
        }

        @Override
        public final Builder retainResources(Collection<String> retainResources) {
            this.retainResources = RetainResourcesCopier.copy(retainResources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder retainResources(String... retainResources) {
            retainResources(Arrays.asList(retainResources));
            return this;
        }

        public final void setRetainResources(Collection<String> retainResources) {
            this.retainResources = RetainResourcesCopier.copy(retainResources);
        }

        public final String getRoleARN() {
            return roleARN;
        }

        @Override
        public final Builder roleARN(String roleARN) {
            this.roleARN = roleARN;
            return this;
        }

        public final void setRoleARN(String roleARN) {
            this.roleARN = roleARN;
        }

        public final String getClientRequestToken() {
            return clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        @Override
        public DeleteStackRequest build() {
            return new DeleteStackRequest(this);
        }
    }
}
