/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudformation.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The output for the <a>DescribeAccountLimits</a> action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeAccountLimitsResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<DescribeAccountLimitsResponse.Builder, DescribeAccountLimitsResponse> {
    private final List<AccountLimit> accountLimits;

    private final String nextToken;

    private DescribeAccountLimitsResponse(BuilderImpl builder) {
        this.accountLimits = builder.accountLimits;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * An account limit structure that contain a list of AWS CloudFormation account limits and their values.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return An account limit structure that contain a list of AWS CloudFormation account limits and their values.
     */
    public List<AccountLimit> accountLimits() {
        return accountLimits;
    }

    /**
     * <p>
     * If the output exceeds 1 MB in size, a string that identifies the next page of limits. If no additional page
     * exists, this value is null.
     * </p>
     * 
     * @return If the output exceeds 1 MB in size, a string that identifies the next page of limits. If no additional
     *         page exists, this value is null.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((accountLimits() == null) ? 0 : accountLimits().hashCode());
        hashCode = 31 * hashCode + ((nextToken() == null) ? 0 : nextToken().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAccountLimitsResponse)) {
            return false;
        }
        DescribeAccountLimitsResponse other = (DescribeAccountLimitsResponse) obj;
        if (other.accountLimits() == null ^ this.accountLimits() == null) {
            return false;
        }
        if (other.accountLimits() != null && !other.accountLimits().equals(this.accountLimits())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        if (other.nextToken() != null && !other.nextToken().equals(this.nextToken())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (accountLimits() != null) {
            sb.append("AccountLimits: ").append(accountLimits()).append(",");
        }
        if (nextToken() != null) {
            sb.append("NextToken: ").append(nextToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, DescribeAccountLimitsResponse> {
        /**
         * <p>
         * An account limit structure that contain a list of AWS CloudFormation account limits and their values.
         * </p>
         * 
         * @param accountLimits
         *        An account limit structure that contain a list of AWS CloudFormation account limits and their values.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountLimits(Collection<AccountLimit> accountLimits);

        /**
         * <p>
         * An account limit structure that contain a list of AWS CloudFormation account limits and their values.
         * </p>
         * 
         * @param accountLimits
         *        An account limit structure that contain a list of AWS CloudFormation account limits and their values.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountLimits(AccountLimit... accountLimits);

        /**
         * <p>
         * If the output exceeds 1 MB in size, a string that identifies the next page of limits. If no additional page
         * exists, this value is null.
         * </p>
         * 
         * @param nextToken
         *        If the output exceeds 1 MB in size, a string that identifies the next page of limits. If no additional
         *        page exists, this value is null.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    private static final class BuilderImpl implements Builder {
        private List<AccountLimit> accountLimits;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAccountLimitsResponse model) {
            setAccountLimits(model.accountLimits);
            setNextToken(model.nextToken);
        }

        public final Collection<AccountLimit> getAccountLimits() {
            return accountLimits;
        }

        @Override
        public final Builder accountLimits(Collection<AccountLimit> accountLimits) {
            this.accountLimits = AccountLimitListCopier.copy(accountLimits);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accountLimits(AccountLimit... accountLimits) {
            accountLimits(Arrays.asList(accountLimits));
            return this;
        }

        public final void setAccountLimits(Collection<AccountLimit> accountLimits) {
            this.accountLimits = AccountLimitListCopier.copy(accountLimits);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeAccountLimitsResponse build() {
            return new DescribeAccountLimitsResponse(this);
        }
    }
}
