/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudformation.model;

import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The <code>Export</code> structure describes the exported output values for a stack.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class Export implements ToCopyableBuilder<Export.Builder, Export> {
    private final String exportingStackId;

    private final String name;

    private final String value;

    private Export(BuilderImpl builder) {
        this.exportingStackId = builder.exportingStackId;
        this.name = builder.name;
        this.value = builder.value;
    }

    /**
     * <p>
     * The stack that contains the exported output name and value.
     * </p>
     * 
     * @return The stack that contains the exported output name and value.
     */
    public String exportingStackId() {
        return exportingStackId;
    }

    /**
     * <p>
     * The name of exported output value. Use this name and the <code>Fn::ImportValue</code> function to import the
     * associated value into other stacks. The name is defined in the <code>Export</code> field in the associated
     * stack's <code>Outputs</code> section.
     * </p>
     * 
     * @return The name of exported output value. Use this name and the <code>Fn::ImportValue</code> function to import
     *         the associated value into other stacks. The name is defined in the <code>Export</code> field in the
     *         associated stack's <code>Outputs</code> section.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * The value of the exported output, such as a resource physical ID. This value is defined in the
     * <code>Export</code> field in the associated stack's <code>Outputs</code> section.
     * </p>
     * 
     * @return The value of the exported output, such as a resource physical ID. This value is defined in the
     *         <code>Export</code> field in the associated stack's <code>Outputs</code> section.
     */
    public String value() {
        return value;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((exportingStackId() == null) ? 0 : exportingStackId().hashCode());
        hashCode = 31 * hashCode + ((name() == null) ? 0 : name().hashCode());
        hashCode = 31 * hashCode + ((value() == null) ? 0 : value().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Export)) {
            return false;
        }
        Export other = (Export) obj;
        if (other.exportingStackId() == null ^ this.exportingStackId() == null) {
            return false;
        }
        if (other.exportingStackId() != null && !other.exportingStackId().equals(this.exportingStackId())) {
            return false;
        }
        if (other.name() == null ^ this.name() == null) {
            return false;
        }
        if (other.name() != null && !other.name().equals(this.name())) {
            return false;
        }
        if (other.value() == null ^ this.value() == null) {
            return false;
        }
        if (other.value() != null && !other.value().equals(this.value())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (exportingStackId() != null) {
            sb.append("ExportingStackId: ").append(exportingStackId()).append(",");
        }
        if (name() != null) {
            sb.append("Name: ").append(name()).append(",");
        }
        if (value() != null) {
            sb.append("Value: ").append(value()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, Export> {
        /**
         * <p>
         * The stack that contains the exported output name and value.
         * </p>
         * 
         * @param exportingStackId
         *        The stack that contains the exported output name and value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exportingStackId(String exportingStackId);

        /**
         * <p>
         * The name of exported output value. Use this name and the <code>Fn::ImportValue</code> function to import the
         * associated value into other stacks. The name is defined in the <code>Export</code> field in the associated
         * stack's <code>Outputs</code> section.
         * </p>
         * 
         * @param name
         *        The name of exported output value. Use this name and the <code>Fn::ImportValue</code> function to
         *        import the associated value into other stacks. The name is defined in the <code>Export</code> field in
         *        the associated stack's <code>Outputs</code> section.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The value of the exported output, such as a resource physical ID. This value is defined in the
         * <code>Export</code> field in the associated stack's <code>Outputs</code> section.
         * </p>
         * 
         * @param value
         *        The value of the exported output, such as a resource physical ID. This value is defined in the
         *        <code>Export</code> field in the associated stack's <code>Outputs</code> section.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder value(String value);
    }

    private static final class BuilderImpl implements Builder {
        private String exportingStackId;

        private String name;

        private String value;

        private BuilderImpl() {
        }

        private BuilderImpl(Export model) {
            setExportingStackId(model.exportingStackId);
            setName(model.name);
            setValue(model.value);
        }

        public final String getExportingStackId() {
            return exportingStackId;
        }

        @Override
        public final Builder exportingStackId(String exportingStackId) {
            this.exportingStackId = exportingStackId;
            return this;
        }

        public final void setExportingStackId(String exportingStackId) {
            this.exportingStackId = exportingStackId;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getValue() {
            return value;
        }

        @Override
        public final Builder value(String value) {
            this.value = value;
            return this;
        }

        public final void setValue(String value) {
            this.value = value;
        }

        @Override
        public Export build() {
            return new Export(this);
        }
    }
}
