/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudformation.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The input for the <a>GetTemplateSummary</a> action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class GetTemplateSummaryRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<GetTemplateSummaryRequest.Builder, GetTemplateSummaryRequest> {
    private final String templateBody;

    private final String templateURL;

    private final String stackName;

    private GetTemplateSummaryRequest(BuilderImpl builder) {
        this.templateBody = builder.templateBody;
        this.templateURL = builder.templateURL;
        this.stackName = builder.stackName;
    }

    /**
     * <p>
     * Structure containing the template body with a minimum length of 1 byte and a maximum length of 51,200 bytes. For
     * more information about templates, see <a
     * href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html">Template Anatomy</a>
     * in the AWS CloudFormation User Guide.
     * </p>
     * <p>
     * Conditional: You must specify only one of the following parameters: <code>StackName</code>,
     * <code>TemplateBody</code>, or <code>TemplateURL</code>.
     * </p>
     * 
     * @return Structure containing the template body with a minimum length of 1 byte and a maximum length of 51,200
     *         bytes. For more information about templates, see <a
     *         href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html">Template
     *         Anatomy</a> in the AWS CloudFormation User Guide.</p>
     *         <p>
     *         Conditional: You must specify only one of the following parameters: <code>StackName</code>,
     *         <code>TemplateBody</code>, or <code>TemplateURL</code>.
     */
    public String templateBody() {
        return templateBody;
    }

    /**
     * <p>
     * Location of file containing the template body. The URL must point to a template (max size: 460,800 bytes) that is
     * located in an Amazon S3 bucket. For more information about templates, see <a
     * href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html">Template Anatomy</a>
     * in the AWS CloudFormation User Guide.
     * </p>
     * <p>
     * Conditional: You must specify only one of the following parameters: <code>StackName</code>,
     * <code>TemplateBody</code>, or <code>TemplateURL</code>.
     * </p>
     * 
     * @return Location of file containing the template body. The URL must point to a template (max size: 460,800 bytes)
     *         that is located in an Amazon S3 bucket. For more information about templates, see <a
     *         href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html">Template
     *         Anatomy</a> in the AWS CloudFormation User Guide.</p>
     *         <p>
     *         Conditional: You must specify only one of the following parameters: <code>StackName</code>,
     *         <code>TemplateBody</code>, or <code>TemplateURL</code>.
     */
    public String templateURL() {
        return templateURL;
    }

    /**
     * <p>
     * The name or the stack ID that is associated with the stack, which are not always interchangeable. For running
     * stacks, you can specify either the stack's name or its unique stack ID. For deleted stack, you must specify the
     * unique stack ID.
     * </p>
     * <p>
     * Conditional: You must specify only one of the following parameters: <code>StackName</code>,
     * <code>TemplateBody</code>, or <code>TemplateURL</code>.
     * </p>
     * 
     * @return The name or the stack ID that is associated with the stack, which are not always interchangeable. For
     *         running stacks, you can specify either the stack's name or its unique stack ID. For deleted stack, you
     *         must specify the unique stack ID.</p>
     *         <p>
     *         Conditional: You must specify only one of the following parameters: <code>StackName</code>,
     *         <code>TemplateBody</code>, or <code>TemplateURL</code>.
     */
    public String stackName() {
        return stackName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((templateBody() == null) ? 0 : templateBody().hashCode());
        hashCode = 31 * hashCode + ((templateURL() == null) ? 0 : templateURL().hashCode());
        hashCode = 31 * hashCode + ((stackName() == null) ? 0 : stackName().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetTemplateSummaryRequest)) {
            return false;
        }
        GetTemplateSummaryRequest other = (GetTemplateSummaryRequest) obj;
        if (other.templateBody() == null ^ this.templateBody() == null) {
            return false;
        }
        if (other.templateBody() != null && !other.templateBody().equals(this.templateBody())) {
            return false;
        }
        if (other.templateURL() == null ^ this.templateURL() == null) {
            return false;
        }
        if (other.templateURL() != null && !other.templateURL().equals(this.templateURL())) {
            return false;
        }
        if (other.stackName() == null ^ this.stackName() == null) {
            return false;
        }
        if (other.stackName() != null && !other.stackName().equals(this.stackName())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (templateBody() != null) {
            sb.append("TemplateBody: ").append(templateBody()).append(",");
        }
        if (templateURL() != null) {
            sb.append("TemplateURL: ").append(templateURL()).append(",");
        }
        if (stackName() != null) {
            sb.append("StackName: ").append(stackName()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, GetTemplateSummaryRequest> {
        /**
         * <p>
         * Structure containing the template body with a minimum length of 1 byte and a maximum length of 51,200 bytes.
         * For more information about templates, see <a
         * href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html">Template
         * Anatomy</a> in the AWS CloudFormation User Guide.
         * </p>
         * <p>
         * Conditional: You must specify only one of the following parameters: <code>StackName</code>,
         * <code>TemplateBody</code>, or <code>TemplateURL</code>.
         * </p>
         * 
         * @param templateBody
         *        Structure containing the template body with a minimum length of 1 byte and a maximum length of 51,200
         *        bytes. For more information about templates, see <a
         *        href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html">Template
         *        Anatomy</a> in the AWS CloudFormation User Guide.</p>
         *        <p>
         *        Conditional: You must specify only one of the following parameters: <code>StackName</code>,
         *        <code>TemplateBody</code>, or <code>TemplateURL</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder templateBody(String templateBody);

        /**
         * <p>
         * Location of file containing the template body. The URL must point to a template (max size: 460,800 bytes)
         * that is located in an Amazon S3 bucket. For more information about templates, see <a
         * href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html">Template
         * Anatomy</a> in the AWS CloudFormation User Guide.
         * </p>
         * <p>
         * Conditional: You must specify only one of the following parameters: <code>StackName</code>,
         * <code>TemplateBody</code>, or <code>TemplateURL</code>.
         * </p>
         * 
         * @param templateURL
         *        Location of file containing the template body. The URL must point to a template (max size: 460,800
         *        bytes) that is located in an Amazon S3 bucket. For more information about templates, see <a
         *        href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html">Template
         *        Anatomy</a> in the AWS CloudFormation User Guide.</p>
         *        <p>
         *        Conditional: You must specify only one of the following parameters: <code>StackName</code>,
         *        <code>TemplateBody</code>, or <code>TemplateURL</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder templateURL(String templateURL);

        /**
         * <p>
         * The name or the stack ID that is associated with the stack, which are not always interchangeable. For running
         * stacks, you can specify either the stack's name or its unique stack ID. For deleted stack, you must specify
         * the unique stack ID.
         * </p>
         * <p>
         * Conditional: You must specify only one of the following parameters: <code>StackName</code>,
         * <code>TemplateBody</code>, or <code>TemplateURL</code>.
         * </p>
         * 
         * @param stackName
         *        The name or the stack ID that is associated with the stack, which are not always interchangeable. For
         *        running stacks, you can specify either the stack's name or its unique stack ID. For deleted stack, you
         *        must specify the unique stack ID.</p>
         *        <p>
         *        Conditional: You must specify only one of the following parameters: <code>StackName</code>,
         *        <code>TemplateBody</code>, or <code>TemplateURL</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stackName(String stackName);
    }

    private static final class BuilderImpl implements Builder {
        private String templateBody;

        private String templateURL;

        private String stackName;

        private BuilderImpl() {
        }

        private BuilderImpl(GetTemplateSummaryRequest model) {
            setTemplateBody(model.templateBody);
            setTemplateURL(model.templateURL);
            setStackName(model.stackName);
        }

        public final String getTemplateBody() {
            return templateBody;
        }

        @Override
        public final Builder templateBody(String templateBody) {
            this.templateBody = templateBody;
            return this;
        }

        public final void setTemplateBody(String templateBody) {
            this.templateBody = templateBody;
        }

        public final String getTemplateURL() {
            return templateURL;
        }

        @Override
        public final Builder templateURL(String templateURL) {
            this.templateURL = templateURL;
            return this;
        }

        public final void setTemplateURL(String templateURL) {
            this.templateURL = templateURL;
        }

        public final String getStackName() {
            return stackName;
        }

        @Override
        public final Builder stackName(String stackName) {
            this.stackName = stackName;
            return this;
        }

        public final void setStackName(String stackName) {
            this.stackName = stackName;
        }

        @Override
        public GetTemplateSummaryRequest build() {
            return new GetTemplateSummaryRequest(this);
        }
    }
}
