/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudformation.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class ListImportsResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<ListImportsResponse.Builder, ListImportsResponse> {
    private final List<String> imports;

    private final String nextToken;

    private ListImportsResponse(BuilderImpl builder) {
        this.imports = builder.imports;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * A list of stack names that are importing the specified exported output value.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A list of stack names that are importing the specified exported output value.
     */
    public List<String> imports() {
        return imports;
    }

    /**
     * <p>
     * A string that identifies the next page of exports. If there is no additional page, this value is null.
     * </p>
     * 
     * @return A string that identifies the next page of exports. If there is no additional page, this value is null.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((imports() == null) ? 0 : imports().hashCode());
        hashCode = 31 * hashCode + ((nextToken() == null) ? 0 : nextToken().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListImportsResponse)) {
            return false;
        }
        ListImportsResponse other = (ListImportsResponse) obj;
        if (other.imports() == null ^ this.imports() == null) {
            return false;
        }
        if (other.imports() != null && !other.imports().equals(this.imports())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        if (other.nextToken() != null && !other.nextToken().equals(this.nextToken())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (imports() != null) {
            sb.append("Imports: ").append(imports()).append(",");
        }
        if (nextToken() != null) {
            sb.append("NextToken: ").append(nextToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, ListImportsResponse> {
        /**
         * <p>
         * A list of stack names that are importing the specified exported output value.
         * </p>
         * 
         * @param imports
         *        A list of stack names that are importing the specified exported output value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imports(Collection<String> imports);

        /**
         * <p>
         * A list of stack names that are importing the specified exported output value.
         * </p>
         * 
         * @param imports
         *        A list of stack names that are importing the specified exported output value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imports(String... imports);

        /**
         * <p>
         * A string that identifies the next page of exports. If there is no additional page, this value is null.
         * </p>
         * 
         * @param nextToken
         *        A string that identifies the next page of exports. If there is no additional page, this value is null.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    private static final class BuilderImpl implements Builder {
        private List<String> imports;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListImportsResponse model) {
            setImports(model.imports);
            setNextToken(model.nextToken);
        }

        public final Collection<String> getImports() {
            return imports;
        }

        @Override
        public final Builder imports(Collection<String> imports) {
            this.imports = ImportsCopier.copy(imports);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder imports(String... imports) {
            imports(Arrays.asList(imports));
            return this;
        }

        public final void setImports(Collection<String> imports) {
            this.imports = ImportsCopier.copy(imports);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListImportsResponse build() {
            return new ListImportsResponse(this);
        }
    }
}
