/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudformation.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The input for the <a>ListStackResource</a> action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ListStackResourcesRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<ListStackResourcesRequest.Builder, ListStackResourcesRequest> {
    private final String stackName;

    private final String nextToken;

    private ListStackResourcesRequest(BuilderImpl builder) {
        this.stackName = builder.stackName;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The name or the unique stack ID that is associated with the stack, which are not always interchangeable:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Running stacks: You can specify either the stack's name or its unique stack ID.
     * </p>
     * </li>
     * <li>
     * <p>
     * Deleted stacks: You must specify the unique stack ID.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Default: There is no default value.
     * </p>
     * 
     * @return The name or the unique stack ID that is associated with the stack, which are not always
     *         interchangeable:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Running stacks: You can specify either the stack's name or its unique stack ID.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Deleted stacks: You must specify the unique stack ID.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         Default: There is no default value.
     */
    public String stackName() {
        return stackName;
    }

    /**
     * <p>
     * A string that identifies the next page of stack resources that you want to retrieve.
     * </p>
     * 
     * @return A string that identifies the next page of stack resources that you want to retrieve.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((stackName() == null) ? 0 : stackName().hashCode());
        hashCode = 31 * hashCode + ((nextToken() == null) ? 0 : nextToken().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListStackResourcesRequest)) {
            return false;
        }
        ListStackResourcesRequest other = (ListStackResourcesRequest) obj;
        if (other.stackName() == null ^ this.stackName() == null) {
            return false;
        }
        if (other.stackName() != null && !other.stackName().equals(this.stackName())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        if (other.nextToken() != null && !other.nextToken().equals(this.nextToken())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (stackName() != null) {
            sb.append("StackName: ").append(stackName()).append(",");
        }
        if (nextToken() != null) {
            sb.append("NextToken: ").append(nextToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, ListStackResourcesRequest> {
        /**
         * <p>
         * The name or the unique stack ID that is associated with the stack, which are not always interchangeable:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Running stacks: You can specify either the stack's name or its unique stack ID.
         * </p>
         * </li>
         * <li>
         * <p>
         * Deleted stacks: You must specify the unique stack ID.
         * </p>
         * </li>
         * </ul>
         * <p>
         * Default: There is no default value.
         * </p>
         * 
         * @param stackName
         *        The name or the unique stack ID that is associated with the stack, which are not always
         *        interchangeable:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        Running stacks: You can specify either the stack's name or its unique stack ID.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Deleted stacks: You must specify the unique stack ID.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        Default: There is no default value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stackName(String stackName);

        /**
         * <p>
         * A string that identifies the next page of stack resources that you want to retrieve.
         * </p>
         * 
         * @param nextToken
         *        A string that identifies the next page of stack resources that you want to retrieve.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    private static final class BuilderImpl implements Builder {
        private String stackName;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListStackResourcesRequest model) {
            setStackName(model.stackName);
            setNextToken(model.nextToken);
        }

        public final String getStackName() {
            return stackName;
        }

        @Override
        public final Builder stackName(String stackName) {
            this.stackName = stackName;
            return this;
        }

        public final void setStackName(String stackName) {
            this.stackName = stackName;
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListStackResourcesRequest build() {
            return new ListStackResourcesRequest(this);
        }
    }
}
