/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudformation.model;

import java.time.Instant;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains detailed information about the specified stack resource.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class StackResourceDetail implements ToCopyableBuilder<StackResourceDetail.Builder, StackResourceDetail> {
    private final String stackName;

    private final String stackId;

    private final String logicalResourceId;

    private final String physicalResourceId;

    private final String resourceType;

    private final Instant lastUpdatedTimestamp;

    private final String resourceStatus;

    private final String resourceStatusReason;

    private final String description;

    private final String metadata;

    private StackResourceDetail(BuilderImpl builder) {
        this.stackName = builder.stackName;
        this.stackId = builder.stackId;
        this.logicalResourceId = builder.logicalResourceId;
        this.physicalResourceId = builder.physicalResourceId;
        this.resourceType = builder.resourceType;
        this.lastUpdatedTimestamp = builder.lastUpdatedTimestamp;
        this.resourceStatus = builder.resourceStatus;
        this.resourceStatusReason = builder.resourceStatusReason;
        this.description = builder.description;
        this.metadata = builder.metadata;
    }

    /**
     * <p>
     * The name associated with the stack.
     * </p>
     * 
     * @return The name associated with the stack.
     */
    public String stackName() {
        return stackName;
    }

    /**
     * <p>
     * Unique identifier of the stack.
     * </p>
     * 
     * @return Unique identifier of the stack.
     */
    public String stackId() {
        return stackId;
    }

    /**
     * <p>
     * The logical name of the resource specified in the template.
     * </p>
     * 
     * @return The logical name of the resource specified in the template.
     */
    public String logicalResourceId() {
        return logicalResourceId;
    }

    /**
     * <p>
     * The name or unique identifier that corresponds to a physical instance ID of a resource supported by AWS
     * CloudFormation.
     * </p>
     * 
     * @return The name or unique identifier that corresponds to a physical instance ID of a resource supported by AWS
     *         CloudFormation.
     */
    public String physicalResourceId() {
        return physicalResourceId;
    }

    /**
     * <p>
     * Type of resource. ((For more information, go to <a
     * href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-template-resource-type-ref.html"> AWS
     * Resource Types Reference</a> in the AWS CloudFormation User Guide.)
     * </p>
     * 
     * @return Type of resource. ((For more information, go to <a
     *         href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-template-resource-type-ref.html">
     *         AWS Resource Types Reference</a> in the AWS CloudFormation User Guide.)
     */
    public String resourceType() {
        return resourceType;
    }

    /**
     * <p>
     * Time the status was updated.
     * </p>
     * 
     * @return Time the status was updated.
     */
    public Instant lastUpdatedTimestamp() {
        return lastUpdatedTimestamp;
    }

    /**
     * <p>
     * Current status of the resource.
     * </p>
     * 
     * @return Current status of the resource.
     * @see ResourceStatus
     */
    public String resourceStatus() {
        return resourceStatus;
    }

    /**
     * <p>
     * Success/failure message associated with the resource.
     * </p>
     * 
     * @return Success/failure message associated with the resource.
     */
    public String resourceStatusReason() {
        return resourceStatusReason;
    }

    /**
     * <p>
     * User defined description associated with the resource.
     * </p>
     * 
     * @return User defined description associated with the resource.
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * The content of the <code>Metadata</code> attribute declared for the resource. For more information, see <a
     * href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-attribute-metadata.html">Metadata
     * Attribute</a> in the AWS CloudFormation User Guide.
     * </p>
     * 
     * @return The content of the <code>Metadata</code> attribute declared for the resource. For more information, see
     *         <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-attribute-metadata.html">
     *         Metadata Attribute</a> in the AWS CloudFormation User Guide.
     */
    public String metadata() {
        return metadata;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((stackName() == null) ? 0 : stackName().hashCode());
        hashCode = 31 * hashCode + ((stackId() == null) ? 0 : stackId().hashCode());
        hashCode = 31 * hashCode + ((logicalResourceId() == null) ? 0 : logicalResourceId().hashCode());
        hashCode = 31 * hashCode + ((physicalResourceId() == null) ? 0 : physicalResourceId().hashCode());
        hashCode = 31 * hashCode + ((resourceType() == null) ? 0 : resourceType().hashCode());
        hashCode = 31 * hashCode + ((lastUpdatedTimestamp() == null) ? 0 : lastUpdatedTimestamp().hashCode());
        hashCode = 31 * hashCode + ((resourceStatus() == null) ? 0 : resourceStatus().hashCode());
        hashCode = 31 * hashCode + ((resourceStatusReason() == null) ? 0 : resourceStatusReason().hashCode());
        hashCode = 31 * hashCode + ((description() == null) ? 0 : description().hashCode());
        hashCode = 31 * hashCode + ((metadata() == null) ? 0 : metadata().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StackResourceDetail)) {
            return false;
        }
        StackResourceDetail other = (StackResourceDetail) obj;
        if (other.stackName() == null ^ this.stackName() == null) {
            return false;
        }
        if (other.stackName() != null && !other.stackName().equals(this.stackName())) {
            return false;
        }
        if (other.stackId() == null ^ this.stackId() == null) {
            return false;
        }
        if (other.stackId() != null && !other.stackId().equals(this.stackId())) {
            return false;
        }
        if (other.logicalResourceId() == null ^ this.logicalResourceId() == null) {
            return false;
        }
        if (other.logicalResourceId() != null && !other.logicalResourceId().equals(this.logicalResourceId())) {
            return false;
        }
        if (other.physicalResourceId() == null ^ this.physicalResourceId() == null) {
            return false;
        }
        if (other.physicalResourceId() != null && !other.physicalResourceId().equals(this.physicalResourceId())) {
            return false;
        }
        if (other.resourceType() == null ^ this.resourceType() == null) {
            return false;
        }
        if (other.resourceType() != null && !other.resourceType().equals(this.resourceType())) {
            return false;
        }
        if (other.lastUpdatedTimestamp() == null ^ this.lastUpdatedTimestamp() == null) {
            return false;
        }
        if (other.lastUpdatedTimestamp() != null && !other.lastUpdatedTimestamp().equals(this.lastUpdatedTimestamp())) {
            return false;
        }
        if (other.resourceStatus() == null ^ this.resourceStatus() == null) {
            return false;
        }
        if (other.resourceStatus() != null && !other.resourceStatus().equals(this.resourceStatus())) {
            return false;
        }
        if (other.resourceStatusReason() == null ^ this.resourceStatusReason() == null) {
            return false;
        }
        if (other.resourceStatusReason() != null && !other.resourceStatusReason().equals(this.resourceStatusReason())) {
            return false;
        }
        if (other.description() == null ^ this.description() == null) {
            return false;
        }
        if (other.description() != null && !other.description().equals(this.description())) {
            return false;
        }
        if (other.metadata() == null ^ this.metadata() == null) {
            return false;
        }
        if (other.metadata() != null && !other.metadata().equals(this.metadata())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (stackName() != null) {
            sb.append("StackName: ").append(stackName()).append(",");
        }
        if (stackId() != null) {
            sb.append("StackId: ").append(stackId()).append(",");
        }
        if (logicalResourceId() != null) {
            sb.append("LogicalResourceId: ").append(logicalResourceId()).append(",");
        }
        if (physicalResourceId() != null) {
            sb.append("PhysicalResourceId: ").append(physicalResourceId()).append(",");
        }
        if (resourceType() != null) {
            sb.append("ResourceType: ").append(resourceType()).append(",");
        }
        if (lastUpdatedTimestamp() != null) {
            sb.append("LastUpdatedTimestamp: ").append(lastUpdatedTimestamp()).append(",");
        }
        if (resourceStatus() != null) {
            sb.append("ResourceStatus: ").append(resourceStatus()).append(",");
        }
        if (resourceStatusReason() != null) {
            sb.append("ResourceStatusReason: ").append(resourceStatusReason()).append(",");
        }
        if (description() != null) {
            sb.append("Description: ").append(description()).append(",");
        }
        if (metadata() != null) {
            sb.append("Metadata: ").append(metadata()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, StackResourceDetail> {
        /**
         * <p>
         * The name associated with the stack.
         * </p>
         * 
         * @param stackName
         *        The name associated with the stack.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stackName(String stackName);

        /**
         * <p>
         * Unique identifier of the stack.
         * </p>
         * 
         * @param stackId
         *        Unique identifier of the stack.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stackId(String stackId);

        /**
         * <p>
         * The logical name of the resource specified in the template.
         * </p>
         * 
         * @param logicalResourceId
         *        The logical name of the resource specified in the template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logicalResourceId(String logicalResourceId);

        /**
         * <p>
         * The name or unique identifier that corresponds to a physical instance ID of a resource supported by AWS
         * CloudFormation.
         * </p>
         * 
         * @param physicalResourceId
         *        The name or unique identifier that corresponds to a physical instance ID of a resource supported by
         *        AWS CloudFormation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder physicalResourceId(String physicalResourceId);

        /**
         * <p>
         * Type of resource. ((For more information, go to <a
         * href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-template-resource-type-ref.html"> AWS
         * Resource Types Reference</a> in the AWS CloudFormation User Guide.)
         * </p>
         * 
         * @param resourceType
         *        Type of resource. ((For more information, go to <a href=
         *        "http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-template-resource-type-ref.html">
         *        AWS Resource Types Reference</a> in the AWS CloudFormation User Guide.)
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceType(String resourceType);

        /**
         * <p>
         * Time the status was updated.
         * </p>
         * 
         * @param lastUpdatedTimestamp
         *        Time the status was updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedTimestamp(Instant lastUpdatedTimestamp);

        /**
         * <p>
         * Current status of the resource.
         * </p>
         * 
         * @param resourceStatus
         *        Current status of the resource.
         * @see ResourceStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceStatus
         */
        Builder resourceStatus(String resourceStatus);

        /**
         * <p>
         * Current status of the resource.
         * </p>
         * 
         * @param resourceStatus
         *        Current status of the resource.
         * @see ResourceStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceStatus
         */
        Builder resourceStatus(ResourceStatus resourceStatus);

        /**
         * <p>
         * Success/failure message associated with the resource.
         * </p>
         * 
         * @param resourceStatusReason
         *        Success/failure message associated with the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceStatusReason(String resourceStatusReason);

        /**
         * <p>
         * User defined description associated with the resource.
         * </p>
         * 
         * @param description
         *        User defined description associated with the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The content of the <code>Metadata</code> attribute declared for the resource. For more information, see <a
         * href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-attribute-metadata.html">Metadata
         * Attribute</a> in the AWS CloudFormation User Guide.
         * </p>
         * 
         * @param metadata
         *        The content of the <code>Metadata</code> attribute declared for the resource. For more information,
         *        see <a
         *        href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-attribute-metadata.html"
         *        >Metadata Attribute</a> in the AWS CloudFormation User Guide.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metadata(String metadata);
    }

    private static final class BuilderImpl implements Builder {
        private String stackName;

        private String stackId;

        private String logicalResourceId;

        private String physicalResourceId;

        private String resourceType;

        private Instant lastUpdatedTimestamp;

        private String resourceStatus;

        private String resourceStatusReason;

        private String description;

        private String metadata;

        private BuilderImpl() {
        }

        private BuilderImpl(StackResourceDetail model) {
            setStackName(model.stackName);
            setStackId(model.stackId);
            setLogicalResourceId(model.logicalResourceId);
            setPhysicalResourceId(model.physicalResourceId);
            setResourceType(model.resourceType);
            setLastUpdatedTimestamp(model.lastUpdatedTimestamp);
            setResourceStatus(model.resourceStatus);
            setResourceStatusReason(model.resourceStatusReason);
            setDescription(model.description);
            setMetadata(model.metadata);
        }

        public final String getStackName() {
            return stackName;
        }

        @Override
        public final Builder stackName(String stackName) {
            this.stackName = stackName;
            return this;
        }

        public final void setStackName(String stackName) {
            this.stackName = stackName;
        }

        public final String getStackId() {
            return stackId;
        }

        @Override
        public final Builder stackId(String stackId) {
            this.stackId = stackId;
            return this;
        }

        public final void setStackId(String stackId) {
            this.stackId = stackId;
        }

        public final String getLogicalResourceId() {
            return logicalResourceId;
        }

        @Override
        public final Builder logicalResourceId(String logicalResourceId) {
            this.logicalResourceId = logicalResourceId;
            return this;
        }

        public final void setLogicalResourceId(String logicalResourceId) {
            this.logicalResourceId = logicalResourceId;
        }

        public final String getPhysicalResourceId() {
            return physicalResourceId;
        }

        @Override
        public final Builder physicalResourceId(String physicalResourceId) {
            this.physicalResourceId = physicalResourceId;
            return this;
        }

        public final void setPhysicalResourceId(String physicalResourceId) {
            this.physicalResourceId = physicalResourceId;
        }

        public final String getResourceType() {
            return resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        public final Instant getLastUpdatedTimestamp() {
            return lastUpdatedTimestamp;
        }

        @Override
        public final Builder lastUpdatedTimestamp(Instant lastUpdatedTimestamp) {
            this.lastUpdatedTimestamp = lastUpdatedTimestamp;
            return this;
        }

        public final void setLastUpdatedTimestamp(Instant lastUpdatedTimestamp) {
            this.lastUpdatedTimestamp = lastUpdatedTimestamp;
        }

        public final String getResourceStatus() {
            return resourceStatus;
        }

        @Override
        public final Builder resourceStatus(String resourceStatus) {
            this.resourceStatus = resourceStatus;
            return this;
        }

        @Override
        public final Builder resourceStatus(ResourceStatus resourceStatus) {
            this.resourceStatus(resourceStatus.toString());
            return this;
        }

        public final void setResourceStatus(String resourceStatus) {
            this.resourceStatus = resourceStatus;
        }

        public final String getResourceStatusReason() {
            return resourceStatusReason;
        }

        @Override
        public final Builder resourceStatusReason(String resourceStatusReason) {
            this.resourceStatusReason = resourceStatusReason;
            return this;
        }

        public final void setResourceStatusReason(String resourceStatusReason) {
            this.resourceStatusReason = resourceStatusReason;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getMetadata() {
            return metadata;
        }

        @Override
        public final Builder metadata(String metadata) {
            this.metadata = metadata;
            return this;
        }

        public final void setMetadata(String metadata) {
            this.metadata = metadata;
        }

        @Override
        public StackResourceDetail build() {
            return new StackResourceDetail(this);
        }
    }
}
