/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudformation.transform;

import javax.annotation.Generated;

import software.amazon.awssdk.services.cloudformation.model.*;
import software.amazon.awssdk.runtime.transform.Unmarshaller;

import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers.*;

/**
 * ContinueUpdateRollbackResponse StAX Unmarshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class ContinueUpdateRollbackResponseUnmarshaller implements
        Unmarshaller<ContinueUpdateRollbackResponse, StaxUnmarshallerContext> {

    public ContinueUpdateRollbackResponse unmarshall(StaxUnmarshallerContext context) throws Exception {
        ContinueUpdateRollbackResponse.Builder continueUpdateRollbackResponse = ContinueUpdateRollbackResponse.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;

        if (context.isStartOfDocument())
            targetDepth += 2;

        return continueUpdateRollbackResponse.build();
    }

    private static final ContinueUpdateRollbackResponseUnmarshaller INSTANCE = new ContinueUpdateRollbackResponseUnmarshaller();

    public static ContinueUpdateRollbackResponseUnmarshaller getInstance() {
        return INSTANCE;
    }
}
