/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudformation.transform;

import java.util.ArrayList;

import javax.xml.stream.events.XMLEvent;
import javax.annotation.Generated;

import software.amazon.awssdk.services.cloudformation.model.*;
import software.amazon.awssdk.runtime.transform.Unmarshaller;

import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers.*;

/**
 * GetTemplateSummaryResponse StAX Unmarshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class GetTemplateSummaryResponseUnmarshaller implements Unmarshaller<GetTemplateSummaryResponse, StaxUnmarshallerContext> {

    public GetTemplateSummaryResponse unmarshall(StaxUnmarshallerContext context) throws Exception {
        GetTemplateSummaryResponse.Builder getTemplateSummaryResponse = GetTemplateSummaryResponse.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;

        if (context.isStartOfDocument())
            targetDepth += 2;

        java.util.List<ParameterDeclaration> parameters = null;
        java.util.List<String> capabilities = null;
        java.util.List<String> resourceTypes = null;
        java.util.List<String> declaredTransforms = null;

        while (true) {
            XMLEvent xmlEvent = context.nextEvent();
            if (xmlEvent.isEndDocument()) {
                getTemplateSummaryResponse.parameters(parameters);
                getTemplateSummaryResponse.capabilities(capabilities);
                getTemplateSummaryResponse.resourceTypes(resourceTypes);
                getTemplateSummaryResponse.declaredTransforms(declaredTransforms);
                break;
            }

            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {

                if (context.testExpression("Parameters", targetDepth)) {
                    parameters = new ArrayList<ParameterDeclaration>();
                    continue;
                }

                if (context.testExpression("Parameters/member", targetDepth)) {
                    parameters.add(ParameterDeclarationUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("Description", targetDepth)) {
                    getTemplateSummaryResponse.description(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("Capabilities", targetDepth)) {
                    capabilities = new ArrayList<String>();
                    continue;
                }

                if (context.testExpression("Capabilities/member", targetDepth)) {
                    capabilities.add(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("CapabilitiesReason", targetDepth)) {
                    getTemplateSummaryResponse.capabilitiesReason(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("ResourceTypes", targetDepth)) {
                    resourceTypes = new ArrayList<String>();
                    continue;
                }

                if (context.testExpression("ResourceTypes/member", targetDepth)) {
                    resourceTypes.add(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("Version", targetDepth)) {
                    getTemplateSummaryResponse.version(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("Metadata", targetDepth)) {
                    getTemplateSummaryResponse.metadata(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("DeclaredTransforms", targetDepth)) {
                    declaredTransforms = new ArrayList<String>();
                    continue;
                }

                if (context.testExpression("DeclaredTransforms/member", targetDepth)) {
                    declaredTransforms.add(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

            } else if (xmlEvent.isEndElement()) {
                if (context.getCurrentDepth() < originalDepth) {
                    getTemplateSummaryResponse.parameters(parameters);
                    getTemplateSummaryResponse.capabilities(capabilities);
                    getTemplateSummaryResponse.resourceTypes(resourceTypes);
                    getTemplateSummaryResponse.declaredTransforms(declaredTransforms);
                    break;
                }
            }
        }
        return getTemplateSummaryResponse.build();
    }

    private static final GetTemplateSummaryResponseUnmarshaller INSTANCE = new GetTemplateSummaryResponseUnmarshaller();

    public static GetTemplateSummaryResponseUnmarshaller getInstance() {
        return INSTANCE;
    }
}
