/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.transform;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.cloudformation.model.CancelUpdateStackRequest;
import software.amazon.awssdk.util.StringUtils;

public class CancelUpdateStackRequestMarshaller
implements Marshaller<Request<CancelUpdateStackRequest>, CancelUpdateStackRequest> {
    public Request<CancelUpdateStackRequest> marshall(CancelUpdateStackRequest cancelUpdateStackRequest) {
        if (cancelUpdateStackRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)cancelUpdateStackRequest, "CloudFormationClient");
        request.addParameter("Action", "CancelUpdateStack");
        request.addParameter("Version", "2010-05-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (cancelUpdateStackRequest.stackName() != null) {
            request.addParameter("StackName", StringUtils.fromString((String)cancelUpdateStackRequest.stackName()));
        }
        if (cancelUpdateStackRequest.clientRequestToken() != null) {
            request.addParameter("ClientRequestToken", StringUtils.fromString((String)cancelUpdateStackRequest.clientRequestToken()));
        }
        return request;
    }
}

