/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.transform;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.cloudformation.model.SetStackPolicyRequest;
import software.amazon.awssdk.util.StringUtils;

public class SetStackPolicyRequestMarshaller
implements Marshaller<Request<SetStackPolicyRequest>, SetStackPolicyRequest> {
    public Request<SetStackPolicyRequest> marshall(SetStackPolicyRequest setStackPolicyRequest) {
        if (setStackPolicyRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)setStackPolicyRequest, "CloudFormationClient");
        request.addParameter("Action", "SetStackPolicy");
        request.addParameter("Version", "2010-05-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (setStackPolicyRequest.stackName() != null) {
            request.addParameter("StackName", StringUtils.fromString((String)setStackPolicyRequest.stackName()));
        }
        if (setStackPolicyRequest.stackPolicyBody() != null) {
            request.addParameter("StackPolicyBody", StringUtils.fromString((String)setStackPolicyRequest.stackPolicyBody()));
        }
        if (setStackPolicyRequest.stackPolicyURL() != null) {
            request.addParameter("StackPolicyURL", StringUtils.fromString((String)setStackPolicyRequest.stackPolicyURL()));
        }
        return request;
    }
}

