/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudformation.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.core.runtime.TypeConverter;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The output for the <a>DescribeChangeSet</a> action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeChangeSetResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<DescribeChangeSetResponse.Builder, DescribeChangeSetResponse> {
    private final String changeSetName;

    private final String changeSetId;

    private final String stackId;

    private final String stackName;

    private final String description;

    private final List<Parameter> parameters;

    private final Instant creationTime;

    private final String executionStatus;

    private final String status;

    private final String statusReason;

    private final List<String> notificationARNs;

    private final List<String> capabilities;

    private final List<Tag> tags;

    private final List<Change> changes;

    private final String nextToken;

    private DescribeChangeSetResponse(BuilderImpl builder) {
        this.changeSetName = builder.changeSetName;
        this.changeSetId = builder.changeSetId;
        this.stackId = builder.stackId;
        this.stackName = builder.stackName;
        this.description = builder.description;
        this.parameters = builder.parameters;
        this.creationTime = builder.creationTime;
        this.executionStatus = builder.executionStatus;
        this.status = builder.status;
        this.statusReason = builder.statusReason;
        this.notificationARNs = builder.notificationARNs;
        this.capabilities = builder.capabilities;
        this.tags = builder.tags;
        this.changes = builder.changes;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The name of the change set.
     * </p>
     * 
     * @return The name of the change set.
     */
    public String changeSetName() {
        return changeSetName;
    }

    /**
     * <p>
     * The ARN of the change set.
     * </p>
     * 
     * @return The ARN of the change set.
     */
    public String changeSetId() {
        return changeSetId;
    }

    /**
     * <p>
     * The ARN of the stack that is associated with the change set.
     * </p>
     * 
     * @return The ARN of the stack that is associated with the change set.
     */
    public String stackId() {
        return stackId;
    }

    /**
     * <p>
     * The name of the stack that is associated with the change set.
     * </p>
     * 
     * @return The name of the stack that is associated with the change set.
     */
    public String stackName() {
        return stackName;
    }

    /**
     * <p>
     * Information about the change set.
     * </p>
     * 
     * @return Information about the change set.
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * A list of <code>Parameter</code> structures that describes the input parameters and their values used to create
     * the change set. For more information, see the <a
     * href="http://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_Parameter.html">Parameter</a> data
     * type.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A list of <code>Parameter</code> structures that describes the input parameters and their values used to
     *         create the change set. For more information, see the <a
     *         href="http://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_Parameter.html">Parameter</a>
     *         data type.
     */
    public List<Parameter> parameters() {
        return parameters;
    }

    /**
     * <p>
     * The start time when the change set was created, in UTC.
     * </p>
     * 
     * @return The start time when the change set was created, in UTC.
     */
    public Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * If the change set execution status is <code>AVAILABLE</code>, you can execute the change set. If you can’t
     * execute the change set, the status indicates why. For example, a change set might be in an
     * <code>UNAVAILABLE</code> state because AWS CloudFormation is still creating it or in an <code>OBSOLETE</code>
     * state because the stack was already updated.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #executionStatus}
     * will return {@link ExecutionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #executionStatusString}.
     * </p>
     * 
     * @return If the change set execution status is <code>AVAILABLE</code>, you can execute the change set. If you
     *         can’t execute the change set, the status indicates why. For example, a change set might be in an
     *         <code>UNAVAILABLE</code> state because AWS CloudFormation is still creating it or in an
     *         <code>OBSOLETE</code> state because the stack was already updated.
     * @see ExecutionStatus
     */
    public ExecutionStatus executionStatus() {
        return ExecutionStatus.fromValue(executionStatus);
    }

    /**
     * <p>
     * If the change set execution status is <code>AVAILABLE</code>, you can execute the change set. If you can’t
     * execute the change set, the status indicates why. For example, a change set might be in an
     * <code>UNAVAILABLE</code> state because AWS CloudFormation is still creating it or in an <code>OBSOLETE</code>
     * state because the stack was already updated.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #executionStatus}
     * will return {@link ExecutionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #executionStatusString}.
     * </p>
     * 
     * @return If the change set execution status is <code>AVAILABLE</code>, you can execute the change set. If you
     *         can’t execute the change set, the status indicates why. For example, a change set might be in an
     *         <code>UNAVAILABLE</code> state because AWS CloudFormation is still creating it or in an
     *         <code>OBSOLETE</code> state because the stack was already updated.
     * @see ExecutionStatus
     */
    public String executionStatusString() {
        return executionStatus;
    }

    /**
     * <p>
     * The current status of the change set, such as <code>CREATE_IN_PROGRESS</code>, <code>CREATE_COMPLETE</code>, or
     * <code>FAILED</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ChangeSetStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusString}.
     * </p>
     * 
     * @return The current status of the change set, such as <code>CREATE_IN_PROGRESS</code>,
     *         <code>CREATE_COMPLETE</code>, or <code>FAILED</code>.
     * @see ChangeSetStatus
     */
    public ChangeSetStatus status() {
        return ChangeSetStatus.fromValue(status);
    }

    /**
     * <p>
     * The current status of the change set, such as <code>CREATE_IN_PROGRESS</code>, <code>CREATE_COMPLETE</code>, or
     * <code>FAILED</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ChangeSetStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusString}.
     * </p>
     * 
     * @return The current status of the change set, such as <code>CREATE_IN_PROGRESS</code>,
     *         <code>CREATE_COMPLETE</code>, or <code>FAILED</code>.
     * @see ChangeSetStatus
     */
    public String statusString() {
        return status;
    }

    /**
     * <p>
     * A description of the change set's status. For example, if your attempt to create a change set failed, AWS
     * CloudFormation shows the error message.
     * </p>
     * 
     * @return A description of the change set's status. For example, if your attempt to create a change set failed, AWS
     *         CloudFormation shows the error message.
     */
    public String statusReason() {
        return statusReason;
    }

    /**
     * <p>
     * The ARNs of the Amazon Simple Notification Service (Amazon SNS) topics that will be associated with the stack if
     * you execute the change set.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The ARNs of the Amazon Simple Notification Service (Amazon SNS) topics that will be associated with the
     *         stack if you execute the change set.
     */
    public List<String> notificationARNs() {
        return notificationARNs;
    }

    /**
     * <p>
     * If you execute the change set, the list of capabilities that were explicitly acknowledged when the change set was
     * created.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return If you execute the change set, the list of capabilities that were explicitly acknowledged when the change
     *         set was created.
     */
    public List<Capability> capabilities() {
        return TypeConverter.convert(capabilities, Capability::fromValue);
    }

    /**
     * <p>
     * If you execute the change set, the list of capabilities that were explicitly acknowledged when the change set was
     * created.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return If you execute the change set, the list of capabilities that were explicitly acknowledged when the change
     *         set was created.
     */
    public List<String> capabilitiesStrings() {
        return capabilities;
    }

    /**
     * <p>
     * If you execute the change set, the tags that will be associated with the stack.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return If you execute the change set, the tags that will be associated with the stack.
     */
    public List<Tag> tags() {
        return tags;
    }

    /**
     * <p>
     * A list of <code>Change</code> structures that describes the resources AWS CloudFormation changes if you execute
     * the change set.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A list of <code>Change</code> structures that describes the resources AWS CloudFormation changes if you
     *         execute the change set.
     */
    public List<Change> changes() {
        return changes;
    }

    /**
     * <p>
     * If the output exceeds 1 MB, a string that identifies the next page of changes. If there is no additional page,
     * this value is null.
     * </p>
     * 
     * @return If the output exceeds 1 MB, a string that identifies the next page of changes. If there is no additional
     *         page, this value is null.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((changeSetName() == null) ? 0 : changeSetName().hashCode());
        hashCode = 31 * hashCode + ((changeSetId() == null) ? 0 : changeSetId().hashCode());
        hashCode = 31 * hashCode + ((stackId() == null) ? 0 : stackId().hashCode());
        hashCode = 31 * hashCode + ((stackName() == null) ? 0 : stackName().hashCode());
        hashCode = 31 * hashCode + ((description() == null) ? 0 : description().hashCode());
        hashCode = 31 * hashCode + ((parameters() == null) ? 0 : parameters().hashCode());
        hashCode = 31 * hashCode + ((creationTime() == null) ? 0 : creationTime().hashCode());
        hashCode = 31 * hashCode + ((executionStatusString() == null) ? 0 : executionStatusString().hashCode());
        hashCode = 31 * hashCode + ((statusString() == null) ? 0 : statusString().hashCode());
        hashCode = 31 * hashCode + ((statusReason() == null) ? 0 : statusReason().hashCode());
        hashCode = 31 * hashCode + ((notificationARNs() == null) ? 0 : notificationARNs().hashCode());
        hashCode = 31 * hashCode + ((capabilitiesStrings() == null) ? 0 : capabilitiesStrings().hashCode());
        hashCode = 31 * hashCode + ((tags() == null) ? 0 : tags().hashCode());
        hashCode = 31 * hashCode + ((changes() == null) ? 0 : changes().hashCode());
        hashCode = 31 * hashCode + ((nextToken() == null) ? 0 : nextToken().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeChangeSetResponse)) {
            return false;
        }
        DescribeChangeSetResponse other = (DescribeChangeSetResponse) obj;
        if (other.changeSetName() == null ^ this.changeSetName() == null) {
            return false;
        }
        if (other.changeSetName() != null && !other.changeSetName().equals(this.changeSetName())) {
            return false;
        }
        if (other.changeSetId() == null ^ this.changeSetId() == null) {
            return false;
        }
        if (other.changeSetId() != null && !other.changeSetId().equals(this.changeSetId())) {
            return false;
        }
        if (other.stackId() == null ^ this.stackId() == null) {
            return false;
        }
        if (other.stackId() != null && !other.stackId().equals(this.stackId())) {
            return false;
        }
        if (other.stackName() == null ^ this.stackName() == null) {
            return false;
        }
        if (other.stackName() != null && !other.stackName().equals(this.stackName())) {
            return false;
        }
        if (other.description() == null ^ this.description() == null) {
            return false;
        }
        if (other.description() != null && !other.description().equals(this.description())) {
            return false;
        }
        if (other.parameters() == null ^ this.parameters() == null) {
            return false;
        }
        if (other.parameters() != null && !other.parameters().equals(this.parameters())) {
            return false;
        }
        if (other.creationTime() == null ^ this.creationTime() == null) {
            return false;
        }
        if (other.creationTime() != null && !other.creationTime().equals(this.creationTime())) {
            return false;
        }
        if (other.executionStatusString() == null ^ this.executionStatusString() == null) {
            return false;
        }
        if (other.executionStatusString() != null && !other.executionStatusString().equals(this.executionStatusString())) {
            return false;
        }
        if (other.statusString() == null ^ this.statusString() == null) {
            return false;
        }
        if (other.statusString() != null && !other.statusString().equals(this.statusString())) {
            return false;
        }
        if (other.statusReason() == null ^ this.statusReason() == null) {
            return false;
        }
        if (other.statusReason() != null && !other.statusReason().equals(this.statusReason())) {
            return false;
        }
        if (other.notificationARNs() == null ^ this.notificationARNs() == null) {
            return false;
        }
        if (other.notificationARNs() != null && !other.notificationARNs().equals(this.notificationARNs())) {
            return false;
        }
        if (other.capabilitiesStrings() == null ^ this.capabilitiesStrings() == null) {
            return false;
        }
        if (other.capabilitiesStrings() != null && !other.capabilitiesStrings().equals(this.capabilitiesStrings())) {
            return false;
        }
        if (other.tags() == null ^ this.tags() == null) {
            return false;
        }
        if (other.tags() != null && !other.tags().equals(this.tags())) {
            return false;
        }
        if (other.changes() == null ^ this.changes() == null) {
            return false;
        }
        if (other.changes() != null && !other.changes().equals(this.changes())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        if (other.nextToken() != null && !other.nextToken().equals(this.nextToken())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (changeSetName() != null) {
            sb.append("ChangeSetName: ").append(changeSetName()).append(",");
        }
        if (changeSetId() != null) {
            sb.append("ChangeSetId: ").append(changeSetId()).append(",");
        }
        if (stackId() != null) {
            sb.append("StackId: ").append(stackId()).append(",");
        }
        if (stackName() != null) {
            sb.append("StackName: ").append(stackName()).append(",");
        }
        if (description() != null) {
            sb.append("Description: ").append(description()).append(",");
        }
        if (parameters() != null) {
            sb.append("Parameters: ").append(parameters()).append(",");
        }
        if (creationTime() != null) {
            sb.append("CreationTime: ").append(creationTime()).append(",");
        }
        if (executionStatusString() != null) {
            sb.append("ExecutionStatus: ").append(executionStatusString()).append(",");
        }
        if (statusString() != null) {
            sb.append("Status: ").append(statusString()).append(",");
        }
        if (statusReason() != null) {
            sb.append("StatusReason: ").append(statusReason()).append(",");
        }
        if (notificationARNs() != null) {
            sb.append("NotificationARNs: ").append(notificationARNs()).append(",");
        }
        if (capabilitiesStrings() != null) {
            sb.append("Capabilities: ").append(capabilitiesStrings()).append(",");
        }
        if (tags() != null) {
            sb.append("Tags: ").append(tags()).append(",");
        }
        if (changes() != null) {
            sb.append("Changes: ").append(changes()).append(",");
        }
        if (nextToken() != null) {
            sb.append("NextToken: ").append(nextToken()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ChangeSetName":
            return Optional.of(clazz.cast(changeSetName()));
        case "ChangeSetId":
            return Optional.of(clazz.cast(changeSetId()));
        case "StackId":
            return Optional.of(clazz.cast(stackId()));
        case "StackName":
            return Optional.of(clazz.cast(stackName()));
        case "Description":
            return Optional.of(clazz.cast(description()));
        case "Parameters":
            return Optional.of(clazz.cast(parameters()));
        case "CreationTime":
            return Optional.of(clazz.cast(creationTime()));
        case "ExecutionStatus":
            return Optional.of(clazz.cast(executionStatusString()));
        case "Status":
            return Optional.of(clazz.cast(statusString()));
        case "StatusReason":
            return Optional.of(clazz.cast(statusReason()));
        case "NotificationARNs":
            return Optional.of(clazz.cast(notificationARNs()));
        case "Capabilities":
            return Optional.of(clazz.cast(capabilitiesStrings()));
        case "Tags":
            return Optional.of(clazz.cast(tags()));
        case "Changes":
            return Optional.of(clazz.cast(changes()));
        case "NextToken":
            return Optional.of(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, DescribeChangeSetResponse> {
        /**
         * <p>
         * The name of the change set.
         * </p>
         * 
         * @param changeSetName
         *        The name of the change set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder changeSetName(String changeSetName);

        /**
         * <p>
         * The ARN of the change set.
         * </p>
         * 
         * @param changeSetId
         *        The ARN of the change set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder changeSetId(String changeSetId);

        /**
         * <p>
         * The ARN of the stack that is associated with the change set.
         * </p>
         * 
         * @param stackId
         *        The ARN of the stack that is associated with the change set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stackId(String stackId);

        /**
         * <p>
         * The name of the stack that is associated with the change set.
         * </p>
         * 
         * @param stackName
         *        The name of the stack that is associated with the change set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stackName(String stackName);

        /**
         * <p>
         * Information about the change set.
         * </p>
         * 
         * @param description
         *        Information about the change set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * A list of <code>Parameter</code> structures that describes the input parameters and their values used to
         * create the change set. For more information, see the <a
         * href="http://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_Parameter.html">Parameter</a> data
         * type.
         * </p>
         * 
         * @param parameters
         *        A list of <code>Parameter</code> structures that describes the input parameters and their values used
         *        to create the change set. For more information, see the <a
         *        href="http://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_Parameter.html"
         *        >Parameter</a> data type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameters(Collection<Parameter> parameters);

        /**
         * <p>
         * A list of <code>Parameter</code> structures that describes the input parameters and their values used to
         * create the change set. For more information, see the <a
         * href="http://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_Parameter.html">Parameter</a> data
         * type.
         * </p>
         * 
         * @param parameters
         *        A list of <code>Parameter</code> structures that describes the input parameters and their values used
         *        to create the change set. For more information, see the <a
         *        href="http://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_Parameter.html"
         *        >Parameter</a> data type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameters(Parameter... parameters);

        /**
         * <p>
         * The start time when the change set was created, in UTC.
         * </p>
         * 
         * @param creationTime
         *        The start time when the change set was created, in UTC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * If the change set execution status is <code>AVAILABLE</code>, you can execute the change set. If you can’t
         * execute the change set, the status indicates why. For example, a change set might be in an
         * <code>UNAVAILABLE</code> state because AWS CloudFormation is still creating it or in an <code>OBSOLETE</code>
         * state because the stack was already updated.
         * </p>
         * 
         * @param executionStatus
         *        If the change set execution status is <code>AVAILABLE</code>, you can execute the change set. If you
         *        can’t execute the change set, the status indicates why. For example, a change set might be in an
         *        <code>UNAVAILABLE</code> state because AWS CloudFormation is still creating it or in an
         *        <code>OBSOLETE</code> state because the stack was already updated.
         * @see ExecutionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExecutionStatus
         */
        Builder executionStatus(String executionStatus);

        /**
         * <p>
         * If the change set execution status is <code>AVAILABLE</code>, you can execute the change set. If you can’t
         * execute the change set, the status indicates why. For example, a change set might be in an
         * <code>UNAVAILABLE</code> state because AWS CloudFormation is still creating it or in an <code>OBSOLETE</code>
         * state because the stack was already updated.
         * </p>
         * 
         * @param executionStatus
         *        If the change set execution status is <code>AVAILABLE</code>, you can execute the change set. If you
         *        can’t execute the change set, the status indicates why. For example, a change set might be in an
         *        <code>UNAVAILABLE</code> state because AWS CloudFormation is still creating it or in an
         *        <code>OBSOLETE</code> state because the stack was already updated.
         * @see ExecutionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExecutionStatus
         */
        Builder executionStatus(ExecutionStatus executionStatus);

        /**
         * <p>
         * The current status of the change set, such as <code>CREATE_IN_PROGRESS</code>, <code>CREATE_COMPLETE</code>,
         * or <code>FAILED</code>.
         * </p>
         * 
         * @param status
         *        The current status of the change set, such as <code>CREATE_IN_PROGRESS</code>,
         *        <code>CREATE_COMPLETE</code>, or <code>FAILED</code>.
         * @see ChangeSetStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ChangeSetStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The current status of the change set, such as <code>CREATE_IN_PROGRESS</code>, <code>CREATE_COMPLETE</code>,
         * or <code>FAILED</code>.
         * </p>
         * 
         * @param status
         *        The current status of the change set, such as <code>CREATE_IN_PROGRESS</code>,
         *        <code>CREATE_COMPLETE</code>, or <code>FAILED</code>.
         * @see ChangeSetStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ChangeSetStatus
         */
        Builder status(ChangeSetStatus status);

        /**
         * <p>
         * A description of the change set's status. For example, if your attempt to create a change set failed, AWS
         * CloudFormation shows the error message.
         * </p>
         * 
         * @param statusReason
         *        A description of the change set's status. For example, if your attempt to create a change set failed,
         *        AWS CloudFormation shows the error message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusReason(String statusReason);

        /**
         * <p>
         * The ARNs of the Amazon Simple Notification Service (Amazon SNS) topics that will be associated with the stack
         * if you execute the change set.
         * </p>
         * 
         * @param notificationARNs
         *        The ARNs of the Amazon Simple Notification Service (Amazon SNS) topics that will be associated with
         *        the stack if you execute the change set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notificationARNs(Collection<String> notificationARNs);

        /**
         * <p>
         * The ARNs of the Amazon Simple Notification Service (Amazon SNS) topics that will be associated with the stack
         * if you execute the change set.
         * </p>
         * 
         * @param notificationARNs
         *        The ARNs of the Amazon Simple Notification Service (Amazon SNS) topics that will be associated with
         *        the stack if you execute the change set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notificationARNs(String... notificationARNs);

        /**
         * <p>
         * If you execute the change set, the list of capabilities that were explicitly acknowledged when the change set
         * was created.
         * </p>
         * 
         * @param capabilities
         *        If you execute the change set, the list of capabilities that were explicitly acknowledged when the
         *        change set was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capabilities(Collection<String> capabilities);

        /**
         * <p>
         * If you execute the change set, the list of capabilities that were explicitly acknowledged when the change set
         * was created.
         * </p>
         * 
         * @param capabilities
         *        If you execute the change set, the list of capabilities that were explicitly acknowledged when the
         *        change set was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capabilities(String... capabilities);

        /**
         * <p>
         * If you execute the change set, the tags that will be associated with the stack.
         * </p>
         * 
         * @param tags
         *        If you execute the change set, the tags that will be associated with the stack.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * If you execute the change set, the tags that will be associated with the stack.
         * </p>
         * 
         * @param tags
         *        If you execute the change set, the tags that will be associated with the stack.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * A list of <code>Change</code> structures that describes the resources AWS CloudFormation changes if you
         * execute the change set.
         * </p>
         * 
         * @param changes
         *        A list of <code>Change</code> structures that describes the resources AWS CloudFormation changes if
         *        you execute the change set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder changes(Collection<Change> changes);

        /**
         * <p>
         * A list of <code>Change</code> structures that describes the resources AWS CloudFormation changes if you
         * execute the change set.
         * </p>
         * 
         * @param changes
         *        A list of <code>Change</code> structures that describes the resources AWS CloudFormation changes if
         *        you execute the change set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder changes(Change... changes);

        /**
         * <p>
         * If the output exceeds 1 MB, a string that identifies the next page of changes. If there is no additional
         * page, this value is null.
         * </p>
         * 
         * @param nextToken
         *        If the output exceeds 1 MB, a string that identifies the next page of changes. If there is no
         *        additional page, this value is null.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl implements Builder {
        private String changeSetName;

        private String changeSetId;

        private String stackId;

        private String stackName;

        private String description;

        private List<Parameter> parameters;

        private Instant creationTime;

        private String executionStatus;

        private String status;

        private String statusReason;

        private List<String> notificationARNs;

        private List<String> capabilities;

        private List<Tag> tags;

        private List<Change> changes;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeChangeSetResponse model) {
            changeSetName(model.changeSetName);
            changeSetId(model.changeSetId);
            stackId(model.stackId);
            stackName(model.stackName);
            description(model.description);
            parameters(model.parameters);
            creationTime(model.creationTime);
            executionStatus(model.executionStatus);
            status(model.status);
            statusReason(model.statusReason);
            notificationARNs(model.notificationARNs);
            capabilities(model.capabilities);
            tags(model.tags);
            changes(model.changes);
            nextToken(model.nextToken);
        }

        public final String getChangeSetName() {
            return changeSetName;
        }

        @Override
        public final Builder changeSetName(String changeSetName) {
            this.changeSetName = changeSetName;
            return this;
        }

        public final void setChangeSetName(String changeSetName) {
            this.changeSetName = changeSetName;
        }

        public final String getChangeSetId() {
            return changeSetId;
        }

        @Override
        public final Builder changeSetId(String changeSetId) {
            this.changeSetId = changeSetId;
            return this;
        }

        public final void setChangeSetId(String changeSetId) {
            this.changeSetId = changeSetId;
        }

        public final String getStackId() {
            return stackId;
        }

        @Override
        public final Builder stackId(String stackId) {
            this.stackId = stackId;
            return this;
        }

        public final void setStackId(String stackId) {
            this.stackId = stackId;
        }

        public final String getStackName() {
            return stackName;
        }

        @Override
        public final Builder stackName(String stackName) {
            this.stackName = stackName;
            return this;
        }

        public final void setStackName(String stackName) {
            this.stackName = stackName;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Collection<Parameter.Builder> getParameters() {
            return parameters != null ? parameters.stream().map(Parameter::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder parameters(Collection<Parameter> parameters) {
            this.parameters = ParametersCopier.copy(parameters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameters(Parameter... parameters) {
            parameters(Arrays.asList(parameters));
            return this;
        }

        public final void setParameters(Collection<Parameter.BuilderImpl> parameters) {
            this.parameters = ParametersCopier.copyFromBuilder(parameters);
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        public final String getExecutionStatus() {
            return executionStatus;
        }

        @Override
        public final Builder executionStatus(String executionStatus) {
            this.executionStatus = executionStatus;
            return this;
        }

        @Override
        public final Builder executionStatus(ExecutionStatus executionStatus) {
            this.executionStatus(executionStatus.toString());
            return this;
        }

        public final void setExecutionStatus(String executionStatus) {
            this.executionStatus = executionStatus;
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ChangeSetStatus status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getStatusReason() {
            return statusReason;
        }

        @Override
        public final Builder statusReason(String statusReason) {
            this.statusReason = statusReason;
            return this;
        }

        public final void setStatusReason(String statusReason) {
            this.statusReason = statusReason;
        }

        public final Collection<String> getNotificationARNs() {
            return notificationARNs;
        }

        @Override
        public final Builder notificationARNs(Collection<String> notificationARNs) {
            this.notificationARNs = NotificationARNsCopier.copy(notificationARNs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder notificationARNs(String... notificationARNs) {
            notificationARNs(Arrays.asList(notificationARNs));
            return this;
        }

        public final void setNotificationARNs(Collection<String> notificationARNs) {
            this.notificationARNs = NotificationARNsCopier.copy(notificationARNs);
        }

        public final Collection<String> getCapabilities() {
            return capabilities;
        }

        @Override
        public final Builder capabilities(Collection<String> capabilities) {
            this.capabilities = CapabilitiesCopier.copy(capabilities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder capabilities(String... capabilities) {
            capabilities(Arrays.asList(capabilities));
            return this;
        }

        public final void setCapabilities(Collection<String> capabilities) {
            this.capabilities = CapabilitiesCopier.copy(capabilities);
        }

        public final Collection<Tag.Builder> getTags() {
            return tags != null ? tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagsCopier.copyFromBuilder(tags);
        }

        public final Collection<Change.Builder> getChanges() {
            return changes != null ? changes.stream().map(Change::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder changes(Collection<Change> changes) {
            this.changes = ChangesCopier.copy(changes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder changes(Change... changes) {
            changes(Arrays.asList(changes));
            return this;
        }

        public final void setChanges(Collection<Change.BuilderImpl> changes) {
            this.changes = ChangesCopier.copyFromBuilder(changes);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeChangeSetResponse build() {
            return new DescribeChangeSetResponse(this);
        }
    }
}
