/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudformation.model;

import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The input for <a>DescribeStackResources</a> action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeStackResourcesRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<DescribeStackResourcesRequest.Builder, DescribeStackResourcesRequest> {
    private final String stackName;

    private final String logicalResourceId;

    private final String physicalResourceId;

    private DescribeStackResourcesRequest(BuilderImpl builder) {
        this.stackName = builder.stackName;
        this.logicalResourceId = builder.logicalResourceId;
        this.physicalResourceId = builder.physicalResourceId;
    }

    /**
     * <p>
     * The name or the unique stack ID that is associated with the stack, which are not always interchangeable:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Running stacks: You can specify either the stack's name or its unique stack ID.
     * </p>
     * </li>
     * <li>
     * <p>
     * Deleted stacks: You must specify the unique stack ID.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Default: There is no default value.
     * </p>
     * <p>
     * Required: Conditional. If you do not specify <code>StackName</code>, you must specify
     * <code>PhysicalResourceId</code>.
     * </p>
     * 
     * @return The name or the unique stack ID that is associated with the stack, which are not always
     *         interchangeable:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Running stacks: You can specify either the stack's name or its unique stack ID.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Deleted stacks: You must specify the unique stack ID.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         Default: There is no default value.
     *         </p>
     *         <p>
     *         Required: Conditional. If you do not specify <code>StackName</code>, you must specify
     *         <code>PhysicalResourceId</code>.
     */
    public String stackName() {
        return stackName;
    }

    /**
     * <p>
     * The logical name of the resource as specified in the template.
     * </p>
     * <p>
     * Default: There is no default value.
     * </p>
     * 
     * @return The logical name of the resource as specified in the template.</p>
     *         <p>
     *         Default: There is no default value.
     */
    public String logicalResourceId() {
        return logicalResourceId;
    }

    /**
     * <p>
     * The name or unique identifier that corresponds to a physical instance ID of a resource supported by AWS
     * CloudFormation.
     * </p>
     * <p>
     * For example, for an Amazon Elastic Compute Cloud (EC2) instance, <code>PhysicalResourceId</code> corresponds to
     * the <code>InstanceId</code>. You can pass the EC2 <code>InstanceId</code> to <code>DescribeStackResources</code>
     * to find which stack the instance belongs to and what other resources are part of the stack.
     * </p>
     * <p>
     * Required: Conditional. If you do not specify <code>PhysicalResourceId</code>, you must specify
     * <code>StackName</code>.
     * </p>
     * <p>
     * Default: There is no default value.
     * </p>
     * 
     * @return The name or unique identifier that corresponds to a physical instance ID of a resource supported by AWS
     *         CloudFormation.</p>
     *         <p>
     *         For example, for an Amazon Elastic Compute Cloud (EC2) instance, <code>PhysicalResourceId</code>
     *         corresponds to the <code>InstanceId</code>. You can pass the EC2 <code>InstanceId</code> to
     *         <code>DescribeStackResources</code> to find which stack the instance belongs to and what other resources
     *         are part of the stack.
     *         </p>
     *         <p>
     *         Required: Conditional. If you do not specify <code>PhysicalResourceId</code>, you must specify
     *         <code>StackName</code>.
     *         </p>
     *         <p>
     *         Default: There is no default value.
     */
    public String physicalResourceId() {
        return physicalResourceId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((stackName() == null) ? 0 : stackName().hashCode());
        hashCode = 31 * hashCode + ((logicalResourceId() == null) ? 0 : logicalResourceId().hashCode());
        hashCode = 31 * hashCode + ((physicalResourceId() == null) ? 0 : physicalResourceId().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeStackResourcesRequest)) {
            return false;
        }
        DescribeStackResourcesRequest other = (DescribeStackResourcesRequest) obj;
        if (other.stackName() == null ^ this.stackName() == null) {
            return false;
        }
        if (other.stackName() != null && !other.stackName().equals(this.stackName())) {
            return false;
        }
        if (other.logicalResourceId() == null ^ this.logicalResourceId() == null) {
            return false;
        }
        if (other.logicalResourceId() != null && !other.logicalResourceId().equals(this.logicalResourceId())) {
            return false;
        }
        if (other.physicalResourceId() == null ^ this.physicalResourceId() == null) {
            return false;
        }
        if (other.physicalResourceId() != null && !other.physicalResourceId().equals(this.physicalResourceId())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (stackName() != null) {
            sb.append("StackName: ").append(stackName()).append(",");
        }
        if (logicalResourceId() != null) {
            sb.append("LogicalResourceId: ").append(logicalResourceId()).append(",");
        }
        if (physicalResourceId() != null) {
            sb.append("PhysicalResourceId: ").append(physicalResourceId()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StackName":
            return Optional.of(clazz.cast(stackName()));
        case "LogicalResourceId":
            return Optional.of(clazz.cast(logicalResourceId()));
        case "PhysicalResourceId":
            return Optional.of(clazz.cast(physicalResourceId()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, DescribeStackResourcesRequest> {
        /**
         * <p>
         * The name or the unique stack ID that is associated with the stack, which are not always interchangeable:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Running stacks: You can specify either the stack's name or its unique stack ID.
         * </p>
         * </li>
         * <li>
         * <p>
         * Deleted stacks: You must specify the unique stack ID.
         * </p>
         * </li>
         * </ul>
         * <p>
         * Default: There is no default value.
         * </p>
         * <p>
         * Required: Conditional. If you do not specify <code>StackName</code>, you must specify
         * <code>PhysicalResourceId</code>.
         * </p>
         * 
         * @param stackName
         *        The name or the unique stack ID that is associated with the stack, which are not always
         *        interchangeable:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        Running stacks: You can specify either the stack's name or its unique stack ID.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Deleted stacks: You must specify the unique stack ID.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        Default: There is no default value.
         *        </p>
         *        <p>
         *        Required: Conditional. If you do not specify <code>StackName</code>, you must specify
         *        <code>PhysicalResourceId</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stackName(String stackName);

        /**
         * <p>
         * The logical name of the resource as specified in the template.
         * </p>
         * <p>
         * Default: There is no default value.
         * </p>
         * 
         * @param logicalResourceId
         *        The logical name of the resource as specified in the template.</p>
         *        <p>
         *        Default: There is no default value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logicalResourceId(String logicalResourceId);

        /**
         * <p>
         * The name or unique identifier that corresponds to a physical instance ID of a resource supported by AWS
         * CloudFormation.
         * </p>
         * <p>
         * For example, for an Amazon Elastic Compute Cloud (EC2) instance, <code>PhysicalResourceId</code> corresponds
         * to the <code>InstanceId</code>. You can pass the EC2 <code>InstanceId</code> to
         * <code>DescribeStackResources</code> to find which stack the instance belongs to and what other resources are
         * part of the stack.
         * </p>
         * <p>
         * Required: Conditional. If you do not specify <code>PhysicalResourceId</code>, you must specify
         * <code>StackName</code>.
         * </p>
         * <p>
         * Default: There is no default value.
         * </p>
         * 
         * @param physicalResourceId
         *        The name or unique identifier that corresponds to a physical instance ID of a resource supported by
         *        AWS CloudFormation.</p>
         *        <p>
         *        For example, for an Amazon Elastic Compute Cloud (EC2) instance, <code>PhysicalResourceId</code>
         *        corresponds to the <code>InstanceId</code>. You can pass the EC2 <code>InstanceId</code> to
         *        <code>DescribeStackResources</code> to find which stack the instance belongs to and what other
         *        resources are part of the stack.
         *        </p>
         *        <p>
         *        Required: Conditional. If you do not specify <code>PhysicalResourceId</code>, you must specify
         *        <code>StackName</code>.
         *        </p>
         *        <p>
         *        Default: There is no default value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder physicalResourceId(String physicalResourceId);
    }

    static final class BuilderImpl implements Builder {
        private String stackName;

        private String logicalResourceId;

        private String physicalResourceId;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeStackResourcesRequest model) {
            stackName(model.stackName);
            logicalResourceId(model.logicalResourceId);
            physicalResourceId(model.physicalResourceId);
        }

        public final String getStackName() {
            return stackName;
        }

        @Override
        public final Builder stackName(String stackName) {
            this.stackName = stackName;
            return this;
        }

        public final void setStackName(String stackName) {
            this.stackName = stackName;
        }

        public final String getLogicalResourceId() {
            return logicalResourceId;
        }

        @Override
        public final Builder logicalResourceId(String logicalResourceId) {
            this.logicalResourceId = logicalResourceId;
            return this;
        }

        public final void setLogicalResourceId(String logicalResourceId) {
            this.logicalResourceId = logicalResourceId;
        }

        public final String getPhysicalResourceId() {
            return physicalResourceId;
        }

        @Override
        public final Builder physicalResourceId(String physicalResourceId) {
            this.physicalResourceId = physicalResourceId;
            return this;
        }

        public final void setPhysicalResourceId(String physicalResourceId) {
            this.physicalResourceId = physicalResourceId;
        }

        @Override
        public DescribeStackResourcesRequest build() {
            return new DescribeStackResourcesRequest(this);
        }
    }
}
