/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudformation.model;

import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The input for the <a>ExecuteChangeSet</a> action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ExecuteChangeSetRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<ExecuteChangeSetRequest.Builder, ExecuteChangeSetRequest> {
    private final String changeSetName;

    private final String stackName;

    private final String clientRequestToken;

    private ExecuteChangeSetRequest(BuilderImpl builder) {
        this.changeSetName = builder.changeSetName;
        this.stackName = builder.stackName;
        this.clientRequestToken = builder.clientRequestToken;
    }

    /**
     * <p>
     * The name or ARN of the change set that you want use to update the specified stack.
     * </p>
     * 
     * @return The name or ARN of the change set that you want use to update the specified stack.
     */
    public String changeSetName() {
        return changeSetName;
    }

    /**
     * <p>
     * If you specified the name of a change set, specify the stack name or ID (ARN) that is associated with the change
     * set you want to execute.
     * </p>
     * 
     * @return If you specified the name of a change set, specify the stack name or ID (ARN) that is associated with the
     *         change set you want to execute.
     */
    public String stackName() {
        return stackName;
    }

    /**
     * <p>
     * A unique identifier for this <code>ExecuteChangeSet</code> request. Specify this token if you plan to retry
     * requests so that AWS CloudFormation knows that you're not attempting to execute a change set to update a stack
     * with the same name. You might retry <code>ExecuteChangeSet</code> requests to ensure that AWS CloudFormation
     * successfully received them.
     * </p>
     * 
     * @return A unique identifier for this <code>ExecuteChangeSet</code> request. Specify this token if you plan to
     *         retry requests so that AWS CloudFormation knows that you're not attempting to execute a change set to
     *         update a stack with the same name. You might retry <code>ExecuteChangeSet</code> requests to ensure that
     *         AWS CloudFormation successfully received them.
     */
    public String clientRequestToken() {
        return clientRequestToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((changeSetName() == null) ? 0 : changeSetName().hashCode());
        hashCode = 31 * hashCode + ((stackName() == null) ? 0 : stackName().hashCode());
        hashCode = 31 * hashCode + ((clientRequestToken() == null) ? 0 : clientRequestToken().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExecuteChangeSetRequest)) {
            return false;
        }
        ExecuteChangeSetRequest other = (ExecuteChangeSetRequest) obj;
        if (other.changeSetName() == null ^ this.changeSetName() == null) {
            return false;
        }
        if (other.changeSetName() != null && !other.changeSetName().equals(this.changeSetName())) {
            return false;
        }
        if (other.stackName() == null ^ this.stackName() == null) {
            return false;
        }
        if (other.stackName() != null && !other.stackName().equals(this.stackName())) {
            return false;
        }
        if (other.clientRequestToken() == null ^ this.clientRequestToken() == null) {
            return false;
        }
        if (other.clientRequestToken() != null && !other.clientRequestToken().equals(this.clientRequestToken())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (changeSetName() != null) {
            sb.append("ChangeSetName: ").append(changeSetName()).append(",");
        }
        if (stackName() != null) {
            sb.append("StackName: ").append(stackName()).append(",");
        }
        if (clientRequestToken() != null) {
            sb.append("ClientRequestToken: ").append(clientRequestToken()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ChangeSetName":
            return Optional.of(clazz.cast(changeSetName()));
        case "StackName":
            return Optional.of(clazz.cast(stackName()));
        case "ClientRequestToken":
            return Optional.of(clazz.cast(clientRequestToken()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, ExecuteChangeSetRequest> {
        /**
         * <p>
         * The name or ARN of the change set that you want use to update the specified stack.
         * </p>
         * 
         * @param changeSetName
         *        The name or ARN of the change set that you want use to update the specified stack.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder changeSetName(String changeSetName);

        /**
         * <p>
         * If you specified the name of a change set, specify the stack name or ID (ARN) that is associated with the
         * change set you want to execute.
         * </p>
         * 
         * @param stackName
         *        If you specified the name of a change set, specify the stack name or ID (ARN) that is associated with
         *        the change set you want to execute.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stackName(String stackName);

        /**
         * <p>
         * A unique identifier for this <code>ExecuteChangeSet</code> request. Specify this token if you plan to retry
         * requests so that AWS CloudFormation knows that you're not attempting to execute a change set to update a
         * stack with the same name. You might retry <code>ExecuteChangeSet</code> requests to ensure that AWS
         * CloudFormation successfully received them.
         * </p>
         * 
         * @param clientRequestToken
         *        A unique identifier for this <code>ExecuteChangeSet</code> request. Specify this token if you plan to
         *        retry requests so that AWS CloudFormation knows that you're not attempting to execute a change set to
         *        update a stack with the same name. You might retry <code>ExecuteChangeSet</code> requests to ensure
         *        that AWS CloudFormation successfully received them.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientRequestToken(String clientRequestToken);
    }

    static final class BuilderImpl implements Builder {
        private String changeSetName;

        private String stackName;

        private String clientRequestToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ExecuteChangeSetRequest model) {
            changeSetName(model.changeSetName);
            stackName(model.stackName);
            clientRequestToken(model.clientRequestToken);
        }

        public final String getChangeSetName() {
            return changeSetName;
        }

        @Override
        public final Builder changeSetName(String changeSetName) {
            this.changeSetName = changeSetName;
            return this;
        }

        public final void setChangeSetName(String changeSetName) {
            this.changeSetName = changeSetName;
        }

        public final String getStackName() {
            return stackName;
        }

        @Override
        public final Builder stackName(String stackName) {
            this.stackName = stackName;
            return this;
        }

        public final void setStackName(String stackName) {
            this.stackName = stackName;
        }

        public final String getClientRequestToken() {
            return clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        @Override
        public ExecuteChangeSetRequest build() {
            return new ExecuteChangeSetRequest(this);
        }
    }
}
