/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudformation.model;

import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The input for the <a>GetStackPolicy</a> action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class GetStackPolicyRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<GetStackPolicyRequest.Builder, GetStackPolicyRequest> {
    private final String stackName;

    private GetStackPolicyRequest(BuilderImpl builder) {
        this.stackName = builder.stackName;
    }

    /**
     * <p>
     * The name or unique stack ID that is associated with the stack whose policy you want to get.
     * </p>
     * 
     * @return The name or unique stack ID that is associated with the stack whose policy you want to get.
     */
    public String stackName() {
        return stackName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((stackName() == null) ? 0 : stackName().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetStackPolicyRequest)) {
            return false;
        }
        GetStackPolicyRequest other = (GetStackPolicyRequest) obj;
        if (other.stackName() == null ^ this.stackName() == null) {
            return false;
        }
        if (other.stackName() != null && !other.stackName().equals(this.stackName())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (stackName() != null) {
            sb.append("StackName: ").append(stackName()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StackName":
            return Optional.of(clazz.cast(stackName()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, GetStackPolicyRequest> {
        /**
         * <p>
         * The name or unique stack ID that is associated with the stack whose policy you want to get.
         * </p>
         * 
         * @param stackName
         *        The name or unique stack ID that is associated with the stack whose policy you want to get.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stackName(String stackName);
    }

    static final class BuilderImpl implements Builder {
        private String stackName;

        private BuilderImpl() {
        }

        private BuilderImpl(GetStackPolicyRequest model) {
            stackName(model.stackName);
        }

        public final String getStackName() {
            return stackName;
        }

        @Override
        public final Builder stackName(String stackName) {
            this.stackName = stackName;
            return this;
        }

        public final void setStackName(String stackName) {
            this.stackName = stackName;
        }

        @Override
        public GetStackPolicyRequest build() {
            return new GetStackPolicyRequest(this);
        }
    }
}
