/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudformation.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.core.runtime.TypeConverter;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The output for the <a>GetTemplateSummary</a> action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class GetTemplateSummaryResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<GetTemplateSummaryResponse.Builder, GetTemplateSummaryResponse> {
    private final List<ParameterDeclaration> parameters;

    private final String description;

    private final List<String> capabilities;

    private final String capabilitiesReason;

    private final List<String> resourceTypes;

    private final String version;

    private final String metadata;

    private final List<String> declaredTransforms;

    private GetTemplateSummaryResponse(BuilderImpl builder) {
        this.parameters = builder.parameters;
        this.description = builder.description;
        this.capabilities = builder.capabilities;
        this.capabilitiesReason = builder.capabilitiesReason;
        this.resourceTypes = builder.resourceTypes;
        this.version = builder.version;
        this.metadata = builder.metadata;
        this.declaredTransforms = builder.declaredTransforms;
    }

    /**
     * <p>
     * A list of parameter declarations that describe various properties for each parameter.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A list of parameter declarations that describe various properties for each parameter.
     */
    public List<ParameterDeclaration> parameters() {
        return parameters;
    }

    /**
     * <p>
     * The value that is defined in the <code>Description</code> property of the template.
     * </p>
     * 
     * @return The value that is defined in the <code>Description</code> property of the template.
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * The capabilities found within the template. If your template contains IAM resources, you must specify the
     * CAPABILITY_IAM or CAPABILITY_NAMED_IAM value for this parameter when you use the <a>CreateStack</a> or
     * <a>UpdateStack</a> actions with your template; otherwise, those actions return an InsufficientCapabilities error.
     * </p>
     * <p>
     * For more information, see <a
     * href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html#capabilities"
     * >Acknowledging IAM Resources in AWS CloudFormation Templates</a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The capabilities found within the template. If your template contains IAM resources, you must specify the
     *         CAPABILITY_IAM or CAPABILITY_NAMED_IAM value for this parameter when you use the <a>CreateStack</a> or
     *         <a>UpdateStack</a> actions with your template; otherwise, those actions return an
     *         InsufficientCapabilities error.</p>
     *         <p>
     *         For more information, see <a href=
     *         "http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html#capabilities"
     *         >Acknowledging IAM Resources in AWS CloudFormation Templates</a>.
     */
    public List<Capability> capabilities() {
        return TypeConverter.convert(capabilities, Capability::fromValue);
    }

    /**
     * <p>
     * The capabilities found within the template. If your template contains IAM resources, you must specify the
     * CAPABILITY_IAM or CAPABILITY_NAMED_IAM value for this parameter when you use the <a>CreateStack</a> or
     * <a>UpdateStack</a> actions with your template; otherwise, those actions return an InsufficientCapabilities error.
     * </p>
     * <p>
     * For more information, see <a
     * href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html#capabilities"
     * >Acknowledging IAM Resources in AWS CloudFormation Templates</a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The capabilities found within the template. If your template contains IAM resources, you must specify the
     *         CAPABILITY_IAM or CAPABILITY_NAMED_IAM value for this parameter when you use the <a>CreateStack</a> or
     *         <a>UpdateStack</a> actions with your template; otherwise, those actions return an
     *         InsufficientCapabilities error.</p>
     *         <p>
     *         For more information, see <a href=
     *         "http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html#capabilities"
     *         >Acknowledging IAM Resources in AWS CloudFormation Templates</a>.
     */
    public List<String> capabilitiesStrings() {
        return capabilities;
    }

    /**
     * <p>
     * The list of resources that generated the values in the <code>Capabilities</code> response element.
     * </p>
     * 
     * @return The list of resources that generated the values in the <code>Capabilities</code> response element.
     */
    public String capabilitiesReason() {
        return capabilitiesReason;
    }

    /**
     * <p>
     * A list of all the template resource types that are defined in the template, such as
     * <code>AWS::EC2::Instance</code>, <code>AWS::Dynamo::Table</code>, and <code>Custom::MyCustomInstance</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A list of all the template resource types that are defined in the template, such as
     *         <code>AWS::EC2::Instance</code>, <code>AWS::Dynamo::Table</code>, and
     *         <code>Custom::MyCustomInstance</code>.
     */
    public List<String> resourceTypes() {
        return resourceTypes;
    }

    /**
     * <p>
     * The AWS template format version, which identifies the capabilities of the template.
     * </p>
     * 
     * @return The AWS template format version, which identifies the capabilities of the template.
     */
    public String version() {
        return version;
    }

    /**
     * <p>
     * The value that is defined for the <code>Metadata</code> property of the template.
     * </p>
     * 
     * @return The value that is defined for the <code>Metadata</code> property of the template.
     */
    public String metadata() {
        return metadata;
    }

    /**
     * <p>
     * A list of the transforms that are declared in the template.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A list of the transforms that are declared in the template.
     */
    public List<String> declaredTransforms() {
        return declaredTransforms;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((parameters() == null) ? 0 : parameters().hashCode());
        hashCode = 31 * hashCode + ((description() == null) ? 0 : description().hashCode());
        hashCode = 31 * hashCode + ((capabilitiesStrings() == null) ? 0 : capabilitiesStrings().hashCode());
        hashCode = 31 * hashCode + ((capabilitiesReason() == null) ? 0 : capabilitiesReason().hashCode());
        hashCode = 31 * hashCode + ((resourceTypes() == null) ? 0 : resourceTypes().hashCode());
        hashCode = 31 * hashCode + ((version() == null) ? 0 : version().hashCode());
        hashCode = 31 * hashCode + ((metadata() == null) ? 0 : metadata().hashCode());
        hashCode = 31 * hashCode + ((declaredTransforms() == null) ? 0 : declaredTransforms().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetTemplateSummaryResponse)) {
            return false;
        }
        GetTemplateSummaryResponse other = (GetTemplateSummaryResponse) obj;
        if (other.parameters() == null ^ this.parameters() == null) {
            return false;
        }
        if (other.parameters() != null && !other.parameters().equals(this.parameters())) {
            return false;
        }
        if (other.description() == null ^ this.description() == null) {
            return false;
        }
        if (other.description() != null && !other.description().equals(this.description())) {
            return false;
        }
        if (other.capabilitiesStrings() == null ^ this.capabilitiesStrings() == null) {
            return false;
        }
        if (other.capabilitiesStrings() != null && !other.capabilitiesStrings().equals(this.capabilitiesStrings())) {
            return false;
        }
        if (other.capabilitiesReason() == null ^ this.capabilitiesReason() == null) {
            return false;
        }
        if (other.capabilitiesReason() != null && !other.capabilitiesReason().equals(this.capabilitiesReason())) {
            return false;
        }
        if (other.resourceTypes() == null ^ this.resourceTypes() == null) {
            return false;
        }
        if (other.resourceTypes() != null && !other.resourceTypes().equals(this.resourceTypes())) {
            return false;
        }
        if (other.version() == null ^ this.version() == null) {
            return false;
        }
        if (other.version() != null && !other.version().equals(this.version())) {
            return false;
        }
        if (other.metadata() == null ^ this.metadata() == null) {
            return false;
        }
        if (other.metadata() != null && !other.metadata().equals(this.metadata())) {
            return false;
        }
        if (other.declaredTransforms() == null ^ this.declaredTransforms() == null) {
            return false;
        }
        if (other.declaredTransforms() != null && !other.declaredTransforms().equals(this.declaredTransforms())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (parameters() != null) {
            sb.append("Parameters: ").append(parameters()).append(",");
        }
        if (description() != null) {
            sb.append("Description: ").append(description()).append(",");
        }
        if (capabilitiesStrings() != null) {
            sb.append("Capabilities: ").append(capabilitiesStrings()).append(",");
        }
        if (capabilitiesReason() != null) {
            sb.append("CapabilitiesReason: ").append(capabilitiesReason()).append(",");
        }
        if (resourceTypes() != null) {
            sb.append("ResourceTypes: ").append(resourceTypes()).append(",");
        }
        if (version() != null) {
            sb.append("Version: ").append(version()).append(",");
        }
        if (metadata() != null) {
            sb.append("Metadata: ").append(metadata()).append(",");
        }
        if (declaredTransforms() != null) {
            sb.append("DeclaredTransforms: ").append(declaredTransforms()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Parameters":
            return Optional.of(clazz.cast(parameters()));
        case "Description":
            return Optional.of(clazz.cast(description()));
        case "Capabilities":
            return Optional.of(clazz.cast(capabilitiesStrings()));
        case "CapabilitiesReason":
            return Optional.of(clazz.cast(capabilitiesReason()));
        case "ResourceTypes":
            return Optional.of(clazz.cast(resourceTypes()));
        case "Version":
            return Optional.of(clazz.cast(version()));
        case "Metadata":
            return Optional.of(clazz.cast(metadata()));
        case "DeclaredTransforms":
            return Optional.of(clazz.cast(declaredTransforms()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, GetTemplateSummaryResponse> {
        /**
         * <p>
         * A list of parameter declarations that describe various properties for each parameter.
         * </p>
         * 
         * @param parameters
         *        A list of parameter declarations that describe various properties for each parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameters(Collection<ParameterDeclaration> parameters);

        /**
         * <p>
         * A list of parameter declarations that describe various properties for each parameter.
         * </p>
         * 
         * @param parameters
         *        A list of parameter declarations that describe various properties for each parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameters(ParameterDeclaration... parameters);

        /**
         * <p>
         * The value that is defined in the <code>Description</code> property of the template.
         * </p>
         * 
         * @param description
         *        The value that is defined in the <code>Description</code> property of the template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The capabilities found within the template. If your template contains IAM resources, you must specify the
         * CAPABILITY_IAM or CAPABILITY_NAMED_IAM value for this parameter when you use the <a>CreateStack</a> or
         * <a>UpdateStack</a> actions with your template; otherwise, those actions return an InsufficientCapabilities
         * error.
         * </p>
         * <p>
         * For more information, see <a
         * href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html#capabilities"
         * >Acknowledging IAM Resources in AWS CloudFormation Templates</a>.
         * </p>
         * 
         * @param capabilities
         *        The capabilities found within the template. If your template contains IAM resources, you must specify
         *        the CAPABILITY_IAM or CAPABILITY_NAMED_IAM value for this parameter when you use the
         *        <a>CreateStack</a> or <a>UpdateStack</a> actions with your template; otherwise, those actions return
         *        an InsufficientCapabilities error.</p>
         *        <p>
         *        For more information, see <a href=
         *        "http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html#capabilities"
         *        >Acknowledging IAM Resources in AWS CloudFormation Templates</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capabilities(Collection<String> capabilities);

        /**
         * <p>
         * The capabilities found within the template. If your template contains IAM resources, you must specify the
         * CAPABILITY_IAM or CAPABILITY_NAMED_IAM value for this parameter when you use the <a>CreateStack</a> or
         * <a>UpdateStack</a> actions with your template; otherwise, those actions return an InsufficientCapabilities
         * error.
         * </p>
         * <p>
         * For more information, see <a
         * href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html#capabilities"
         * >Acknowledging IAM Resources in AWS CloudFormation Templates</a>.
         * </p>
         * 
         * @param capabilities
         *        The capabilities found within the template. If your template contains IAM resources, you must specify
         *        the CAPABILITY_IAM or CAPABILITY_NAMED_IAM value for this parameter when you use the
         *        <a>CreateStack</a> or <a>UpdateStack</a> actions with your template; otherwise, those actions return
         *        an InsufficientCapabilities error.</p>
         *        <p>
         *        For more information, see <a href=
         *        "http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html#capabilities"
         *        >Acknowledging IAM Resources in AWS CloudFormation Templates</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capabilities(String... capabilities);

        /**
         * <p>
         * The list of resources that generated the values in the <code>Capabilities</code> response element.
         * </p>
         * 
         * @param capabilitiesReason
         *        The list of resources that generated the values in the <code>Capabilities</code> response element.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capabilitiesReason(String capabilitiesReason);

        /**
         * <p>
         * A list of all the template resource types that are defined in the template, such as
         * <code>AWS::EC2::Instance</code>, <code>AWS::Dynamo::Table</code>, and <code>Custom::MyCustomInstance</code>.
         * </p>
         * 
         * @param resourceTypes
         *        A list of all the template resource types that are defined in the template, such as
         *        <code>AWS::EC2::Instance</code>, <code>AWS::Dynamo::Table</code>, and
         *        <code>Custom::MyCustomInstance</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceTypes(Collection<String> resourceTypes);

        /**
         * <p>
         * A list of all the template resource types that are defined in the template, such as
         * <code>AWS::EC2::Instance</code>, <code>AWS::Dynamo::Table</code>, and <code>Custom::MyCustomInstance</code>.
         * </p>
         * 
         * @param resourceTypes
         *        A list of all the template resource types that are defined in the template, such as
         *        <code>AWS::EC2::Instance</code>, <code>AWS::Dynamo::Table</code>, and
         *        <code>Custom::MyCustomInstance</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceTypes(String... resourceTypes);

        /**
         * <p>
         * The AWS template format version, which identifies the capabilities of the template.
         * </p>
         * 
         * @param version
         *        The AWS template format version, which identifies the capabilities of the template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder version(String version);

        /**
         * <p>
         * The value that is defined for the <code>Metadata</code> property of the template.
         * </p>
         * 
         * @param metadata
         *        The value that is defined for the <code>Metadata</code> property of the template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metadata(String metadata);

        /**
         * <p>
         * A list of the transforms that are declared in the template.
         * </p>
         * 
         * @param declaredTransforms
         *        A list of the transforms that are declared in the template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder declaredTransforms(Collection<String> declaredTransforms);

        /**
         * <p>
         * A list of the transforms that are declared in the template.
         * </p>
         * 
         * @param declaredTransforms
         *        A list of the transforms that are declared in the template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder declaredTransforms(String... declaredTransforms);
    }

    static final class BuilderImpl implements Builder {
        private List<ParameterDeclaration> parameters;

        private String description;

        private List<String> capabilities;

        private String capabilitiesReason;

        private List<String> resourceTypes;

        private String version;

        private String metadata;

        private List<String> declaredTransforms;

        private BuilderImpl() {
        }

        private BuilderImpl(GetTemplateSummaryResponse model) {
            parameters(model.parameters);
            description(model.description);
            capabilities(model.capabilities);
            capabilitiesReason(model.capabilitiesReason);
            resourceTypes(model.resourceTypes);
            version(model.version);
            metadata(model.metadata);
            declaredTransforms(model.declaredTransforms);
        }

        public final Collection<ParameterDeclaration.Builder> getParameters() {
            return parameters != null ? parameters.stream().map(ParameterDeclaration::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder parameters(Collection<ParameterDeclaration> parameters) {
            this.parameters = ParameterDeclarationsCopier.copy(parameters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameters(ParameterDeclaration... parameters) {
            parameters(Arrays.asList(parameters));
            return this;
        }

        public final void setParameters(Collection<ParameterDeclaration.BuilderImpl> parameters) {
            this.parameters = ParameterDeclarationsCopier.copyFromBuilder(parameters);
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Collection<String> getCapabilities() {
            return capabilities;
        }

        @Override
        public final Builder capabilities(Collection<String> capabilities) {
            this.capabilities = CapabilitiesCopier.copy(capabilities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder capabilities(String... capabilities) {
            capabilities(Arrays.asList(capabilities));
            return this;
        }

        public final void setCapabilities(Collection<String> capabilities) {
            this.capabilities = CapabilitiesCopier.copy(capabilities);
        }

        public final String getCapabilitiesReason() {
            return capabilitiesReason;
        }

        @Override
        public final Builder capabilitiesReason(String capabilitiesReason) {
            this.capabilitiesReason = capabilitiesReason;
            return this;
        }

        public final void setCapabilitiesReason(String capabilitiesReason) {
            this.capabilitiesReason = capabilitiesReason;
        }

        public final Collection<String> getResourceTypes() {
            return resourceTypes;
        }

        @Override
        public final Builder resourceTypes(Collection<String> resourceTypes) {
            this.resourceTypes = ResourceTypesCopier.copy(resourceTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceTypes(String... resourceTypes) {
            resourceTypes(Arrays.asList(resourceTypes));
            return this;
        }

        public final void setResourceTypes(Collection<String> resourceTypes) {
            this.resourceTypes = ResourceTypesCopier.copy(resourceTypes);
        }

        public final String getVersion() {
            return version;
        }

        @Override
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        public final String getMetadata() {
            return metadata;
        }

        @Override
        public final Builder metadata(String metadata) {
            this.metadata = metadata;
            return this;
        }

        public final void setMetadata(String metadata) {
            this.metadata = metadata;
        }

        public final Collection<String> getDeclaredTransforms() {
            return declaredTransforms;
        }

        @Override
        public final Builder declaredTransforms(Collection<String> declaredTransforms) {
            this.declaredTransforms = TransformsListCopier.copy(declaredTransforms);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder declaredTransforms(String... declaredTransforms) {
            declaredTransforms(Arrays.asList(declaredTransforms));
            return this;
        }

        public final void setDeclaredTransforms(Collection<String> declaredTransforms) {
            this.declaredTransforms = TransformsListCopier.copy(declaredTransforms);
        }

        @Override
        public GetTemplateSummaryResponse build() {
            return new GetTemplateSummaryResponse(this);
        }
    }
}
