/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudformation.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The output for <a>ListStacks</a> action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ListStacksResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<ListStacksResponse.Builder, ListStacksResponse> {
    private final List<StackSummary> stackSummaries;

    private final String nextToken;

    private ListStacksResponse(BuilderImpl builder) {
        this.stackSummaries = builder.stackSummaries;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * A list of <code>StackSummary</code> structures containing information about the specified stacks.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A list of <code>StackSummary</code> structures containing information about the specified stacks.
     */
    public List<StackSummary> stackSummaries() {
        return stackSummaries;
    }

    /**
     * <p>
     * If the output exceeds 1 MB in size, a string that identifies the next page of stacks. If no additional page
     * exists, this value is null.
     * </p>
     * 
     * @return If the output exceeds 1 MB in size, a string that identifies the next page of stacks. If no additional
     *         page exists, this value is null.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((stackSummaries() == null) ? 0 : stackSummaries().hashCode());
        hashCode = 31 * hashCode + ((nextToken() == null) ? 0 : nextToken().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListStacksResponse)) {
            return false;
        }
        ListStacksResponse other = (ListStacksResponse) obj;
        if (other.stackSummaries() == null ^ this.stackSummaries() == null) {
            return false;
        }
        if (other.stackSummaries() != null && !other.stackSummaries().equals(this.stackSummaries())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        if (other.nextToken() != null && !other.nextToken().equals(this.nextToken())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (stackSummaries() != null) {
            sb.append("StackSummaries: ").append(stackSummaries()).append(",");
        }
        if (nextToken() != null) {
            sb.append("NextToken: ").append(nextToken()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StackSummaries":
            return Optional.of(clazz.cast(stackSummaries()));
        case "NextToken":
            return Optional.of(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, ListStacksResponse> {
        /**
         * <p>
         * A list of <code>StackSummary</code> structures containing information about the specified stacks.
         * </p>
         * 
         * @param stackSummaries
         *        A list of <code>StackSummary</code> structures containing information about the specified stacks.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stackSummaries(Collection<StackSummary> stackSummaries);

        /**
         * <p>
         * A list of <code>StackSummary</code> structures containing information about the specified stacks.
         * </p>
         * 
         * @param stackSummaries
         *        A list of <code>StackSummary</code> structures containing information about the specified stacks.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stackSummaries(StackSummary... stackSummaries);

        /**
         * <p>
         * If the output exceeds 1 MB in size, a string that identifies the next page of stacks. If no additional page
         * exists, this value is null.
         * </p>
         * 
         * @param nextToken
         *        If the output exceeds 1 MB in size, a string that identifies the next page of stacks. If no additional
         *        page exists, this value is null.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl implements Builder {
        private List<StackSummary> stackSummaries;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListStacksResponse model) {
            stackSummaries(model.stackSummaries);
            nextToken(model.nextToken);
        }

        public final Collection<StackSummary.Builder> getStackSummaries() {
            return stackSummaries != null ? stackSummaries.stream().map(StackSummary::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder stackSummaries(Collection<StackSummary> stackSummaries) {
            this.stackSummaries = StackSummariesCopier.copy(stackSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stackSummaries(StackSummary... stackSummaries) {
            stackSummaries(Arrays.asList(stackSummaries));
            return this;
        }

        public final void setStackSummaries(Collection<StackSummary.BuilderImpl> stackSummaries) {
            this.stackSummaries = StackSummariesCopier.copyFromBuilder(stackSummaries);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListStacksResponse build() {
            return new ListStacksResponse(this);
        }
    }
}
