/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudformation.model;

import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The Output data type.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class Output implements ToCopyableBuilder<Output.Builder, Output> {
    private final String outputKey;

    private final String outputValue;

    private final String description;

    private Output(BuilderImpl builder) {
        this.outputKey = builder.outputKey;
        this.outputValue = builder.outputValue;
        this.description = builder.description;
    }

    /**
     * <p>
     * The key associated with the output.
     * </p>
     * 
     * @return The key associated with the output.
     */
    public String outputKey() {
        return outputKey;
    }

    /**
     * <p>
     * The value associated with the output.
     * </p>
     * 
     * @return The value associated with the output.
     */
    public String outputValue() {
        return outputValue;
    }

    /**
     * <p>
     * User defined description associated with the output.
     * </p>
     * 
     * @return User defined description associated with the output.
     */
    public String description() {
        return description;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((outputKey() == null) ? 0 : outputKey().hashCode());
        hashCode = 31 * hashCode + ((outputValue() == null) ? 0 : outputValue().hashCode());
        hashCode = 31 * hashCode + ((description() == null) ? 0 : description().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Output)) {
            return false;
        }
        Output other = (Output) obj;
        if (other.outputKey() == null ^ this.outputKey() == null) {
            return false;
        }
        if (other.outputKey() != null && !other.outputKey().equals(this.outputKey())) {
            return false;
        }
        if (other.outputValue() == null ^ this.outputValue() == null) {
            return false;
        }
        if (other.outputValue() != null && !other.outputValue().equals(this.outputValue())) {
            return false;
        }
        if (other.description() == null ^ this.description() == null) {
            return false;
        }
        if (other.description() != null && !other.description().equals(this.description())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (outputKey() != null) {
            sb.append("OutputKey: ").append(outputKey()).append(",");
        }
        if (outputValue() != null) {
            sb.append("OutputValue: ").append(outputValue()).append(",");
        }
        if (description() != null) {
            sb.append("Description: ").append(description()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "OutputKey":
            return Optional.of(clazz.cast(outputKey()));
        case "OutputValue":
            return Optional.of(clazz.cast(outputValue()));
        case "Description":
            return Optional.of(clazz.cast(description()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, Output> {
        /**
         * <p>
         * The key associated with the output.
         * </p>
         * 
         * @param outputKey
         *        The key associated with the output.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputKey(String outputKey);

        /**
         * <p>
         * The value associated with the output.
         * </p>
         * 
         * @param outputValue
         *        The value associated with the output.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputValue(String outputValue);

        /**
         * <p>
         * User defined description associated with the output.
         * </p>
         * 
         * @param description
         *        User defined description associated with the output.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);
    }

    static final class BuilderImpl implements Builder {
        private String outputKey;

        private String outputValue;

        private String description;

        private BuilderImpl() {
        }

        private BuilderImpl(Output model) {
            outputKey(model.outputKey);
            outputValue(model.outputValue);
            description(model.description);
        }

        public final String getOutputKey() {
            return outputKey;
        }

        @Override
        public final Builder outputKey(String outputKey) {
            this.outputKey = outputKey;
            return this;
        }

        public final void setOutputKey(String outputKey) {
            this.outputKey = outputKey;
        }

        public final String getOutputValue() {
            return outputValue;
        }

        @Override
        public final Builder outputValue(String outputValue) {
            this.outputValue = outputValue;
            return this;
        }

        public final void setOutputValue(String outputValue) {
            this.outputValue = outputValue;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public Output build() {
            return new Output(this);
        }
    }
}
