/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudformation.model;

import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The ParameterDeclaration data type.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ParameterDeclaration implements ToCopyableBuilder<ParameterDeclaration.Builder, ParameterDeclaration> {
    private final String parameterKey;

    private final String defaultValue;

    private final String parameterType;

    private final Boolean noEcho;

    private final String description;

    private final ParameterConstraints parameterConstraints;

    private ParameterDeclaration(BuilderImpl builder) {
        this.parameterKey = builder.parameterKey;
        this.defaultValue = builder.defaultValue;
        this.parameterType = builder.parameterType;
        this.noEcho = builder.noEcho;
        this.description = builder.description;
        this.parameterConstraints = builder.parameterConstraints;
    }

    /**
     * <p>
     * The name that is associated with the parameter.
     * </p>
     * 
     * @return The name that is associated with the parameter.
     */
    public String parameterKey() {
        return parameterKey;
    }

    /**
     * <p>
     * The default value of the parameter.
     * </p>
     * 
     * @return The default value of the parameter.
     */
    public String defaultValue() {
        return defaultValue;
    }

    /**
     * <p>
     * The type of parameter.
     * </p>
     * 
     * @return The type of parameter.
     */
    public String parameterType() {
        return parameterType;
    }

    /**
     * <p>
     * Flag that indicates whether the parameter value is shown as plain text in logs and in the AWS Management Console.
     * </p>
     * 
     * @return Flag that indicates whether the parameter value is shown as plain text in logs and in the AWS Management
     *         Console.
     */
    public Boolean noEcho() {
        return noEcho;
    }

    /**
     * <p>
     * The description that is associate with the parameter.
     * </p>
     * 
     * @return The description that is associate with the parameter.
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * The criteria that AWS CloudFormation uses to validate parameter values.
     * </p>
     * 
     * @return The criteria that AWS CloudFormation uses to validate parameter values.
     */
    public ParameterConstraints parameterConstraints() {
        return parameterConstraints;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((parameterKey() == null) ? 0 : parameterKey().hashCode());
        hashCode = 31 * hashCode + ((defaultValue() == null) ? 0 : defaultValue().hashCode());
        hashCode = 31 * hashCode + ((parameterType() == null) ? 0 : parameterType().hashCode());
        hashCode = 31 * hashCode + ((noEcho() == null) ? 0 : noEcho().hashCode());
        hashCode = 31 * hashCode + ((description() == null) ? 0 : description().hashCode());
        hashCode = 31 * hashCode + ((parameterConstraints() == null) ? 0 : parameterConstraints().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ParameterDeclaration)) {
            return false;
        }
        ParameterDeclaration other = (ParameterDeclaration) obj;
        if (other.parameterKey() == null ^ this.parameterKey() == null) {
            return false;
        }
        if (other.parameterKey() != null && !other.parameterKey().equals(this.parameterKey())) {
            return false;
        }
        if (other.defaultValue() == null ^ this.defaultValue() == null) {
            return false;
        }
        if (other.defaultValue() != null && !other.defaultValue().equals(this.defaultValue())) {
            return false;
        }
        if (other.parameterType() == null ^ this.parameterType() == null) {
            return false;
        }
        if (other.parameterType() != null && !other.parameterType().equals(this.parameterType())) {
            return false;
        }
        if (other.noEcho() == null ^ this.noEcho() == null) {
            return false;
        }
        if (other.noEcho() != null && !other.noEcho().equals(this.noEcho())) {
            return false;
        }
        if (other.description() == null ^ this.description() == null) {
            return false;
        }
        if (other.description() != null && !other.description().equals(this.description())) {
            return false;
        }
        if (other.parameterConstraints() == null ^ this.parameterConstraints() == null) {
            return false;
        }
        if (other.parameterConstraints() != null && !other.parameterConstraints().equals(this.parameterConstraints())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (parameterKey() != null) {
            sb.append("ParameterKey: ").append(parameterKey()).append(",");
        }
        if (defaultValue() != null) {
            sb.append("DefaultValue: ").append(defaultValue()).append(",");
        }
        if (parameterType() != null) {
            sb.append("ParameterType: ").append(parameterType()).append(",");
        }
        if (noEcho() != null) {
            sb.append("NoEcho: ").append(noEcho()).append(",");
        }
        if (description() != null) {
            sb.append("Description: ").append(description()).append(",");
        }
        if (parameterConstraints() != null) {
            sb.append("ParameterConstraints: ").append(parameterConstraints()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ParameterKey":
            return Optional.of(clazz.cast(parameterKey()));
        case "DefaultValue":
            return Optional.of(clazz.cast(defaultValue()));
        case "ParameterType":
            return Optional.of(clazz.cast(parameterType()));
        case "NoEcho":
            return Optional.of(clazz.cast(noEcho()));
        case "Description":
            return Optional.of(clazz.cast(description()));
        case "ParameterConstraints":
            return Optional.of(clazz.cast(parameterConstraints()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, ParameterDeclaration> {
        /**
         * <p>
         * The name that is associated with the parameter.
         * </p>
         * 
         * @param parameterKey
         *        The name that is associated with the parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameterKey(String parameterKey);

        /**
         * <p>
         * The default value of the parameter.
         * </p>
         * 
         * @param defaultValue
         *        The default value of the parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultValue(String defaultValue);

        /**
         * <p>
         * The type of parameter.
         * </p>
         * 
         * @param parameterType
         *        The type of parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameterType(String parameterType);

        /**
         * <p>
         * Flag that indicates whether the parameter value is shown as plain text in logs and in the AWS Management
         * Console.
         * </p>
         * 
         * @param noEcho
         *        Flag that indicates whether the parameter value is shown as plain text in logs and in the AWS
         *        Management Console.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder noEcho(Boolean noEcho);

        /**
         * <p>
         * The description that is associate with the parameter.
         * </p>
         * 
         * @param description
         *        The description that is associate with the parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The criteria that AWS CloudFormation uses to validate parameter values.
         * </p>
         * 
         * @param parameterConstraints
         *        The criteria that AWS CloudFormation uses to validate parameter values.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameterConstraints(ParameterConstraints parameterConstraints);
    }

    static final class BuilderImpl implements Builder {
        private String parameterKey;

        private String defaultValue;

        private String parameterType;

        private Boolean noEcho;

        private String description;

        private ParameterConstraints parameterConstraints;

        private BuilderImpl() {
        }

        private BuilderImpl(ParameterDeclaration model) {
            parameterKey(model.parameterKey);
            defaultValue(model.defaultValue);
            parameterType(model.parameterType);
            noEcho(model.noEcho);
            description(model.description);
            parameterConstraints(model.parameterConstraints);
        }

        public final String getParameterKey() {
            return parameterKey;
        }

        @Override
        public final Builder parameterKey(String parameterKey) {
            this.parameterKey = parameterKey;
            return this;
        }

        public final void setParameterKey(String parameterKey) {
            this.parameterKey = parameterKey;
        }

        public final String getDefaultValue() {
            return defaultValue;
        }

        @Override
        public final Builder defaultValue(String defaultValue) {
            this.defaultValue = defaultValue;
            return this;
        }

        public final void setDefaultValue(String defaultValue) {
            this.defaultValue = defaultValue;
        }

        public final String getParameterType() {
            return parameterType;
        }

        @Override
        public final Builder parameterType(String parameterType) {
            this.parameterType = parameterType;
            return this;
        }

        public final void setParameterType(String parameterType) {
            this.parameterType = parameterType;
        }

        public final Boolean getNoEcho() {
            return noEcho;
        }

        @Override
        public final Builder noEcho(Boolean noEcho) {
            this.noEcho = noEcho;
            return this;
        }

        public final void setNoEcho(Boolean noEcho) {
            this.noEcho = noEcho;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final ParameterConstraints.Builder getParameterConstraints() {
            return parameterConstraints != null ? parameterConstraints.toBuilder() : null;
        }

        @Override
        public final Builder parameterConstraints(ParameterConstraints parameterConstraints) {
            this.parameterConstraints = parameterConstraints;
            return this;
        }

        public final void setParameterConstraints(ParameterConstraints.BuilderImpl parameterConstraints) {
            this.parameterConstraints = parameterConstraints != null ? parameterConstraints.build() : null;
        }

        @Override
        public ParameterDeclaration build() {
            return new ParameterDeclaration(this);
        }
    }
}
