/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudformation.model;

import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * For a resource with <code>Modify</code> as the action, the <code>ResourceChange</code> structure describes the
 * changes AWS CloudFormation will make to that resource.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ResourceChangeDetail implements ToCopyableBuilder<ResourceChangeDetail.Builder, ResourceChangeDetail> {
    private final ResourceTargetDefinition target;

    private final String evaluation;

    private final String changeSource;

    private final String causingEntity;

    private ResourceChangeDetail(BuilderImpl builder) {
        this.target = builder.target;
        this.evaluation = builder.evaluation;
        this.changeSource = builder.changeSource;
        this.causingEntity = builder.causingEntity;
    }

    /**
     * <p>
     * A <code>ResourceTargetDefinition</code> structure that describes the field that AWS CloudFormation will change
     * and whether the resource will be recreated.
     * </p>
     * 
     * @return A <code>ResourceTargetDefinition</code> structure that describes the field that AWS CloudFormation will
     *         change and whether the resource will be recreated.
     */
    public ResourceTargetDefinition target() {
        return target;
    }

    /**
     * <p>
     * Indicates whether AWS CloudFormation can determine the target value, and whether the target value will change
     * before you execute a change set.
     * </p>
     * <p>
     * For <code>Static</code> evaluations, AWS CloudFormation can determine that the target value will change, and its
     * value. For example, if you directly modify the <code>InstanceType</code> property of an EC2 instance, AWS
     * CloudFormation knows that this property value will change, and its value, so this is a <code>Static</code>
     * evaluation.
     * </p>
     * <p>
     * For <code>Dynamic</code> evaluations, cannot determine the target value because it depends on the result of an
     * intrinsic function, such as a <code>Ref</code> or <code>Fn::GetAtt</code> intrinsic function, when the stack is
     * updated. For example, if your template includes a reference to a resource that is conditionally recreated, the
     * value of the reference (the physical ID of the resource) might change, depending on if the resource is recreated.
     * If the resource is recreated, it will have a new physical ID, so all references to that resource will also be
     * updated.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #evaluation} will
     * return {@link EvaluationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #evaluationString}.
     * </p>
     * 
     * @return Indicates whether AWS CloudFormation can determine the target value, and whether the target value will
     *         change before you execute a change set.</p>
     *         <p>
     *         For <code>Static</code> evaluations, AWS CloudFormation can determine that the target value will change,
     *         and its value. For example, if you directly modify the <code>InstanceType</code> property of an EC2
     *         instance, AWS CloudFormation knows that this property value will change, and its value, so this is a
     *         <code>Static</code> evaluation.
     *         </p>
     *         <p>
     *         For <code>Dynamic</code> evaluations, cannot determine the target value because it depends on the result
     *         of an intrinsic function, such as a <code>Ref</code> or <code>Fn::GetAtt</code> intrinsic function, when
     *         the stack is updated. For example, if your template includes a reference to a resource that is
     *         conditionally recreated, the value of the reference (the physical ID of the resource) might change,
     *         depending on if the resource is recreated. If the resource is recreated, it will have a new physical ID,
     *         so all references to that resource will also be updated.
     * @see EvaluationType
     */
    public EvaluationType evaluation() {
        return EvaluationType.fromValue(evaluation);
    }

    /**
     * <p>
     * Indicates whether AWS CloudFormation can determine the target value, and whether the target value will change
     * before you execute a change set.
     * </p>
     * <p>
     * For <code>Static</code> evaluations, AWS CloudFormation can determine that the target value will change, and its
     * value. For example, if you directly modify the <code>InstanceType</code> property of an EC2 instance, AWS
     * CloudFormation knows that this property value will change, and its value, so this is a <code>Static</code>
     * evaluation.
     * </p>
     * <p>
     * For <code>Dynamic</code> evaluations, cannot determine the target value because it depends on the result of an
     * intrinsic function, such as a <code>Ref</code> or <code>Fn::GetAtt</code> intrinsic function, when the stack is
     * updated. For example, if your template includes a reference to a resource that is conditionally recreated, the
     * value of the reference (the physical ID of the resource) might change, depending on if the resource is recreated.
     * If the resource is recreated, it will have a new physical ID, so all references to that resource will also be
     * updated.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #evaluation} will
     * return {@link EvaluationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #evaluationString}.
     * </p>
     * 
     * @return Indicates whether AWS CloudFormation can determine the target value, and whether the target value will
     *         change before you execute a change set.</p>
     *         <p>
     *         For <code>Static</code> evaluations, AWS CloudFormation can determine that the target value will change,
     *         and its value. For example, if you directly modify the <code>InstanceType</code> property of an EC2
     *         instance, AWS CloudFormation knows that this property value will change, and its value, so this is a
     *         <code>Static</code> evaluation.
     *         </p>
     *         <p>
     *         For <code>Dynamic</code> evaluations, cannot determine the target value because it depends on the result
     *         of an intrinsic function, such as a <code>Ref</code> or <code>Fn::GetAtt</code> intrinsic function, when
     *         the stack is updated. For example, if your template includes a reference to a resource that is
     *         conditionally recreated, the value of the reference (the physical ID of the resource) might change,
     *         depending on if the resource is recreated. If the resource is recreated, it will have a new physical ID,
     *         so all references to that resource will also be updated.
     * @see EvaluationType
     */
    public String evaluationString() {
        return evaluation;
    }

    /**
     * <p>
     * The group to which the <code>CausingEntity</code> value belongs. There are five entity groups:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ResourceReference</code> entities are <code>Ref</code> intrinsic functions that refer to resources in the
     * template, such as <code>{ "Ref" : "MyEC2InstanceResource" }</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ParameterReference</code> entities are <code>Ref</code> intrinsic functions that get template parameter
     * values, such as <code>{ "Ref" : "MyPasswordParameter" }</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ResourceAttribute</code> entities are <code>Fn::GetAtt</code> intrinsic functions that get resource
     * attribute values, such as <code>{ "Fn::GetAtt" : [ "MyEC2InstanceResource", "PublicDnsName" ] }</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DirectModification</code> entities are changes that are made directly to the template.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Automatic</code> entities are <code>AWS::CloudFormation::Stack</code> resource types, which are also known
     * as nested stacks. If you made no changes to the <code>AWS::CloudFormation::Stack</code> resource, AWS
     * CloudFormation sets the <code>ChangeSource</code> to <code>Automatic</code> because the nested stack's template
     * might have changed. Changes to a nested stack's template aren't visible to AWS CloudFormation until you run an
     * update on the parent stack.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #changeSource} will
     * return {@link ChangeSource#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #changeSourceString}.
     * </p>
     * 
     * @return The group to which the <code>CausingEntity</code> value belongs. There are five entity groups:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ResourceReference</code> entities are <code>Ref</code> intrinsic functions that refer to resources
     *         in the template, such as <code>{ "Ref" : "MyEC2InstanceResource" }</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ParameterReference</code> entities are <code>Ref</code> intrinsic functions that get template
     *         parameter values, such as <code>{ "Ref" : "MyPasswordParameter" }</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ResourceAttribute</code> entities are <code>Fn::GetAtt</code> intrinsic functions that get resource
     *         attribute values, such as <code>{ "Fn::GetAtt" : [ "MyEC2InstanceResource", "PublicDnsName" ] }</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DirectModification</code> entities are changes that are made directly to the template.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Automatic</code> entities are <code>AWS::CloudFormation::Stack</code> resource types, which are
     *         also known as nested stacks. If you made no changes to the <code>AWS::CloudFormation::Stack</code>
     *         resource, AWS CloudFormation sets the <code>ChangeSource</code> to <code>Automatic</code> because the
     *         nested stack's template might have changed. Changes to a nested stack's template aren't visible to AWS
     *         CloudFormation until you run an update on the parent stack.
     *         </p>
     *         </li>
     * @see ChangeSource
     */
    public ChangeSource changeSource() {
        return ChangeSource.fromValue(changeSource);
    }

    /**
     * <p>
     * The group to which the <code>CausingEntity</code> value belongs. There are five entity groups:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ResourceReference</code> entities are <code>Ref</code> intrinsic functions that refer to resources in the
     * template, such as <code>{ "Ref" : "MyEC2InstanceResource" }</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ParameterReference</code> entities are <code>Ref</code> intrinsic functions that get template parameter
     * values, such as <code>{ "Ref" : "MyPasswordParameter" }</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ResourceAttribute</code> entities are <code>Fn::GetAtt</code> intrinsic functions that get resource
     * attribute values, such as <code>{ "Fn::GetAtt" : [ "MyEC2InstanceResource", "PublicDnsName" ] }</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DirectModification</code> entities are changes that are made directly to the template.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Automatic</code> entities are <code>AWS::CloudFormation::Stack</code> resource types, which are also known
     * as nested stacks. If you made no changes to the <code>AWS::CloudFormation::Stack</code> resource, AWS
     * CloudFormation sets the <code>ChangeSource</code> to <code>Automatic</code> because the nested stack's template
     * might have changed. Changes to a nested stack's template aren't visible to AWS CloudFormation until you run an
     * update on the parent stack.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #changeSource} will
     * return {@link ChangeSource#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #changeSourceString}.
     * </p>
     * 
     * @return The group to which the <code>CausingEntity</code> value belongs. There are five entity groups:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ResourceReference</code> entities are <code>Ref</code> intrinsic functions that refer to resources
     *         in the template, such as <code>{ "Ref" : "MyEC2InstanceResource" }</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ParameterReference</code> entities are <code>Ref</code> intrinsic functions that get template
     *         parameter values, such as <code>{ "Ref" : "MyPasswordParameter" }</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ResourceAttribute</code> entities are <code>Fn::GetAtt</code> intrinsic functions that get resource
     *         attribute values, such as <code>{ "Fn::GetAtt" : [ "MyEC2InstanceResource", "PublicDnsName" ] }</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DirectModification</code> entities are changes that are made directly to the template.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Automatic</code> entities are <code>AWS::CloudFormation::Stack</code> resource types, which are
     *         also known as nested stacks. If you made no changes to the <code>AWS::CloudFormation::Stack</code>
     *         resource, AWS CloudFormation sets the <code>ChangeSource</code> to <code>Automatic</code> because the
     *         nested stack's template might have changed. Changes to a nested stack's template aren't visible to AWS
     *         CloudFormation until you run an update on the parent stack.
     *         </p>
     *         </li>
     * @see ChangeSource
     */
    public String changeSourceString() {
        return changeSource;
    }

    /**
     * <p>
     * The identity of the entity that triggered this change. This entity is a member of the group that is specified by
     * the <code>ChangeSource</code> field. For example, if you modified the value of the <code>KeyPairName</code>
     * parameter, the <code>CausingEntity</code> is the name of the parameter (<code>KeyPairName</code>).
     * </p>
     * <p>
     * If the <code>ChangeSource</code> value is <code>DirectModification</code>, no value is given for
     * <code>CausingEntity</code>.
     * </p>
     * 
     * @return The identity of the entity that triggered this change. This entity is a member of the group that is
     *         specified by the <code>ChangeSource</code> field. For example, if you modified the value of the
     *         <code>KeyPairName</code> parameter, the <code>CausingEntity</code> is the name of the parameter (
     *         <code>KeyPairName</code>).</p>
     *         <p>
     *         If the <code>ChangeSource</code> value is <code>DirectModification</code>, no value is given for
     *         <code>CausingEntity</code>.
     */
    public String causingEntity() {
        return causingEntity;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((target() == null) ? 0 : target().hashCode());
        hashCode = 31 * hashCode + ((evaluationString() == null) ? 0 : evaluationString().hashCode());
        hashCode = 31 * hashCode + ((changeSourceString() == null) ? 0 : changeSourceString().hashCode());
        hashCode = 31 * hashCode + ((causingEntity() == null) ? 0 : causingEntity().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourceChangeDetail)) {
            return false;
        }
        ResourceChangeDetail other = (ResourceChangeDetail) obj;
        if (other.target() == null ^ this.target() == null) {
            return false;
        }
        if (other.target() != null && !other.target().equals(this.target())) {
            return false;
        }
        if (other.evaluationString() == null ^ this.evaluationString() == null) {
            return false;
        }
        if (other.evaluationString() != null && !other.evaluationString().equals(this.evaluationString())) {
            return false;
        }
        if (other.changeSourceString() == null ^ this.changeSourceString() == null) {
            return false;
        }
        if (other.changeSourceString() != null && !other.changeSourceString().equals(this.changeSourceString())) {
            return false;
        }
        if (other.causingEntity() == null ^ this.causingEntity() == null) {
            return false;
        }
        if (other.causingEntity() != null && !other.causingEntity().equals(this.causingEntity())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (target() != null) {
            sb.append("Target: ").append(target()).append(",");
        }
        if (evaluationString() != null) {
            sb.append("Evaluation: ").append(evaluationString()).append(",");
        }
        if (changeSourceString() != null) {
            sb.append("ChangeSource: ").append(changeSourceString()).append(",");
        }
        if (causingEntity() != null) {
            sb.append("CausingEntity: ").append(causingEntity()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Target":
            return Optional.of(clazz.cast(target()));
        case "Evaluation":
            return Optional.of(clazz.cast(evaluationString()));
        case "ChangeSource":
            return Optional.of(clazz.cast(changeSourceString()));
        case "CausingEntity":
            return Optional.of(clazz.cast(causingEntity()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, ResourceChangeDetail> {
        /**
         * <p>
         * A <code>ResourceTargetDefinition</code> structure that describes the field that AWS CloudFormation will
         * change and whether the resource will be recreated.
         * </p>
         * 
         * @param target
         *        A <code>ResourceTargetDefinition</code> structure that describes the field that AWS CloudFormation
         *        will change and whether the resource will be recreated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder target(ResourceTargetDefinition target);

        /**
         * <p>
         * Indicates whether AWS CloudFormation can determine the target value, and whether the target value will change
         * before you execute a change set.
         * </p>
         * <p>
         * For <code>Static</code> evaluations, AWS CloudFormation can determine that the target value will change, and
         * its value. For example, if you directly modify the <code>InstanceType</code> property of an EC2 instance, AWS
         * CloudFormation knows that this property value will change, and its value, so this is a <code>Static</code>
         * evaluation.
         * </p>
         * <p>
         * For <code>Dynamic</code> evaluations, cannot determine the target value because it depends on the result of
         * an intrinsic function, such as a <code>Ref</code> or <code>Fn::GetAtt</code> intrinsic function, when the
         * stack is updated. For example, if your template includes a reference to a resource that is conditionally
         * recreated, the value of the reference (the physical ID of the resource) might change, depending on if the
         * resource is recreated. If the resource is recreated, it will have a new physical ID, so all references to
         * that resource will also be updated.
         * </p>
         * 
         * @param evaluation
         *        Indicates whether AWS CloudFormation can determine the target value, and whether the target value will
         *        change before you execute a change set.</p>
         *        <p>
         *        For <code>Static</code> evaluations, AWS CloudFormation can determine that the target value will
         *        change, and its value. For example, if you directly modify the <code>InstanceType</code> property of
         *        an EC2 instance, AWS CloudFormation knows that this property value will change, and its value, so this
         *        is a <code>Static</code> evaluation.
         *        </p>
         *        <p>
         *        For <code>Dynamic</code> evaluations, cannot determine the target value because it depends on the
         *        result of an intrinsic function, such as a <code>Ref</code> or <code>Fn::GetAtt</code> intrinsic
         *        function, when the stack is updated. For example, if your template includes a reference to a resource
         *        that is conditionally recreated, the value of the reference (the physical ID of the resource) might
         *        change, depending on if the resource is recreated. If the resource is recreated, it will have a new
         *        physical ID, so all references to that resource will also be updated.
         * @see EvaluationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EvaluationType
         */
        Builder evaluation(String evaluation);

        /**
         * <p>
         * Indicates whether AWS CloudFormation can determine the target value, and whether the target value will change
         * before you execute a change set.
         * </p>
         * <p>
         * For <code>Static</code> evaluations, AWS CloudFormation can determine that the target value will change, and
         * its value. For example, if you directly modify the <code>InstanceType</code> property of an EC2 instance, AWS
         * CloudFormation knows that this property value will change, and its value, so this is a <code>Static</code>
         * evaluation.
         * </p>
         * <p>
         * For <code>Dynamic</code> evaluations, cannot determine the target value because it depends on the result of
         * an intrinsic function, such as a <code>Ref</code> or <code>Fn::GetAtt</code> intrinsic function, when the
         * stack is updated. For example, if your template includes a reference to a resource that is conditionally
         * recreated, the value of the reference (the physical ID of the resource) might change, depending on if the
         * resource is recreated. If the resource is recreated, it will have a new physical ID, so all references to
         * that resource will also be updated.
         * </p>
         * 
         * @param evaluation
         *        Indicates whether AWS CloudFormation can determine the target value, and whether the target value will
         *        change before you execute a change set.</p>
         *        <p>
         *        For <code>Static</code> evaluations, AWS CloudFormation can determine that the target value will
         *        change, and its value. For example, if you directly modify the <code>InstanceType</code> property of
         *        an EC2 instance, AWS CloudFormation knows that this property value will change, and its value, so this
         *        is a <code>Static</code> evaluation.
         *        </p>
         *        <p>
         *        For <code>Dynamic</code> evaluations, cannot determine the target value because it depends on the
         *        result of an intrinsic function, such as a <code>Ref</code> or <code>Fn::GetAtt</code> intrinsic
         *        function, when the stack is updated. For example, if your template includes a reference to a resource
         *        that is conditionally recreated, the value of the reference (the physical ID of the resource) might
         *        change, depending on if the resource is recreated. If the resource is recreated, it will have a new
         *        physical ID, so all references to that resource will also be updated.
         * @see EvaluationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EvaluationType
         */
        Builder evaluation(EvaluationType evaluation);

        /**
         * <p>
         * The group to which the <code>CausingEntity</code> value belongs. There are five entity groups:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ResourceReference</code> entities are <code>Ref</code> intrinsic functions that refer to resources in
         * the template, such as <code>{ "Ref" : "MyEC2InstanceResource" }</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ParameterReference</code> entities are <code>Ref</code> intrinsic functions that get template parameter
         * values, such as <code>{ "Ref" : "MyPasswordParameter" }</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ResourceAttribute</code> entities are <code>Fn::GetAtt</code> intrinsic functions that get resource
         * attribute values, such as <code>{ "Fn::GetAtt" : [ "MyEC2InstanceResource", "PublicDnsName" ] }</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DirectModification</code> entities are changes that are made directly to the template.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Automatic</code> entities are <code>AWS::CloudFormation::Stack</code> resource types, which are also
         * known as nested stacks. If you made no changes to the <code>AWS::CloudFormation::Stack</code> resource, AWS
         * CloudFormation sets the <code>ChangeSource</code> to <code>Automatic</code> because the nested stack's
         * template might have changed. Changes to a nested stack's template aren't visible to AWS CloudFormation until
         * you run an update on the parent stack.
         * </p>
         * </li>
         * </ul>
         * 
         * @param changeSource
         *        The group to which the <code>CausingEntity</code> value belongs. There are five entity groups:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ResourceReference</code> entities are <code>Ref</code> intrinsic functions that refer to
         *        resources in the template, such as <code>{ "Ref" : "MyEC2InstanceResource" }</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ParameterReference</code> entities are <code>Ref</code> intrinsic functions that get template
         *        parameter values, such as <code>{ "Ref" : "MyPasswordParameter" }</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ResourceAttribute</code> entities are <code>Fn::GetAtt</code> intrinsic functions that get
         *        resource attribute values, such as
         *        <code>{ "Fn::GetAtt" : [ "MyEC2InstanceResource", "PublicDnsName" ] }</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DirectModification</code> entities are changes that are made directly to the template.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Automatic</code> entities are <code>AWS::CloudFormation::Stack</code> resource types, which are
         *        also known as nested stacks. If you made no changes to the <code>AWS::CloudFormation::Stack</code>
         *        resource, AWS CloudFormation sets the <code>ChangeSource</code> to <code>Automatic</code> because the
         *        nested stack's template might have changed. Changes to a nested stack's template aren't visible to AWS
         *        CloudFormation until you run an update on the parent stack.
         *        </p>
         *        </li>
         * @see ChangeSource
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ChangeSource
         */
        Builder changeSource(String changeSource);

        /**
         * <p>
         * The group to which the <code>CausingEntity</code> value belongs. There are five entity groups:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ResourceReference</code> entities are <code>Ref</code> intrinsic functions that refer to resources in
         * the template, such as <code>{ "Ref" : "MyEC2InstanceResource" }</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ParameterReference</code> entities are <code>Ref</code> intrinsic functions that get template parameter
         * values, such as <code>{ "Ref" : "MyPasswordParameter" }</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ResourceAttribute</code> entities are <code>Fn::GetAtt</code> intrinsic functions that get resource
         * attribute values, such as <code>{ "Fn::GetAtt" : [ "MyEC2InstanceResource", "PublicDnsName" ] }</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DirectModification</code> entities are changes that are made directly to the template.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Automatic</code> entities are <code>AWS::CloudFormation::Stack</code> resource types, which are also
         * known as nested stacks. If you made no changes to the <code>AWS::CloudFormation::Stack</code> resource, AWS
         * CloudFormation sets the <code>ChangeSource</code> to <code>Automatic</code> because the nested stack's
         * template might have changed. Changes to a nested stack's template aren't visible to AWS CloudFormation until
         * you run an update on the parent stack.
         * </p>
         * </li>
         * </ul>
         * 
         * @param changeSource
         *        The group to which the <code>CausingEntity</code> value belongs. There are five entity groups:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ResourceReference</code> entities are <code>Ref</code> intrinsic functions that refer to
         *        resources in the template, such as <code>{ "Ref" : "MyEC2InstanceResource" }</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ParameterReference</code> entities are <code>Ref</code> intrinsic functions that get template
         *        parameter values, such as <code>{ "Ref" : "MyPasswordParameter" }</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ResourceAttribute</code> entities are <code>Fn::GetAtt</code> intrinsic functions that get
         *        resource attribute values, such as
         *        <code>{ "Fn::GetAtt" : [ "MyEC2InstanceResource", "PublicDnsName" ] }</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DirectModification</code> entities are changes that are made directly to the template.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Automatic</code> entities are <code>AWS::CloudFormation::Stack</code> resource types, which are
         *        also known as nested stacks. If you made no changes to the <code>AWS::CloudFormation::Stack</code>
         *        resource, AWS CloudFormation sets the <code>ChangeSource</code> to <code>Automatic</code> because the
         *        nested stack's template might have changed. Changes to a nested stack's template aren't visible to AWS
         *        CloudFormation until you run an update on the parent stack.
         *        </p>
         *        </li>
         * @see ChangeSource
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ChangeSource
         */
        Builder changeSource(ChangeSource changeSource);

        /**
         * <p>
         * The identity of the entity that triggered this change. This entity is a member of the group that is specified
         * by the <code>ChangeSource</code> field. For example, if you modified the value of the
         * <code>KeyPairName</code> parameter, the <code>CausingEntity</code> is the name of the parameter (
         * <code>KeyPairName</code>).
         * </p>
         * <p>
         * If the <code>ChangeSource</code> value is <code>DirectModification</code>, no value is given for
         * <code>CausingEntity</code>.
         * </p>
         * 
         * @param causingEntity
         *        The identity of the entity that triggered this change. This entity is a member of the group that is
         *        specified by the <code>ChangeSource</code> field. For example, if you modified the value of the
         *        <code>KeyPairName</code> parameter, the <code>CausingEntity</code> is the name of the parameter (
         *        <code>KeyPairName</code>).</p>
         *        <p>
         *        If the <code>ChangeSource</code> value is <code>DirectModification</code>, no value is given for
         *        <code>CausingEntity</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder causingEntity(String causingEntity);
    }

    static final class BuilderImpl implements Builder {
        private ResourceTargetDefinition target;

        private String evaluation;

        private String changeSource;

        private String causingEntity;

        private BuilderImpl() {
        }

        private BuilderImpl(ResourceChangeDetail model) {
            target(model.target);
            evaluation(model.evaluation);
            changeSource(model.changeSource);
            causingEntity(model.causingEntity);
        }

        public final ResourceTargetDefinition.Builder getTarget() {
            return target != null ? target.toBuilder() : null;
        }

        @Override
        public final Builder target(ResourceTargetDefinition target) {
            this.target = target;
            return this;
        }

        public final void setTarget(ResourceTargetDefinition.BuilderImpl target) {
            this.target = target != null ? target.build() : null;
        }

        public final String getEvaluation() {
            return evaluation;
        }

        @Override
        public final Builder evaluation(String evaluation) {
            this.evaluation = evaluation;
            return this;
        }

        @Override
        public final Builder evaluation(EvaluationType evaluation) {
            this.evaluation(evaluation.toString());
            return this;
        }

        public final void setEvaluation(String evaluation) {
            this.evaluation = evaluation;
        }

        public final String getChangeSource() {
            return changeSource;
        }

        @Override
        public final Builder changeSource(String changeSource) {
            this.changeSource = changeSource;
            return this;
        }

        @Override
        public final Builder changeSource(ChangeSource changeSource) {
            this.changeSource(changeSource.toString());
            return this;
        }

        public final void setChangeSource(String changeSource) {
            this.changeSource = changeSource;
        }

        public final String getCausingEntity() {
            return causingEntity;
        }

        @Override
        public final Builder causingEntity(String causingEntity) {
            this.causingEntity = causingEntity;
            return this;
        }

        public final void setCausingEntity(String causingEntity) {
            this.causingEntity = causingEntity;
        }

        @Override
        public ResourceChangeDetail build() {
            return new ResourceChangeDetail(this);
        }
    }
}
