/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudformation.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.core.runtime.TypeConverter;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The output for <a>ValidateTemplate</a> action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ValidateTemplateResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<ValidateTemplateResponse.Builder, ValidateTemplateResponse> {
    private final List<TemplateParameter> parameters;

    private final String description;

    private final List<String> capabilities;

    private final String capabilitiesReason;

    private final List<String> declaredTransforms;

    private ValidateTemplateResponse(BuilderImpl builder) {
        this.parameters = builder.parameters;
        this.description = builder.description;
        this.capabilities = builder.capabilities;
        this.capabilitiesReason = builder.capabilitiesReason;
        this.declaredTransforms = builder.declaredTransforms;
    }

    /**
     * <p>
     * A list of <code>TemplateParameter</code> structures.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A list of <code>TemplateParameter</code> structures.
     */
    public List<TemplateParameter> parameters() {
        return parameters;
    }

    /**
     * <p>
     * The description found within the template.
     * </p>
     * 
     * @return The description found within the template.
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * The capabilities found within the template. If your template contains IAM resources, you must specify the
     * CAPABILITY_IAM or CAPABILITY_NAMED_IAM value for this parameter when you use the <a>CreateStack</a> or
     * <a>UpdateStack</a> actions with your template; otherwise, those actions return an InsufficientCapabilities error.
     * </p>
     * <p>
     * For more information, see <a
     * href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html#capabilities"
     * >Acknowledging IAM Resources in AWS CloudFormation Templates</a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The capabilities found within the template. If your template contains IAM resources, you must specify the
     *         CAPABILITY_IAM or CAPABILITY_NAMED_IAM value for this parameter when you use the <a>CreateStack</a> or
     *         <a>UpdateStack</a> actions with your template; otherwise, those actions return an
     *         InsufficientCapabilities error.</p>
     *         <p>
     *         For more information, see <a href=
     *         "http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html#capabilities"
     *         >Acknowledging IAM Resources in AWS CloudFormation Templates</a>.
     */
    public List<Capability> capabilities() {
        return TypeConverter.convert(capabilities, Capability::fromValue);
    }

    /**
     * <p>
     * The capabilities found within the template. If your template contains IAM resources, you must specify the
     * CAPABILITY_IAM or CAPABILITY_NAMED_IAM value for this parameter when you use the <a>CreateStack</a> or
     * <a>UpdateStack</a> actions with your template; otherwise, those actions return an InsufficientCapabilities error.
     * </p>
     * <p>
     * For more information, see <a
     * href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html#capabilities"
     * >Acknowledging IAM Resources in AWS CloudFormation Templates</a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The capabilities found within the template. If your template contains IAM resources, you must specify the
     *         CAPABILITY_IAM or CAPABILITY_NAMED_IAM value for this parameter when you use the <a>CreateStack</a> or
     *         <a>UpdateStack</a> actions with your template; otherwise, those actions return an
     *         InsufficientCapabilities error.</p>
     *         <p>
     *         For more information, see <a href=
     *         "http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html#capabilities"
     *         >Acknowledging IAM Resources in AWS CloudFormation Templates</a>.
     */
    public List<String> capabilitiesStrings() {
        return capabilities;
    }

    /**
     * <p>
     * The list of resources that generated the values in the <code>Capabilities</code> response element.
     * </p>
     * 
     * @return The list of resources that generated the values in the <code>Capabilities</code> response element.
     */
    public String capabilitiesReason() {
        return capabilitiesReason;
    }

    /**
     * <p>
     * A list of the transforms that are declared in the template.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A list of the transforms that are declared in the template.
     */
    public List<String> declaredTransforms() {
        return declaredTransforms;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((parameters() == null) ? 0 : parameters().hashCode());
        hashCode = 31 * hashCode + ((description() == null) ? 0 : description().hashCode());
        hashCode = 31 * hashCode + ((capabilitiesStrings() == null) ? 0 : capabilitiesStrings().hashCode());
        hashCode = 31 * hashCode + ((capabilitiesReason() == null) ? 0 : capabilitiesReason().hashCode());
        hashCode = 31 * hashCode + ((declaredTransforms() == null) ? 0 : declaredTransforms().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ValidateTemplateResponse)) {
            return false;
        }
        ValidateTemplateResponse other = (ValidateTemplateResponse) obj;
        if (other.parameters() == null ^ this.parameters() == null) {
            return false;
        }
        if (other.parameters() != null && !other.parameters().equals(this.parameters())) {
            return false;
        }
        if (other.description() == null ^ this.description() == null) {
            return false;
        }
        if (other.description() != null && !other.description().equals(this.description())) {
            return false;
        }
        if (other.capabilitiesStrings() == null ^ this.capabilitiesStrings() == null) {
            return false;
        }
        if (other.capabilitiesStrings() != null && !other.capabilitiesStrings().equals(this.capabilitiesStrings())) {
            return false;
        }
        if (other.capabilitiesReason() == null ^ this.capabilitiesReason() == null) {
            return false;
        }
        if (other.capabilitiesReason() != null && !other.capabilitiesReason().equals(this.capabilitiesReason())) {
            return false;
        }
        if (other.declaredTransforms() == null ^ this.declaredTransforms() == null) {
            return false;
        }
        if (other.declaredTransforms() != null && !other.declaredTransforms().equals(this.declaredTransforms())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (parameters() != null) {
            sb.append("Parameters: ").append(parameters()).append(",");
        }
        if (description() != null) {
            sb.append("Description: ").append(description()).append(",");
        }
        if (capabilitiesStrings() != null) {
            sb.append("Capabilities: ").append(capabilitiesStrings()).append(",");
        }
        if (capabilitiesReason() != null) {
            sb.append("CapabilitiesReason: ").append(capabilitiesReason()).append(",");
        }
        if (declaredTransforms() != null) {
            sb.append("DeclaredTransforms: ").append(declaredTransforms()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Parameters":
            return Optional.of(clazz.cast(parameters()));
        case "Description":
            return Optional.of(clazz.cast(description()));
        case "Capabilities":
            return Optional.of(clazz.cast(capabilitiesStrings()));
        case "CapabilitiesReason":
            return Optional.of(clazz.cast(capabilitiesReason()));
        case "DeclaredTransforms":
            return Optional.of(clazz.cast(declaredTransforms()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, ValidateTemplateResponse> {
        /**
         * <p>
         * A list of <code>TemplateParameter</code> structures.
         * </p>
         * 
         * @param parameters
         *        A list of <code>TemplateParameter</code> structures.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameters(Collection<TemplateParameter> parameters);

        /**
         * <p>
         * A list of <code>TemplateParameter</code> structures.
         * </p>
         * 
         * @param parameters
         *        A list of <code>TemplateParameter</code> structures.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameters(TemplateParameter... parameters);

        /**
         * <p>
         * The description found within the template.
         * </p>
         * 
         * @param description
         *        The description found within the template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The capabilities found within the template. If your template contains IAM resources, you must specify the
         * CAPABILITY_IAM or CAPABILITY_NAMED_IAM value for this parameter when you use the <a>CreateStack</a> or
         * <a>UpdateStack</a> actions with your template; otherwise, those actions return an InsufficientCapabilities
         * error.
         * </p>
         * <p>
         * For more information, see <a
         * href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html#capabilities"
         * >Acknowledging IAM Resources in AWS CloudFormation Templates</a>.
         * </p>
         * 
         * @param capabilities
         *        The capabilities found within the template. If your template contains IAM resources, you must specify
         *        the CAPABILITY_IAM or CAPABILITY_NAMED_IAM value for this parameter when you use the
         *        <a>CreateStack</a> or <a>UpdateStack</a> actions with your template; otherwise, those actions return
         *        an InsufficientCapabilities error.</p>
         *        <p>
         *        For more information, see <a href=
         *        "http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html#capabilities"
         *        >Acknowledging IAM Resources in AWS CloudFormation Templates</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capabilities(Collection<String> capabilities);

        /**
         * <p>
         * The capabilities found within the template. If your template contains IAM resources, you must specify the
         * CAPABILITY_IAM or CAPABILITY_NAMED_IAM value for this parameter when you use the <a>CreateStack</a> or
         * <a>UpdateStack</a> actions with your template; otherwise, those actions return an InsufficientCapabilities
         * error.
         * </p>
         * <p>
         * For more information, see <a
         * href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html#capabilities"
         * >Acknowledging IAM Resources in AWS CloudFormation Templates</a>.
         * </p>
         * 
         * @param capabilities
         *        The capabilities found within the template. If your template contains IAM resources, you must specify
         *        the CAPABILITY_IAM or CAPABILITY_NAMED_IAM value for this parameter when you use the
         *        <a>CreateStack</a> or <a>UpdateStack</a> actions with your template; otherwise, those actions return
         *        an InsufficientCapabilities error.</p>
         *        <p>
         *        For more information, see <a href=
         *        "http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html#capabilities"
         *        >Acknowledging IAM Resources in AWS CloudFormation Templates</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capabilities(String... capabilities);

        /**
         * <p>
         * The list of resources that generated the values in the <code>Capabilities</code> response element.
         * </p>
         * 
         * @param capabilitiesReason
         *        The list of resources that generated the values in the <code>Capabilities</code> response element.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capabilitiesReason(String capabilitiesReason);

        /**
         * <p>
         * A list of the transforms that are declared in the template.
         * </p>
         * 
         * @param declaredTransforms
         *        A list of the transforms that are declared in the template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder declaredTransforms(Collection<String> declaredTransforms);

        /**
         * <p>
         * A list of the transforms that are declared in the template.
         * </p>
         * 
         * @param declaredTransforms
         *        A list of the transforms that are declared in the template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder declaredTransforms(String... declaredTransforms);
    }

    static final class BuilderImpl implements Builder {
        private List<TemplateParameter> parameters;

        private String description;

        private List<String> capabilities;

        private String capabilitiesReason;

        private List<String> declaredTransforms;

        private BuilderImpl() {
        }

        private BuilderImpl(ValidateTemplateResponse model) {
            parameters(model.parameters);
            description(model.description);
            capabilities(model.capabilities);
            capabilitiesReason(model.capabilitiesReason);
            declaredTransforms(model.declaredTransforms);
        }

        public final Collection<TemplateParameter.Builder> getParameters() {
            return parameters != null ? parameters.stream().map(TemplateParameter::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder parameters(Collection<TemplateParameter> parameters) {
            this.parameters = TemplateParametersCopier.copy(parameters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameters(TemplateParameter... parameters) {
            parameters(Arrays.asList(parameters));
            return this;
        }

        public final void setParameters(Collection<TemplateParameter.BuilderImpl> parameters) {
            this.parameters = TemplateParametersCopier.copyFromBuilder(parameters);
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Collection<String> getCapabilities() {
            return capabilities;
        }

        @Override
        public final Builder capabilities(Collection<String> capabilities) {
            this.capabilities = CapabilitiesCopier.copy(capabilities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder capabilities(String... capabilities) {
            capabilities(Arrays.asList(capabilities));
            return this;
        }

        public final void setCapabilities(Collection<String> capabilities) {
            this.capabilities = CapabilitiesCopier.copy(capabilities);
        }

        public final String getCapabilitiesReason() {
            return capabilitiesReason;
        }

        @Override
        public final Builder capabilitiesReason(String capabilitiesReason) {
            this.capabilitiesReason = capabilitiesReason;
            return this;
        }

        public final void setCapabilitiesReason(String capabilitiesReason) {
            this.capabilitiesReason = capabilitiesReason;
        }

        public final Collection<String> getDeclaredTransforms() {
            return declaredTransforms;
        }

        @Override
        public final Builder declaredTransforms(Collection<String> declaredTransforms) {
            this.declaredTransforms = TransformsListCopier.copy(declaredTransforms);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder declaredTransforms(String... declaredTransforms) {
            declaredTransforms(Arrays.asList(declaredTransforms));
            return this;
        }

        public final void setDeclaredTransforms(Collection<String> declaredTransforms) {
            this.declaredTransforms = TransformsListCopier.copy(declaredTransforms);
        }

        @Override
        public ValidateTemplateResponse build() {
            return new ValidateTemplateResponse(this);
        }
    }
}
