/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudformation.transform;

import java.util.ArrayList;

import javax.xml.stream.events.XMLEvent;
import javax.annotation.Generated;

import software.amazon.awssdk.services.cloudformation.model.*;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;

import software.amazon.awssdk.core.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.SimpleTypeStaxUnmarshallers.*;

/**
 * DescribeChangeSetResponse StAX Unmarshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class DescribeChangeSetResponseUnmarshaller implements Unmarshaller<DescribeChangeSetResponse, StaxUnmarshallerContext> {

    public DescribeChangeSetResponse unmarshall(StaxUnmarshallerContext context) throws Exception {
        DescribeChangeSetResponse.Builder describeChangeSetResponse = DescribeChangeSetResponse.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;

        if (context.isStartOfDocument())
            targetDepth += 2;

        java.util.List<Parameter> parameters = null;
        java.util.List<String> notificationARNs = null;
        java.util.List<String> capabilities = null;
        java.util.List<Tag> tags = null;
        java.util.List<Change> changes = null;

        while (true) {
            XMLEvent xmlEvent = context.nextEvent();
            if (xmlEvent.isEndDocument()) {
                describeChangeSetResponse.parameters(parameters);
                describeChangeSetResponse.notificationARNs(notificationARNs);
                describeChangeSetResponse.capabilities(capabilities);
                describeChangeSetResponse.tags(tags);
                describeChangeSetResponse.changes(changes);
                break;
            }

            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {

                if (context.testExpression("ChangeSetName", targetDepth)) {
                    describeChangeSetResponse.changeSetName(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("ChangeSetId", targetDepth)) {
                    describeChangeSetResponse.changeSetId(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("StackId", targetDepth)) {
                    describeChangeSetResponse.stackId(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("StackName", targetDepth)) {
                    describeChangeSetResponse.stackName(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("Description", targetDepth)) {
                    describeChangeSetResponse.description(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("Parameters", targetDepth)) {
                    parameters = new ArrayList<Parameter>();
                    continue;
                }

                if (context.testExpression("Parameters/member", targetDepth)) {
                    parameters.add(ParameterUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("CreationTime", targetDepth)) {
                    describeChangeSetResponse.creationTime(InstantUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("ExecutionStatus", targetDepth)) {
                    describeChangeSetResponse.executionStatus(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("Status", targetDepth)) {
                    describeChangeSetResponse.status(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("StatusReason", targetDepth)) {
                    describeChangeSetResponse.statusReason(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("NotificationARNs", targetDepth)) {
                    notificationARNs = new ArrayList<String>();
                    continue;
                }

                if (context.testExpression("NotificationARNs/member", targetDepth)) {
                    notificationARNs.add(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("Capabilities", targetDepth)) {
                    capabilities = new ArrayList<String>();
                    continue;
                }

                if (context.testExpression("Capabilities/member", targetDepth)) {
                    capabilities.add(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("Tags", targetDepth)) {
                    tags = new ArrayList<Tag>();
                    continue;
                }

                if (context.testExpression("Tags/member", targetDepth)) {
                    tags.add(TagUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("Changes", targetDepth)) {
                    changes = new ArrayList<Change>();
                    continue;
                }

                if (context.testExpression("Changes/member", targetDepth)) {
                    changes.add(ChangeUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("NextToken", targetDepth)) {
                    describeChangeSetResponse.nextToken(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
            } else if (xmlEvent.isEndElement()) {
                if (context.getCurrentDepth() < originalDepth) {
                    describeChangeSetResponse.parameters(parameters);
                    describeChangeSetResponse.notificationARNs(notificationARNs);
                    describeChangeSetResponse.capabilities(capabilities);
                    describeChangeSetResponse.tags(tags);
                    describeChangeSetResponse.changes(changes);
                    break;
                }
            }
        }
        return describeChangeSetResponse.build();
    }

    private static final DescribeChangeSetResponseUnmarshaller INSTANCE = new DescribeChangeSetResponseUnmarshaller();

    public static DescribeChangeSetResponseUnmarshaller getInstance() {
        return INSTANCE;
    }
}
