/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudformation.transform;

import java.util.ArrayList;

import javax.xml.stream.events.XMLEvent;
import javax.annotation.Generated;

import software.amazon.awssdk.services.cloudformation.model.*;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;

import software.amazon.awssdk.core.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.SimpleTypeStaxUnmarshallers.*;

/**
 * ListChangeSetsResponse StAX Unmarshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class ListChangeSetsResponseUnmarshaller implements Unmarshaller<ListChangeSetsResponse, StaxUnmarshallerContext> {

    public ListChangeSetsResponse unmarshall(StaxUnmarshallerContext context) throws Exception {
        ListChangeSetsResponse.Builder listChangeSetsResponse = ListChangeSetsResponse.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;

        if (context.isStartOfDocument())
            targetDepth += 2;

        java.util.List<ChangeSetSummary> summaries = null;

        while (true) {
            XMLEvent xmlEvent = context.nextEvent();
            if (xmlEvent.isEndDocument()) {
                listChangeSetsResponse.summaries(summaries);
                break;
            }

            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {

                if (context.testExpression("Summaries", targetDepth)) {
                    summaries = new ArrayList<ChangeSetSummary>();
                    continue;
                }

                if (context.testExpression("Summaries/member", targetDepth)) {
                    summaries.add(ChangeSetSummaryUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("NextToken", targetDepth)) {
                    listChangeSetsResponse.nextToken(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
            } else if (xmlEvent.isEndElement()) {
                if (context.getCurrentDepth() < originalDepth) {
                    listChangeSetsResponse.summaries(summaries);
                    break;
                }
            }
        }
        return listChangeSetsResponse.build();
    }

    private static final ListChangeSetsResponseUnmarshaller INSTANCE = new ListChangeSetsResponseUnmarshaller();

    public static ListChangeSetsResponseUnmarshaller getInstance() {
        return INSTANCE;
    }
}
