/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudformation.transform;

import java.util.List;

import javax.annotation.Generated;

import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.services.cloudformation.model.*;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;

/**
 * ListStacksRequest Marshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class ListStacksRequestMarshaller implements Marshaller<Request<ListStacksRequest>, ListStacksRequest> {

    public Request<ListStacksRequest> marshall(ListStacksRequest listStacksRequest) {

        if (listStacksRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        Request<ListStacksRequest> request = new DefaultRequest<ListStacksRequest>(listStacksRequest, "CloudFormationClient");
        request.addParameter("Action", "ListStacks");
        request.addParameter("Version", "2010-05-15");
        request.setHttpMethod(HttpMethodName.POST);

        if (listStacksRequest.nextToken() != null) {
            request.addParameter("NextToken", StringUtils.fromString(listStacksRequest.nextToken()));
        }

        java.util.List<String> stackStatusFiltersList = listStacksRequest.stackStatusFiltersStrings();

        if (stackStatusFiltersList != null) {
            if (!stackStatusFiltersList.isEmpty()) {
                int stackStatusFiltersListIndex = 1;

                for (String stackStatusFiltersListValue : stackStatusFiltersList) {
                    if (stackStatusFiltersListValue != null) {
                        request.addParameter("StackStatusFilter.member." + stackStatusFiltersListIndex,
                                StringUtils.fromString(stackStatusFiltersListValue));
                    }
                    stackStatusFiltersListIndex++;
                }
            } else {
                request.addParameter("StackStatusFilter", "");
            }
        }

        return request;
    }

}
