/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudformation;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.services.cloudformation.model.CancelUpdateStackRequest;
import software.amazon.awssdk.services.cloudformation.model.CancelUpdateStackResponse;
import software.amazon.awssdk.services.cloudformation.model.ContinueUpdateRollbackRequest;
import software.amazon.awssdk.services.cloudformation.model.ContinueUpdateRollbackResponse;
import software.amazon.awssdk.services.cloudformation.model.CreateChangeSetRequest;
import software.amazon.awssdk.services.cloudformation.model.CreateChangeSetResponse;
import software.amazon.awssdk.services.cloudformation.model.CreateStackInstancesRequest;
import software.amazon.awssdk.services.cloudformation.model.CreateStackInstancesResponse;
import software.amazon.awssdk.services.cloudformation.model.CreateStackRequest;
import software.amazon.awssdk.services.cloudformation.model.CreateStackResponse;
import software.amazon.awssdk.services.cloudformation.model.CreateStackSetRequest;
import software.amazon.awssdk.services.cloudformation.model.CreateStackSetResponse;
import software.amazon.awssdk.services.cloudformation.model.DeleteChangeSetRequest;
import software.amazon.awssdk.services.cloudformation.model.DeleteChangeSetResponse;
import software.amazon.awssdk.services.cloudformation.model.DeleteStackInstancesRequest;
import software.amazon.awssdk.services.cloudformation.model.DeleteStackInstancesResponse;
import software.amazon.awssdk.services.cloudformation.model.DeleteStackRequest;
import software.amazon.awssdk.services.cloudformation.model.DeleteStackResponse;
import software.amazon.awssdk.services.cloudformation.model.DeleteStackSetRequest;
import software.amazon.awssdk.services.cloudformation.model.DeleteStackSetResponse;
import software.amazon.awssdk.services.cloudformation.model.DescribeAccountLimitsRequest;
import software.amazon.awssdk.services.cloudformation.model.DescribeAccountLimitsResponse;
import software.amazon.awssdk.services.cloudformation.model.DescribeChangeSetRequest;
import software.amazon.awssdk.services.cloudformation.model.DescribeChangeSetResponse;
import software.amazon.awssdk.services.cloudformation.model.DescribeStackEventsRequest;
import software.amazon.awssdk.services.cloudformation.model.DescribeStackEventsResponse;
import software.amazon.awssdk.services.cloudformation.model.DescribeStackInstanceRequest;
import software.amazon.awssdk.services.cloudformation.model.DescribeStackInstanceResponse;
import software.amazon.awssdk.services.cloudformation.model.DescribeStackResourceRequest;
import software.amazon.awssdk.services.cloudformation.model.DescribeStackResourceResponse;
import software.amazon.awssdk.services.cloudformation.model.DescribeStackResourcesRequest;
import software.amazon.awssdk.services.cloudformation.model.DescribeStackResourcesResponse;
import software.amazon.awssdk.services.cloudformation.model.DescribeStackSetOperationRequest;
import software.amazon.awssdk.services.cloudformation.model.DescribeStackSetOperationResponse;
import software.amazon.awssdk.services.cloudformation.model.DescribeStackSetRequest;
import software.amazon.awssdk.services.cloudformation.model.DescribeStackSetResponse;
import software.amazon.awssdk.services.cloudformation.model.DescribeStacksRequest;
import software.amazon.awssdk.services.cloudformation.model.DescribeStacksResponse;
import software.amazon.awssdk.services.cloudformation.model.EstimateTemplateCostRequest;
import software.amazon.awssdk.services.cloudformation.model.EstimateTemplateCostResponse;
import software.amazon.awssdk.services.cloudformation.model.ExecuteChangeSetRequest;
import software.amazon.awssdk.services.cloudformation.model.ExecuteChangeSetResponse;
import software.amazon.awssdk.services.cloudformation.model.GetStackPolicyRequest;
import software.amazon.awssdk.services.cloudformation.model.GetStackPolicyResponse;
import software.amazon.awssdk.services.cloudformation.model.GetTemplateRequest;
import software.amazon.awssdk.services.cloudformation.model.GetTemplateResponse;
import software.amazon.awssdk.services.cloudformation.model.GetTemplateSummaryRequest;
import software.amazon.awssdk.services.cloudformation.model.GetTemplateSummaryResponse;
import software.amazon.awssdk.services.cloudformation.model.ListChangeSetsRequest;
import software.amazon.awssdk.services.cloudformation.model.ListChangeSetsResponse;
import software.amazon.awssdk.services.cloudformation.model.ListExportsRequest;
import software.amazon.awssdk.services.cloudformation.model.ListExportsResponse;
import software.amazon.awssdk.services.cloudformation.model.ListImportsRequest;
import software.amazon.awssdk.services.cloudformation.model.ListImportsResponse;
import software.amazon.awssdk.services.cloudformation.model.ListStackInstancesRequest;
import software.amazon.awssdk.services.cloudformation.model.ListStackInstancesResponse;
import software.amazon.awssdk.services.cloudformation.model.ListStackResourcesRequest;
import software.amazon.awssdk.services.cloudformation.model.ListStackResourcesResponse;
import software.amazon.awssdk.services.cloudformation.model.ListStackSetOperationResultsRequest;
import software.amazon.awssdk.services.cloudformation.model.ListStackSetOperationResultsResponse;
import software.amazon.awssdk.services.cloudformation.model.ListStackSetOperationsRequest;
import software.amazon.awssdk.services.cloudformation.model.ListStackSetOperationsResponse;
import software.amazon.awssdk.services.cloudformation.model.ListStackSetsRequest;
import software.amazon.awssdk.services.cloudformation.model.ListStackSetsResponse;
import software.amazon.awssdk.services.cloudformation.model.ListStacksRequest;
import software.amazon.awssdk.services.cloudformation.model.ListStacksResponse;
import software.amazon.awssdk.services.cloudformation.model.SetStackPolicyRequest;
import software.amazon.awssdk.services.cloudformation.model.SetStackPolicyResponse;
import software.amazon.awssdk.services.cloudformation.model.SignalResourceRequest;
import software.amazon.awssdk.services.cloudformation.model.SignalResourceResponse;
import software.amazon.awssdk.services.cloudformation.model.StopStackSetOperationRequest;
import software.amazon.awssdk.services.cloudformation.model.StopStackSetOperationResponse;
import software.amazon.awssdk.services.cloudformation.model.UpdateStackRequest;
import software.amazon.awssdk.services.cloudformation.model.UpdateStackResponse;
import software.amazon.awssdk.services.cloudformation.model.UpdateStackSetRequest;
import software.amazon.awssdk.services.cloudformation.model.UpdateStackSetResponse;
import software.amazon.awssdk.services.cloudformation.model.UpdateTerminationProtectionRequest;
import software.amazon.awssdk.services.cloudformation.model.UpdateTerminationProtectionResponse;
import software.amazon.awssdk.services.cloudformation.model.ValidateTemplateRequest;
import software.amazon.awssdk.services.cloudformation.model.ValidateTemplateResponse;
import software.amazon.awssdk.utils.SdkAutoCloseable;

/**
 * Service client for accessing null asynchronously. This can be created using the static {@link #builder()} method.
 *
 * <fullname>AWS CloudFormation</fullname>
 * <p>
 * AWS CloudFormation allows you to create and manage AWS infrastructure deployments predictably and repeatedly. You can
 * use AWS CloudFormation to leverage AWS products, such as Amazon Elastic Compute Cloud, Amazon Elastic Block Store,
 * Amazon Simple Notification Service, Elastic Load Balancing, and Auto Scaling to build highly-reliable, highly
 * scalable, cost-effective applications without creating or configuring the underlying AWS infrastructure.
 * </p>
 * <p>
 * With AWS CloudFormation, you declare all of your resources and dependencies in a template file. The template defines
 * a collection of resources as a single unit called a stack. AWS CloudFormation creates and deletes all member
 * resources of the stack together and manages all dependencies between the resources for you.
 * </p>
 * <p>
 * For more information about AWS CloudFormation, see the <a href="http://aws.amazon.com/cloudformation/">AWS
 * CloudFormation Product Page</a>.
 * </p>
 * <p>
 * Amazon CloudFormation makes use of other AWS products. If you need additional technical information about a specific
 * AWS product, you can find the product's technical documentation at <a
 * href="http://docs.aws.amazon.com/">docs.aws.amazon.com</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public interface CloudFormationAsyncClient extends SdkAutoCloseable {
    /**
     * Create a {@link CloudFormationAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.core.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from
     * the {@link software.amazon.awssdk.core.auth.DefaultCredentialsProvider}.
     */
    static CloudFormationAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link CloudFormationAsyncClient}.
     */
    static CloudFormationAsyncClientBuilder builder() {
        return new DefaultCloudFormationAsyncClientBuilder();
    }

    /**
     * <p>
     * Cancels an update on the specified stack. If the call completes successfully, the stack rolls back the update and
     * reverts to the previous stack configuration.
     * </p>
     * <note>
     * <p>
     * You can cancel only stacks that are in the UPDATE_IN_PROGRESS state.
     * </p>
     * </note>
     *
     * @param cancelUpdateStackRequest
     *        The input for the <a>CancelUpdateStack</a> action.
     * @return A Java Future containing the result of the CancelUpdateStack operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>TokenAlreadyExistsException A client request token already exists.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.CancelUpdateStack
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/CancelUpdateStack"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CancelUpdateStackResponse> cancelUpdateStack(CancelUpdateStackRequest cancelUpdateStackRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Cancels an update on the specified stack. If the call completes successfully, the stack rolls back the update and
     * reverts to the previous stack configuration.
     * </p>
     * <note>
     * <p>
     * You can cancel only stacks that are in the UPDATE_IN_PROGRESS state.
     * </p>
     * </note><br/>
     * This is a convenience which creates an instance of the {@link CancelUpdateStackRequest.Builder} avoiding the need
     * to create one manually via {@link CancelUpdateStackRequest#builder()}
     *
     * @param cancelUpdateStackRequest
     *        a {@link Consumer} that will call methods on {@link CancelUpdateStackInput.Builder}.
     * @return A Java Future containing the result of the CancelUpdateStack operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>TokenAlreadyExistsException A client request token already exists.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.CancelUpdateStack
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/CancelUpdateStack"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CancelUpdateStackResponse> cancelUpdateStack(
            Consumer<CancelUpdateStackRequest.Builder> cancelUpdateStackRequest) {
        return cancelUpdateStack(CancelUpdateStackRequest.builder().apply(cancelUpdateStackRequest).build());
    }

    /**
     * <p>
     * For a specified stack that is in the <code>UPDATE_ROLLBACK_FAILED</code> state, continues rolling it back to the
     * <code>UPDATE_ROLLBACK_COMPLETE</code> state. Depending on the cause of the failure, you can manually <a href=
     * "http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/troubleshooting.html#troubleshooting-errors-update-rollback-failed"
     * > fix the error</a> and continue the rollback. By continuing the rollback, you can return your stack to a working
     * state (the <code>UPDATE_ROLLBACK_COMPLETE</code> state), and then try to update the stack again.
     * </p>
     * <p>
     * A stack goes into the <code>UPDATE_ROLLBACK_FAILED</code> state when AWS CloudFormation cannot roll back all
     * changes after a failed stack update. For example, you might have a stack that is rolling back to an old database
     * instance that was deleted outside of AWS CloudFormation. Because AWS CloudFormation doesn't know the database was
     * deleted, it assumes that the database instance still exists and attempts to roll back to it, causing the update
     * rollback to fail.
     * </p>
     *
     * @param continueUpdateRollbackRequest
     *        The input for the <a>ContinueUpdateRollback</a> action.
     * @return A Java Future containing the result of the ContinueUpdateRollback operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>TokenAlreadyExistsException A client request token already exists.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.ContinueUpdateRollback
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ContinueUpdateRollback"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ContinueUpdateRollbackResponse> continueUpdateRollback(
            ContinueUpdateRollbackRequest continueUpdateRollbackRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * For a specified stack that is in the <code>UPDATE_ROLLBACK_FAILED</code> state, continues rolling it back to the
     * <code>UPDATE_ROLLBACK_COMPLETE</code> state. Depending on the cause of the failure, you can manually <a href=
     * "http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/troubleshooting.html#troubleshooting-errors-update-rollback-failed"
     * > fix the error</a> and continue the rollback. By continuing the rollback, you can return your stack to a working
     * state (the <code>UPDATE_ROLLBACK_COMPLETE</code> state), and then try to update the stack again.
     * </p>
     * <p>
     * A stack goes into the <code>UPDATE_ROLLBACK_FAILED</code> state when AWS CloudFormation cannot roll back all
     * changes after a failed stack update. For example, you might have a stack that is rolling back to an old database
     * instance that was deleted outside of AWS CloudFormation. Because AWS CloudFormation doesn't know the database was
     * deleted, it assumes that the database instance still exists and attempts to roll back to it, causing the update
     * rollback to fail.
     * </p>
     * <br/>
     * This is a convenience which creates an instance of the {@link ContinueUpdateRollbackRequest.Builder} avoiding the
     * need to create one manually via {@link ContinueUpdateRollbackRequest#builder()}
     *
     * @param continueUpdateRollbackRequest
     *        a {@link Consumer} that will call methods on {@link ContinueUpdateRollbackInput.Builder}.
     * @return A Java Future containing the result of the ContinueUpdateRollback operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>TokenAlreadyExistsException A client request token already exists.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.ContinueUpdateRollback
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ContinueUpdateRollback"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ContinueUpdateRollbackResponse> continueUpdateRollback(
            Consumer<ContinueUpdateRollbackRequest.Builder> continueUpdateRollbackRequest) {
        return continueUpdateRollback(ContinueUpdateRollbackRequest.builder().apply(continueUpdateRollbackRequest).build());
    }

    /**
     * <p>
     * Creates a list of changes that will be applied to a stack so that you can review the changes before executing
     * them. You can create a change set for a stack that doesn't exist or an existing stack. If you create a change set
     * for a stack that doesn't exist, the change set shows all of the resources that AWS CloudFormation will create. If
     * you create a change set for an existing stack, AWS CloudFormation compares the stack's information with the
     * information that you submit in the change set and lists the differences. Use change sets to understand which
     * resources AWS CloudFormation will create or change, and how it will change resources in an existing stack, before
     * you create or update a stack.
     * </p>
     * <p>
     * To create a change set for a stack that doesn't exist, for the <code>ChangeSetType</code> parameter, specify
     * <code>CREATE</code>. To create a change set for an existing stack, specify <code>UPDATE</code> for the
     * <code>ChangeSetType</code> parameter. After the <code>CreateChangeSet</code> call successfully completes, AWS
     * CloudFormation starts creating the change set. To check the status of the change set or to review it, use the
     * <a>DescribeChangeSet</a> action.
     * </p>
     * <p>
     * When you are satisfied with the changes the change set will make, execute the change set by using the
     * <a>ExecuteChangeSet</a> action. AWS CloudFormation doesn't make changes until you execute the change set.
     * </p>
     *
     * @param createChangeSetRequest
     *        The input for the <a>CreateChangeSet</a> action.
     * @return A Java Future containing the result of the CreateChangeSet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AlreadyExistsException The resource with the name requested already exists.</li>
     *         <li>InsufficientCapabilitiesException The template contains resources with capabilities that weren't
     *         specified in the Capabilities parameter.</li>
     *         <li>LimitExceededException The quota for the resource has already been reached.</p>
     *         <p>
     *         For information on stack set limitations, see <a
     *         href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-limitations.html"
     *         >Limitations of StackSets</a>.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.CreateChangeSet
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/CreateChangeSet" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateChangeSetResponse> createChangeSet(CreateChangeSetRequest createChangeSetRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a list of changes that will be applied to a stack so that you can review the changes before executing
     * them. You can create a change set for a stack that doesn't exist or an existing stack. If you create a change set
     * for a stack that doesn't exist, the change set shows all of the resources that AWS CloudFormation will create. If
     * you create a change set for an existing stack, AWS CloudFormation compares the stack's information with the
     * information that you submit in the change set and lists the differences. Use change sets to understand which
     * resources AWS CloudFormation will create or change, and how it will change resources in an existing stack, before
     * you create or update a stack.
     * </p>
     * <p>
     * To create a change set for a stack that doesn't exist, for the <code>ChangeSetType</code> parameter, specify
     * <code>CREATE</code>. To create a change set for an existing stack, specify <code>UPDATE</code> for the
     * <code>ChangeSetType</code> parameter. After the <code>CreateChangeSet</code> call successfully completes, AWS
     * CloudFormation starts creating the change set. To check the status of the change set or to review it, use the
     * <a>DescribeChangeSet</a> action.
     * </p>
     * <p>
     * When you are satisfied with the changes the change set will make, execute the change set by using the
     * <a>ExecuteChangeSet</a> action. AWS CloudFormation doesn't make changes until you execute the change set.
     * </p>
     * <br/>
     * This is a convenience which creates an instance of the {@link CreateChangeSetRequest.Builder} avoiding the need
     * to create one manually via {@link CreateChangeSetRequest#builder()}
     *
     * @param createChangeSetRequest
     *        a {@link Consumer} that will call methods on {@link CreateChangeSetInput.Builder}.
     * @return A Java Future containing the result of the CreateChangeSet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AlreadyExistsException The resource with the name requested already exists.</li>
     *         <li>InsufficientCapabilitiesException The template contains resources with capabilities that weren't
     *         specified in the Capabilities parameter.</li>
     *         <li>LimitExceededException The quota for the resource has already been reached.</p>
     *         <p>
     *         For information on stack set limitations, see <a
     *         href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-limitations.html"
     *         >Limitations of StackSets</a>.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.CreateChangeSet
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/CreateChangeSet" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateChangeSetResponse> createChangeSet(
            Consumer<CreateChangeSetRequest.Builder> createChangeSetRequest) {
        return createChangeSet(CreateChangeSetRequest.builder().apply(createChangeSetRequest).build());
    }

    /**
     * <p>
     * Creates a stack as specified in the template. After the call completes successfully, the stack creation starts.
     * You can check the status of the stack via the <a>DescribeStacks</a> API.
     * </p>
     *
     * @param createStackRequest
     *        The input for <a>CreateStack</a> action.
     * @return A Java Future containing the result of the CreateStack operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>LimitExceededException The quota for the resource has already been reached.</p>
     *         <p>
     *         For information on stack set limitations, see <a
     *         href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-limitations.html"
     *         >Limitations of StackSets</a>.</li>
     *         <li>AlreadyExistsException The resource with the name requested already exists.</li>
     *         <li>TokenAlreadyExistsException A client request token already exists.</li>
     *         <li>InsufficientCapabilitiesException The template contains resources with capabilities that weren't
     *         specified in the Capabilities parameter.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.CreateStack
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/CreateStack" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateStackResponse> createStack(CreateStackRequest createStackRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a stack as specified in the template. After the call completes successfully, the stack creation starts.
     * You can check the status of the stack via the <a>DescribeStacks</a> API.
     * </p>
     * <br/>
     * This is a convenience which creates an instance of the {@link CreateStackRequest.Builder} avoiding the need to
     * create one manually via {@link CreateStackRequest#builder()}
     *
     * @param createStackRequest
     *        a {@link Consumer} that will call methods on {@link CreateStackInput.Builder}.
     * @return A Java Future containing the result of the CreateStack operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>LimitExceededException The quota for the resource has already been reached.</p>
     *         <p>
     *         For information on stack set limitations, see <a
     *         href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-limitations.html"
     *         >Limitations of StackSets</a>.</li>
     *         <li>AlreadyExistsException The resource with the name requested already exists.</li>
     *         <li>TokenAlreadyExistsException A client request token already exists.</li>
     *         <li>InsufficientCapabilitiesException The template contains resources with capabilities that weren't
     *         specified in the Capabilities parameter.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.CreateStack
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/CreateStack" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateStackResponse> createStack(Consumer<CreateStackRequest.Builder> createStackRequest) {
        return createStack(CreateStackRequest.builder().apply(createStackRequest).build());
    }

    /**
     * <p>
     * Creates stack instances for the specified accounts, within the specified regions. A stack instance refers to a
     * stack in a specific account and region. <code>Accounts</code> and <code>Regions</code> are required
     * parameters—you must specify at least one account and one region.
     * </p>
     *
     * @param createStackInstancesRequest
     * @return A Java Future containing the result of the CreateStackInstances operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>StackSetNotFoundException The specified stack set doesn't exist.</li>
     *         <li>OperationInProgressException Another operation is currently in progress for this stack set. Only one
     *         operation can be performed for a stack set at a given time.</li>
     *         <li>OperationIdAlreadyExistsException The specified operation ID already exists.</li>
     *         <li>StaleRequestException Another operation has been performed on this stack set since the specified
     *         operation was performed.</li>
     *         <li>InvalidOperationException The specified operation isn't valid.</li>
     *         <li>LimitExceededException The quota for the resource has already been reached.</p>
     *         <p>
     *         For information on stack set limitations, see <a
     *         href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-limitations.html"
     *         >Limitations of StackSets</a>.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.CreateStackInstances
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/CreateStackInstances"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateStackInstancesResponse> createStackInstances(
            CreateStackInstancesRequest createStackInstancesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates stack instances for the specified accounts, within the specified regions. A stack instance refers to a
     * stack in a specific account and region. <code>Accounts</code> and <code>Regions</code> are required
     * parameters—you must specify at least one account and one region.
     * </p>
     * <br/>
     * This is a convenience which creates an instance of the {@link CreateStackInstancesRequest.Builder} avoiding the
     * need to create one manually via {@link CreateStackInstancesRequest#builder()}
     *
     * @param createStackInstancesRequest
     *        a {@link Consumer} that will call methods on {@link CreateStackInstancesInput.Builder}.
     * @return A Java Future containing the result of the CreateStackInstances operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>StackSetNotFoundException The specified stack set doesn't exist.</li>
     *         <li>OperationInProgressException Another operation is currently in progress for this stack set. Only one
     *         operation can be performed for a stack set at a given time.</li>
     *         <li>OperationIdAlreadyExistsException The specified operation ID already exists.</li>
     *         <li>StaleRequestException Another operation has been performed on this stack set since the specified
     *         operation was performed.</li>
     *         <li>InvalidOperationException The specified operation isn't valid.</li>
     *         <li>LimitExceededException The quota for the resource has already been reached.</p>
     *         <p>
     *         For information on stack set limitations, see <a
     *         href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-limitations.html"
     *         >Limitations of StackSets</a>.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.CreateStackInstances
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/CreateStackInstances"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateStackInstancesResponse> createStackInstances(
            Consumer<CreateStackInstancesRequest.Builder> createStackInstancesRequest) {
        return createStackInstances(CreateStackInstancesRequest.builder().apply(createStackInstancesRequest).build());
    }

    /**
     * <p>
     * Creates a stack set.
     * </p>
     *
     * @param createStackSetRequest
     * @return A Java Future containing the result of the CreateStackSet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NameAlreadyExistsException The specified name is already in use.</li>
     *         <li>CreatedButModifiedException The specified resource exists, but has been changed.</li>
     *         <li>LimitExceededException The quota for the resource has already been reached.</p>
     *         <p>
     *         For information on stack set limitations, see <a
     *         href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-limitations.html"
     *         >Limitations of StackSets</a>.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.CreateStackSet
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/CreateStackSet" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateStackSetResponse> createStackSet(CreateStackSetRequest createStackSetRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a stack set.
     * </p>
     * <br/>
     * This is a convenience which creates an instance of the {@link CreateStackSetRequest.Builder} avoiding the need to
     * create one manually via {@link CreateStackSetRequest#builder()}
     *
     * @param createStackSetRequest
     *        a {@link Consumer} that will call methods on {@link CreateStackSetInput.Builder}.
     * @return A Java Future containing the result of the CreateStackSet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NameAlreadyExistsException The specified name is already in use.</li>
     *         <li>CreatedButModifiedException The specified resource exists, but has been changed.</li>
     *         <li>LimitExceededException The quota for the resource has already been reached.</p>
     *         <p>
     *         For information on stack set limitations, see <a
     *         href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-limitations.html"
     *         >Limitations of StackSets</a>.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.CreateStackSet
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/CreateStackSet" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateStackSetResponse> createStackSet(Consumer<CreateStackSetRequest.Builder> createStackSetRequest) {
        return createStackSet(CreateStackSetRequest.builder().apply(createStackSetRequest).build());
    }

    /**
     * <p>
     * Deletes the specified change set. Deleting change sets ensures that no one executes the wrong change set.
     * </p>
     * <p>
     * If the call successfully completes, AWS CloudFormation successfully deleted the change set.
     * </p>
     *
     * @param deleteChangeSetRequest
     *        The input for the <a>DeleteChangeSet</a> action.
     * @return A Java Future containing the result of the DeleteChangeSet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidChangeSetStatusException The specified change set can't be used to update the stack. For
     *         example, the change set status might be <code>CREATE_IN_PROGRESS</code>, or the stack status might be
     *         <code>UPDATE_IN_PROGRESS</code>.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.DeleteChangeSet
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DeleteChangeSet" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteChangeSetResponse> deleteChangeSet(DeleteChangeSetRequest deleteChangeSetRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified change set. Deleting change sets ensures that no one executes the wrong change set.
     * </p>
     * <p>
     * If the call successfully completes, AWS CloudFormation successfully deleted the change set.
     * </p>
     * <br/>
     * This is a convenience which creates an instance of the {@link DeleteChangeSetRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteChangeSetRequest#builder()}
     *
     * @param deleteChangeSetRequest
     *        a {@link Consumer} that will call methods on {@link DeleteChangeSetInput.Builder}.
     * @return A Java Future containing the result of the DeleteChangeSet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidChangeSetStatusException The specified change set can't be used to update the stack. For
     *         example, the change set status might be <code>CREATE_IN_PROGRESS</code>, or the stack status might be
     *         <code>UPDATE_IN_PROGRESS</code>.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.DeleteChangeSet
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DeleteChangeSet" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteChangeSetResponse> deleteChangeSet(
            Consumer<DeleteChangeSetRequest.Builder> deleteChangeSetRequest) {
        return deleteChangeSet(DeleteChangeSetRequest.builder().apply(deleteChangeSetRequest).build());
    }

    /**
     * <p>
     * Deletes a specified stack. Once the call completes successfully, stack deletion starts. Deleted stacks do not
     * show up in the <a>DescribeStacks</a> API if the deletion has been completed successfully.
     * </p>
     *
     * @param deleteStackRequest
     *        The input for <a>DeleteStack</a> action.
     * @return A Java Future containing the result of the DeleteStack operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>TokenAlreadyExistsException A client request token already exists.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.DeleteStack
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DeleteStack" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteStackResponse> deleteStack(DeleteStackRequest deleteStackRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a specified stack. Once the call completes successfully, stack deletion starts. Deleted stacks do not
     * show up in the <a>DescribeStacks</a> API if the deletion has been completed successfully.
     * </p>
     * <br/>
     * This is a convenience which creates an instance of the {@link DeleteStackRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteStackRequest#builder()}
     *
     * @param deleteStackRequest
     *        a {@link Consumer} that will call methods on {@link DeleteStackInput.Builder}.
     * @return A Java Future containing the result of the DeleteStack operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>TokenAlreadyExistsException A client request token already exists.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.DeleteStack
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DeleteStack" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteStackResponse> deleteStack(Consumer<DeleteStackRequest.Builder> deleteStackRequest) {
        return deleteStack(DeleteStackRequest.builder().apply(deleteStackRequest).build());
    }

    /**
     * <p>
     * Deletes stack instances for the specified accounts, in the specified regions.
     * </p>
     *
     * @param deleteStackInstancesRequest
     * @return A Java Future containing the result of the DeleteStackInstances operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>StackSetNotFoundException The specified stack set doesn't exist.</li>
     *         <li>OperationInProgressException Another operation is currently in progress for this stack set. Only one
     *         operation can be performed for a stack set at a given time.</li>
     *         <li>OperationIdAlreadyExistsException The specified operation ID already exists.</li>
     *         <li>StaleRequestException Another operation has been performed on this stack set since the specified
     *         operation was performed.</li>
     *         <li>InvalidOperationException The specified operation isn't valid.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.DeleteStackInstances
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DeleteStackInstances"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteStackInstancesResponse> deleteStackInstances(
            DeleteStackInstancesRequest deleteStackInstancesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes stack instances for the specified accounts, in the specified regions.
     * </p>
     * <br/>
     * This is a convenience which creates an instance of the {@link DeleteStackInstancesRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteStackInstancesRequest#builder()}
     *
     * @param deleteStackInstancesRequest
     *        a {@link Consumer} that will call methods on {@link DeleteStackInstancesInput.Builder}.
     * @return A Java Future containing the result of the DeleteStackInstances operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>StackSetNotFoundException The specified stack set doesn't exist.</li>
     *         <li>OperationInProgressException Another operation is currently in progress for this stack set. Only one
     *         operation can be performed for a stack set at a given time.</li>
     *         <li>OperationIdAlreadyExistsException The specified operation ID already exists.</li>
     *         <li>StaleRequestException Another operation has been performed on this stack set since the specified
     *         operation was performed.</li>
     *         <li>InvalidOperationException The specified operation isn't valid.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.DeleteStackInstances
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DeleteStackInstances"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteStackInstancesResponse> deleteStackInstances(
            Consumer<DeleteStackInstancesRequest.Builder> deleteStackInstancesRequest) {
        return deleteStackInstances(DeleteStackInstancesRequest.builder().apply(deleteStackInstancesRequest).build());
    }

    /**
     * <p>
     * Deletes a stack set. Before you can delete a stack set, all of its member stack instances must be deleted. For
     * more information about how to do this, see <a>DeleteStackInstances</a>.
     * </p>
     *
     * @param deleteStackSetRequest
     * @return A Java Future containing the result of the DeleteStackSet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>StackSetNotEmptyException You can't yet delete this stack set, because it still contains one or more
     *         stack instances. Delete all stack instances from the stack set before deleting the stack set.</li>
     *         <li>OperationInProgressException Another operation is currently in progress for this stack set. Only one
     *         operation can be performed for a stack set at a given time.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.DeleteStackSet
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DeleteStackSet" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteStackSetResponse> deleteStackSet(DeleteStackSetRequest deleteStackSetRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a stack set. Before you can delete a stack set, all of its member stack instances must be deleted. For
     * more information about how to do this, see <a>DeleteStackInstances</a>.
     * </p>
     * <br/>
     * This is a convenience which creates an instance of the {@link DeleteStackSetRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteStackSetRequest#builder()}
     *
     * @param deleteStackSetRequest
     *        a {@link Consumer} that will call methods on {@link DeleteStackSetInput.Builder}.
     * @return A Java Future containing the result of the DeleteStackSet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>StackSetNotEmptyException You can't yet delete this stack set, because it still contains one or more
     *         stack instances. Delete all stack instances from the stack set before deleting the stack set.</li>
     *         <li>OperationInProgressException Another operation is currently in progress for this stack set. Only one
     *         operation can be performed for a stack set at a given time.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.DeleteStackSet
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DeleteStackSet" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteStackSetResponse> deleteStackSet(Consumer<DeleteStackSetRequest.Builder> deleteStackSetRequest) {
        return deleteStackSet(DeleteStackSetRequest.builder().apply(deleteStackSetRequest).build());
    }

    /**
     * <p>
     * Retrieves your account's AWS CloudFormation limits, such as the maximum number of stacks that you can create in
     * your account.
     * </p>
     *
     * @param describeAccountLimitsRequest
     *        The input for the <a>DescribeAccountLimits</a> action.
     * @return A Java Future containing the result of the DescribeAccountLimits operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.DescribeAccountLimits
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribeAccountLimits"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeAccountLimitsResponse> describeAccountLimits(
            DescribeAccountLimitsRequest describeAccountLimitsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves your account's AWS CloudFormation limits, such as the maximum number of stacks that you can create in
     * your account.
     * </p>
     *
     * @return A Java Future containing the result of the DescribeAccountLimits operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.DescribeAccountLimits
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribeAccountLimits"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeAccountLimitsResponse> describeAccountLimits() {
        return describeAccountLimits(DescribeAccountLimitsRequest.builder().build());
    }

    /**
     * <p>
     * Retrieves your account's AWS CloudFormation limits, such as the maximum number of stacks that you can create in
     * your account.
     * </p>
     * <br/>
     * This is a convenience which creates an instance of the {@link DescribeAccountLimitsRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeAccountLimitsRequest#builder()}
     *
     * @param describeAccountLimitsRequest
     *        a {@link Consumer} that will call methods on {@link DescribeAccountLimitsInput.Builder}.
     * @return A Java Future containing the result of the DescribeAccountLimits operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.DescribeAccountLimits
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribeAccountLimits"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeAccountLimitsResponse> describeAccountLimits(
            Consumer<DescribeAccountLimitsRequest.Builder> describeAccountLimitsRequest) {
        return describeAccountLimits(DescribeAccountLimitsRequest.builder().apply(describeAccountLimitsRequest).build());
    }

    /**
     * <p>
     * Returns the inputs for the change set and a list of changes that AWS CloudFormation will make if you execute the
     * change set. For more information, see <a
     * href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-updating-stacks-changesets.html"
     * >Updating Stacks Using Change Sets</a> in the AWS CloudFormation User Guide.
     * </p>
     *
     * @param describeChangeSetRequest
     *        The input for the <a>DescribeChangeSet</a> action.
     * @return A Java Future containing the result of the DescribeChangeSet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ChangeSetNotFoundException The specified change set name or ID doesn't exit. To view valid change
     *         sets for a stack, use the <code>ListChangeSets</code> action.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.DescribeChangeSet
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribeChangeSet"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeChangeSetResponse> describeChangeSet(DescribeChangeSetRequest describeChangeSetRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the inputs for the change set and a list of changes that AWS CloudFormation will make if you execute the
     * change set. For more information, see <a
     * href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-updating-stacks-changesets.html"
     * >Updating Stacks Using Change Sets</a> in the AWS CloudFormation User Guide.
     * </p>
     * <br/>
     * This is a convenience which creates an instance of the {@link DescribeChangeSetRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeChangeSetRequest#builder()}
     *
     * @param describeChangeSetRequest
     *        a {@link Consumer} that will call methods on {@link DescribeChangeSetInput.Builder}.
     * @return A Java Future containing the result of the DescribeChangeSet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ChangeSetNotFoundException The specified change set name or ID doesn't exit. To view valid change
     *         sets for a stack, use the <code>ListChangeSets</code> action.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.DescribeChangeSet
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribeChangeSet"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeChangeSetResponse> describeChangeSet(
            Consumer<DescribeChangeSetRequest.Builder> describeChangeSetRequest) {
        return describeChangeSet(DescribeChangeSetRequest.builder().apply(describeChangeSetRequest).build());
    }

    /**
     * <p>
     * Returns all stack related events for a specified stack in reverse chronological order. For more information about
     * a stack's event history, go to <a
     * href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/concept-stack.html">Stacks</a> in the AWS
     * CloudFormation User Guide.
     * </p>
     * <note>
     * <p>
     * You can list events for stacks that have failed to create or have been deleted by specifying the unique stack
     * identifier (stack ID).
     * </p>
     * </note>
     *
     * @param describeStackEventsRequest
     *        The input for <a>DescribeStackEvents</a> action.
     * @return A Java Future containing the result of the DescribeStackEvents operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.DescribeStackEvents
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribeStackEvents"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeStackEventsResponse> describeStackEvents(
            DescribeStackEventsRequest describeStackEventsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns all stack related events for a specified stack in reverse chronological order. For more information about
     * a stack's event history, go to <a
     * href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/concept-stack.html">Stacks</a> in the AWS
     * CloudFormation User Guide.
     * </p>
     * <note>
     * <p>
     * You can list events for stacks that have failed to create or have been deleted by specifying the unique stack
     * identifier (stack ID).
     * </p>
     * </note><br/>
     * This is a convenience which creates an instance of the {@link DescribeStackEventsRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeStackEventsRequest#builder()}
     *
     * @param describeStackEventsRequest
     *        a {@link Consumer} that will call methods on {@link DescribeStackEventsInput.Builder}.
     * @return A Java Future containing the result of the DescribeStackEvents operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.DescribeStackEvents
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribeStackEvents"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeStackEventsResponse> describeStackEvents(
            Consumer<DescribeStackEventsRequest.Builder> describeStackEventsRequest) {
        return describeStackEvents(DescribeStackEventsRequest.builder().apply(describeStackEventsRequest).build());
    }

    /**
     * <p>
     * Returns the stack instance that's associated with the specified stack set, AWS account, and region.
     * </p>
     * <p>
     * For a list of stack instances that are associated with a specific stack set, use <a>ListStackInstances</a>.
     * </p>
     *
     * @param describeStackInstanceRequest
     * @return A Java Future containing the result of the DescribeStackInstance operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>StackSetNotFoundException The specified stack set doesn't exist.</li>
     *         <li>StackInstanceNotFoundException The specified stack instance doesn't exist.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.DescribeStackInstance
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribeStackInstance"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeStackInstanceResponse> describeStackInstance(
            DescribeStackInstanceRequest describeStackInstanceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the stack instance that's associated with the specified stack set, AWS account, and region.
     * </p>
     * <p>
     * For a list of stack instances that are associated with a specific stack set, use <a>ListStackInstances</a>.
     * </p>
     * <br/>
     * This is a convenience which creates an instance of the {@link DescribeStackInstanceRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeStackInstanceRequest#builder()}
     *
     * @param describeStackInstanceRequest
     *        a {@link Consumer} that will call methods on {@link DescribeStackInstanceInput.Builder}.
     * @return A Java Future containing the result of the DescribeStackInstance operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>StackSetNotFoundException The specified stack set doesn't exist.</li>
     *         <li>StackInstanceNotFoundException The specified stack instance doesn't exist.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.DescribeStackInstance
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribeStackInstance"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeStackInstanceResponse> describeStackInstance(
            Consumer<DescribeStackInstanceRequest.Builder> describeStackInstanceRequest) {
        return describeStackInstance(DescribeStackInstanceRequest.builder().apply(describeStackInstanceRequest).build());
    }

    /**
     * <p>
     * Returns a description of the specified resource in the specified stack.
     * </p>
     * <p>
     * For deleted stacks, DescribeStackResource returns resource information for up to 90 days after the stack has been
     * deleted.
     * </p>
     *
     * @param describeStackResourceRequest
     *        The input for <a>DescribeStackResource</a> action.
     * @return A Java Future containing the result of the DescribeStackResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.DescribeStackResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribeStackResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeStackResourceResponse> describeStackResource(
            DescribeStackResourceRequest describeStackResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a description of the specified resource in the specified stack.
     * </p>
     * <p>
     * For deleted stacks, DescribeStackResource returns resource information for up to 90 days after the stack has been
     * deleted.
     * </p>
     * <br/>
     * This is a convenience which creates an instance of the {@link DescribeStackResourceRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeStackResourceRequest#builder()}
     *
     * @param describeStackResourceRequest
     *        a {@link Consumer} that will call methods on {@link DescribeStackResourceInput.Builder}.
     * @return A Java Future containing the result of the DescribeStackResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.DescribeStackResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribeStackResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeStackResourceResponse> describeStackResource(
            Consumer<DescribeStackResourceRequest.Builder> describeStackResourceRequest) {
        return describeStackResource(DescribeStackResourceRequest.builder().apply(describeStackResourceRequest).build());
    }

    /**
     * <p>
     * Returns AWS resource descriptions for running and deleted stacks. If <code>StackName</code> is specified, all the
     * associated resources that are part of the stack are returned. If <code>PhysicalResourceId</code> is specified,
     * the associated resources of the stack that the resource belongs to are returned.
     * </p>
     * <note>
     * <p>
     * Only the first 100 resources will be returned. If your stack has more resources than this, you should use
     * <code>ListStackResources</code> instead.
     * </p>
     * </note>
     * <p>
     * For deleted stacks, <code>DescribeStackResources</code> returns resource information for up to 90 days after the
     * stack has been deleted.
     * </p>
     * <p>
     * You must specify either <code>StackName</code> or <code>PhysicalResourceId</code>, but not both. In addition, you
     * can specify <code>LogicalResourceId</code> to filter the returned result. For more information about resources,
     * the <code>LogicalResourceId</code> and <code>PhysicalResourceId</code>, go to the <a
     * href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/">AWS CloudFormation User Guide</a>.
     * </p>
     * <note>
     * <p>
     * A <code>ValidationError</code> is returned if you specify both <code>StackName</code> and
     * <code>PhysicalResourceId</code> in the same request.
     * </p>
     * </note>
     *
     * @param describeStackResourcesRequest
     *        The input for <a>DescribeStackResources</a> action.
     * @return A Java Future containing the result of the DescribeStackResources operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.DescribeStackResources
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribeStackResources"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeStackResourcesResponse> describeStackResources(
            DescribeStackResourcesRequest describeStackResourcesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns AWS resource descriptions for running and deleted stacks. If <code>StackName</code> is specified, all the
     * associated resources that are part of the stack are returned. If <code>PhysicalResourceId</code> is specified,
     * the associated resources of the stack that the resource belongs to are returned.
     * </p>
     * <note>
     * <p>
     * Only the first 100 resources will be returned. If your stack has more resources than this, you should use
     * <code>ListStackResources</code> instead.
     * </p>
     * </note>
     * <p>
     * For deleted stacks, <code>DescribeStackResources</code> returns resource information for up to 90 days after the
     * stack has been deleted.
     * </p>
     * <p>
     * You must specify either <code>StackName</code> or <code>PhysicalResourceId</code>, but not both. In addition, you
     * can specify <code>LogicalResourceId</code> to filter the returned result. For more information about resources,
     * the <code>LogicalResourceId</code> and <code>PhysicalResourceId</code>, go to the <a
     * href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/">AWS CloudFormation User Guide</a>.
     * </p>
     * <note>
     * <p>
     * A <code>ValidationError</code> is returned if you specify both <code>StackName</code> and
     * <code>PhysicalResourceId</code> in the same request.
     * </p>
     * </note><br/>
     * This is a convenience which creates an instance of the {@link DescribeStackResourcesRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeStackResourcesRequest#builder()}
     *
     * @param describeStackResourcesRequest
     *        a {@link Consumer} that will call methods on {@link DescribeStackResourcesInput.Builder}.
     * @return A Java Future containing the result of the DescribeStackResources operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.DescribeStackResources
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribeStackResources"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeStackResourcesResponse> describeStackResources(
            Consumer<DescribeStackResourcesRequest.Builder> describeStackResourcesRequest) {
        return describeStackResources(DescribeStackResourcesRequest.builder().apply(describeStackResourcesRequest).build());
    }

    /**
     * <p>
     * Returns the description of the specified stack set.
     * </p>
     *
     * @param describeStackSetRequest
     * @return A Java Future containing the result of the DescribeStackSet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>StackSetNotFoundException The specified stack set doesn't exist.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.DescribeStackSet
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribeStackSet"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeStackSetResponse> describeStackSet(DescribeStackSetRequest describeStackSetRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the description of the specified stack set.
     * </p>
     * <br/>
     * This is a convenience which creates an instance of the {@link DescribeStackSetRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeStackSetRequest#builder()}
     *
     * @param describeStackSetRequest
     *        a {@link Consumer} that will call methods on {@link DescribeStackSetInput.Builder}.
     * @return A Java Future containing the result of the DescribeStackSet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>StackSetNotFoundException The specified stack set doesn't exist.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.DescribeStackSet
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribeStackSet"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeStackSetResponse> describeStackSet(
            Consumer<DescribeStackSetRequest.Builder> describeStackSetRequest) {
        return describeStackSet(DescribeStackSetRequest.builder().apply(describeStackSetRequest).build());
    }

    /**
     * <p>
     * Returns the description of the specified stack set operation.
     * </p>
     *
     * @param describeStackSetOperationRequest
     * @return A Java Future containing the result of the DescribeStackSetOperation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>StackSetNotFoundException The specified stack set doesn't exist.</li>
     *         <li>OperationNotFoundException The specified ID refers to an operation that doesn't exist.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.DescribeStackSetOperation
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribeStackSetOperation"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeStackSetOperationResponse> describeStackSetOperation(
            DescribeStackSetOperationRequest describeStackSetOperationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the description of the specified stack set operation.
     * </p>
     * <br/>
     * This is a convenience which creates an instance of the {@link DescribeStackSetOperationRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeStackSetOperationRequest#builder()}
     *
     * @param describeStackSetOperationRequest
     *        a {@link Consumer} that will call methods on {@link DescribeStackSetOperationInput.Builder}.
     * @return A Java Future containing the result of the DescribeStackSetOperation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>StackSetNotFoundException The specified stack set doesn't exist.</li>
     *         <li>OperationNotFoundException The specified ID refers to an operation that doesn't exist.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.DescribeStackSetOperation
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribeStackSetOperation"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeStackSetOperationResponse> describeStackSetOperation(
            Consumer<DescribeStackSetOperationRequest.Builder> describeStackSetOperationRequest) {
        return describeStackSetOperation(DescribeStackSetOperationRequest.builder().apply(describeStackSetOperationRequest)
                .build());
    }

    /**
     * <p>
     * Returns the description for the specified stack; if no stack name was specified, then it returns the description
     * for all the stacks created.
     * </p>
     * <note>
     * <p>
     * If the stack does not exist, an <code>AmazonCloudFormationException</code> is returned.
     * </p>
     * </note>
     *
     * @param describeStacksRequest
     *        The input for <a>DescribeStacks</a> action.
     * @return A Java Future containing the result of the DescribeStacks operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.DescribeStacks
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribeStacks" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeStacksResponse> describeStacks(DescribeStacksRequest describeStacksRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the description for the specified stack; if no stack name was specified, then it returns the description
     * for all the stacks created.
     * </p>
     * <note>
     * <p>
     * If the stack does not exist, an <code>AmazonCloudFormationException</code> is returned.
     * </p>
     * </note>
     *
     * @return A Java Future containing the result of the DescribeStacks operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.DescribeStacks
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribeStacks" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeStacksResponse> describeStacks() {
        return describeStacks(DescribeStacksRequest.builder().build());
    }

    /**
     * <p>
     * Returns the description for the specified stack; if no stack name was specified, then it returns the description
     * for all the stacks created.
     * </p>
     * <note>
     * <p>
     * If the stack does not exist, an <code>AmazonCloudFormationException</code> is returned.
     * </p>
     * </note><br/>
     * This is a convenience which creates an instance of the {@link DescribeStacksRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeStacksRequest#builder()}
     *
     * @param describeStacksRequest
     *        a {@link Consumer} that will call methods on {@link DescribeStacksInput.Builder}.
     * @return A Java Future containing the result of the DescribeStacks operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.DescribeStacks
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribeStacks" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeStacksResponse> describeStacks(Consumer<DescribeStacksRequest.Builder> describeStacksRequest) {
        return describeStacks(DescribeStacksRequest.builder().apply(describeStacksRequest).build());
    }

    /**
     * <p>
     * Returns the estimated monthly cost of a template. The return value is an AWS Simple Monthly Calculator URL with a
     * query string that describes the resources required to run the template.
     * </p>
     *
     * @param estimateTemplateCostRequest
     *        The input for an <a>EstimateTemplateCost</a> action.
     * @return A Java Future containing the result of the EstimateTemplateCost operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.EstimateTemplateCost
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/EstimateTemplateCost"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<EstimateTemplateCostResponse> estimateTemplateCost(
            EstimateTemplateCostRequest estimateTemplateCostRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the estimated monthly cost of a template. The return value is an AWS Simple Monthly Calculator URL with a
     * query string that describes the resources required to run the template.
     * </p>
     * <br/>
     * This is a convenience which creates an instance of the {@link EstimateTemplateCostRequest.Builder} avoiding the
     * need to create one manually via {@link EstimateTemplateCostRequest#builder()}
     *
     * @param estimateTemplateCostRequest
     *        a {@link Consumer} that will call methods on {@link EstimateTemplateCostInput.Builder}.
     * @return A Java Future containing the result of the EstimateTemplateCost operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.EstimateTemplateCost
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/EstimateTemplateCost"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<EstimateTemplateCostResponse> estimateTemplateCost(
            Consumer<EstimateTemplateCostRequest.Builder> estimateTemplateCostRequest) {
        return estimateTemplateCost(EstimateTemplateCostRequest.builder().apply(estimateTemplateCostRequest).build());
    }

    /**
     * <p>
     * Updates a stack using the input information that was provided when the specified change set was created. After
     * the call successfully completes, AWS CloudFormation starts updating the stack. Use the <a>DescribeStacks</a>
     * action to view the status of the update.
     * </p>
     * <p>
     * When you execute a change set, AWS CloudFormation deletes all other change sets associated with the stack because
     * they aren't valid for the updated stack.
     * </p>
     * <p>
     * If a stack policy is associated with the stack, AWS CloudFormation enforces the policy during the update. You
     * can't specify a temporary stack policy that overrides the current policy.
     * </p>
     *
     * @param executeChangeSetRequest
     *        The input for the <a>ExecuteChangeSet</a> action.
     * @return A Java Future containing the result of the ExecuteChangeSet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidChangeSetStatusException The specified change set can't be used to update the stack. For
     *         example, the change set status might be <code>CREATE_IN_PROGRESS</code>, or the stack status might be
     *         <code>UPDATE_IN_PROGRESS</code>.</li>
     *         <li>ChangeSetNotFoundException The specified change set name or ID doesn't exit. To view valid change
     *         sets for a stack, use the <code>ListChangeSets</code> action.</li>
     *         <li>InsufficientCapabilitiesException The template contains resources with capabilities that weren't
     *         specified in the Capabilities parameter.</li>
     *         <li>TokenAlreadyExistsException A client request token already exists.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.ExecuteChangeSet
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ExecuteChangeSet"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ExecuteChangeSetResponse> executeChangeSet(ExecuteChangeSetRequest executeChangeSetRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a stack using the input information that was provided when the specified change set was created. After
     * the call successfully completes, AWS CloudFormation starts updating the stack. Use the <a>DescribeStacks</a>
     * action to view the status of the update.
     * </p>
     * <p>
     * When you execute a change set, AWS CloudFormation deletes all other change sets associated with the stack because
     * they aren't valid for the updated stack.
     * </p>
     * <p>
     * If a stack policy is associated with the stack, AWS CloudFormation enforces the policy during the update. You
     * can't specify a temporary stack policy that overrides the current policy.
     * </p>
     * <br/>
     * This is a convenience which creates an instance of the {@link ExecuteChangeSetRequest.Builder} avoiding the need
     * to create one manually via {@link ExecuteChangeSetRequest#builder()}
     *
     * @param executeChangeSetRequest
     *        a {@link Consumer} that will call methods on {@link ExecuteChangeSetInput.Builder}.
     * @return A Java Future containing the result of the ExecuteChangeSet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidChangeSetStatusException The specified change set can't be used to update the stack. For
     *         example, the change set status might be <code>CREATE_IN_PROGRESS</code>, or the stack status might be
     *         <code>UPDATE_IN_PROGRESS</code>.</li>
     *         <li>ChangeSetNotFoundException The specified change set name or ID doesn't exit. To view valid change
     *         sets for a stack, use the <code>ListChangeSets</code> action.</li>
     *         <li>InsufficientCapabilitiesException The template contains resources with capabilities that weren't
     *         specified in the Capabilities parameter.</li>
     *         <li>TokenAlreadyExistsException A client request token already exists.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.ExecuteChangeSet
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ExecuteChangeSet"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ExecuteChangeSetResponse> executeChangeSet(
            Consumer<ExecuteChangeSetRequest.Builder> executeChangeSetRequest) {
        return executeChangeSet(ExecuteChangeSetRequest.builder().apply(executeChangeSetRequest).build());
    }

    /**
     * <p>
     * Returns the stack policy for a specified stack. If a stack doesn't have a policy, a null value is returned.
     * </p>
     *
     * @param getStackPolicyRequest
     *        The input for the <a>GetStackPolicy</a> action.
     * @return A Java Future containing the result of the GetStackPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.GetStackPolicy
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/GetStackPolicy" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetStackPolicyResponse> getStackPolicy(GetStackPolicyRequest getStackPolicyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the stack policy for a specified stack. If a stack doesn't have a policy, a null value is returned.
     * </p>
     * <br/>
     * This is a convenience which creates an instance of the {@link GetStackPolicyRequest.Builder} avoiding the need to
     * create one manually via {@link GetStackPolicyRequest#builder()}
     *
     * @param getStackPolicyRequest
     *        a {@link Consumer} that will call methods on {@link GetStackPolicyInput.Builder}.
     * @return A Java Future containing the result of the GetStackPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.GetStackPolicy
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/GetStackPolicy" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetStackPolicyResponse> getStackPolicy(Consumer<GetStackPolicyRequest.Builder> getStackPolicyRequest) {
        return getStackPolicy(GetStackPolicyRequest.builder().apply(getStackPolicyRequest).build());
    }

    /**
     * <p>
     * Returns the template body for a specified stack. You can get the template for running or deleted stacks.
     * </p>
     * <p>
     * For deleted stacks, GetTemplate returns the template for up to 90 days after the stack has been deleted.
     * </p>
     * <note>
     * <p>
     * If the template does not exist, a <code>ValidationError</code> is returned.
     * </p>
     * </note>
     *
     * @param getTemplateRequest
     *        The input for a <a>GetTemplate</a> action.
     * @return A Java Future containing the result of the GetTemplate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ChangeSetNotFoundException The specified change set name or ID doesn't exit. To view valid change
     *         sets for a stack, use the <code>ListChangeSets</code> action.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.GetTemplate
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/GetTemplate" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetTemplateResponse> getTemplate(GetTemplateRequest getTemplateRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the template body for a specified stack. You can get the template for running or deleted stacks.
     * </p>
     * <p>
     * For deleted stacks, GetTemplate returns the template for up to 90 days after the stack has been deleted.
     * </p>
     * <note>
     * <p>
     * If the template does not exist, a <code>ValidationError</code> is returned.
     * </p>
     * </note><br/>
     * This is a convenience which creates an instance of the {@link GetTemplateRequest.Builder} avoiding the need to
     * create one manually via {@link GetTemplateRequest#builder()}
     *
     * @param getTemplateRequest
     *        a {@link Consumer} that will call methods on {@link GetTemplateInput.Builder}.
     * @return A Java Future containing the result of the GetTemplate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ChangeSetNotFoundException The specified change set name or ID doesn't exit. To view valid change
     *         sets for a stack, use the <code>ListChangeSets</code> action.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.GetTemplate
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/GetTemplate" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetTemplateResponse> getTemplate(Consumer<GetTemplateRequest.Builder> getTemplateRequest) {
        return getTemplate(GetTemplateRequest.builder().apply(getTemplateRequest).build());
    }

    /**
     * <p>
     * Returns information about a new or existing template. The <code>GetTemplateSummary</code> action is useful for
     * viewing parameter information, such as default parameter values and parameter types, before you create or update
     * a stack or stack set.
     * </p>
     * <p>
     * You can use the <code>GetTemplateSummary</code> action when you submit a template, or you can get template
     * information for a stack set, or a running or deleted stack.
     * </p>
     * <p>
     * For deleted stacks, <code>GetTemplateSummary</code> returns the template information for up to 90 days after the
     * stack has been deleted. If the template does not exist, a <code>ValidationError</code> is returned.
     * </p>
     *
     * @param getTemplateSummaryRequest
     *        The input for the <a>GetTemplateSummary</a> action.
     * @return A Java Future containing the result of the GetTemplateSummary operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>StackSetNotFoundException The specified stack set doesn't exist.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.GetTemplateSummary
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/GetTemplateSummary"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetTemplateSummaryResponse> getTemplateSummary(GetTemplateSummaryRequest getTemplateSummaryRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about a new or existing template. The <code>GetTemplateSummary</code> action is useful for
     * viewing parameter information, such as default parameter values and parameter types, before you create or update
     * a stack or stack set.
     * </p>
     * <p>
     * You can use the <code>GetTemplateSummary</code> action when you submit a template, or you can get template
     * information for a stack set, or a running or deleted stack.
     * </p>
     * <p>
     * For deleted stacks, <code>GetTemplateSummary</code> returns the template information for up to 90 days after the
     * stack has been deleted. If the template does not exist, a <code>ValidationError</code> is returned.
     * </p>
     * <br/>
     * This is a convenience which creates an instance of the {@link GetTemplateSummaryRequest.Builder} avoiding the
     * need to create one manually via {@link GetTemplateSummaryRequest#builder()}
     *
     * @param getTemplateSummaryRequest
     *        a {@link Consumer} that will call methods on {@link GetTemplateSummaryInput.Builder}.
     * @return A Java Future containing the result of the GetTemplateSummary operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>StackSetNotFoundException The specified stack set doesn't exist.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.GetTemplateSummary
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/GetTemplateSummary"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetTemplateSummaryResponse> getTemplateSummary(
            Consumer<GetTemplateSummaryRequest.Builder> getTemplateSummaryRequest) {
        return getTemplateSummary(GetTemplateSummaryRequest.builder().apply(getTemplateSummaryRequest).build());
    }

    /**
     * <p>
     * Returns the ID and status of each active change set for a stack. For example, AWS CloudFormation lists change
     * sets that are in the <code>CREATE_IN_PROGRESS</code> or <code>CREATE_PENDING</code> state.
     * </p>
     *
     * @param listChangeSetsRequest
     *        The input for the <a>ListChangeSets</a> action.
     * @return A Java Future containing the result of the ListChangeSets operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.ListChangeSets
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListChangeSets" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListChangeSetsResponse> listChangeSets(ListChangeSetsRequest listChangeSetsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the ID and status of each active change set for a stack. For example, AWS CloudFormation lists change
     * sets that are in the <code>CREATE_IN_PROGRESS</code> or <code>CREATE_PENDING</code> state.
     * </p>
     * <br/>
     * This is a convenience which creates an instance of the {@link ListChangeSetsRequest.Builder} avoiding the need to
     * create one manually via {@link ListChangeSetsRequest#builder()}
     *
     * @param listChangeSetsRequest
     *        a {@link Consumer} that will call methods on {@link ListChangeSetsInput.Builder}.
     * @return A Java Future containing the result of the ListChangeSets operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.ListChangeSets
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListChangeSets" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListChangeSetsResponse> listChangeSets(Consumer<ListChangeSetsRequest.Builder> listChangeSetsRequest) {
        return listChangeSets(ListChangeSetsRequest.builder().apply(listChangeSetsRequest).build());
    }

    /**
     * <p>
     * Lists all exported output values in the account and region in which you call this action. Use this action to see
     * the exported output values that you can import into other stacks. To import values, use the <a href=
     * "http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/intrinsic-function-reference-importvalue.html">
     * <code>Fn::ImportValue</code> </a> function.
     * </p>
     * <p>
     * For more information, see <a
     * href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-stack-exports.html"> AWS
     * CloudFormation Export Stack Output Values</a>.
     * </p>
     *
     * @param listExportsRequest
     * @return A Java Future containing the result of the ListExports operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.ListExports
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListExports" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListExportsResponse> listExports(ListExportsRequest listExportsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all exported output values in the account and region in which you call this action. Use this action to see
     * the exported output values that you can import into other stacks. To import values, use the <a href=
     * "http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/intrinsic-function-reference-importvalue.html">
     * <code>Fn::ImportValue</code> </a> function.
     * </p>
     * <p>
     * For more information, see <a
     * href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-stack-exports.html"> AWS
     * CloudFormation Export Stack Output Values</a>.
     * </p>
     *
     * @return A Java Future containing the result of the ListExports operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.ListExports
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListExports" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListExportsResponse> listExports() {
        return listExports(ListExportsRequest.builder().build());
    }

    /**
     * <p>
     * Lists all exported output values in the account and region in which you call this action. Use this action to see
     * the exported output values that you can import into other stacks. To import values, use the <a href=
     * "http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/intrinsic-function-reference-importvalue.html">
     * <code>Fn::ImportValue</code> </a> function.
     * </p>
     * <p>
     * For more information, see <a
     * href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-stack-exports.html"> AWS
     * CloudFormation Export Stack Output Values</a>.
     * </p>
     * <br/>
     * This is a convenience which creates an instance of the {@link ListExportsRequest.Builder} avoiding the need to
     * create one manually via {@link ListExportsRequest#builder()}
     *
     * @param listExportsRequest
     *        a {@link Consumer} that will call methods on {@link ListExportsInput.Builder}.
     * @return A Java Future containing the result of the ListExports operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.ListExports
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListExports" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListExportsResponse> listExports(Consumer<ListExportsRequest.Builder> listExportsRequest) {
        return listExports(ListExportsRequest.builder().apply(listExportsRequest).build());
    }

    /**
     * <p>
     * Lists all stacks that are importing an exported output value. To modify or remove an exported output value, first
     * use this action to see which stacks are using it. To see the exported output values in your account, see
     * <a>ListExports</a>.
     * </p>
     * <p>
     * For more information about importing an exported output value, see the <a href=
     * "http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/intrinsic-function-reference-importvalue.html">
     * <code>Fn::ImportValue</code> </a> function.
     * </p>
     *
     * @param listImportsRequest
     * @return A Java Future containing the result of the ListImports operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.ListImports
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListImports" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListImportsResponse> listImports(ListImportsRequest listImportsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all stacks that are importing an exported output value. To modify or remove an exported output value, first
     * use this action to see which stacks are using it. To see the exported output values in your account, see
     * <a>ListExports</a>.
     * </p>
     * <p>
     * For more information about importing an exported output value, see the <a href=
     * "http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/intrinsic-function-reference-importvalue.html">
     * <code>Fn::ImportValue</code> </a> function.
     * </p>
     * <br/>
     * This is a convenience which creates an instance of the {@link ListImportsRequest.Builder} avoiding the need to
     * create one manually via {@link ListImportsRequest#builder()}
     *
     * @param listImportsRequest
     *        a {@link Consumer} that will call methods on {@link ListImportsInput.Builder}.
     * @return A Java Future containing the result of the ListImports operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.ListImports
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListImports" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListImportsResponse> listImports(Consumer<ListImportsRequest.Builder> listImportsRequest) {
        return listImports(ListImportsRequest.builder().apply(listImportsRequest).build());
    }

    /**
     * <p>
     * Returns summary information about stack instances that are associated with the specified stack set. You can
     * filter for stack instances that are associated with a specific AWS account name or region.
     * </p>
     *
     * @param listStackInstancesRequest
     * @return A Java Future containing the result of the ListStackInstances operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>StackSetNotFoundException The specified stack set doesn't exist.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.ListStackInstances
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListStackInstances"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListStackInstancesResponse> listStackInstances(ListStackInstancesRequest listStackInstancesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns summary information about stack instances that are associated with the specified stack set. You can
     * filter for stack instances that are associated with a specific AWS account name or region.
     * </p>
     * <br/>
     * This is a convenience which creates an instance of the {@link ListStackInstancesRequest.Builder} avoiding the
     * need to create one manually via {@link ListStackInstancesRequest#builder()}
     *
     * @param listStackInstancesRequest
     *        a {@link Consumer} that will call methods on {@link ListStackInstancesInput.Builder}.
     * @return A Java Future containing the result of the ListStackInstances operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>StackSetNotFoundException The specified stack set doesn't exist.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.ListStackInstances
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListStackInstances"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListStackInstancesResponse> listStackInstances(
            Consumer<ListStackInstancesRequest.Builder> listStackInstancesRequest) {
        return listStackInstances(ListStackInstancesRequest.builder().apply(listStackInstancesRequest).build());
    }

    /**
     * <p>
     * Returns descriptions of all resources of the specified stack.
     * </p>
     * <p>
     * For deleted stacks, ListStackResources returns resource information for up to 90 days after the stack has been
     * deleted.
     * </p>
     *
     * @param listStackResourcesRequest
     *        The input for the <a>ListStackResource</a> action.
     * @return A Java Future containing the result of the ListStackResources operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.ListStackResources
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListStackResources"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListStackResourcesResponse> listStackResources(ListStackResourcesRequest listStackResourcesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns descriptions of all resources of the specified stack.
     * </p>
     * <p>
     * For deleted stacks, ListStackResources returns resource information for up to 90 days after the stack has been
     * deleted.
     * </p>
     * <br/>
     * This is a convenience which creates an instance of the {@link ListStackResourcesRequest.Builder} avoiding the
     * need to create one manually via {@link ListStackResourcesRequest#builder()}
     *
     * @param listStackResourcesRequest
     *        a {@link Consumer} that will call methods on {@link ListStackResourcesInput.Builder}.
     * @return A Java Future containing the result of the ListStackResources operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.ListStackResources
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListStackResources"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListStackResourcesResponse> listStackResources(
            Consumer<ListStackResourcesRequest.Builder> listStackResourcesRequest) {
        return listStackResources(ListStackResourcesRequest.builder().apply(listStackResourcesRequest).build());
    }

    /**
     * <p>
     * Returns summary information about the results of a stack set operation.
     * </p>
     *
     * @param listStackSetOperationResultsRequest
     * @return A Java Future containing the result of the ListStackSetOperationResults operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>StackSetNotFoundException The specified stack set doesn't exist.</li>
     *         <li>OperationNotFoundException The specified ID refers to an operation that doesn't exist.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.ListStackSetOperationResults
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListStackSetOperationResults"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListStackSetOperationResultsResponse> listStackSetOperationResults(
            ListStackSetOperationResultsRequest listStackSetOperationResultsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns summary information about the results of a stack set operation.
     * </p>
     * <br/>
     * This is a convenience which creates an instance of the {@link ListStackSetOperationResultsRequest.Builder}
     * avoiding the need to create one manually via {@link ListStackSetOperationResultsRequest#builder()}
     *
     * @param listStackSetOperationResultsRequest
     *        a {@link Consumer} that will call methods on {@link ListStackSetOperationResultsInput.Builder}.
     * @return A Java Future containing the result of the ListStackSetOperationResults operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>StackSetNotFoundException The specified stack set doesn't exist.</li>
     *         <li>OperationNotFoundException The specified ID refers to an operation that doesn't exist.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.ListStackSetOperationResults
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListStackSetOperationResults"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListStackSetOperationResultsResponse> listStackSetOperationResults(
            Consumer<ListStackSetOperationResultsRequest.Builder> listStackSetOperationResultsRequest) {
        return listStackSetOperationResults(ListStackSetOperationResultsRequest.builder()
                .apply(listStackSetOperationResultsRequest).build());
    }

    /**
     * <p>
     * Returns summary information about operations performed on a stack set.
     * </p>
     *
     * @param listStackSetOperationsRequest
     * @return A Java Future containing the result of the ListStackSetOperations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>StackSetNotFoundException The specified stack set doesn't exist.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.ListStackSetOperations
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListStackSetOperations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListStackSetOperationsResponse> listStackSetOperations(
            ListStackSetOperationsRequest listStackSetOperationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns summary information about operations performed on a stack set.
     * </p>
     * <br/>
     * This is a convenience which creates an instance of the {@link ListStackSetOperationsRequest.Builder} avoiding the
     * need to create one manually via {@link ListStackSetOperationsRequest#builder()}
     *
     * @param listStackSetOperationsRequest
     *        a {@link Consumer} that will call methods on {@link ListStackSetOperationsInput.Builder}.
     * @return A Java Future containing the result of the ListStackSetOperations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>StackSetNotFoundException The specified stack set doesn't exist.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.ListStackSetOperations
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListStackSetOperations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListStackSetOperationsResponse> listStackSetOperations(
            Consumer<ListStackSetOperationsRequest.Builder> listStackSetOperationsRequest) {
        return listStackSetOperations(ListStackSetOperationsRequest.builder().apply(listStackSetOperationsRequest).build());
    }

    /**
     * <p>
     * Returns summary information about stack sets that are associated with the user.
     * </p>
     *
     * @param listStackSetsRequest
     * @return A Java Future containing the result of the ListStackSets operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.ListStackSets
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListStackSets" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListStackSetsResponse> listStackSets(ListStackSetsRequest listStackSetsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns summary information about stack sets that are associated with the user.
     * </p>
     *
     * @return A Java Future containing the result of the ListStackSets operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.ListStackSets
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListStackSets" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListStackSetsResponse> listStackSets() {
        return listStackSets(ListStackSetsRequest.builder().build());
    }

    /**
     * <p>
     * Returns summary information about stack sets that are associated with the user.
     * </p>
     * <br/>
     * This is a convenience which creates an instance of the {@link ListStackSetsRequest.Builder} avoiding the need to
     * create one manually via {@link ListStackSetsRequest#builder()}
     *
     * @param listStackSetsRequest
     *        a {@link Consumer} that will call methods on {@link ListStackSetsInput.Builder}.
     * @return A Java Future containing the result of the ListStackSets operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.ListStackSets
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListStackSets" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListStackSetsResponse> listStackSets(Consumer<ListStackSetsRequest.Builder> listStackSetsRequest) {
        return listStackSets(ListStackSetsRequest.builder().apply(listStackSetsRequest).build());
    }

    /**
     * <p>
     * Returns the summary information for stacks whose status matches the specified StackStatusFilter. Summary
     * information for stacks that have been deleted is kept for 90 days after the stack is deleted. If no
     * StackStatusFilter is specified, summary information for all stacks is returned (including existing stacks and
     * stacks that have been deleted).
     * </p>
     *
     * @param listStacksRequest
     *        The input for <a>ListStacks</a> action.
     * @return A Java Future containing the result of the ListStacks operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.ListStacks
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListStacks" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListStacksResponse> listStacks(ListStacksRequest listStacksRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the summary information for stacks whose status matches the specified StackStatusFilter. Summary
     * information for stacks that have been deleted is kept for 90 days after the stack is deleted. If no
     * StackStatusFilter is specified, summary information for all stacks is returned (including existing stacks and
     * stacks that have been deleted).
     * </p>
     *
     * @return A Java Future containing the result of the ListStacks operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.ListStacks
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListStacks" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListStacksResponse> listStacks() {
        return listStacks(ListStacksRequest.builder().build());
    }

    /**
     * <p>
     * Returns the summary information for stacks whose status matches the specified StackStatusFilter. Summary
     * information for stacks that have been deleted is kept for 90 days after the stack is deleted. If no
     * StackStatusFilter is specified, summary information for all stacks is returned (including existing stacks and
     * stacks that have been deleted).
     * </p>
     * <br/>
     * This is a convenience which creates an instance of the {@link ListStacksRequest.Builder} avoiding the need to
     * create one manually via {@link ListStacksRequest#builder()}
     *
     * @param listStacksRequest
     *        a {@link Consumer} that will call methods on {@link ListStacksInput.Builder}.
     * @return A Java Future containing the result of the ListStacks operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.ListStacks
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListStacks" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListStacksResponse> listStacks(Consumer<ListStacksRequest.Builder> listStacksRequest) {
        return listStacks(ListStacksRequest.builder().apply(listStacksRequest).build());
    }

    /**
     * <p>
     * Sets a stack policy for a specified stack.
     * </p>
     *
     * @param setStackPolicyRequest
     *        The input for the <a>SetStackPolicy</a> action.
     * @return A Java Future containing the result of the SetStackPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.SetStackPolicy
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/SetStackPolicy" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<SetStackPolicyResponse> setStackPolicy(SetStackPolicyRequest setStackPolicyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Sets a stack policy for a specified stack.
     * </p>
     * <br/>
     * This is a convenience which creates an instance of the {@link SetStackPolicyRequest.Builder} avoiding the need to
     * create one manually via {@link SetStackPolicyRequest#builder()}
     *
     * @param setStackPolicyRequest
     *        a {@link Consumer} that will call methods on {@link SetStackPolicyInput.Builder}.
     * @return A Java Future containing the result of the SetStackPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.SetStackPolicy
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/SetStackPolicy" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<SetStackPolicyResponse> setStackPolicy(Consumer<SetStackPolicyRequest.Builder> setStackPolicyRequest) {
        return setStackPolicy(SetStackPolicyRequest.builder().apply(setStackPolicyRequest).build());
    }

    /**
     * <p>
     * Sends a signal to the specified resource with a success or failure status. You can use the SignalResource API in
     * conjunction with a creation policy or update policy. AWS CloudFormation doesn't proceed with a stack creation or
     * update until resources receive the required number of signals or the timeout period is exceeded. The
     * SignalResource API is useful in cases where you want to send signals from anywhere other than an Amazon EC2
     * instance.
     * </p>
     *
     * @param signalResourceRequest
     *        The input for the <a>SignalResource</a> action.
     * @return A Java Future containing the result of the SignalResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.SignalResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/SignalResource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<SignalResourceResponse> signalResource(SignalResourceRequest signalResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Sends a signal to the specified resource with a success or failure status. You can use the SignalResource API in
     * conjunction with a creation policy or update policy. AWS CloudFormation doesn't proceed with a stack creation or
     * update until resources receive the required number of signals or the timeout period is exceeded. The
     * SignalResource API is useful in cases where you want to send signals from anywhere other than an Amazon EC2
     * instance.
     * </p>
     * <br/>
     * This is a convenience which creates an instance of the {@link SignalResourceRequest.Builder} avoiding the need to
     * create one manually via {@link SignalResourceRequest#builder()}
     *
     * @param signalResourceRequest
     *        a {@link Consumer} that will call methods on {@link SignalResourceInput.Builder}.
     * @return A Java Future containing the result of the SignalResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.SignalResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/SignalResource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<SignalResourceResponse> signalResource(Consumer<SignalResourceRequest.Builder> signalResourceRequest) {
        return signalResource(SignalResourceRequest.builder().apply(signalResourceRequest).build());
    }

    /**
     * <p>
     * Stops an in-progress operation on a stack set and its associated stack instances.
     * </p>
     *
     * @param stopStackSetOperationRequest
     * @return A Java Future containing the result of the StopStackSetOperation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>StackSetNotFoundException The specified stack set doesn't exist.</li>
     *         <li>OperationNotFoundException The specified ID refers to an operation that doesn't exist.</li>
     *         <li>InvalidOperationException The specified operation isn't valid.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.StopStackSetOperation
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/StopStackSetOperation"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StopStackSetOperationResponse> stopStackSetOperation(
            StopStackSetOperationRequest stopStackSetOperationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Stops an in-progress operation on a stack set and its associated stack instances.
     * </p>
     * <br/>
     * This is a convenience which creates an instance of the {@link StopStackSetOperationRequest.Builder} avoiding the
     * need to create one manually via {@link StopStackSetOperationRequest#builder()}
     *
     * @param stopStackSetOperationRequest
     *        a {@link Consumer} that will call methods on {@link StopStackSetOperationInput.Builder}.
     * @return A Java Future containing the result of the StopStackSetOperation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>StackSetNotFoundException The specified stack set doesn't exist.</li>
     *         <li>OperationNotFoundException The specified ID refers to an operation that doesn't exist.</li>
     *         <li>InvalidOperationException The specified operation isn't valid.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.StopStackSetOperation
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/StopStackSetOperation"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StopStackSetOperationResponse> stopStackSetOperation(
            Consumer<StopStackSetOperationRequest.Builder> stopStackSetOperationRequest) {
        return stopStackSetOperation(StopStackSetOperationRequest.builder().apply(stopStackSetOperationRequest).build());
    }

    /**
     * <p>
     * Updates a stack as specified in the template. After the call completes successfully, the stack update starts. You
     * can check the status of the stack via the <a>DescribeStacks</a> action.
     * </p>
     * <p>
     * To get a copy of the template for an existing stack, you can use the <a>GetTemplate</a> action.
     * </p>
     * <p>
     * For more information about creating an update template, updating a stack, and monitoring the progress of the
     * update, see <a
     * href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-updating-stacks.html">Updating a
     * Stack</a>.
     * </p>
     *
     * @param updateStackRequest
     *        The input for an <a>UpdateStack</a> action.
     * @return A Java Future containing the result of the UpdateStack operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InsufficientCapabilitiesException The template contains resources with capabilities that weren't
     *         specified in the Capabilities parameter.</li>
     *         <li>TokenAlreadyExistsException A client request token already exists.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.UpdateStack
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/UpdateStack" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateStackResponse> updateStack(UpdateStackRequest updateStackRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a stack as specified in the template. After the call completes successfully, the stack update starts. You
     * can check the status of the stack via the <a>DescribeStacks</a> action.
     * </p>
     * <p>
     * To get a copy of the template for an existing stack, you can use the <a>GetTemplate</a> action.
     * </p>
     * <p>
     * For more information about creating an update template, updating a stack, and monitoring the progress of the
     * update, see <a
     * href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-updating-stacks.html">Updating a
     * Stack</a>.
     * </p>
     * <br/>
     * This is a convenience which creates an instance of the {@link UpdateStackRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateStackRequest#builder()}
     *
     * @param updateStackRequest
     *        a {@link Consumer} that will call methods on {@link UpdateStackInput.Builder}.
     * @return A Java Future containing the result of the UpdateStack operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InsufficientCapabilitiesException The template contains resources with capabilities that weren't
     *         specified in the Capabilities parameter.</li>
     *         <li>TokenAlreadyExistsException A client request token already exists.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.UpdateStack
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/UpdateStack" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateStackResponse> updateStack(Consumer<UpdateStackRequest.Builder> updateStackRequest) {
        return updateStack(UpdateStackRequest.builder().apply(updateStackRequest).build());
    }

    /**
     * <p>
     * Updates the stack set and <i>all</i> associated stack instances.
     * </p>
     * <p>
     * Even if the stack set operation created by updating the stack set fails (completely or partially, below or above
     * a specified failure tolerance), the stack set is updated with your changes. Subsequent
     * <a>CreateStackInstances</a> calls on the specified stack set use the updated stack set.
     * </p>
     *
     * @param updateStackSetRequest
     * @return A Java Future containing the result of the UpdateStackSet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>StackSetNotFoundException The specified stack set doesn't exist.</li>
     *         <li>OperationInProgressException Another operation is currently in progress for this stack set. Only one
     *         operation can be performed for a stack set at a given time.</li>
     *         <li>OperationIdAlreadyExistsException The specified operation ID already exists.</li>
     *         <li>StaleRequestException Another operation has been performed on this stack set since the specified
     *         operation was performed.</li>
     *         <li>InvalidOperationException The specified operation isn't valid.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.UpdateStackSet
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/UpdateStackSet" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateStackSetResponse> updateStackSet(UpdateStackSetRequest updateStackSetRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the stack set and <i>all</i> associated stack instances.
     * </p>
     * <p>
     * Even if the stack set operation created by updating the stack set fails (completely or partially, below or above
     * a specified failure tolerance), the stack set is updated with your changes. Subsequent
     * <a>CreateStackInstances</a> calls on the specified stack set use the updated stack set.
     * </p>
     * <br/>
     * This is a convenience which creates an instance of the {@link UpdateStackSetRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateStackSetRequest#builder()}
     *
     * @param updateStackSetRequest
     *        a {@link Consumer} that will call methods on {@link UpdateStackSetInput.Builder}.
     * @return A Java Future containing the result of the UpdateStackSet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>StackSetNotFoundException The specified stack set doesn't exist.</li>
     *         <li>OperationInProgressException Another operation is currently in progress for this stack set. Only one
     *         operation can be performed for a stack set at a given time.</li>
     *         <li>OperationIdAlreadyExistsException The specified operation ID already exists.</li>
     *         <li>StaleRequestException Another operation has been performed on this stack set since the specified
     *         operation was performed.</li>
     *         <li>InvalidOperationException The specified operation isn't valid.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.UpdateStackSet
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/UpdateStackSet" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateStackSetResponse> updateStackSet(Consumer<UpdateStackSetRequest.Builder> updateStackSetRequest) {
        return updateStackSet(UpdateStackSetRequest.builder().apply(updateStackSetRequest).build());
    }

    /**
     * <p>
     * Updates termination protection for the specified stack. If a user attempts to delete a stack with termination
     * protection enabled, the operation fails and the stack remains unchanged. For more information, see <a
     * href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-protect-stacks.html">Protecting a
     * Stack From Being Deleted</a> in the <i>AWS CloudFormation User Guide</i>.
     * </p>
     * <p>
     * For <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-nested-stacks.html">nested
     * stacks</a>, termination protection is set on the root stack and cannot be changed directly on the nested stack.
     * </p>
     *
     * @param updateTerminationProtectionRequest
     * @return A Java Future containing the result of the UpdateTerminationProtection operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.UpdateTerminationProtection
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/UpdateTerminationProtection"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateTerminationProtectionResponse> updateTerminationProtection(
            UpdateTerminationProtectionRequest updateTerminationProtectionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates termination protection for the specified stack. If a user attempts to delete a stack with termination
     * protection enabled, the operation fails and the stack remains unchanged. For more information, see <a
     * href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-protect-stacks.html">Protecting a
     * Stack From Being Deleted</a> in the <i>AWS CloudFormation User Guide</i>.
     * </p>
     * <p>
     * For <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-nested-stacks.html">nested
     * stacks</a>, termination protection is set on the root stack and cannot be changed directly on the nested stack.
     * </p>
     * <br/>
     * This is a convenience which creates an instance of the {@link UpdateTerminationProtectionRequest.Builder}
     * avoiding the need to create one manually via {@link UpdateTerminationProtectionRequest#builder()}
     *
     * @param updateTerminationProtectionRequest
     *        a {@link Consumer} that will call methods on {@link UpdateTerminationProtectionInput.Builder}.
     * @return A Java Future containing the result of the UpdateTerminationProtection operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.UpdateTerminationProtection
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/UpdateTerminationProtection"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateTerminationProtectionResponse> updateTerminationProtection(
            Consumer<UpdateTerminationProtectionRequest.Builder> updateTerminationProtectionRequest) {
        return updateTerminationProtection(UpdateTerminationProtectionRequest.builder().apply(updateTerminationProtectionRequest)
                .build());
    }

    /**
     * <p>
     * Validates a specified template. AWS CloudFormation first checks if the template is valid JSON. If it isn't, AWS
     * CloudFormation checks if the template is valid YAML. If both these checks fail, AWS CloudFormation returns a
     * template validation error.
     * </p>
     *
     * @param validateTemplateRequest
     *        The input for <a>ValidateTemplate</a> action.
     * @return A Java Future containing the result of the ValidateTemplate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.ValidateTemplate
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ValidateTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ValidateTemplateResponse> validateTemplate(ValidateTemplateRequest validateTemplateRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Validates a specified template. AWS CloudFormation first checks if the template is valid JSON. If it isn't, AWS
     * CloudFormation checks if the template is valid YAML. If both these checks fail, AWS CloudFormation returns a
     * template validation error.
     * </p>
     * <br/>
     * This is a convenience which creates an instance of the {@link ValidateTemplateRequest.Builder} avoiding the need
     * to create one manually via {@link ValidateTemplateRequest#builder()}
     *
     * @param validateTemplateRequest
     *        a {@link Consumer} that will call methods on {@link ValidateTemplateInput.Builder}.
     * @return A Java Future containing the result of the ValidateTemplate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.ValidateTemplate
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ValidateTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ValidateTemplateResponse> validateTemplate(
            Consumer<ValidateTemplateRequest.Builder> validateTemplateRequest) {
        return validateTemplate(ValidateTemplateRequest.builder().apply(validateTemplateRequest).build());
    }
}
