/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudformation.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The output for a <a>DescribeStackEvents</a> action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeStackEventsResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<DescribeStackEventsResponse.Builder, DescribeStackEventsResponse> {
    private final List<StackEvent> stackEvents;

    private final String nextToken;

    private DescribeStackEventsResponse(BuilderImpl builder) {
        this.stackEvents = builder.stackEvents;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * A list of <code>StackEvents</code> structures.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A list of <code>StackEvents</code> structures.
     */
    public List<StackEvent> stackEvents() {
        return stackEvents;
    }

    /**
     * <p>
     * If the output exceeds 1 MB in size, a string that identifies the next page of events. If no additional page
     * exists, this value is null.
     * </p>
     * 
     * @return If the output exceeds 1 MB in size, a string that identifies the next page of events. If no additional
     *         page exists, this value is null.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(stackEvents());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeStackEventsResponse)) {
            return false;
        }
        DescribeStackEventsResponse other = (DescribeStackEventsResponse) obj;
        return Objects.equals(stackEvents(), other.stackEvents()) && Objects.equals(nextToken(), other.nextToken());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (stackEvents() != null) {
            sb.append("StackEvents: ").append(stackEvents()).append(",");
        }
        if (nextToken() != null) {
            sb.append("NextToken: ").append(nextToken()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StackEvents":
            return Optional.of(clazz.cast(stackEvents()));
        case "NextToken":
            return Optional.of(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, DescribeStackEventsResponse> {
        /**
         * <p>
         * A list of <code>StackEvents</code> structures.
         * </p>
         * 
         * @param stackEvents
         *        A list of <code>StackEvents</code> structures.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stackEvents(Collection<StackEvent> stackEvents);

        /**
         * <p>
         * A list of <code>StackEvents</code> structures.
         * </p>
         * 
         * @param stackEvents
         *        A list of <code>StackEvents</code> structures.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stackEvents(StackEvent... stackEvents);

        /**
         * <p>
         * If the output exceeds 1 MB in size, a string that identifies the next page of events. If no additional page
         * exists, this value is null.
         * </p>
         * 
         * @param nextToken
         *        If the output exceeds 1 MB in size, a string that identifies the next page of events. If no additional
         *        page exists, this value is null.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl implements Builder {
        private List<StackEvent> stackEvents;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeStackEventsResponse model) {
            stackEvents(model.stackEvents);
            nextToken(model.nextToken);
        }

        public final Collection<StackEvent.Builder> getStackEvents() {
            return stackEvents != null ? stackEvents.stream().map(StackEvent::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder stackEvents(Collection<StackEvent> stackEvents) {
            this.stackEvents = StackEventsCopier.copy(stackEvents);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stackEvents(StackEvent... stackEvents) {
            stackEvents(Arrays.asList(stackEvents));
            return this;
        }

        public final void setStackEvents(Collection<StackEvent.BuilderImpl> stackEvents) {
            this.stackEvents = StackEventsCopier.copyFromBuilder(stackEvents);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeStackEventsResponse build() {
            return new DescribeStackEventsResponse(this);
        }
    }
}
