/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudformation.model;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeStackSetOperationRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<DescribeStackSetOperationRequest.Builder, DescribeStackSetOperationRequest> {
    private final String stackSetName;

    private final String operationId;

    private DescribeStackSetOperationRequest(BuilderImpl builder) {
        this.stackSetName = builder.stackSetName;
        this.operationId = builder.operationId;
    }

    /**
     * <p>
     * The name or the unique stack ID of the stack set for the stack operation.
     * </p>
     * 
     * @return The name or the unique stack ID of the stack set for the stack operation.
     */
    public String stackSetName() {
        return stackSetName;
    }

    /**
     * <p>
     * The unique ID of the stack set operation.
     * </p>
     * 
     * @return The unique ID of the stack set operation.
     */
    public String operationId() {
        return operationId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(stackSetName());
        hashCode = 31 * hashCode + Objects.hashCode(operationId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeStackSetOperationRequest)) {
            return false;
        }
        DescribeStackSetOperationRequest other = (DescribeStackSetOperationRequest) obj;
        return Objects.equals(stackSetName(), other.stackSetName()) && Objects.equals(operationId(), other.operationId());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (stackSetName() != null) {
            sb.append("StackSetName: ").append(stackSetName()).append(",");
        }
        if (operationId() != null) {
            sb.append("OperationId: ").append(operationId()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StackSetName":
            return Optional.of(clazz.cast(stackSetName()));
        case "OperationId":
            return Optional.of(clazz.cast(operationId()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, DescribeStackSetOperationRequest> {
        /**
         * <p>
         * The name or the unique stack ID of the stack set for the stack operation.
         * </p>
         * 
         * @param stackSetName
         *        The name or the unique stack ID of the stack set for the stack operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stackSetName(String stackSetName);

        /**
         * <p>
         * The unique ID of the stack set operation.
         * </p>
         * 
         * @param operationId
         *        The unique ID of the stack set operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder operationId(String operationId);
    }

    static final class BuilderImpl implements Builder {
        private String stackSetName;

        private String operationId;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeStackSetOperationRequest model) {
            stackSetName(model.stackSetName);
            operationId(model.operationId);
        }

        public final String getStackSetName() {
            return stackSetName;
        }

        @Override
        public final Builder stackSetName(String stackSetName) {
            this.stackSetName = stackSetName;
            return this;
        }

        public final void setStackSetName(String stackSetName) {
            this.stackSetName = stackSetName;
        }

        public final String getOperationId() {
            return operationId;
        }

        @Override
        public final Builder operationId(String operationId) {
            this.operationId = operationId;
            return this;
        }

        public final void setOperationId(String operationId) {
            this.operationId = operationId;
        }

        @Override
        public DescribeStackSetOperationRequest build() {
            return new DescribeStackSetOperationRequest(this);
        }
    }
}
