/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudformation.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeStackSetResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<DescribeStackSetResponse.Builder, DescribeStackSetResponse> {
    private final StackSet stackSet;

    private DescribeStackSetResponse(BuilderImpl builder) {
        this.stackSet = builder.stackSet;
    }

    /**
     * <p>
     * The specified stack set.
     * </p>
     * 
     * @return The specified stack set.
     */
    public StackSet stackSet() {
        return stackSet;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(stackSet());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeStackSetResponse)) {
            return false;
        }
        DescribeStackSetResponse other = (DescribeStackSetResponse) obj;
        return Objects.equals(stackSet(), other.stackSet());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (stackSet() != null) {
            sb.append("StackSet: ").append(stackSet()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StackSet":
            return Optional.of(clazz.cast(stackSet()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, DescribeStackSetResponse> {
        /**
         * <p>
         * The specified stack set.
         * </p>
         * 
         * @param stackSet
         *        The specified stack set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stackSet(StackSet stackSet);

        /**
         * <p>
         * The specified stack set.
         * </p>
         * This is a convenience that creates an instance of the {@link StackSet.Builder} avoiding the need to create
         * one manually via {@link StackSet#builder()}.
         *
         * When the {@link Consumer} completes, {@link StackSet.Builder#build()} is called immediately and its result is
         * passed to {@link #stackSet(StackSet)}.
         * 
         * @param stackSet
         *        a consumer that will call methods on {@link StackSet.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #stackSet(StackSet)
         */
        default Builder stackSet(Consumer<StackSet.Builder> stackSet) {
            return stackSet(StackSet.builder().apply(stackSet).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private StackSet stackSet;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeStackSetResponse model) {
            stackSet(model.stackSet);
        }

        public final StackSet.Builder getStackSet() {
            return stackSet != null ? stackSet.toBuilder() : null;
        }

        @Override
        public final Builder stackSet(StackSet stackSet) {
            this.stackSet = stackSet;
            return this;
        }

        public final void setStackSet(StackSet.BuilderImpl stackSet) {
            this.stackSet = stackSet != null ? stackSet.build() : null;
        }

        @Override
        public DescribeStackSetResponse build() {
            return new DescribeStackSetResponse(this);
        }
    }
}
