/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudformation.model;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The output for the <a>GetStackPolicy</a> action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class GetStackPolicyResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<GetStackPolicyResponse.Builder, GetStackPolicyResponse> {
    private final String stackPolicyBody;

    private GetStackPolicyResponse(BuilderImpl builder) {
        this.stackPolicyBody = builder.stackPolicyBody;
    }

    /**
     * <p>
     * Structure containing the stack policy body. (For more information, go to <a
     * href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/protect-stack-resources.html"> Prevent
     * Updates to Stack Resources</a> in the AWS CloudFormation User Guide.)
     * </p>
     * 
     * @return Structure containing the stack policy body. (For more information, go to <a
     *         href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/protect-stack-resources.html">
     *         Prevent Updates to Stack Resources</a> in the AWS CloudFormation User Guide.)
     */
    public String stackPolicyBody() {
        return stackPolicyBody;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(stackPolicyBody());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetStackPolicyResponse)) {
            return false;
        }
        GetStackPolicyResponse other = (GetStackPolicyResponse) obj;
        return Objects.equals(stackPolicyBody(), other.stackPolicyBody());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (stackPolicyBody() != null) {
            sb.append("StackPolicyBody: ").append(stackPolicyBody()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StackPolicyBody":
            return Optional.of(clazz.cast(stackPolicyBody()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, GetStackPolicyResponse> {
        /**
         * <p>
         * Structure containing the stack policy body. (For more information, go to <a
         * href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/protect-stack-resources.html"> Prevent
         * Updates to Stack Resources</a> in the AWS CloudFormation User Guide.)
         * </p>
         * 
         * @param stackPolicyBody
         *        Structure containing the stack policy body. (For more information, go to <a
         *        href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/protect-stack-resources.html">
         *        Prevent Updates to Stack Resources</a> in the AWS CloudFormation User Guide.)
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stackPolicyBody(String stackPolicyBody);
    }

    static final class BuilderImpl implements Builder {
        private String stackPolicyBody;

        private BuilderImpl() {
        }

        private BuilderImpl(GetStackPolicyResponse model) {
            stackPolicyBody(model.stackPolicyBody);
        }

        public final String getStackPolicyBody() {
            return stackPolicyBody;
        }

        @Override
        public final Builder stackPolicyBody(String stackPolicyBody) {
            this.stackPolicyBody = stackPolicyBody;
            return this;
        }

        public final void setStackPolicyBody(String stackPolicyBody) {
            this.stackPolicyBody = stackPolicyBody;
        }

        @Override
        public GetStackPolicyResponse build() {
            return new GetStackPolicyResponse(this);
        }
    }
}
