/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudformation.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The output for the <a>ListChangeSets</a> action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ListChangeSetsResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<ListChangeSetsResponse.Builder, ListChangeSetsResponse> {
    private final List<ChangeSetSummary> summaries;

    private final String nextToken;

    private ListChangeSetsResponse(BuilderImpl builder) {
        this.summaries = builder.summaries;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * A list of <code>ChangeSetSummary</code> structures that provides the ID and status of each change set for the
     * specified stack.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A list of <code>ChangeSetSummary</code> structures that provides the ID and status of each change set for
     *         the specified stack.
     */
    public List<ChangeSetSummary> summaries() {
        return summaries;
    }

    /**
     * <p>
     * If the output exceeds 1 MB, a string that identifies the next page of change sets. If there is no additional
     * page, this value is null.
     * </p>
     * 
     * @return If the output exceeds 1 MB, a string that identifies the next page of change sets. If there is no
     *         additional page, this value is null.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(summaries());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListChangeSetsResponse)) {
            return false;
        }
        ListChangeSetsResponse other = (ListChangeSetsResponse) obj;
        return Objects.equals(summaries(), other.summaries()) && Objects.equals(nextToken(), other.nextToken());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (summaries() != null) {
            sb.append("Summaries: ").append(summaries()).append(",");
        }
        if (nextToken() != null) {
            sb.append("NextToken: ").append(nextToken()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Summaries":
            return Optional.of(clazz.cast(summaries()));
        case "NextToken":
            return Optional.of(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, ListChangeSetsResponse> {
        /**
         * <p>
         * A list of <code>ChangeSetSummary</code> structures that provides the ID and status of each change set for the
         * specified stack.
         * </p>
         * 
         * @param summaries
         *        A list of <code>ChangeSetSummary</code> structures that provides the ID and status of each change set
         *        for the specified stack.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder summaries(Collection<ChangeSetSummary> summaries);

        /**
         * <p>
         * A list of <code>ChangeSetSummary</code> structures that provides the ID and status of each change set for the
         * specified stack.
         * </p>
         * 
         * @param summaries
         *        A list of <code>ChangeSetSummary</code> structures that provides the ID and status of each change set
         *        for the specified stack.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder summaries(ChangeSetSummary... summaries);

        /**
         * <p>
         * If the output exceeds 1 MB, a string that identifies the next page of change sets. If there is no additional
         * page, this value is null.
         * </p>
         * 
         * @param nextToken
         *        If the output exceeds 1 MB, a string that identifies the next page of change sets. If there is no
         *        additional page, this value is null.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl implements Builder {
        private List<ChangeSetSummary> summaries;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListChangeSetsResponse model) {
            summaries(model.summaries);
            nextToken(model.nextToken);
        }

        public final Collection<ChangeSetSummary.Builder> getSummaries() {
            return summaries != null ? summaries.stream().map(ChangeSetSummary::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder summaries(Collection<ChangeSetSummary> summaries) {
            this.summaries = ChangeSetSummariesCopier.copy(summaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder summaries(ChangeSetSummary... summaries) {
            summaries(Arrays.asList(summaries));
            return this;
        }

        public final void setSummaries(Collection<ChangeSetSummary.BuilderImpl> summaries) {
            this.summaries = ChangeSetSummariesCopier.copyFromBuilder(summaries);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListChangeSetsResponse build() {
            return new ListChangeSetsResponse(this);
        }
    }
}
