/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudformation.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The output for a <a>ListStackResources</a> action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ListStackResourcesResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<ListStackResourcesResponse.Builder, ListStackResourcesResponse> {
    private final List<StackResourceSummary> stackResourceSummaries;

    private final String nextToken;

    private ListStackResourcesResponse(BuilderImpl builder) {
        this.stackResourceSummaries = builder.stackResourceSummaries;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * A list of <code>StackResourceSummary</code> structures.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A list of <code>StackResourceSummary</code> structures.
     */
    public List<StackResourceSummary> stackResourceSummaries() {
        return stackResourceSummaries;
    }

    /**
     * <p>
     * If the output exceeds 1 MB, a string that identifies the next page of stack resources. If no additional page
     * exists, this value is null.
     * </p>
     * 
     * @return If the output exceeds 1 MB, a string that identifies the next page of stack resources. If no additional
     *         page exists, this value is null.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(stackResourceSummaries());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListStackResourcesResponse)) {
            return false;
        }
        ListStackResourcesResponse other = (ListStackResourcesResponse) obj;
        return Objects.equals(stackResourceSummaries(), other.stackResourceSummaries())
                && Objects.equals(nextToken(), other.nextToken());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (stackResourceSummaries() != null) {
            sb.append("StackResourceSummaries: ").append(stackResourceSummaries()).append(",");
        }
        if (nextToken() != null) {
            sb.append("NextToken: ").append(nextToken()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StackResourceSummaries":
            return Optional.of(clazz.cast(stackResourceSummaries()));
        case "NextToken":
            return Optional.of(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, ListStackResourcesResponse> {
        /**
         * <p>
         * A list of <code>StackResourceSummary</code> structures.
         * </p>
         * 
         * @param stackResourceSummaries
         *        A list of <code>StackResourceSummary</code> structures.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stackResourceSummaries(Collection<StackResourceSummary> stackResourceSummaries);

        /**
         * <p>
         * A list of <code>StackResourceSummary</code> structures.
         * </p>
         * 
         * @param stackResourceSummaries
         *        A list of <code>StackResourceSummary</code> structures.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stackResourceSummaries(StackResourceSummary... stackResourceSummaries);

        /**
         * <p>
         * If the output exceeds 1 MB, a string that identifies the next page of stack resources. If no additional page
         * exists, this value is null.
         * </p>
         * 
         * @param nextToken
         *        If the output exceeds 1 MB, a string that identifies the next page of stack resources. If no
         *        additional page exists, this value is null.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl implements Builder {
        private List<StackResourceSummary> stackResourceSummaries;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListStackResourcesResponse model) {
            stackResourceSummaries(model.stackResourceSummaries);
            nextToken(model.nextToken);
        }

        public final Collection<StackResourceSummary.Builder> getStackResourceSummaries() {
            return stackResourceSummaries != null ? stackResourceSummaries.stream().map(StackResourceSummary::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder stackResourceSummaries(Collection<StackResourceSummary> stackResourceSummaries) {
            this.stackResourceSummaries = StackResourceSummariesCopier.copy(stackResourceSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stackResourceSummaries(StackResourceSummary... stackResourceSummaries) {
            stackResourceSummaries(Arrays.asList(stackResourceSummaries));
            return this;
        }

        public final void setStackResourceSummaries(Collection<StackResourceSummary.BuilderImpl> stackResourceSummaries) {
            this.stackResourceSummaries = StackResourceSummariesCopier.copyFromBuilder(stackResourceSummaries);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListStackResourcesResponse build() {
            return new ListStackResourcesResponse(this);
        }
    }
}
