/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudformation.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The structures that contain summary information about the specified operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class StackSetOperationSummary implements ToCopyableBuilder<StackSetOperationSummary.Builder, StackSetOperationSummary> {
    private final String operationId;

    private final String action;

    private final String status;

    private final Instant creationTimestamp;

    private final Instant endTimestamp;

    private StackSetOperationSummary(BuilderImpl builder) {
        this.operationId = builder.operationId;
        this.action = builder.action;
        this.status = builder.status;
        this.creationTimestamp = builder.creationTimestamp;
        this.endTimestamp = builder.endTimestamp;
    }

    /**
     * <p>
     * The unique ID of the stack set operation.
     * </p>
     * 
     * @return The unique ID of the stack set operation.
     */
    public String operationId() {
        return operationId;
    }

    /**
     * <p>
     * The type of operation: <code>CREATE</code>, <code>UPDATE</code>, or <code>DELETE</code>. Create and delete
     * operations affect only the specified stack instances that are associated with the specified stack set. Update
     * operations affect both the stack set itself as well as <i>all</i> associated stack set instances.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #action} will
     * return {@link StackSetOperationAction#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #actionString}.
     * </p>
     * 
     * @return The type of operation: <code>CREATE</code>, <code>UPDATE</code>, or <code>DELETE</code>. Create and
     *         delete operations affect only the specified stack instances that are associated with the specified stack
     *         set. Update operations affect both the stack set itself as well as <i>all</i> associated stack set
     *         instances.
     * @see StackSetOperationAction
     */
    public StackSetOperationAction action() {
        return StackSetOperationAction.fromValue(action);
    }

    /**
     * <p>
     * The type of operation: <code>CREATE</code>, <code>UPDATE</code>, or <code>DELETE</code>. Create and delete
     * operations affect only the specified stack instances that are associated with the specified stack set. Update
     * operations affect both the stack set itself as well as <i>all</i> associated stack set instances.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #action} will
     * return {@link StackSetOperationAction#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #actionString}.
     * </p>
     * 
     * @return The type of operation: <code>CREATE</code>, <code>UPDATE</code>, or <code>DELETE</code>. Create and
     *         delete operations affect only the specified stack instances that are associated with the specified stack
     *         set. Update operations affect both the stack set itself as well as <i>all</i> associated stack set
     *         instances.
     * @see StackSetOperationAction
     */
    public String actionString() {
        return action;
    }

    /**
     * <p>
     * The overall status of the operation.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>FAILED</code>: The operation exceeded the specified failure tolerance. The failure tolerance value that
     * you've set for an operation is applied for each region during stack create and update operations. If the number
     * of failed stacks within a region exceeds the failure tolerance, the status of the operation in the region is set
     * to <code>FAILED</code>. This in turn sets the status of the operation as a whole to <code>FAILED</code>, and AWS
     * CloudFormation cancels the operation in any remaining regions.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>RUNNING</code>: The operation is currently being performed.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>STOPPED</code>: The user has cancelled the operation.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>STOPPING</code>: The operation is in the process of stopping, at user request.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SUCCEEDED</code>: The operation completed creating or updating all the specified stacks without exceeding
     * the failure tolerance for the operation.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link StackSetOperationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusString}.
     * </p>
     * 
     * @return The overall status of the operation.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>FAILED</code>: The operation exceeded the specified failure tolerance. The failure tolerance value
     *         that you've set for an operation is applied for each region during stack create and update operations. If
     *         the number of failed stacks within a region exceeds the failure tolerance, the status of the operation in
     *         the region is set to <code>FAILED</code>. This in turn sets the status of the operation as a whole to
     *         <code>FAILED</code>, and AWS CloudFormation cancels the operation in any remaining regions.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>RUNNING</code>: The operation is currently being performed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>STOPPED</code>: The user has cancelled the operation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>STOPPING</code>: The operation is in the process of stopping, at user request.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SUCCEEDED</code>: The operation completed creating or updating all the specified stacks without
     *         exceeding the failure tolerance for the operation.
     *         </p>
     *         </li>
     * @see StackSetOperationStatus
     */
    public StackSetOperationStatus status() {
        return StackSetOperationStatus.fromValue(status);
    }

    /**
     * <p>
     * The overall status of the operation.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>FAILED</code>: The operation exceeded the specified failure tolerance. The failure tolerance value that
     * you've set for an operation is applied for each region during stack create and update operations. If the number
     * of failed stacks within a region exceeds the failure tolerance, the status of the operation in the region is set
     * to <code>FAILED</code>. This in turn sets the status of the operation as a whole to <code>FAILED</code>, and AWS
     * CloudFormation cancels the operation in any remaining regions.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>RUNNING</code>: The operation is currently being performed.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>STOPPED</code>: The user has cancelled the operation.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>STOPPING</code>: The operation is in the process of stopping, at user request.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SUCCEEDED</code>: The operation completed creating or updating all the specified stacks without exceeding
     * the failure tolerance for the operation.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link StackSetOperationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusString}.
     * </p>
     * 
     * @return The overall status of the operation.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>FAILED</code>: The operation exceeded the specified failure tolerance. The failure tolerance value
     *         that you've set for an operation is applied for each region during stack create and update operations. If
     *         the number of failed stacks within a region exceeds the failure tolerance, the status of the operation in
     *         the region is set to <code>FAILED</code>. This in turn sets the status of the operation as a whole to
     *         <code>FAILED</code>, and AWS CloudFormation cancels the operation in any remaining regions.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>RUNNING</code>: The operation is currently being performed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>STOPPED</code>: The user has cancelled the operation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>STOPPING</code>: The operation is in the process of stopping, at user request.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SUCCEEDED</code>: The operation completed creating or updating all the specified stacks without
     *         exceeding the failure tolerance for the operation.
     *         </p>
     *         </li>
     * @see StackSetOperationStatus
     */
    public String statusString() {
        return status;
    }

    /**
     * <p>
     * The time at which the operation was initiated. Note that the creation times for the stack set operation might
     * differ from the creation time of the individual stacks themselves. This is because AWS CloudFormation needs to
     * perform preparatory work for the operation, such as dispatching the work to the requested regions, before
     * actually creating the first stacks.
     * </p>
     * 
     * @return The time at which the operation was initiated. Note that the creation times for the stack set operation
     *         might differ from the creation time of the individual stacks themselves. This is because AWS
     *         CloudFormation needs to perform preparatory work for the operation, such as dispatching the work to the
     *         requested regions, before actually creating the first stacks.
     */
    public Instant creationTimestamp() {
        return creationTimestamp;
    }

    /**
     * <p>
     * The time at which the stack set operation ended, across all accounts and regions specified. Note that this
     * doesn't necessarily mean that the stack set operation was successful, or even attempted, in each account or
     * region.
     * </p>
     * 
     * @return The time at which the stack set operation ended, across all accounts and regions specified. Note that
     *         this doesn't necessarily mean that the stack set operation was successful, or even attempted, in each
     *         account or region.
     */
    public Instant endTimestamp() {
        return endTimestamp;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(operationId());
        hashCode = 31 * hashCode + Objects.hashCode(actionString());
        hashCode = 31 * hashCode + Objects.hashCode(statusString());
        hashCode = 31 * hashCode + Objects.hashCode(creationTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(endTimestamp());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StackSetOperationSummary)) {
            return false;
        }
        StackSetOperationSummary other = (StackSetOperationSummary) obj;
        return Objects.equals(operationId(), other.operationId()) && Objects.equals(actionString(), other.actionString())
                && Objects.equals(statusString(), other.statusString())
                && Objects.equals(creationTimestamp(), other.creationTimestamp())
                && Objects.equals(endTimestamp(), other.endTimestamp());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (operationId() != null) {
            sb.append("OperationId: ").append(operationId()).append(",");
        }
        if (actionString() != null) {
            sb.append("Action: ").append(actionString()).append(",");
        }
        if (statusString() != null) {
            sb.append("Status: ").append(statusString()).append(",");
        }
        if (creationTimestamp() != null) {
            sb.append("CreationTimestamp: ").append(creationTimestamp()).append(",");
        }
        if (endTimestamp() != null) {
            sb.append("EndTimestamp: ").append(endTimestamp()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "OperationId":
            return Optional.of(clazz.cast(operationId()));
        case "Action":
            return Optional.of(clazz.cast(actionString()));
        case "Status":
            return Optional.of(clazz.cast(statusString()));
        case "CreationTimestamp":
            return Optional.of(clazz.cast(creationTimestamp()));
        case "EndTimestamp":
            return Optional.of(clazz.cast(endTimestamp()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, StackSetOperationSummary> {
        /**
         * <p>
         * The unique ID of the stack set operation.
         * </p>
         * 
         * @param operationId
         *        The unique ID of the stack set operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder operationId(String operationId);

        /**
         * <p>
         * The type of operation: <code>CREATE</code>, <code>UPDATE</code>, or <code>DELETE</code>. Create and delete
         * operations affect only the specified stack instances that are associated with the specified stack set. Update
         * operations affect both the stack set itself as well as <i>all</i> associated stack set instances.
         * </p>
         * 
         * @param action
         *        The type of operation: <code>CREATE</code>, <code>UPDATE</code>, or <code>DELETE</code>. Create and
         *        delete operations affect only the specified stack instances that are associated with the specified
         *        stack set. Update operations affect both the stack set itself as well as <i>all</i> associated stack
         *        set instances.
         * @see StackSetOperationAction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StackSetOperationAction
         */
        Builder action(String action);

        /**
         * <p>
         * The type of operation: <code>CREATE</code>, <code>UPDATE</code>, or <code>DELETE</code>. Create and delete
         * operations affect only the specified stack instances that are associated with the specified stack set. Update
         * operations affect both the stack set itself as well as <i>all</i> associated stack set instances.
         * </p>
         * 
         * @param action
         *        The type of operation: <code>CREATE</code>, <code>UPDATE</code>, or <code>DELETE</code>. Create and
         *        delete operations affect only the specified stack instances that are associated with the specified
         *        stack set. Update operations affect both the stack set itself as well as <i>all</i> associated stack
         *        set instances.
         * @see StackSetOperationAction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StackSetOperationAction
         */
        Builder action(StackSetOperationAction action);

        /**
         * <p>
         * The overall status of the operation.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>FAILED</code>: The operation exceeded the specified failure tolerance. The failure tolerance value that
         * you've set for an operation is applied for each region during stack create and update operations. If the
         * number of failed stacks within a region exceeds the failure tolerance, the status of the operation in the
         * region is set to <code>FAILED</code>. This in turn sets the status of the operation as a whole to
         * <code>FAILED</code>, and AWS CloudFormation cancels the operation in any remaining regions.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>RUNNING</code>: The operation is currently being performed.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>STOPPED</code>: The user has cancelled the operation.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>STOPPING</code>: The operation is in the process of stopping, at user request.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SUCCEEDED</code>: The operation completed creating or updating all the specified stacks without
         * exceeding the failure tolerance for the operation.
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The overall status of the operation.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>FAILED</code>: The operation exceeded the specified failure tolerance. The failure tolerance
         *        value that you've set for an operation is applied for each region during stack create and update
         *        operations. If the number of failed stacks within a region exceeds the failure tolerance, the status
         *        of the operation in the region is set to <code>FAILED</code>. This in turn sets the status of the
         *        operation as a whole to <code>FAILED</code>, and AWS CloudFormation cancels the operation in any
         *        remaining regions.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>RUNNING</code>: The operation is currently being performed.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>STOPPED</code>: The user has cancelled the operation.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>STOPPING</code>: The operation is in the process of stopping, at user request.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SUCCEEDED</code>: The operation completed creating or updating all the specified stacks without
         *        exceeding the failure tolerance for the operation.
         *        </p>
         *        </li>
         * @see StackSetOperationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StackSetOperationStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The overall status of the operation.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>FAILED</code>: The operation exceeded the specified failure tolerance. The failure tolerance value that
         * you've set for an operation is applied for each region during stack create and update operations. If the
         * number of failed stacks within a region exceeds the failure tolerance, the status of the operation in the
         * region is set to <code>FAILED</code>. This in turn sets the status of the operation as a whole to
         * <code>FAILED</code>, and AWS CloudFormation cancels the operation in any remaining regions.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>RUNNING</code>: The operation is currently being performed.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>STOPPED</code>: The user has cancelled the operation.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>STOPPING</code>: The operation is in the process of stopping, at user request.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SUCCEEDED</code>: The operation completed creating or updating all the specified stacks without
         * exceeding the failure tolerance for the operation.
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The overall status of the operation.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>FAILED</code>: The operation exceeded the specified failure tolerance. The failure tolerance
         *        value that you've set for an operation is applied for each region during stack create and update
         *        operations. If the number of failed stacks within a region exceeds the failure tolerance, the status
         *        of the operation in the region is set to <code>FAILED</code>. This in turn sets the status of the
         *        operation as a whole to <code>FAILED</code>, and AWS CloudFormation cancels the operation in any
         *        remaining regions.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>RUNNING</code>: The operation is currently being performed.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>STOPPED</code>: The user has cancelled the operation.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>STOPPING</code>: The operation is in the process of stopping, at user request.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SUCCEEDED</code>: The operation completed creating or updating all the specified stacks without
         *        exceeding the failure tolerance for the operation.
         *        </p>
         *        </li>
         * @see StackSetOperationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StackSetOperationStatus
         */
        Builder status(StackSetOperationStatus status);

        /**
         * <p>
         * The time at which the operation was initiated. Note that the creation times for the stack set operation might
         * differ from the creation time of the individual stacks themselves. This is because AWS CloudFormation needs
         * to perform preparatory work for the operation, such as dispatching the work to the requested regions, before
         * actually creating the first stacks.
         * </p>
         * 
         * @param creationTimestamp
         *        The time at which the operation was initiated. Note that the creation times for the stack set
         *        operation might differ from the creation time of the individual stacks themselves. This is because AWS
         *        CloudFormation needs to perform preparatory work for the operation, such as dispatching the work to
         *        the requested regions, before actually creating the first stacks.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTimestamp(Instant creationTimestamp);

        /**
         * <p>
         * The time at which the stack set operation ended, across all accounts and regions specified. Note that this
         * doesn't necessarily mean that the stack set operation was successful, or even attempted, in each account or
         * region.
         * </p>
         * 
         * @param endTimestamp
         *        The time at which the stack set operation ended, across all accounts and regions specified. Note that
         *        this doesn't necessarily mean that the stack set operation was successful, or even attempted, in each
         *        account or region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endTimestamp(Instant endTimestamp);
    }

    static final class BuilderImpl implements Builder {
        private String operationId;

        private String action;

        private String status;

        private Instant creationTimestamp;

        private Instant endTimestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(StackSetOperationSummary model) {
            operationId(model.operationId);
            action(model.action);
            status(model.status);
            creationTimestamp(model.creationTimestamp);
            endTimestamp(model.endTimestamp);
        }

        public final String getOperationId() {
            return operationId;
        }

        @Override
        public final Builder operationId(String operationId) {
            this.operationId = operationId;
            return this;
        }

        public final void setOperationId(String operationId) {
            this.operationId = operationId;
        }

        public final String getAction() {
            return action;
        }

        @Override
        public final Builder action(String action) {
            this.action = action;
            return this;
        }

        @Override
        public final Builder action(StackSetOperationAction action) {
            this.action(action.toString());
            return this;
        }

        public final void setAction(String action) {
            this.action = action;
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(StackSetOperationStatus status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final Instant getCreationTimestamp() {
            return creationTimestamp;
        }

        @Override
        public final Builder creationTimestamp(Instant creationTimestamp) {
            this.creationTimestamp = creationTimestamp;
            return this;
        }

        public final void setCreationTimestamp(Instant creationTimestamp) {
            this.creationTimestamp = creationTimestamp;
        }

        public final Instant getEndTimestamp() {
            return endTimestamp;
        }

        @Override
        public final Builder endTimestamp(Instant endTimestamp) {
            this.endTimestamp = endTimestamp;
            return this;
        }

        public final void setEndTimestamp(Instant endTimestamp) {
            this.endTimestamp = endTimestamp;
        }

        @Override
        public StackSetOperationSummary build() {
            return new StackSetOperationSummary(this);
        }
    }
}
