/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudformation.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.core.runtime.TypeConverter;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The input for an <a>UpdateStack</a> action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class UpdateStackRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<UpdateStackRequest.Builder, UpdateStackRequest> {
    private final String stackName;

    private final String templateBody;

    private final String templateURL;

    private final Boolean usePreviousTemplate;

    private final String stackPolicyDuringUpdateBody;

    private final String stackPolicyDuringUpdateURL;

    private final List<Parameter> parameters;

    private final List<String> capabilities;

    private final List<String> resourceTypes;

    private final String roleARN;

    private final RollbackConfiguration rollbackConfiguration;

    private final String stackPolicyBody;

    private final String stackPolicyURL;

    private final List<String> notificationARNs;

    private final List<Tag> tags;

    private final String clientRequestToken;

    private UpdateStackRequest(BuilderImpl builder) {
        this.stackName = builder.stackName;
        this.templateBody = builder.templateBody;
        this.templateURL = builder.templateURL;
        this.usePreviousTemplate = builder.usePreviousTemplate;
        this.stackPolicyDuringUpdateBody = builder.stackPolicyDuringUpdateBody;
        this.stackPolicyDuringUpdateURL = builder.stackPolicyDuringUpdateURL;
        this.parameters = builder.parameters;
        this.capabilities = builder.capabilities;
        this.resourceTypes = builder.resourceTypes;
        this.roleARN = builder.roleARN;
        this.rollbackConfiguration = builder.rollbackConfiguration;
        this.stackPolicyBody = builder.stackPolicyBody;
        this.stackPolicyURL = builder.stackPolicyURL;
        this.notificationARNs = builder.notificationARNs;
        this.tags = builder.tags;
        this.clientRequestToken = builder.clientRequestToken;
    }

    /**
     * <p>
     * The name or unique stack ID of the stack to update.
     * </p>
     * 
     * @return The name or unique stack ID of the stack to update.
     */
    public String stackName() {
        return stackName;
    }

    /**
     * <p>
     * Structure containing the template body with a minimum length of 1 byte and a maximum length of 51,200 bytes. (For
     * more information, go to <a
     * href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html">Template Anatomy</a>
     * in the AWS CloudFormation User Guide.)
     * </p>
     * <p>
     * Conditional: You must specify only one of the following parameters: <code>TemplateBody</code>,
     * <code>TemplateURL</code>, or set the <code>UsePreviousTemplate</code> to <code>true</code>.
     * </p>
     * 
     * @return Structure containing the template body with a minimum length of 1 byte and a maximum length of 51,200
     *         bytes. (For more information, go to <a
     *         href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html">Template
     *         Anatomy</a> in the AWS CloudFormation User Guide.)</p>
     *         <p>
     *         Conditional: You must specify only one of the following parameters: <code>TemplateBody</code>,
     *         <code>TemplateURL</code>, or set the <code>UsePreviousTemplate</code> to <code>true</code>.
     */
    public String templateBody() {
        return templateBody;
    }

    /**
     * <p>
     * Location of file containing the template body. The URL must point to a template that is located in an Amazon S3
     * bucket. For more information, go to <a
     * href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html">Template Anatomy</a>
     * in the AWS CloudFormation User Guide.
     * </p>
     * <p>
     * Conditional: You must specify only one of the following parameters: <code>TemplateBody</code>,
     * <code>TemplateURL</code>, or set the <code>UsePreviousTemplate</code> to <code>true</code>.
     * </p>
     * 
     * @return Location of file containing the template body. The URL must point to a template that is located in an
     *         Amazon S3 bucket. For more information, go to <a
     *         href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html">Template
     *         Anatomy</a> in the AWS CloudFormation User Guide.</p>
     *         <p>
     *         Conditional: You must specify only one of the following parameters: <code>TemplateBody</code>,
     *         <code>TemplateURL</code>, or set the <code>UsePreviousTemplate</code> to <code>true</code>.
     */
    public String templateURL() {
        return templateURL;
    }

    /**
     * <p>
     * Reuse the existing template that is associated with the stack that you are updating.
     * </p>
     * <p>
     * Conditional: You must specify only one of the following parameters: <code>TemplateBody</code>,
     * <code>TemplateURL</code>, or set the <code>UsePreviousTemplate</code> to <code>true</code>.
     * </p>
     * 
     * @return Reuse the existing template that is associated with the stack that you are updating.</p>
     *         <p>
     *         Conditional: You must specify only one of the following parameters: <code>TemplateBody</code>,
     *         <code>TemplateURL</code>, or set the <code>UsePreviousTemplate</code> to <code>true</code>.
     */
    public Boolean usePreviousTemplate() {
        return usePreviousTemplate;
    }

    /**
     * <p>
     * Structure containing the temporary overriding stack policy body. You can specify either the
     * <code>StackPolicyDuringUpdateBody</code> or the <code>StackPolicyDuringUpdateURL</code> parameter, but not both.
     * </p>
     * <p>
     * If you want to update protected resources, specify a temporary overriding stack policy during this update. If you
     * do not specify a stack policy, the current policy that is associated with the stack will be used.
     * </p>
     * 
     * @return Structure containing the temporary overriding stack policy body. You can specify either the
     *         <code>StackPolicyDuringUpdateBody</code> or the <code>StackPolicyDuringUpdateURL</code> parameter, but
     *         not both.</p>
     *         <p>
     *         If you want to update protected resources, specify a temporary overriding stack policy during this
     *         update. If you do not specify a stack policy, the current policy that is associated with the stack will
     *         be used.
     */
    public String stackPolicyDuringUpdateBody() {
        return stackPolicyDuringUpdateBody;
    }

    /**
     * <p>
     * Location of a file containing the temporary overriding stack policy. The URL must point to a policy (max size:
     * 16KB) located in an S3 bucket in the same region as the stack. You can specify either the
     * <code>StackPolicyDuringUpdateBody</code> or the <code>StackPolicyDuringUpdateURL</code> parameter, but not both.
     * </p>
     * <p>
     * If you want to update protected resources, specify a temporary overriding stack policy during this update. If you
     * do not specify a stack policy, the current policy that is associated with the stack will be used.
     * </p>
     * 
     * @return Location of a file containing the temporary overriding stack policy. The URL must point to a policy (max
     *         size: 16KB) located in an S3 bucket in the same region as the stack. You can specify either the
     *         <code>StackPolicyDuringUpdateBody</code> or the <code>StackPolicyDuringUpdateURL</code> parameter, but
     *         not both.</p>
     *         <p>
     *         If you want to update protected resources, specify a temporary overriding stack policy during this
     *         update. If you do not specify a stack policy, the current policy that is associated with the stack will
     *         be used.
     */
    public String stackPolicyDuringUpdateURL() {
        return stackPolicyDuringUpdateURL;
    }

    /**
     * <p>
     * A list of <code>Parameter</code> structures that specify input parameters for the stack. For more information,
     * see the <a
     * href="http://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_Parameter.html">Parameter</a> data
     * type.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A list of <code>Parameter</code> structures that specify input parameters for the stack. For more
     *         information, see the <a
     *         href="http://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_Parameter.html">Parameter</a>
     *         data type.
     */
    public List<Parameter> parameters() {
        return parameters;
    }

    /**
     * <p>
     * A list of values that you must specify before AWS CloudFormation can update certain stacks. Some stack templates
     * might include resources that can affect permissions in your AWS account, for example, by creating new AWS
     * Identity and Access Management (IAM) users. For those stacks, you must explicitly acknowledge their capabilities
     * by specifying this parameter.
     * </p>
     * <p>
     * The only valid values are <code>CAPABILITY_IAM</code> and <code>CAPABILITY_NAMED_IAM</code>. The following
     * resources require you to specify this parameter: <a
     * href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-accesskey.html">
     * AWS::IAM::AccessKey</a>, <a
     * href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-group.html">
     * AWS::IAM::Group</a>, <a
     * href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-instanceprofile.html">
     * AWS::IAM::InstanceProfile</a>, <a
     * href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-policy.html">
     * AWS::IAM::Policy</a>, <a
     * href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-role.html">
     * AWS::IAM::Role</a>, <a
     * href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-user.html">
     * AWS::IAM::User</a>, and <a
     * href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-addusertogroup.html">
     * AWS::IAM::UserToGroupAddition</a>. If your stack template contains these resources, we recommend that you review
     * all permissions associated with them and edit their permissions if necessary.
     * </p>
     * <p>
     * If you have IAM resources, you can specify either capability. If you have IAM resources with custom names, you
     * must specify <code>CAPABILITY_NAMED_IAM</code>. If you don't specify this parameter, this action returns an
     * <code>InsufficientCapabilities</code> error.
     * </p>
     * <p>
     * For more information, see <a
     * href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html#capabilities"
     * >Acknowledging IAM Resources in AWS CloudFormation Templates</a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A list of values that you must specify before AWS CloudFormation can update certain stacks. Some stack
     *         templates might include resources that can affect permissions in your AWS account, for example, by
     *         creating new AWS Identity and Access Management (IAM) users. For those stacks, you must explicitly
     *         acknowledge their capabilities by specifying this parameter.</p>
     *         <p>
     *         The only valid values are <code>CAPABILITY_IAM</code> and <code>CAPABILITY_NAMED_IAM</code>. The
     *         following resources require you to specify this parameter: <a
     *         href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-accesskey.html">
     *         AWS::IAM::AccessKey</a>, <a
     *         href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-group.html">
     *         AWS::IAM::Group</a>, <a href=
     *         "http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-instanceprofile.html">
     *         AWS::IAM::InstanceProfile</a>, <a
     *         href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-policy.html">
     *         AWS::IAM::Policy</a>, <a
     *         href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-role.html">
     *         AWS::IAM::Role</a>, <a
     *         href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-user.html">
     *         AWS::IAM::User</a>, and <a href=
     *         "http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-addusertogroup.html">
     *         AWS::IAM::UserToGroupAddition</a>. If your stack template contains these resources, we recommend that you
     *         review all permissions associated with them and edit their permissions if necessary.
     *         </p>
     *         <p>
     *         If you have IAM resources, you can specify either capability. If you have IAM resources with custom
     *         names, you must specify <code>CAPABILITY_NAMED_IAM</code>. If you don't specify this parameter, this
     *         action returns an <code>InsufficientCapabilities</code> error.
     *         </p>
     *         <p>
     *         For more information, see <a href=
     *         "http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html#capabilities"
     *         >Acknowledging IAM Resources in AWS CloudFormation Templates</a>.
     */
    public List<Capability> capabilities() {
        return TypeConverter.convert(capabilities, Capability::fromValue);
    }

    /**
     * <p>
     * A list of values that you must specify before AWS CloudFormation can update certain stacks. Some stack templates
     * might include resources that can affect permissions in your AWS account, for example, by creating new AWS
     * Identity and Access Management (IAM) users. For those stacks, you must explicitly acknowledge their capabilities
     * by specifying this parameter.
     * </p>
     * <p>
     * The only valid values are <code>CAPABILITY_IAM</code> and <code>CAPABILITY_NAMED_IAM</code>. The following
     * resources require you to specify this parameter: <a
     * href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-accesskey.html">
     * AWS::IAM::AccessKey</a>, <a
     * href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-group.html">
     * AWS::IAM::Group</a>, <a
     * href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-instanceprofile.html">
     * AWS::IAM::InstanceProfile</a>, <a
     * href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-policy.html">
     * AWS::IAM::Policy</a>, <a
     * href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-role.html">
     * AWS::IAM::Role</a>, <a
     * href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-user.html">
     * AWS::IAM::User</a>, and <a
     * href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-addusertogroup.html">
     * AWS::IAM::UserToGroupAddition</a>. If your stack template contains these resources, we recommend that you review
     * all permissions associated with them and edit their permissions if necessary.
     * </p>
     * <p>
     * If you have IAM resources, you can specify either capability. If you have IAM resources with custom names, you
     * must specify <code>CAPABILITY_NAMED_IAM</code>. If you don't specify this parameter, this action returns an
     * <code>InsufficientCapabilities</code> error.
     * </p>
     * <p>
     * For more information, see <a
     * href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html#capabilities"
     * >Acknowledging IAM Resources in AWS CloudFormation Templates</a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A list of values that you must specify before AWS CloudFormation can update certain stacks. Some stack
     *         templates might include resources that can affect permissions in your AWS account, for example, by
     *         creating new AWS Identity and Access Management (IAM) users. For those stacks, you must explicitly
     *         acknowledge their capabilities by specifying this parameter.</p>
     *         <p>
     *         The only valid values are <code>CAPABILITY_IAM</code> and <code>CAPABILITY_NAMED_IAM</code>. The
     *         following resources require you to specify this parameter: <a
     *         href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-accesskey.html">
     *         AWS::IAM::AccessKey</a>, <a
     *         href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-group.html">
     *         AWS::IAM::Group</a>, <a href=
     *         "http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-instanceprofile.html">
     *         AWS::IAM::InstanceProfile</a>, <a
     *         href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-policy.html">
     *         AWS::IAM::Policy</a>, <a
     *         href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-role.html">
     *         AWS::IAM::Role</a>, <a
     *         href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-user.html">
     *         AWS::IAM::User</a>, and <a href=
     *         "http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-addusertogroup.html">
     *         AWS::IAM::UserToGroupAddition</a>. If your stack template contains these resources, we recommend that you
     *         review all permissions associated with them and edit their permissions if necessary.
     *         </p>
     *         <p>
     *         If you have IAM resources, you can specify either capability. If you have IAM resources with custom
     *         names, you must specify <code>CAPABILITY_NAMED_IAM</code>. If you don't specify this parameter, this
     *         action returns an <code>InsufficientCapabilities</code> error.
     *         </p>
     *         <p>
     *         For more information, see <a href=
     *         "http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html#capabilities"
     *         >Acknowledging IAM Resources in AWS CloudFormation Templates</a>.
     */
    public List<String> capabilitiesStrings() {
        return capabilities;
    }

    /**
     * <p>
     * The template resource types that you have permissions to work with for this update stack action, such as
     * <code>AWS::EC2::Instance</code>, <code>AWS::EC2::*</code>, or <code>Custom::MyCustomInstance</code>.
     * </p>
     * <p>
     * If the list of resource types doesn't include a resource that you're updating, the stack update fails. By
     * default, AWS CloudFormation grants permissions to all resource types. AWS Identity and Access Management (IAM)
     * uses this parameter for AWS CloudFormation-specific condition keys in IAM policies. For more information, see <a
     * href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html">Controlling Access
     * with AWS Identity and Access Management</a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The template resource types that you have permissions to work with for this update stack action, such as
     *         <code>AWS::EC2::Instance</code>, <code>AWS::EC2::*</code>, or <code>Custom::MyCustomInstance</code>.</p>
     *         <p>
     *         If the list of resource types doesn't include a resource that you're updating, the stack update fails. By
     *         default, AWS CloudFormation grants permissions to all resource types. AWS Identity and Access Management
     *         (IAM) uses this parameter for AWS CloudFormation-specific condition keys in IAM policies. For more
     *         information, see <a
     *         href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html">Controlling
     *         Access with AWS Identity and Access Management</a>.
     */
    public List<String> resourceTypes() {
        return resourceTypes;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of an AWS Identity and Access Management (IAM) role that AWS CloudFormation
     * assumes to update the stack. AWS CloudFormation uses the role's credentials to make calls on your behalf. AWS
     * CloudFormation always uses this role for all future operations on the stack. As long as users have permission to
     * operate on the stack, AWS CloudFormation uses this role even if the users don't have permission to pass it.
     * Ensure that the role grants least privilege.
     * </p>
     * <p>
     * If you don't specify a value, AWS CloudFormation uses the role that was previously associated with the stack. If
     * no role is available, AWS CloudFormation uses a temporary session that is generated from your user credentials.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of an AWS Identity and Access Management (IAM) role that AWS
     *         CloudFormation assumes to update the stack. AWS CloudFormation uses the role's credentials to make calls
     *         on your behalf. AWS CloudFormation always uses this role for all future operations on the stack. As long
     *         as users have permission to operate on the stack, AWS CloudFormation uses this role even if the users
     *         don't have permission to pass it. Ensure that the role grants least privilege.</p>
     *         <p>
     *         If you don't specify a value, AWS CloudFormation uses the role that was previously associated with the
     *         stack. If no role is available, AWS CloudFormation uses a temporary session that is generated from your
     *         user credentials.
     */
    public String roleARN() {
        return roleARN;
    }

    /**
     * <p>
     * The rollback triggers for AWS CloudFormation to monitor during stack creation and updating operations, and for
     * the specified monitoring period afterwards.
     * </p>
     * 
     * @return The rollback triggers for AWS CloudFormation to monitor during stack creation and updating operations,
     *         and for the specified monitoring period afterwards.
     */
    public RollbackConfiguration rollbackConfiguration() {
        return rollbackConfiguration;
    }

    /**
     * <p>
     * Structure containing a new stack policy body. You can specify either the <code>StackPolicyBody</code> or the
     * <code>StackPolicyURL</code> parameter, but not both.
     * </p>
     * <p>
     * You might update the stack policy, for example, in order to protect a new resource that you created during a
     * stack update. If you do not specify a stack policy, the current policy that is associated with the stack is
     * unchanged.
     * </p>
     * 
     * @return Structure containing a new stack policy body. You can specify either the <code>StackPolicyBody</code> or
     *         the <code>StackPolicyURL</code> parameter, but not both.</p>
     *         <p>
     *         You might update the stack policy, for example, in order to protect a new resource that you created
     *         during a stack update. If you do not specify a stack policy, the current policy that is associated with
     *         the stack is unchanged.
     */
    public String stackPolicyBody() {
        return stackPolicyBody;
    }

    /**
     * <p>
     * Location of a file containing the updated stack policy. The URL must point to a policy (max size: 16KB) located
     * in an S3 bucket in the same region as the stack. You can specify either the <code>StackPolicyBody</code> or the
     * <code>StackPolicyURL</code> parameter, but not both.
     * </p>
     * <p>
     * You might update the stack policy, for example, in order to protect a new resource that you created during a
     * stack update. If you do not specify a stack policy, the current policy that is associated with the stack is
     * unchanged.
     * </p>
     * 
     * @return Location of a file containing the updated stack policy. The URL must point to a policy (max size: 16KB)
     *         located in an S3 bucket in the same region as the stack. You can specify either the
     *         <code>StackPolicyBody</code> or the <code>StackPolicyURL</code> parameter, but not both.</p>
     *         <p>
     *         You might update the stack policy, for example, in order to protect a new resource that you created
     *         during a stack update. If you do not specify a stack policy, the current policy that is associated with
     *         the stack is unchanged.
     */
    public String stackPolicyURL() {
        return stackPolicyURL;
    }

    /**
     * <p>
     * Amazon Simple Notification Service topic Amazon Resource Names (ARNs) that AWS CloudFormation associates with the
     * stack. Specify an empty list to remove all notification topics.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Amazon Simple Notification Service topic Amazon Resource Names (ARNs) that AWS CloudFormation associates
     *         with the stack. Specify an empty list to remove all notification topics.
     */
    public List<String> notificationARNs() {
        return notificationARNs;
    }

    /**
     * <p>
     * Key-value pairs to associate with this stack. AWS CloudFormation also propagates these tags to supported
     * resources in the stack. You can specify a maximum number of 50 tags.
     * </p>
     * <p>
     * If you don't specify this parameter, AWS CloudFormation doesn't modify the stack's tags. If you specify an empty
     * value, AWS CloudFormation removes all associated tags.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Key-value pairs to associate with this stack. AWS CloudFormation also propagates these tags to supported
     *         resources in the stack. You can specify a maximum number of 50 tags.</p>
     *         <p>
     *         If you don't specify this parameter, AWS CloudFormation doesn't modify the stack's tags. If you specify
     *         an empty value, AWS CloudFormation removes all associated tags.
     */
    public List<Tag> tags() {
        return tags;
    }

    /**
     * <p>
     * A unique identifier for this <code>UpdateStack</code> request. Specify this token if you plan to retry requests
     * so that AWS CloudFormation knows that you're not attempting to update a stack with the same name. You might retry
     * <code>UpdateStack</code> requests to ensure that AWS CloudFormation successfully received them.
     * </p>
     * <p>
     * All events triggered by a given stack operation are assigned the same client request token, which you can use to
     * track operations. For example, if you execute a <code>CreateStack</code> operation with the token
     * <code>token1</code>, then all the <code>StackEvents</code> generated by that operation will have
     * <code>ClientRequestToken</code> set as <code>token1</code>.
     * </p>
     * <p>
     * In the console, stack operations display the client request token on the Events tab. Stack operations that are
     * initiated from the console use the token format <i>Console-StackOperation-ID</i>, which helps you easily identify
     * the stack operation . For example, if you create a stack using the console, each stack event would be assigned
     * the same token in the following format: <code>Console-CreateStack-7f59c3cf-00d2-40c7-b2ff-e75db0987002</code>.
     * </p>
     * 
     * @return A unique identifier for this <code>UpdateStack</code> request. Specify this token if you plan to retry
     *         requests so that AWS CloudFormation knows that you're not attempting to update a stack with the same
     *         name. You might retry <code>UpdateStack</code> requests to ensure that AWS CloudFormation successfully
     *         received them.</p>
     *         <p>
     *         All events triggered by a given stack operation are assigned the same client request token, which you can
     *         use to track operations. For example, if you execute a <code>CreateStack</code> operation with the token
     *         <code>token1</code>, then all the <code>StackEvents</code> generated by that operation will have
     *         <code>ClientRequestToken</code> set as <code>token1</code>.
     *         </p>
     *         <p>
     *         In the console, stack operations display the client request token on the Events tab. Stack operations
     *         that are initiated from the console use the token format <i>Console-StackOperation-ID</i>, which helps
     *         you easily identify the stack operation . For example, if you create a stack using the console, each
     *         stack event would be assigned the same token in the following format:
     *         <code>Console-CreateStack-7f59c3cf-00d2-40c7-b2ff-e75db0987002</code>.
     */
    public String clientRequestToken() {
        return clientRequestToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(stackName());
        hashCode = 31 * hashCode + Objects.hashCode(templateBody());
        hashCode = 31 * hashCode + Objects.hashCode(templateURL());
        hashCode = 31 * hashCode + Objects.hashCode(usePreviousTemplate());
        hashCode = 31 * hashCode + Objects.hashCode(stackPolicyDuringUpdateBody());
        hashCode = 31 * hashCode + Objects.hashCode(stackPolicyDuringUpdateURL());
        hashCode = 31 * hashCode + Objects.hashCode(parameters());
        hashCode = 31 * hashCode + Objects.hashCode(capabilitiesStrings());
        hashCode = 31 * hashCode + Objects.hashCode(resourceTypes());
        hashCode = 31 * hashCode + Objects.hashCode(roleARN());
        hashCode = 31 * hashCode + Objects.hashCode(rollbackConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(stackPolicyBody());
        hashCode = 31 * hashCode + Objects.hashCode(stackPolicyURL());
        hashCode = 31 * hashCode + Objects.hashCode(notificationARNs());
        hashCode = 31 * hashCode + Objects.hashCode(tags());
        hashCode = 31 * hashCode + Objects.hashCode(clientRequestToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateStackRequest)) {
            return false;
        }
        UpdateStackRequest other = (UpdateStackRequest) obj;
        return Objects.equals(stackName(), other.stackName()) && Objects.equals(templateBody(), other.templateBody())
                && Objects.equals(templateURL(), other.templateURL())
                && Objects.equals(usePreviousTemplate(), other.usePreviousTemplate())
                && Objects.equals(stackPolicyDuringUpdateBody(), other.stackPolicyDuringUpdateBody())
                && Objects.equals(stackPolicyDuringUpdateURL(), other.stackPolicyDuringUpdateURL())
                && Objects.equals(parameters(), other.parameters())
                && Objects.equals(capabilitiesStrings(), other.capabilitiesStrings())
                && Objects.equals(resourceTypes(), other.resourceTypes()) && Objects.equals(roleARN(), other.roleARN())
                && Objects.equals(rollbackConfiguration(), other.rollbackConfiguration())
                && Objects.equals(stackPolicyBody(), other.stackPolicyBody())
                && Objects.equals(stackPolicyURL(), other.stackPolicyURL())
                && Objects.equals(notificationARNs(), other.notificationARNs()) && Objects.equals(tags(), other.tags())
                && Objects.equals(clientRequestToken(), other.clientRequestToken());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (stackName() != null) {
            sb.append("StackName: ").append(stackName()).append(",");
        }
        if (templateBody() != null) {
            sb.append("TemplateBody: ").append(templateBody()).append(",");
        }
        if (templateURL() != null) {
            sb.append("TemplateURL: ").append(templateURL()).append(",");
        }
        if (usePreviousTemplate() != null) {
            sb.append("UsePreviousTemplate: ").append(usePreviousTemplate()).append(",");
        }
        if (stackPolicyDuringUpdateBody() != null) {
            sb.append("StackPolicyDuringUpdateBody: ").append(stackPolicyDuringUpdateBody()).append(",");
        }
        if (stackPolicyDuringUpdateURL() != null) {
            sb.append("StackPolicyDuringUpdateURL: ").append(stackPolicyDuringUpdateURL()).append(",");
        }
        if (parameters() != null) {
            sb.append("Parameters: ").append(parameters()).append(",");
        }
        if (capabilitiesStrings() != null) {
            sb.append("Capabilities: ").append(capabilitiesStrings()).append(",");
        }
        if (resourceTypes() != null) {
            sb.append("ResourceTypes: ").append(resourceTypes()).append(",");
        }
        if (roleARN() != null) {
            sb.append("RoleARN: ").append(roleARN()).append(",");
        }
        if (rollbackConfiguration() != null) {
            sb.append("RollbackConfiguration: ").append(rollbackConfiguration()).append(",");
        }
        if (stackPolicyBody() != null) {
            sb.append("StackPolicyBody: ").append(stackPolicyBody()).append(",");
        }
        if (stackPolicyURL() != null) {
            sb.append("StackPolicyURL: ").append(stackPolicyURL()).append(",");
        }
        if (notificationARNs() != null) {
            sb.append("NotificationARNs: ").append(notificationARNs()).append(",");
        }
        if (tags() != null) {
            sb.append("Tags: ").append(tags()).append(",");
        }
        if (clientRequestToken() != null) {
            sb.append("ClientRequestToken: ").append(clientRequestToken()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StackName":
            return Optional.of(clazz.cast(stackName()));
        case "TemplateBody":
            return Optional.of(clazz.cast(templateBody()));
        case "TemplateURL":
            return Optional.of(clazz.cast(templateURL()));
        case "UsePreviousTemplate":
            return Optional.of(clazz.cast(usePreviousTemplate()));
        case "StackPolicyDuringUpdateBody":
            return Optional.of(clazz.cast(stackPolicyDuringUpdateBody()));
        case "StackPolicyDuringUpdateURL":
            return Optional.of(clazz.cast(stackPolicyDuringUpdateURL()));
        case "Parameters":
            return Optional.of(clazz.cast(parameters()));
        case "Capabilities":
            return Optional.of(clazz.cast(capabilitiesStrings()));
        case "ResourceTypes":
            return Optional.of(clazz.cast(resourceTypes()));
        case "RoleARN":
            return Optional.of(clazz.cast(roleARN()));
        case "RollbackConfiguration":
            return Optional.of(clazz.cast(rollbackConfiguration()));
        case "StackPolicyBody":
            return Optional.of(clazz.cast(stackPolicyBody()));
        case "StackPolicyURL":
            return Optional.of(clazz.cast(stackPolicyURL()));
        case "NotificationARNs":
            return Optional.of(clazz.cast(notificationARNs()));
        case "Tags":
            return Optional.of(clazz.cast(tags()));
        case "ClientRequestToken":
            return Optional.of(clazz.cast(clientRequestToken()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, UpdateStackRequest> {
        /**
         * <p>
         * The name or unique stack ID of the stack to update.
         * </p>
         * 
         * @param stackName
         *        The name or unique stack ID of the stack to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stackName(String stackName);

        /**
         * <p>
         * Structure containing the template body with a minimum length of 1 byte and a maximum length of 51,200 bytes.
         * (For more information, go to <a
         * href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html">Template
         * Anatomy</a> in the AWS CloudFormation User Guide.)
         * </p>
         * <p>
         * Conditional: You must specify only one of the following parameters: <code>TemplateBody</code>,
         * <code>TemplateURL</code>, or set the <code>UsePreviousTemplate</code> to <code>true</code>.
         * </p>
         * 
         * @param templateBody
         *        Structure containing the template body with a minimum length of 1 byte and a maximum length of 51,200
         *        bytes. (For more information, go to <a
         *        href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html">Template
         *        Anatomy</a> in the AWS CloudFormation User Guide.)</p>
         *        <p>
         *        Conditional: You must specify only one of the following parameters: <code>TemplateBody</code>,
         *        <code>TemplateURL</code>, or set the <code>UsePreviousTemplate</code> to <code>true</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder templateBody(String templateBody);

        /**
         * <p>
         * Location of file containing the template body. The URL must point to a template that is located in an Amazon
         * S3 bucket. For more information, go to <a
         * href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html">Template
         * Anatomy</a> in the AWS CloudFormation User Guide.
         * </p>
         * <p>
         * Conditional: You must specify only one of the following parameters: <code>TemplateBody</code>,
         * <code>TemplateURL</code>, or set the <code>UsePreviousTemplate</code> to <code>true</code>.
         * </p>
         * 
         * @param templateURL
         *        Location of file containing the template body. The URL must point to a template that is located in an
         *        Amazon S3 bucket. For more information, go to <a
         *        href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html">Template
         *        Anatomy</a> in the AWS CloudFormation User Guide.</p>
         *        <p>
         *        Conditional: You must specify only one of the following parameters: <code>TemplateBody</code>,
         *        <code>TemplateURL</code>, or set the <code>UsePreviousTemplate</code> to <code>true</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder templateURL(String templateURL);

        /**
         * <p>
         * Reuse the existing template that is associated with the stack that you are updating.
         * </p>
         * <p>
         * Conditional: You must specify only one of the following parameters: <code>TemplateBody</code>,
         * <code>TemplateURL</code>, or set the <code>UsePreviousTemplate</code> to <code>true</code>.
         * </p>
         * 
         * @param usePreviousTemplate
         *        Reuse the existing template that is associated with the stack that you are updating.</p>
         *        <p>
         *        Conditional: You must specify only one of the following parameters: <code>TemplateBody</code>,
         *        <code>TemplateURL</code>, or set the <code>UsePreviousTemplate</code> to <code>true</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder usePreviousTemplate(Boolean usePreviousTemplate);

        /**
         * <p>
         * Structure containing the temporary overriding stack policy body. You can specify either the
         * <code>StackPolicyDuringUpdateBody</code> or the <code>StackPolicyDuringUpdateURL</code> parameter, but not
         * both.
         * </p>
         * <p>
         * If you want to update protected resources, specify a temporary overriding stack policy during this update. If
         * you do not specify a stack policy, the current policy that is associated with the stack will be used.
         * </p>
         * 
         * @param stackPolicyDuringUpdateBody
         *        Structure containing the temporary overriding stack policy body. You can specify either the
         *        <code>StackPolicyDuringUpdateBody</code> or the <code>StackPolicyDuringUpdateURL</code> parameter, but
         *        not both.</p>
         *        <p>
         *        If you want to update protected resources, specify a temporary overriding stack policy during this
         *        update. If you do not specify a stack policy, the current policy that is associated with the stack
         *        will be used.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stackPolicyDuringUpdateBody(String stackPolicyDuringUpdateBody);

        /**
         * <p>
         * Location of a file containing the temporary overriding stack policy. The URL must point to a policy (max
         * size: 16KB) located in an S3 bucket in the same region as the stack. You can specify either the
         * <code>StackPolicyDuringUpdateBody</code> or the <code>StackPolicyDuringUpdateURL</code> parameter, but not
         * both.
         * </p>
         * <p>
         * If you want to update protected resources, specify a temporary overriding stack policy during this update. If
         * you do not specify a stack policy, the current policy that is associated with the stack will be used.
         * </p>
         * 
         * @param stackPolicyDuringUpdateURL
         *        Location of a file containing the temporary overriding stack policy. The URL must point to a policy
         *        (max size: 16KB) located in an S3 bucket in the same region as the stack. You can specify either the
         *        <code>StackPolicyDuringUpdateBody</code> or the <code>StackPolicyDuringUpdateURL</code> parameter, but
         *        not both.</p>
         *        <p>
         *        If you want to update protected resources, specify a temporary overriding stack policy during this
         *        update. If you do not specify a stack policy, the current policy that is associated with the stack
         *        will be used.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stackPolicyDuringUpdateURL(String stackPolicyDuringUpdateURL);

        /**
         * <p>
         * A list of <code>Parameter</code> structures that specify input parameters for the stack. For more
         * information, see the <a
         * href="http://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_Parameter.html">Parameter</a> data
         * type.
         * </p>
         * 
         * @param parameters
         *        A list of <code>Parameter</code> structures that specify input parameters for the stack. For more
         *        information, see the <a
         *        href="http://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_Parameter.html"
         *        >Parameter</a> data type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameters(Collection<Parameter> parameters);

        /**
         * <p>
         * A list of <code>Parameter</code> structures that specify input parameters for the stack. For more
         * information, see the <a
         * href="http://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_Parameter.html">Parameter</a> data
         * type.
         * </p>
         * 
         * @param parameters
         *        A list of <code>Parameter</code> structures that specify input parameters for the stack. For more
         *        information, see the <a
         *        href="http://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_Parameter.html"
         *        >Parameter</a> data type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameters(Parameter... parameters);

        /**
         * <p>
         * A list of values that you must specify before AWS CloudFormation can update certain stacks. Some stack
         * templates might include resources that can affect permissions in your AWS account, for example, by creating
         * new AWS Identity and Access Management (IAM) users. For those stacks, you must explicitly acknowledge their
         * capabilities by specifying this parameter.
         * </p>
         * <p>
         * The only valid values are <code>CAPABILITY_IAM</code> and <code>CAPABILITY_NAMED_IAM</code>. The following
         * resources require you to specify this parameter: <a
         * href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-accesskey.html">
         * AWS::IAM::AccessKey</a>, <a
         * href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-group.html">
         * AWS::IAM::Group</a>, <a
         * href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-instanceprofile.html">
         * AWS::IAM::InstanceProfile</a>, <a
         * href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-policy.html">
         * AWS::IAM::Policy</a>, <a
         * href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-role.html">
         * AWS::IAM::Role</a>, <a
         * href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-user.html">
         * AWS::IAM::User</a>, and <a
         * href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-addusertogroup.html">
         * AWS::IAM::UserToGroupAddition</a>. If your stack template contains these resources, we recommend that you
         * review all permissions associated with them and edit their permissions if necessary.
         * </p>
         * <p>
         * If you have IAM resources, you can specify either capability. If you have IAM resources with custom names,
         * you must specify <code>CAPABILITY_NAMED_IAM</code>. If you don't specify this parameter, this action returns
         * an <code>InsufficientCapabilities</code> error.
         * </p>
         * <p>
         * For more information, see <a
         * href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html#capabilities"
         * >Acknowledging IAM Resources in AWS CloudFormation Templates</a>.
         * </p>
         * 
         * @param capabilities
         *        A list of values that you must specify before AWS CloudFormation can update certain stacks. Some stack
         *        templates might include resources that can affect permissions in your AWS account, for example, by
         *        creating new AWS Identity and Access Management (IAM) users. For those stacks, you must explicitly
         *        acknowledge their capabilities by specifying this parameter.</p>
         *        <p>
         *        The only valid values are <code>CAPABILITY_IAM</code> and <code>CAPABILITY_NAMED_IAM</code>. The
         *        following resources require you to specify this parameter: <a href=
         *        "http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-accesskey.html">
         *        AWS::IAM::AccessKey</a>, <a
         *        href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-group.html">
         *        AWS::IAM::Group</a>, <a href=
         *        "http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-instanceprofile.html">
         *        AWS::IAM::InstanceProfile</a>, <a
         *        href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-policy.html">
         *        AWS::IAM::Policy</a>, <a
         *        href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-role.html">
         *        AWS::IAM::Role</a>, <a
         *        href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-user.html">
         *        AWS::IAM::User</a>, and <a href=
         *        "http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-addusertogroup.html"
         *        > AWS::IAM::UserToGroupAddition</a>. If your stack template contains these resources, we recommend
         *        that you review all permissions associated with them and edit their permissions if necessary.
         *        </p>
         *        <p>
         *        If you have IAM resources, you can specify either capability. If you have IAM resources with custom
         *        names, you must specify <code>CAPABILITY_NAMED_IAM</code>. If you don't specify this parameter, this
         *        action returns an <code>InsufficientCapabilities</code> error.
         *        </p>
         *        <p>
         *        For more information, see <a href=
         *        "http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html#capabilities"
         *        >Acknowledging IAM Resources in AWS CloudFormation Templates</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capabilities(Collection<String> capabilities);

        /**
         * <p>
         * A list of values that you must specify before AWS CloudFormation can update certain stacks. Some stack
         * templates might include resources that can affect permissions in your AWS account, for example, by creating
         * new AWS Identity and Access Management (IAM) users. For those stacks, you must explicitly acknowledge their
         * capabilities by specifying this parameter.
         * </p>
         * <p>
         * The only valid values are <code>CAPABILITY_IAM</code> and <code>CAPABILITY_NAMED_IAM</code>. The following
         * resources require you to specify this parameter: <a
         * href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-accesskey.html">
         * AWS::IAM::AccessKey</a>, <a
         * href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-group.html">
         * AWS::IAM::Group</a>, <a
         * href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-instanceprofile.html">
         * AWS::IAM::InstanceProfile</a>, <a
         * href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-policy.html">
         * AWS::IAM::Policy</a>, <a
         * href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-role.html">
         * AWS::IAM::Role</a>, <a
         * href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-user.html">
         * AWS::IAM::User</a>, and <a
         * href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-addusertogroup.html">
         * AWS::IAM::UserToGroupAddition</a>. If your stack template contains these resources, we recommend that you
         * review all permissions associated with them and edit their permissions if necessary.
         * </p>
         * <p>
         * If you have IAM resources, you can specify either capability. If you have IAM resources with custom names,
         * you must specify <code>CAPABILITY_NAMED_IAM</code>. If you don't specify this parameter, this action returns
         * an <code>InsufficientCapabilities</code> error.
         * </p>
         * <p>
         * For more information, see <a
         * href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html#capabilities"
         * >Acknowledging IAM Resources in AWS CloudFormation Templates</a>.
         * </p>
         * 
         * @param capabilities
         *        A list of values that you must specify before AWS CloudFormation can update certain stacks. Some stack
         *        templates might include resources that can affect permissions in your AWS account, for example, by
         *        creating new AWS Identity and Access Management (IAM) users. For those stacks, you must explicitly
         *        acknowledge their capabilities by specifying this parameter.</p>
         *        <p>
         *        The only valid values are <code>CAPABILITY_IAM</code> and <code>CAPABILITY_NAMED_IAM</code>. The
         *        following resources require you to specify this parameter: <a href=
         *        "http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-accesskey.html">
         *        AWS::IAM::AccessKey</a>, <a
         *        href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-group.html">
         *        AWS::IAM::Group</a>, <a href=
         *        "http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-instanceprofile.html">
         *        AWS::IAM::InstanceProfile</a>, <a
         *        href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-policy.html">
         *        AWS::IAM::Policy</a>, <a
         *        href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-role.html">
         *        AWS::IAM::Role</a>, <a
         *        href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-user.html">
         *        AWS::IAM::User</a>, and <a href=
         *        "http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-addusertogroup.html"
         *        > AWS::IAM::UserToGroupAddition</a>. If your stack template contains these resources, we recommend
         *        that you review all permissions associated with them and edit their permissions if necessary.
         *        </p>
         *        <p>
         *        If you have IAM resources, you can specify either capability. If you have IAM resources with custom
         *        names, you must specify <code>CAPABILITY_NAMED_IAM</code>. If you don't specify this parameter, this
         *        action returns an <code>InsufficientCapabilities</code> error.
         *        </p>
         *        <p>
         *        For more information, see <a href=
         *        "http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html#capabilities"
         *        >Acknowledging IAM Resources in AWS CloudFormation Templates</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capabilities(String... capabilities);

        /**
         * <p>
         * The template resource types that you have permissions to work with for this update stack action, such as
         * <code>AWS::EC2::Instance</code>, <code>AWS::EC2::*</code>, or <code>Custom::MyCustomInstance</code>.
         * </p>
         * <p>
         * If the list of resource types doesn't include a resource that you're updating, the stack update fails. By
         * default, AWS CloudFormation grants permissions to all resource types. AWS Identity and Access Management
         * (IAM) uses this parameter for AWS CloudFormation-specific condition keys in IAM policies. For more
         * information, see <a
         * href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html">Controlling
         * Access with AWS Identity and Access Management</a>.
         * </p>
         * 
         * @param resourceTypes
         *        The template resource types that you have permissions to work with for this update stack action, such
         *        as <code>AWS::EC2::Instance</code>, <code>AWS::EC2::*</code>, or <code>Custom::MyCustomInstance</code>
         *        .</p>
         *        <p>
         *        If the list of resource types doesn't include a resource that you're updating, the stack update fails.
         *        By default, AWS CloudFormation grants permissions to all resource types. AWS Identity and Access
         *        Management (IAM) uses this parameter for AWS CloudFormation-specific condition keys in IAM policies.
         *        For more information, see <a
         *        href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html"
         *        >Controlling Access with AWS Identity and Access Management</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceTypes(Collection<String> resourceTypes);

        /**
         * <p>
         * The template resource types that you have permissions to work with for this update stack action, such as
         * <code>AWS::EC2::Instance</code>, <code>AWS::EC2::*</code>, or <code>Custom::MyCustomInstance</code>.
         * </p>
         * <p>
         * If the list of resource types doesn't include a resource that you're updating, the stack update fails. By
         * default, AWS CloudFormation grants permissions to all resource types. AWS Identity and Access Management
         * (IAM) uses this parameter for AWS CloudFormation-specific condition keys in IAM policies. For more
         * information, see <a
         * href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html">Controlling
         * Access with AWS Identity and Access Management</a>.
         * </p>
         * 
         * @param resourceTypes
         *        The template resource types that you have permissions to work with for this update stack action, such
         *        as <code>AWS::EC2::Instance</code>, <code>AWS::EC2::*</code>, or <code>Custom::MyCustomInstance</code>
         *        .</p>
         *        <p>
         *        If the list of resource types doesn't include a resource that you're updating, the stack update fails.
         *        By default, AWS CloudFormation grants permissions to all resource types. AWS Identity and Access
         *        Management (IAM) uses this parameter for AWS CloudFormation-specific condition keys in IAM policies.
         *        For more information, see <a
         *        href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html"
         *        >Controlling Access with AWS Identity and Access Management</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceTypes(String... resourceTypes);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of an AWS Identity and Access Management (IAM) role that AWS CloudFormation
         * assumes to update the stack. AWS CloudFormation uses the role's credentials to make calls on your behalf. AWS
         * CloudFormation always uses this role for all future operations on the stack. As long as users have permission
         * to operate on the stack, AWS CloudFormation uses this role even if the users don't have permission to pass
         * it. Ensure that the role grants least privilege.
         * </p>
         * <p>
         * If you don't specify a value, AWS CloudFormation uses the role that was previously associated with the stack.
         * If no role is available, AWS CloudFormation uses a temporary session that is generated from your user
         * credentials.
         * </p>
         * 
         * @param roleARN
         *        The Amazon Resource Name (ARN) of an AWS Identity and Access Management (IAM) role that AWS
         *        CloudFormation assumes to update the stack. AWS CloudFormation uses the role's credentials to make
         *        calls on your behalf. AWS CloudFormation always uses this role for all future operations on the stack.
         *        As long as users have permission to operate on the stack, AWS CloudFormation uses this role even if
         *        the users don't have permission to pass it. Ensure that the role grants least privilege.</p>
         *        <p>
         *        If you don't specify a value, AWS CloudFormation uses the role that was previously associated with the
         *        stack. If no role is available, AWS CloudFormation uses a temporary session that is generated from
         *        your user credentials.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleARN(String roleARN);

        /**
         * <p>
         * The rollback triggers for AWS CloudFormation to monitor during stack creation and updating operations, and
         * for the specified monitoring period afterwards.
         * </p>
         * 
         * @param rollbackConfiguration
         *        The rollback triggers for AWS CloudFormation to monitor during stack creation and updating operations,
         *        and for the specified monitoring period afterwards.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rollbackConfiguration(RollbackConfiguration rollbackConfiguration);

        /**
         * <p>
         * The rollback triggers for AWS CloudFormation to monitor during stack creation and updating operations, and
         * for the specified monitoring period afterwards.
         * </p>
         * This is a convenience that creates an instance of the {@link RollbackConfiguration.Builder} avoiding the need
         * to create one manually via {@link RollbackConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link RollbackConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #rollbackConfiguration(RollbackConfiguration)}.
         * 
         * @param rollbackConfiguration
         *        a consumer that will call methods on {@link RollbackConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #rollbackConfiguration(RollbackConfiguration)
         */
        default Builder rollbackConfiguration(Consumer<RollbackConfiguration.Builder> rollbackConfiguration) {
            return rollbackConfiguration(RollbackConfiguration.builder().apply(rollbackConfiguration).build());
        }

        /**
         * <p>
         * Structure containing a new stack policy body. You can specify either the <code>StackPolicyBody</code> or the
         * <code>StackPolicyURL</code> parameter, but not both.
         * </p>
         * <p>
         * You might update the stack policy, for example, in order to protect a new resource that you created during a
         * stack update. If you do not specify a stack policy, the current policy that is associated with the stack is
         * unchanged.
         * </p>
         * 
         * @param stackPolicyBody
         *        Structure containing a new stack policy body. You can specify either the <code>StackPolicyBody</code>
         *        or the <code>StackPolicyURL</code> parameter, but not both.</p>
         *        <p>
         *        You might update the stack policy, for example, in order to protect a new resource that you created
         *        during a stack update. If you do not specify a stack policy, the current policy that is associated
         *        with the stack is unchanged.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stackPolicyBody(String stackPolicyBody);

        /**
         * <p>
         * Location of a file containing the updated stack policy. The URL must point to a policy (max size: 16KB)
         * located in an S3 bucket in the same region as the stack. You can specify either the
         * <code>StackPolicyBody</code> or the <code>StackPolicyURL</code> parameter, but not both.
         * </p>
         * <p>
         * You might update the stack policy, for example, in order to protect a new resource that you created during a
         * stack update. If you do not specify a stack policy, the current policy that is associated with the stack is
         * unchanged.
         * </p>
         * 
         * @param stackPolicyURL
         *        Location of a file containing the updated stack policy. The URL must point to a policy (max size:
         *        16KB) located in an S3 bucket in the same region as the stack. You can specify either the
         *        <code>StackPolicyBody</code> or the <code>StackPolicyURL</code> parameter, but not both.</p>
         *        <p>
         *        You might update the stack policy, for example, in order to protect a new resource that you created
         *        during a stack update. If you do not specify a stack policy, the current policy that is associated
         *        with the stack is unchanged.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stackPolicyURL(String stackPolicyURL);

        /**
         * <p>
         * Amazon Simple Notification Service topic Amazon Resource Names (ARNs) that AWS CloudFormation associates with
         * the stack. Specify an empty list to remove all notification topics.
         * </p>
         * 
         * @param notificationARNs
         *        Amazon Simple Notification Service topic Amazon Resource Names (ARNs) that AWS CloudFormation
         *        associates with the stack. Specify an empty list to remove all notification topics.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notificationARNs(Collection<String> notificationARNs);

        /**
         * <p>
         * Amazon Simple Notification Service topic Amazon Resource Names (ARNs) that AWS CloudFormation associates with
         * the stack. Specify an empty list to remove all notification topics.
         * </p>
         * 
         * @param notificationARNs
         *        Amazon Simple Notification Service topic Amazon Resource Names (ARNs) that AWS CloudFormation
         *        associates with the stack. Specify an empty list to remove all notification topics.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notificationARNs(String... notificationARNs);

        /**
         * <p>
         * Key-value pairs to associate with this stack. AWS CloudFormation also propagates these tags to supported
         * resources in the stack. You can specify a maximum number of 50 tags.
         * </p>
         * <p>
         * If you don't specify this parameter, AWS CloudFormation doesn't modify the stack's tags. If you specify an
         * empty value, AWS CloudFormation removes all associated tags.
         * </p>
         * 
         * @param tags
         *        Key-value pairs to associate with this stack. AWS CloudFormation also propagates these tags to
         *        supported resources in the stack. You can specify a maximum number of 50 tags.</p>
         *        <p>
         *        If you don't specify this parameter, AWS CloudFormation doesn't modify the stack's tags. If you
         *        specify an empty value, AWS CloudFormation removes all associated tags.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * Key-value pairs to associate with this stack. AWS CloudFormation also propagates these tags to supported
         * resources in the stack. You can specify a maximum number of 50 tags.
         * </p>
         * <p>
         * If you don't specify this parameter, AWS CloudFormation doesn't modify the stack's tags. If you specify an
         * empty value, AWS CloudFormation removes all associated tags.
         * </p>
         * 
         * @param tags
         *        Key-value pairs to associate with this stack. AWS CloudFormation also propagates these tags to
         *        supported resources in the stack. You can specify a maximum number of 50 tags.</p>
         *        <p>
         *        If you don't specify this parameter, AWS CloudFormation doesn't modify the stack's tags. If you
         *        specify an empty value, AWS CloudFormation removes all associated tags.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * A unique identifier for this <code>UpdateStack</code> request. Specify this token if you plan to retry
         * requests so that AWS CloudFormation knows that you're not attempting to update a stack with the same name.
         * You might retry <code>UpdateStack</code> requests to ensure that AWS CloudFormation successfully received
         * them.
         * </p>
         * <p>
         * All events triggered by a given stack operation are assigned the same client request token, which you can use
         * to track operations. For example, if you execute a <code>CreateStack</code> operation with the token
         * <code>token1</code>, then all the <code>StackEvents</code> generated by that operation will have
         * <code>ClientRequestToken</code> set as <code>token1</code>.
         * </p>
         * <p>
         * In the console, stack operations display the client request token on the Events tab. Stack operations that
         * are initiated from the console use the token format <i>Console-StackOperation-ID</i>, which helps you easily
         * identify the stack operation . For example, if you create a stack using the console, each stack event would
         * be assigned the same token in the following format:
         * <code>Console-CreateStack-7f59c3cf-00d2-40c7-b2ff-e75db0987002</code>.
         * </p>
         * 
         * @param clientRequestToken
         *        A unique identifier for this <code>UpdateStack</code> request. Specify this token if you plan to retry
         *        requests so that AWS CloudFormation knows that you're not attempting to update a stack with the same
         *        name. You might retry <code>UpdateStack</code> requests to ensure that AWS CloudFormation successfully
         *        received them.</p>
         *        <p>
         *        All events triggered by a given stack operation are assigned the same client request token, which you
         *        can use to track operations. For example, if you execute a <code>CreateStack</code> operation with the
         *        token <code>token1</code>, then all the <code>StackEvents</code> generated by that operation will have
         *        <code>ClientRequestToken</code> set as <code>token1</code>.
         *        </p>
         *        <p>
         *        In the console, stack operations display the client request token on the Events tab. Stack operations
         *        that are initiated from the console use the token format <i>Console-StackOperation-ID</i>, which helps
         *        you easily identify the stack operation . For example, if you create a stack using the console, each
         *        stack event would be assigned the same token in the following format:
         *        <code>Console-CreateStack-7f59c3cf-00d2-40c7-b2ff-e75db0987002</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientRequestToken(String clientRequestToken);
    }

    static final class BuilderImpl implements Builder {
        private String stackName;

        private String templateBody;

        private String templateURL;

        private Boolean usePreviousTemplate;

        private String stackPolicyDuringUpdateBody;

        private String stackPolicyDuringUpdateURL;

        private List<Parameter> parameters;

        private List<String> capabilities;

        private List<String> resourceTypes;

        private String roleARN;

        private RollbackConfiguration rollbackConfiguration;

        private String stackPolicyBody;

        private String stackPolicyURL;

        private List<String> notificationARNs;

        private List<Tag> tags;

        private String clientRequestToken;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateStackRequest model) {
            stackName(model.stackName);
            templateBody(model.templateBody);
            templateURL(model.templateURL);
            usePreviousTemplate(model.usePreviousTemplate);
            stackPolicyDuringUpdateBody(model.stackPolicyDuringUpdateBody);
            stackPolicyDuringUpdateURL(model.stackPolicyDuringUpdateURL);
            parameters(model.parameters);
            capabilities(model.capabilities);
            resourceTypes(model.resourceTypes);
            roleARN(model.roleARN);
            rollbackConfiguration(model.rollbackConfiguration);
            stackPolicyBody(model.stackPolicyBody);
            stackPolicyURL(model.stackPolicyURL);
            notificationARNs(model.notificationARNs);
            tags(model.tags);
            clientRequestToken(model.clientRequestToken);
        }

        public final String getStackName() {
            return stackName;
        }

        @Override
        public final Builder stackName(String stackName) {
            this.stackName = stackName;
            return this;
        }

        public final void setStackName(String stackName) {
            this.stackName = stackName;
        }

        public final String getTemplateBody() {
            return templateBody;
        }

        @Override
        public final Builder templateBody(String templateBody) {
            this.templateBody = templateBody;
            return this;
        }

        public final void setTemplateBody(String templateBody) {
            this.templateBody = templateBody;
        }

        public final String getTemplateURL() {
            return templateURL;
        }

        @Override
        public final Builder templateURL(String templateURL) {
            this.templateURL = templateURL;
            return this;
        }

        public final void setTemplateURL(String templateURL) {
            this.templateURL = templateURL;
        }

        public final Boolean getUsePreviousTemplate() {
            return usePreviousTemplate;
        }

        @Override
        public final Builder usePreviousTemplate(Boolean usePreviousTemplate) {
            this.usePreviousTemplate = usePreviousTemplate;
            return this;
        }

        public final void setUsePreviousTemplate(Boolean usePreviousTemplate) {
            this.usePreviousTemplate = usePreviousTemplate;
        }

        public final String getStackPolicyDuringUpdateBody() {
            return stackPolicyDuringUpdateBody;
        }

        @Override
        public final Builder stackPolicyDuringUpdateBody(String stackPolicyDuringUpdateBody) {
            this.stackPolicyDuringUpdateBody = stackPolicyDuringUpdateBody;
            return this;
        }

        public final void setStackPolicyDuringUpdateBody(String stackPolicyDuringUpdateBody) {
            this.stackPolicyDuringUpdateBody = stackPolicyDuringUpdateBody;
        }

        public final String getStackPolicyDuringUpdateURL() {
            return stackPolicyDuringUpdateURL;
        }

        @Override
        public final Builder stackPolicyDuringUpdateURL(String stackPolicyDuringUpdateURL) {
            this.stackPolicyDuringUpdateURL = stackPolicyDuringUpdateURL;
            return this;
        }

        public final void setStackPolicyDuringUpdateURL(String stackPolicyDuringUpdateURL) {
            this.stackPolicyDuringUpdateURL = stackPolicyDuringUpdateURL;
        }

        public final Collection<Parameter.Builder> getParameters() {
            return parameters != null ? parameters.stream().map(Parameter::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder parameters(Collection<Parameter> parameters) {
            this.parameters = ParametersCopier.copy(parameters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameters(Parameter... parameters) {
            parameters(Arrays.asList(parameters));
            return this;
        }

        public final void setParameters(Collection<Parameter.BuilderImpl> parameters) {
            this.parameters = ParametersCopier.copyFromBuilder(parameters);
        }

        public final Collection<String> getCapabilities() {
            return capabilities;
        }

        @Override
        public final Builder capabilities(Collection<String> capabilities) {
            this.capabilities = CapabilitiesCopier.copy(capabilities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder capabilities(String... capabilities) {
            capabilities(Arrays.asList(capabilities));
            return this;
        }

        public final void setCapabilities(Collection<String> capabilities) {
            this.capabilities = CapabilitiesCopier.copy(capabilities);
        }

        public final Collection<String> getResourceTypes() {
            return resourceTypes;
        }

        @Override
        public final Builder resourceTypes(Collection<String> resourceTypes) {
            this.resourceTypes = ResourceTypesCopier.copy(resourceTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceTypes(String... resourceTypes) {
            resourceTypes(Arrays.asList(resourceTypes));
            return this;
        }

        public final void setResourceTypes(Collection<String> resourceTypes) {
            this.resourceTypes = ResourceTypesCopier.copy(resourceTypes);
        }

        public final String getRoleARN() {
            return roleARN;
        }

        @Override
        public final Builder roleARN(String roleARN) {
            this.roleARN = roleARN;
            return this;
        }

        public final void setRoleARN(String roleARN) {
            this.roleARN = roleARN;
        }

        public final RollbackConfiguration.Builder getRollbackConfiguration() {
            return rollbackConfiguration != null ? rollbackConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder rollbackConfiguration(RollbackConfiguration rollbackConfiguration) {
            this.rollbackConfiguration = rollbackConfiguration;
            return this;
        }

        public final void setRollbackConfiguration(RollbackConfiguration.BuilderImpl rollbackConfiguration) {
            this.rollbackConfiguration = rollbackConfiguration != null ? rollbackConfiguration.build() : null;
        }

        public final String getStackPolicyBody() {
            return stackPolicyBody;
        }

        @Override
        public final Builder stackPolicyBody(String stackPolicyBody) {
            this.stackPolicyBody = stackPolicyBody;
            return this;
        }

        public final void setStackPolicyBody(String stackPolicyBody) {
            this.stackPolicyBody = stackPolicyBody;
        }

        public final String getStackPolicyURL() {
            return stackPolicyURL;
        }

        @Override
        public final Builder stackPolicyURL(String stackPolicyURL) {
            this.stackPolicyURL = stackPolicyURL;
            return this;
        }

        public final void setStackPolicyURL(String stackPolicyURL) {
            this.stackPolicyURL = stackPolicyURL;
        }

        public final Collection<String> getNotificationARNs() {
            return notificationARNs;
        }

        @Override
        public final Builder notificationARNs(Collection<String> notificationARNs) {
            this.notificationARNs = NotificationARNsCopier.copy(notificationARNs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder notificationARNs(String... notificationARNs) {
            notificationARNs(Arrays.asList(notificationARNs));
            return this;
        }

        public final void setNotificationARNs(Collection<String> notificationARNs) {
            this.notificationARNs = NotificationARNsCopier.copy(notificationARNs);
        }

        public final Collection<Tag.Builder> getTags() {
            return tags != null ? tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagsCopier.copyFromBuilder(tags);
        }

        public final String getClientRequestToken() {
            return clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        @Override
        public UpdateStackRequest build() {
            return new UpdateStackRequest(this);
        }
    }
}
