/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudformation.transform;

import javax.annotation.Generated;

import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.services.cloudformation.model.*;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;

/**
 * ListStackSetOperationResultsRequest Marshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class ListStackSetOperationResultsRequestMarshaller implements
        Marshaller<Request<ListStackSetOperationResultsRequest>, ListStackSetOperationResultsRequest> {

    public Request<ListStackSetOperationResultsRequest> marshall(
            ListStackSetOperationResultsRequest listStackSetOperationResultsRequest) {

        if (listStackSetOperationResultsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        Request<ListStackSetOperationResultsRequest> request = new DefaultRequest<ListStackSetOperationResultsRequest>(
                listStackSetOperationResultsRequest, "CloudFormationClient");
        request.addParameter("Action", "ListStackSetOperationResults");
        request.addParameter("Version", "2010-05-15");
        request.setHttpMethod(HttpMethodName.POST);

        if (listStackSetOperationResultsRequest.stackSetName() != null) {
            request.addParameter("StackSetName", StringUtils.fromString(listStackSetOperationResultsRequest.stackSetName()));
        }

        if (listStackSetOperationResultsRequest.operationId() != null) {
            request.addParameter("OperationId", StringUtils.fromString(listStackSetOperationResultsRequest.operationId()));
        }

        if (listStackSetOperationResultsRequest.nextToken() != null) {
            request.addParameter("NextToken", StringUtils.fromString(listStackSetOperationResultsRequest.nextToken()));
        }

        if (listStackSetOperationResultsRequest.maxResults() != null) {
            request.addParameter("MaxResults", StringUtils.fromInteger(listStackSetOperationResultsRequest.maxResults()));
        }

        return request;
    }

}
